/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.utils.AppDisplay;

import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatImageView;

public class UICircleColorImageView extends AppCompatImageView {
    static final int CICLE_RADIUS = 10;

    private Context mContext;
    private int mBorderColorRes;
    private int mBgColor;
    private int mTextColor;
    private Paint mPaint;

    public UICircleColorImageView(Context context) {
        this(context, null, R.style.AppTheme);
    }

    public UICircleColorImageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.style.AppTheme);
    }

    public UICircleColorImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        mContext = context;
        mBorderColorRes = R.color.ux_color_toolbar;
        mPaint = new Paint();
        mPaint.setAntiAlias(true);
        mPaint.setDither(true);
    }

    public UICircleColorImageView(Context context, int bgColor, int txtColor) {
        this(context, null, 0);

        mBgColor = bgColor;
        mTextColor = txtColor;
    }

    public void setBorderColorRes(@ColorInt int colorRes) {
        mBorderColorRes = colorRes;
        invalidate();
    }

    public void setBgColor(@ColorInt int color) {
        mBgColor = color;
        invalidate();
    }

    public void setTextColor(int color) {
        mTextColor = color;
        invalidate();
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        int width = getWidth();
        int height = getHeight();

        int radius = AppDisplay.dp2px(CICLE_RADIUS);
        int outerThickness = AppDisplay.dp2px(1);

        mPaint.setStyle(Paint.Style.FILL);
        mPaint.setColor(mBgColor);
        canvas.drawCircle((float) width / 2, (float) height / 2, radius, mPaint);

        mPaint.setStyle(Paint.Style.STROKE);
        mPaint.setStrokeWidth(outerThickness);
        mPaint.setColor(mBorderColorRes);
        canvas.drawCircle((float) width / 2, (float) height / 2, radius, mPaint);
    }
}

