/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.drag;


import android.content.Context;
import android.text.TextUtils;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;

import com.foxit.uiextensions.DocumentManager;
import com.foxit.uiextensions.IUIInteractionEventListener;
import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.annots.stamp.StampConstants;
import com.foxit.uiextensions.annots.stamp.StampUtil;
import com.foxit.uiextensions.annots.stamp.customstamp.BaseStampBean;
import com.foxit.uiextensions.config.ConfigUtils;
import com.foxit.uiextensions.controls.dialog.MatchDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.IToolSupply;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.ToolItemsManager;
import com.foxit.uiextensions.controls.toolbar.UIToolView;
import com.foxit.uiextensions.controls.toolbar.drag.addtools.AddToolsDialog;
import com.foxit.uiextensions.controls.toolbar.impl.ToolSupplyBtnImpl;
import com.foxit.uiextensions.controls.toolbar.impl.UIColorItem;
import com.foxit.uiextensions.pdfreader.AddToolsBean;
import com.foxit.uiextensions.pdfreader.config.ReadStateConfig;
import com.foxit.uiextensions.security.standard.PasswordModule;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import androidx.annotation.NonNull;

public class HomeToolBar extends UIHSToolBar {
    private static final String SP_NAME = "home_tools";
    private static final int DEFAULT_CONUT = 9;

    private List<AddToolsBean> mCustomToolPropertys;
    private SparseArray<List<ToolItemBean>> mCustomTools;
    private AddToolsDialog mAddToolsDialog;

    public static HomeToolBar newInstance(Context context, UIExtensionsManager uiExtensionsManager, UIDragToolBar uiToolbar) {
        HomeToolBar homeToolbar;
        if (uiToolbar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_TOP
                /*|| uiToolbar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_BOTTOM*/)
            homeToolbar = new HomeToolBar(context, BaseBar.HORIZONTAL, uiExtensionsManager, uiToolbar);
        else
            homeToolbar = new HomeToolBar(context, BaseBar.VERTICAL, uiExtensionsManager, uiToolbar);
        return homeToolbar;
    }

    public HomeToolBar(Context context, UIExtensionsManager uiExtensionsManager, UIDragToolBar uiToolbar) {
        this(context, UIToolBaseBar.HORIZONTAL, uiExtensionsManager, uiToolbar);
    }

    public HomeToolBar(Context context, int orientation, UIExtensionsManager uiExtensionsManager, UIDragToolBar uiToolbar) {
        super(context, orientation, false, uiExtensionsManager, uiToolbar);
    }

    @Override
    void initialize(Context context, int orientation, UIDragToolBar uiToolbar) {
        super.initialize(context, orientation, uiToolbar);
    }

    private boolean isInitWithAddItem = true;

    public void setInitWithAddItem(boolean flag) {
        isInitWithAddItem = flag;
    }

    @Override
    public void addOptionItems(List<ToolItemBean> toolList) {
        super.addOptionItems(toolList);
        setDividerItemVisible(true);
        setMultiSelectItemVisible(true);
        setPropItemVisiable(true);
        setUndoItemVisiable(true);
        if (AppDisplay.isPad()) {
            setRedoItemVisiable(true);
        }
        initAddItemView(toolList);
    }

    private void initAddItemView(List<ToolItemBean> toolList) {
        if (!isInitWithAddItem) return;

        if (toolList.size() > 0) {
            setAddItemPosition(TB_Position.Position_RB);
        } else {
            setAddItemPosition(TB_Position.Position_CENTER);
        }
        mAddItem.setOnItemClickListener(new IBaseItem.OnItemClickListener() {
            @Override
            public void onClick(IBaseItem item, View v) {
                mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_HomeBar_AddTools);
                if (mCurItem != null)
                    mCurItem.performClick();

//                if (mAddToolsDialog == null)
                mAddToolsDialog = new AddToolsDialog(mUiExtensionsManager.getAttachedActivity(), mUiExtensionsManager);
                if (mCustomTools == null)
                    initAddProperty();
                if (AppDisplay.isPad() && mCustomTools.size() < 5) {
                    //旧版本，只有 4 组 tools
                    initProtectTools();
                }
                mAddToolsDialog.resetWH();
                mAddToolsDialog.initData(mToolsList, mCustomTools);
                mAddToolsDialog.showDialog();
                mUiExtensionsManager.stopHideToolbarsTimer();
                mAddToolsDialog.setOnDLDismissListener(new MatchDialog.DismissListener() {
                    @Override
                    public void onDismiss() {
                        mUiExtensionsManager.startHideToolbarsTimer();
                        if (mAddToolsDialog != null && mAddToolsDialog.isToolItemsChanged()) {
                            setToolItems(mCenterItemBean);
                            mUIToolbar.layoutToolbar();
                            mUiExtensionsManager.changeState(mUIExtensionsManager.getState());
                        }
                    }
                });
            }
        });
    }

    @Override
    public int getUsageType() {
        return USAGE_TYPE_HOME;
    }

    public void initAddProperty() {
        mCustomTools = new SparseArray<>();
        mCustomToolPropertys = new ArrayList<>();

        initEditTools();
        initCommentTools();
        initDrawingTools();
        initFormTools();
        if (AppDisplay.isPad())
            initProtectTools();
    }

    private void initEditTools() {
        //edit
        int[] editTypes = {ToolConstants.Text,
                ToolConstants.Image,
                ToolConstants.Audio,
                ToolConstants.Video,
                ToolConstants.Link};
        addToolBeans(AddToolsBean.EDIT_TOOLS, editTypes);
    }

    private void initCommentTools() {
        //comment
        int[] commentTypes = {ToolConstants.Note,
                ToolConstants.Attachments,
                ToolConstants.Stamp,
                ToolConstants.Typewriter,
                ToolConstants.Callout,
                ToolConstants.Textbox,
                ToolConstants.Highlight,
                ToolConstants.Underline,
                ToolConstants.Squiggly,
                ToolConstants.Strikeout,
                ToolConstants.Replace_Text,
                ToolConstants.Insert_Text,
                ToolConstants.Area_Highlight,
                ToolConstants.Measure,
                ToolConstants.Image_Annotation};
        addToolBeans(AddToolsBean.COMMENT_TOOLS, commentTypes);
    }

    private void initDrawingTools() {
        //drawing
        int[] drawingTypes = {ToolConstants.Pencil,
                ToolConstants.Highlighter,
                ToolConstants.Eraser,
                ToolConstants.Rectangle,
                ToolConstants.Oval,
                ToolConstants.Line,
                ToolConstants.Arrow,
                ToolConstants.PolyLine,
                ToolConstants.Polygon,
                ToolConstants.Cloud};
        addToolBeans(AddToolsBean.DRAWING_TOOLS, drawingTypes);
    }

    private void initFormTools() {
        //form
        int[] formTypes = {ToolConstants.TextField,
                ToolConstants.CheckBox,
                ToolConstants.RadioButton,
                ToolConstants.ComboBox,
                ToolConstants.ListBox,
                ToolConstants.SignatureField,
                ToolConstants.ImageField};
        addToolBeans(AddToolsBean.FORM_TOOLS, formTypes);
    }

    private List<Integer> mProtectTypes = new ArrayList<>();

    private void initProtectTools() {
        //protect
        if (!mProtectTypes.contains(ToolConstants.ProtectTypeRedaction))
            mProtectTypes.add(ToolConstants.ProtectTypeRedaction);
        if (!mProtectTypes.contains(ToolConstants.ProtectTypeStandard))
            mProtectTypes.add(ToolConstants.ProtectTypeStandard);
        if (!mProtectTypes.contains(ToolConstants.ProtectTypeTrustCert))
            mProtectTypes.add(ToolConstants.ProtectTypeTrustCert);

        Collections.sort(mProtectTypes);

        int[] protectTypes = new int[mProtectTypes.size()];
        for (int i = 0; i < mProtectTypes.size(); i++) {
            protectTypes[i] = mProtectTypes.get(i);
        }
        addToolBeans(AddToolsBean.PROTECT_TOOLS, protectTypes);
    }

    public void addProtectTools(int type) {
        if (!mProtectTypes.contains(type))
            mProtectTypes.add(type);
    }

    private AddToolsBean getAddToolBean(int type) {
        if (mCustomToolPropertys != null) {
            for (AddToolsBean atb : mCustomToolPropertys) {
                if (atb.toolsType == type)
                    return atb;
            }
        }
        return null;
    }

    private List<ToolItemBean> getAddToolItems(int type) {
        if (mCustomTools != null) {
            return mCustomTools.get(type);
        }
        return null;
    }

    private void addToolBeans(int toolType, int[] tools) {
        List<ToolItemBean> toolItemBeans = new ArrayList<>();
        for (int type : tools) {
            ToolItemsManager toolItemsManager = mUiExtensionsManager.getToolsManager();
            IToolSupply toolSupply = toolItemsManager.getToolSupply(type);
            if (toolSupply == null) continue;

            ToolItemBean toolItemBean = new ToolItemBean();
            toolItemBean.type = type;
            if (toolSupply instanceof ToolSupplyBtnImpl)
                toolItemBean.name = ((ToolSupplyBtnImpl) toolSupply).getToolName(0);
            else
                toolItemBean.name = AppResource.getString(mContext, toolItemsManager.getToolStrId(type));
            toolItemBean.property = ConfigUtils.config2ToolBean(mUIExtensionsManager, type);
            UIColorItem colorItem = toolSupply.createToolItem(type, true);
            colorItem.setTag(type);
            toolItemBean.toolItem = colorItem;
            if (toolItemBean.property != null)
                colorItem.setAlphaColorBg(toolItemBean.property.color);
            toolItemBeans.add(toolItemBean);
            setIds(toolItemBean.toolItem, type);
        }
        mCustomTools.append(toolType, toolItemBeans);

        AddToolsBean addToolsBean = new AddToolsBean();
        addToolsBean.toolsType = toolType;
        addToolsBean.toolItems = toolItemBeans;
        mCustomToolPropertys.add(addToolsBean);
    }

    private void setIds(IBaseItem toolItem, int type) {
        switch (type) {
            // COMMENTS
            case ToolConstants.Note:
                toolItem.setId(R.id.id_comment_Note);
                break;
            case ToolConstants.Attachments:
                toolItem.setId(R.id.id_comment_Attachments);
                break;
            case ToolConstants.Stamp:
                toolItem.setId(R.id.id_comment_Stamp);
                break;
            case ToolConstants.Typewriter:
                toolItem.setId(R.id.id_comment_Typewriter);
                break;
            case ToolConstants.Callout:
                toolItem.setId(R.id.id_comment_Callout);
                break;
            case ToolConstants.Textbox:
                toolItem.setId(R.id.id_comment_Textbox);
                break;
            case ToolConstants.Highlight:
                toolItem.setId(R.id.id_comment_Highlight);
                break;
            case ToolConstants.Underline:
                toolItem.setId(R.id.id_comment_Underline);
                break;
            case ToolConstants.Squiggly:
                toolItem.setId(R.id.id_comment_Squiggly);
                break;
            case ToolConstants.Strikeout:
                toolItem.setId(R.id.id_comment_Strikeout);
                break;
            case ToolConstants.Replace_Text:
                toolItem.setId(R.id.id_comment_Replace_Text);
                break;
            case ToolConstants.Insert_Text:
                toolItem.setId(R.id.id_comment_Insert_Text);
                break;
            case ToolConstants.Area_Highlight:
                toolItem.setId(R.id.id_comment_Area_Highlight);
                break;
            case ToolConstants.Measure:
                toolItem.setId(R.id.id_comment_Measure);
                break;
            case ToolConstants.Image_Annotation:
                toolItem.setId(R.id.id_comment_Image_Annotation);
                break;

            // form
            case ToolConstants.TextField:
                toolItem.setId(R.id.id_at_form_toolbar_textfield);
                break;
            case ToolConstants.CheckBox:
                toolItem.setId(R.id.id_at_form_toolbar_checkbox);
                break;
            case ToolConstants.RadioButton:
                toolItem.setId(R.id.id_at_form_toolbar_radiobutton);
                break;
            case ToolConstants.ComboBox:
                toolItem.setId(R.id.id_at_form_toolbar_combobox);
                break;
            case ToolConstants.ListBox:
                toolItem.setId(R.id.id_at_form_toolbar_listbox);
                break;
            case ToolConstants.SignatureField:
                toolItem.setId(R.id.id_at_form_toolbar_signaturefield);
                break;
            case ToolConstants.ImageField:
                toolItem.setId(R.id.id_at_form_toolbar_imagefield);
                break;
            // edit
            case ToolConstants.Text:
                toolItem.setId(R.id.id_at_edit_toolbar_text);
                break;
            case ToolConstants.Image:
                toolItem.setId(R.id.id_at_edit_toolbar_image);
                break;
            case ToolConstants.Audio:
                toolItem.setId(R.id.id_at_edit_toolbar_audio);
                break;
            case ToolConstants.Video:
                toolItem.setId(R.id.id_at_edit_toolbar_video);
                break;

            // drawing
            case ToolConstants.Link:
                toolItem.setId(R.id.id_at_edit_toolbar_link);
                break;
            case ToolConstants.Pencil:
                toolItem.setId(R.id.id_at_drawing_toolbar_pencil);
                break;
            case ToolConstants.Highlighter:
                toolItem.setId(R.id.id_at_drawing_toolbar_highlight);
                break;
            case ToolConstants.Eraser:
                toolItem.setId(R.id.id_at_drawing_toolbar_eraser);
                break;
            case ToolConstants.Rectangle:
                toolItem.setId(R.id.id_at_drawing_toolbar_rectangle);
                break;
            case ToolConstants.Oval:
                toolItem.setId(R.id.id_at_drawing_toolbar_oval);
                break;
            case ToolConstants.Line:
                toolItem.setId(R.id.id_at_drawing_toolbar_line);
                break;
            case ToolConstants.Arrow:
                toolItem.setId(R.id.id_at_drawing_toolbar_arrow);
                break;
            case ToolConstants.PolyLine:
                toolItem.setId(R.id.id_at_drawing_toolbar_polyline);
                break;
            case ToolConstants.Polygon:
                toolItem.setId(R.id.id_at_drawing_toolbar_polygon);
                break;
            case ToolConstants.Cloud:
                toolItem.setId(R.id.id_at_drawing_toolbar_cloud);
                break;

            // Protect
            case ToolConstants.ProtectTypeRedaction:
                toolItem.setId(R.id.add_tools_protect_toolbar_1);
                break;
            case ToolConstants.ProtectTypeStandard:
                toolItem.setId(R.id.add_tools_protect_toolbar_2);
                break;
            case ToolConstants.ProtectTypeTrustCert:
                toolItem.setId(R.id.add_tools_protect_toolbar_3);
                break;
            case ToolConstants.ProtectTypeCert:
                toolItem.setId(R.id.add_tools_protect_toolbar_4);
                break;
            case ToolConstants.ProtectTypeCertRemove:
                toolItem.setId(R.id.add_tools_protect_toolbar_5);
                break;
            case ToolConstants.ProtectTypeStandRemove:
                toolItem.setId(R.id.add_tools_protect_toolbar_6);
                break;
            case ToolConstants.ProtectTypeRMS:
                toolItem.setId(R.id.add_tools_protect_toolbar_7);
                break;
            case ToolConstants.ProtectTypeAIP:
                toolItem.setId(R.id.add_tools_protect_toolbar_8);
                break;
        }
    }

    @Override
    public List<Integer> getToolTypes(@NonNull ToolItemsManager toolItemsManager) {
        List<Integer> toolItems = toolItemsManager.getToolItems(UIToolBaseBar.USAGE_TYPE_HOME);
        if (toolItems != null) {
            SparseIntArray typeArray = new SparseIntArray();
            int size = toolItems.size();
            for (int i = 0; i < size; i++) {
                int type = toolItems.get(i);
                if (type == ToolConstants.Note)
                    typeArray.put(10000, type);
                else if (type == ToolConstants.Highlight)
                    typeArray.put(10000 * 2, type);
                else if (type == ToolConstants.Typewriter)
                    typeArray.put(10000 * 3, type);
                else if (type == ToolConstants.Pencil)
                    typeArray.put(10000 * 4, type);
                else if (type == ToolConstants.Eraser)
                    typeArray.put(10000 * 5, type);
                else if (type == ToolConstants.Text)
                    typeArray.put(10000 * 6, type);
                else if (type == ToolConstants.Image)
                    typeArray.put(10000 * 7, type);
            }

            toolItems = new ArrayList<>();
            for (int i = 0; i < typeArray.size(); i++) {
                toolItems.add(typeArray.valueAt(i));
            }
        }
        return toolItems;
    }

    @Override
    public void setEnabled(boolean enabled) {
        mEnabled = enabled;
        for (int i = 0; i < mToolsList.size(); i++) {
            ToolItemBean toolItemBean = mToolsList.get(i);
            if (toolItemBean.itemStyle == ToolItemBean.DEFAULT_STYLE) {
                IBaseItem toolItem = toolItemBean.toolItem;

                boolean isReflow = mUiExtensionsManager.getState() == ReadStateConfig.STATE_REFLOW;
                if (isReflow) {
                    toolItem.setEnable(false);
                } else {
                    if (toolItem != null) {
                        int tag = toolItem.getTag();
                        if (tag == ToolConstants.TextField
                                || tag == ToolConstants.CheckBox
                                || tag == ToolConstants.RadioButton
                                || tag == ToolConstants.ComboBox
                                || tag == ToolConstants.ListBox
                                || tag == ToolConstants.SignatureField
                                || tag == ToolConstants.ImageField) {
                            DocumentManager documentManager = mUiExtensionsManager.getDocumentManager();
                            toolItem.setEnable(mUiExtensionsManager.getPDFViewCtrl().getDoc() != null
                                    && mUIExtensionsManager.isEnableModification()
                                    && !documentManager.isXFA()
                                    && !documentManager.isSign()
                                    && documentManager.canModifyForm()
                                    && documentManager.withAddPermission());
                        } else if (tag == ToolConstants.Video
                                || tag == ToolConstants.Audio
                                || tag == ToolConstants.Link) {
                            DocumentManager documentManager = mUiExtensionsManager.getDocumentManager();
                            toolItem.setEnable(documentManager.withAddPermission()
                                    && documentManager.canEdit()
                                    && mUIExtensionsManager.isEnableModification());
                        } else if (tag == ToolConstants.Text
                                || tag == ToolConstants.Image) {
                            DocumentManager documentManager = mUiExtensionsManager.getDocumentManager();
                            toolItem.setEnable(documentManager.canEdit() && mUIExtensionsManager.isEnableModification());
                        } else if (tag == ToolConstants.ProtectTypeStandard
                                || tag == ToolConstants.ProtectTypeStandRemove) {
                            String filePath = mUIExtensionsManager.getPDFViewCtrl().getFilePath();
                            boolean isPPDF = false;
                            if (!TextUtils.isEmpty(filePath)) {
                                isPPDF = filePath.endsWith(".ppdf");
                            }
                            boolean isAvailable = false;
                            PasswordModule passwordModule = (PasswordModule) mUIExtensionsManager.getModuleByName(Module.MODULE_NAME_PASSWORD);
                            if (passwordModule != null) {
                                isAvailable = passwordModule.getSecurityHandler().isAvailable();
                            }
                            toolItem.setEnable(isAvailable && !isPPDF);
                        } else if (tag == ToolConstants.ProtectTypeRedaction) {
                            toolItem.setEnable(mUIExtensionsManager.getDocumentManager().canAddAnnot()
                                    && mUIExtensionsManager.isEnableModification());
                        } else if (tag == ToolConstants.ProtectTypeTrustCert) {
                            toolItem.setEnable(true);
                        } else {
                            toolItem.setEnable(enabled);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onThemeColorChanged() {
        updateThemeColor();
        dismissAddToolsDialog();
    }

    public void setAddToolsProperty(List<AddToolsBean> items) {
        mCustomToolPropertys = items;
        if (mCustomToolPropertys != null) {
            for (AddToolsBean toolsBean : mCustomToolPropertys) {
                List<ToolItemBean> toolItemBeans = new ArrayList<>();

                List<ToolItemBean> toolItems = toolsBean.toolItems;
                for (ToolItemBean toolItem : toolItems) {
                    if (toolItem == null)
                        continue;

                    int type = toolItem.type;
                    ToolItemsManager toolItemsManager = mUiExtensionsManager.getToolsManager();
                    IToolSupply toolSupply = toolItemsManager.getToolSupply(type);
                    if (toolSupply == null) continue;
                    ToolItemBean toolItemBean = new ToolItemBean();
                    toolItemBean.type = type;
                    if (toolSupply instanceof ToolSupplyBtnImpl)
                        toolItemBean.name = ((ToolSupplyBtnImpl) toolSupply).getToolName(0);
                    else
                        toolItemBean.name = AppResource.getString(mContext, toolItemsManager.getToolStrId(type));
                    toolItemBean.property = toolItem.property;
                    UIColorItem colorItem = toolSupply.createToolItem(type, false);
                    colorItem.setTag(type);
                    toolItemBean.toolItem = colorItem;
                    if (toolItemBean.property != null)
                        colorItem.setAlphaColorBg(toolItemBean.property.color);
                    toolItemBeans.add(toolItemBean);
                }
                if (mCustomTools == null)
                    mCustomTools = new SparseArray<>();
                mCustomTools.append(toolsBean.toolsType, toolItemBeans);
            }
        }
    }

    public List<AddToolsBean> getAddToolsProperty() {
        return mCustomToolPropertys;
    }

    public void dismissAddToolsDialog() {
        if (mAddToolsDialog != null && mAddToolsDialog.isShowing()) {
            mAddToolsDialog.dismiss();
            mAddToolsDialog = null;
        }
    }

    public void removeCustomStamps(boolean clearAll, List<? extends BaseStampBean> removeStamps) {
        if (mToolsList == null) return;

        //custom stamp tools on the home tab
        List<ToolItemBean> customStamps = new ArrayList<>();
        for (ToolItemBean toolItemBean : mToolsList) {
            if (toolItemBean.type == ToolConstants.Stamp
                    && (toolItemBean.property.style == StampConstants.CUSTOM_TEXT_STAMP
                    || toolItemBean.property.style == StampConstants.CUSTOM_IMAGE_STAMP)) {
                customStamps.add(toolItemBean);
            }
        }

        if (customStamps.size() > 0) {
            if (clearAll) {
                // home tab
                for (ToolItemBean toolItemBean : customStamps) {
                    resetStampItem(toolItemBean);
                }
            } else {
                for (BaseStampBean removeStampBean : removeStamps) {
                    for (ToolItemBean toolItemBean : customStamps) {
                        Long createTime = (Long) toolItemBean.property.mTag;
                        if (createTime != null && createTime == removeStampBean.mCreateTime) {
                            resetStampItem(toolItemBean);
                        }
                    }
                }
            }

            if (mAddToolsDialog != null)
                mAddToolsDialog.notifyUpdateAddedTools();
        }

        //custom stamp tool on the comment tools
        List<ToolItemBean> addTools = getAddToolItems(AddToolsBean.COMMENT_TOOLS);
        ToolItemBean commentStampBean = null;
        if (addTools != null) {
            for (ToolItemBean toolItemBean : addTools) {
                if (toolItemBean.type == ToolConstants.Stamp) {
                    if (toolItemBean.property.style == StampConstants.CUSTOM_TEXT_STAMP
                            || toolItemBean.property.style == StampConstants.CUSTOM_IMAGE_STAMP) {
                        commentStampBean = toolItemBean;
                    }
                    break;
                }
            }

            if (commentStampBean != null) {
                if (clearAll) {
                    commentStampBean.property.style = 0;
                    commentStampBean.property.mTag = null;
                } else {
                    for (BaseStampBean removeStampBean : removeStamps) {
                        Long createTime = (Long) commentStampBean.property.mTag;
                        if (createTime != null && createTime == removeStampBean.mCreateTime) {
                            commentStampBean.property.style = 0;
                            commentStampBean.property.mTag = null;
                            break;
                        }
                    }
                }
            }
        }
    }

    private void resetStampItem(ToolItemBean toolItemBean) {
        toolItemBean.property.style = 0;
        toolItemBean.property.mTag = null;
        if (toolItemBean.toolItem != null) {
            View view = ((UIColorItem) toolItemBean.toolItem).getCustomView();
            if (view instanceof UIToolView) {
                ((UIToolView) view).setFillBackgroundResource(StampUtil.getStampIconThumbnail(0));
            }
        }
    }

}
