/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.drag;


import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import androidx.annotation.RequiresApi;

public class UIDragToolBarRL extends RelativeLayout {

    UIDragToolBar mDragToolbar;

    void setDragToolbar(UIDragToolBar dragToolbar) {
        mDragToolbar = dragToolbar;
    }

    public UIDragToolBarRL(Context context) {
        super(context);
    }

    public UIDragToolBarRL(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public UIDragToolBarRL(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public UIDragToolBarRL(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);

        if (mDragToolbar != null) {
            mDragToolbar.onLayout(changed, l, t, r, b);
        }
    }
}