/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.drag;


import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.FrameLayout;

import com.foxit.uiextensions.UIExtensionsManager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

class UIRelativeLayout extends FrameLayout {
    private UIExtensionsManager mUIExtensionsManager;

    public UIRelativeLayout(UIExtensionsManager uiExtensionsManager, @NonNull Context context) {
        super(context);
        mUIExtensionsManager = uiExtensionsManager;
    }

    public UIRelativeLayout(UIExtensionsManager uiExtensionsManager, @NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        mUIExtensionsManager = uiExtensionsManager;
    }


    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == MotionEvent.ACTION_DOWN) {
            mUIExtensionsManager.resetHideToolbarsTimer();
        }
        return super.dispatchTouchEvent(ev);
    }
}
