/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.impl;


import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppUtil;

public class TabItemImpl extends BaseItemImpl {

    public TabItemImpl(Context context, String text) {
        super(context, text, 0, IBaseItem.RELATION_TOP);
        setText(text);
        setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(context, R.dimen.ux_text_size_15sp));
        setTextColor(ThemeUtil.getTopBarTextColorStateList(context));
//        LinearLayout.LayoutParams imageParams = (LinearLayout.LayoutParams) mImage.getLayoutParams();
//        mTextView.measure(0, 0);
//        imageParams.width = mTextView.getMeasuredWidth();
//        mImage.setLayoutParams(imageParams);
//        setImageTextBackgroundResouce(R.drawable.tab_indicator_icon);
//        ThemeUtil.setBackgroundTintList(mImage, ThemeUtil.getPrimaryIconColor(context));

        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams) mTextView.getLayoutParams();
        params.height = AppDisplay.dp2px(30);
        mTextView.setGravity(Gravity.CENTER_VERTICAL);
        mImage.setVisibility(View.INVISIBLE);

        setTextPadding(AppResource.getDimensionPixelSize(context, R.dimen.ux_margin_12dp),
                0,
                AppResource.getDimensionPixelSize(context, R.dimen.ux_margin_12dp),
                0);
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            mTextView.setBackground(AppResource.getDrawable(mContext,R.drawable.toolbar_center_layout_bg));
            if (backgroundColorProvider != null) {
                int color = backgroundColorProvider.getColor(AppUtil.isDarkMode(mContext));
                if (color != 0) {
                    mTextView.getBackground().setColorFilter(color, PorterDuff.Mode.SRC_IN);
                }
            }
//            mImage.setVisibility(View.VISIBLE);
        } else {
            mTextView.setBackground(AppResource.getDrawable(mContext, R.drawable.toolbar_center_layout_bg_tran));
//            mImage.setVisibility(View.INVISIBLE);
        }
    }

    @Override
    public void setBackgroundColor(int color) {
        if (this.isSelected()) {
            mTextView.getBackground().setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
        }
    }

    @Override
    public void setImageTintList(ColorStateList tint) {
        if (mImage != null) {
            ThemeUtil.setBackgroundTintList(mImage, ThemeUtil.getPrimaryIconColor(mContext));
        }
    }

}
