/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.impl;


import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.annots.common.UIBtnImageView;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.UIToolView;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;

public class UIColorItem implements IBaseItem {

    private int mTag;
    protected ItemType mItemType;
    protected int mRelation;
    protected Context mContext;

    protected LinearLayout mRootLayout;//content view
    protected  LinearLayout mBorderLayout;

    protected RelativeLayout mImageRL;
    protected ImageView mImageColorBgView;
    protected ImageView mCoverImageView;
    protected UIBtnImageView mImageView;
    protected TextView mTextView;//title
    protected View mCustomView;

    protected LinearLayout.LayoutParams mImgParams;//image or mCustomView
    protected LinearLayout.LayoutParams mTextParams;

    protected int mNoSelectTextColor = Color.BLACK;
    protected int mSelectTextColor = Color.RED;
    protected boolean mUseTextColorRes = false;
    protected int mDefinedTextSize = 12;

    View.OnClickListener mClickListener;
    View.OnLongClickListener mLongClickListener;
    OnItemClickListener mItemClickListener;
    OnItemLongPressListener mItemLongClickListener;

    protected int mImageRes;

    public UIColorItem(Context context) {
        this(context, null, 0, null, RELATION_LEFT, ItemType.Item_Text_Image);
    }

    public UIColorItem(Context context, String text) {
        this(context, text, 0, null, RELATION_LEFT, ItemType.Item_Text);
    }

    public UIColorItem(Context context, int imgRes) {
        this(context, null, imgRes, null, RELATION_LEFT, ItemType.Item_Image);
    }

    public UIColorItem(Context context, View customView) {
        this(context, null, 0, customView, RELATION_LEFT, ItemType.Item_custom);
    }

    protected UIColorItem(Context context, String text, int imgRes, int relation) {
        this(context, text, imgRes, null, relation, ItemType.Item_Text_Image);
    }

    private void initDimens(Context context) {
        mDefinedTextSize = (int) AppDisplay.px2dp(AppResource.getDimensionPixelSize(context, R.dimen.ux_text_size_14sp));
    }

    private UIColorItem(Context context, String text, int imgRes, View customView, int relation, ItemType type) {
        mContext = context;
        initDimens(context);

        mRelation = relation;
        mItemType = type;

        mRootLayout = new LinearLayout(context) {
            @Override
            protected void onLayout(boolean changed, int l, int t, int r, int b) {
                super.onLayout(changed, l, t, r, b);
                onItemLayout(l, t, r, b);
            }
        };

        mRootLayout.setGravity(Gravity.CENTER);
        mBorderLayout = new LinearLayout(context);
        mBorderLayout.setGravity(Gravity.CENTER);
//        mBorderLayout.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, AppDisplay.dp2px(42)));
        mBorderLayout.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        ((LinearLayout.LayoutParams)mBorderLayout.getLayoutParams()).setMargins(0, AppDisplay.dp2px(2), 0, AppDisplay.dp2px(2));

        if (ItemType.Item_Image.equals(type) || ItemType.Item_Text_Image.equals(type)) {
            mImageRL = new RelativeLayout(context);

            mImageColorBgView = new ImageView(context);
            RelativeLayout.LayoutParams bglp = new RelativeLayout.LayoutParams(AppDisplay.dp2px(20),
                    AppDisplay.dp2px(20));
            bglp.addRule(BarRelativeLayoutImpl.CENTER_IN_PARENT);
            mImageRL.addView(mImageColorBgView, bglp);

            mImageView = new UIBtnImageView(context, mImageRL);
            mImgParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
            mImgParams.gravity = Gravity.CENTER;
            if (imgRes != 0) {
                mImageRes = imgRes;
                mImageView.setImageResource(imgRes);
            }

            RelativeLayout.LayoutParams imglp = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            imglp.addRule(BarRelativeLayoutImpl.CENTER_IN_PARENT);
            mImageRL.addView(mImageView, imglp);

            mCoverImageView = new ImageView(context);
            RelativeLayout.LayoutParams coverlp = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            coverlp.addRule(BarRelativeLayoutImpl.CENTER_IN_PARENT);
            mImageRL.addView(mCoverImageView, coverlp);
        }

        if (ItemType.Item_Text.equals(type)) {
            mTextView = new TextView(context);
            mTextView.setSingleLine();
            mTextParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
            mTextParams.gravity = Gravity.CENTER;
            if (text != null) {
                mTextView.setText(text);
            }
        }

        if (ItemType.Item_Text_Image.equals(type)) {
            mTextView = new TextView(context);
            mTextView.setSingleLine();
            mTextParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
            mTextParams.gravity = Gravity.CENTER;
            mTextParams.leftMargin = AppDisplay.dp2px(4);
            mTextParams.rightMargin = AppDisplay.dp2px(8);
            if (text != null) {
                mTextView.setText(text);

            }
        }

        if (customView != null) {
            mCustomView = customView;
            mRootLayout.setOrientation(LinearLayout.VERTICAL);
            mRootLayout.addView(customView, new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        } else {
            setTextImgRelation(relation);
        }

        if (mTextView != null) {//defined textSize and color
            setTextSize(mDefinedTextSize);
            setTextColorResource(R.color.fx_button_text_selector);
        }
    }

    private void setTextImgRelation(int relation) {
        if (relation == RELATION_LEFT || relation == RELATION_RIGNT) {
            mRootLayout.setOrientation(LinearLayout.HORIZONTAL);
            mBorderLayout.setOrientation(LinearLayout.HORIZONTAL);
        } else {
            mRootLayout.setOrientation(LinearLayout.VERTICAL);
            mBorderLayout.setOrientation(LinearLayout.VERTICAL);
        }
        int padding = AppDisplay.dp2px(4);
        mBorderLayout.setPadding(0, padding, 0, padding);
        mRootLayout.addView(mBorderLayout);
        if (relation == RELATION_RIGNT || relation == RELATION_TOP) {
            if (mTextView != null) {
                if (mTextParams != null) {
                    mBorderLayout.addView(mTextView, mTextParams);
                } else {
                    mBorderLayout.addView(mTextView);
                }
            }
            if (mImageRL != null) {
                if (mImgParams != null) {
                    mBorderLayout.addView(mImageRL, mImgParams);
                } else {
                    mBorderLayout.addView(mImageRL);
                }
            }
        } else {
            if (mImageRL != null) {
                if (mImgParams != null) {
                    mBorderLayout.addView(mImageRL, mImgParams);
                } else {
                    mBorderLayout.addView(mImageRL);
                }
            }
            if (mTextView != null) {
                if (mTextParams != null) {
                    mBorderLayout.addView(mTextView, mTextParams);
                } else {
                    mBorderLayout.addView(mTextView);
                }
            }
        }
    }

    @Override
    public View getContentView() {
        return mRootLayout;
    }

    @Override
    public TextView getTextView() {
        return mTextView;
    }

    @Override
    public void setText(CharSequence text) {
        if (mTextView != null) {
            mTextView.setText(text);
        }
    }

    @Override
    public String getText() {
        if (mTextView != null) {
            if (mTextView.getText() != null) {
                return mTextView.getText().toString();
            }
        }
        return null;
    }

    @Override
    public void setTextColor(int selectedTextColor, int disSelectedTextColor) {
        mUseTextColorRes = false;
        mSelectTextColor = selectedTextColor;
        mNoSelectTextColor = disSelectedTextColor;
        if (mTextView != null) {
            mTextView.setTextColor(mNoSelectTextColor);
        }
    }

    @Override
    public void setTextColor(ColorStateList colors) {
        if (mTextView != null) {
            mTextView.setTextColor(colors);

        }
    }

    @Override
    public void setTextBackground(Drawable drawable) {

    }

    @Override
    public void setImageTintList(@Nullable ColorStateList tint) {
        if (mImageView != null) {
            mImageView.setColorStateList(tint);
        }
    }

    @Override
    public void setForceDarkAllowed(boolean allowed) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            if (mRootLayout != null)
                mRootLayout.setForceDarkAllowed(allowed);
        }
    }

    @Override
    public void setTextColor(int color) {
        setTextColor(color, color);
    }

    @Override
    public void setTypeface(Typeface typeface) {
        if (mTextView != null) {
            mTextView.setTypeface(typeface);
        }
    }

    @Override
    public void setTextSize(float dp) {
        if (mTextView != null) {
            mTextView.setTextSize(TypedValue.COMPLEX_UNIT_DIP, dp);
        }
    }

    @Override
    public void setTextSize(int unit, float size) {
        if (mTextView != null) {
            mTextView.setTextSize(unit, size);
        }
    }

    @Override
    public void setTextColorResource(int res) {
        if (mTextView != null) {
            Resources resource = mTextView.getContext().getResources();
            ColorStateList csl = resource.getColorStateList(res);
            mTextView.setTextColor(csl);
            mUseTextColorRes = true;
        }
    }

    @Override
    public void setText(int res) {
        mTextView.setText(res);
    }

    @Override
    public boolean setImageResource(int res) {
        if (mImageView != null) {
            mImageView.setImageResource(res);
            return true;
        } else {
            return false;
        }
    }

    protected int mHighlightImageRes;

    @Override
    public void setHighlightImageResource(int res) {
        this.mHighlightImageRes = res;
    }

    @Override
    public int getHighlightImageResource() {
        return mHighlightImageRes;
    }

    @Override
    public boolean setImageDrawable(@Nullable Drawable drawable) {
        if (mImageView != null) {
            mImageView.setImageDrawable(drawable);
            return true;
        } else {
            return false;
        }
    }

    @Override
    public Drawable getImageDrawable() {
        if (mImageView != null)
            return mImageView.getDrawable();
        return null;
    }

    @Override
    public void setImagePadding(int l, int t, int r, int b) {
        if (mImageRL != null) {
            mImageRL.setPadding(l, t, r, b);
        }
    }

    @Override
    public void setTextPadding(int l, int t, int r, int b) {
        if (mTextView != null) {
            mTextView.setPadding(l, t, r, b);
        }
    }

    @Override
    public void setTextLayoutParams(int width, int height) {
        if (mTextView != null) {
            mTextView.getLayoutParams().width = width;
            mTextView.getLayoutParams().height = height;
            mTextView.setGravity(Gravity.CENTER_VERTICAL);
        }
    }

    @Override
    public void setImageTextBackgroundResouce(int res) {
        if (mImageView != null) {
            mImageRL.setBackgroundResource(res);
            return;
        }
        if (mTextView != null) {
            mTextView.setBackgroundResource(res);
            return;
        }

        View customView = mRootLayout.getChildAt(0);
        if (customView instanceof ImageView) {
            customView.setBackgroundResource(res);
        } else {
            customView.setBackgroundResource(res);
        }
    }

    @Override
    public void setFilters(InputFilter[] filters) {
        if (mTextView != null) {
            mTextView.setFilters(filters);
            mTextView.setText(mTextView.getText());
        }
    }

    @Override
    public void setEllipsize(TextUtils.TruncateAt where) {
        if (mTextView != null) {
            mTextView.setLines(1);
            mTextView.setEllipsize(where);
        }
    }

    @Override
    public void setMaxWidth(int maxWidth) {
        if (mTextView != null) {
            mTextView.setMaxWidth(maxWidth);
        }
    }

    public void setTextMatchParentHeight() {
        if (mTextView != null) {
            mTextView.getLayoutParams().height = ViewGroup.LayoutParams.MATCH_PARENT;
            mTextView.setGravity(Gravity.CENTER_VERTICAL);
        }
    }

    @Override
    public void setContentView(View view) {
        if (view != null && mRootLayout != null) {
            mRootLayout.removeAllViews();
            mBorderLayout.removeAllViews();
            mRootLayout.addView(view);
        }
    }

    @Override
    public void setBackgroundResource(int res) {
        mRootLayout.setBackgroundResource(res);
    }

    @Override
    public void setBackgroundColor(int color) {
        //todo
    }

    @Override
    public void setRelation(int relation) {
        if (mRelation == relation) {
            return;
        }
        if (mItemType != ItemType.Item_Text_Image) {
            return;
        }
        mRelation = relation;
        mRootLayout.removeAllViews();
        mBorderLayout.removeAllViews();
        setTextImgRelation(relation);
    }

    protected boolean mIsEnabled = true;

    @Override
    public void setEnable(boolean enable) {
        mIsEnabled = enable;
        mRootLayout.setEnabled(enable);
        if (mItemType == ItemType.Item_custom) {
            if (mCustomView != null)
                mCustomView.setEnabled(enable);
        } else {
            if (mImageView != null)
                mImageView.setEnabled(enable);
            if (mCoverImageView != null)
                mCoverImageView.setEnabled(enable);
            if (mTextView != null)
                mTextView.setEnabled(enable);
        }
    }

    @Override
    public void setClickable(boolean clickable) {
        mRootLayout.setClickable(clickable);
        if (mItemType == ItemType.Item_custom) {
            if (mCustomView != null)
                mCustomView.setClickable(clickable);
        } else {
            if (mImageView != null)
                mImageView.setClickable(clickable);
            if (mCoverImageView != null)
                mCoverImageView.setClickable(clickable);
            if (mTextView != null)
                mTextView.setClickable(clickable);
        }
    }

    @Override
    public boolean isEnable() {
        return mIsEnabled;
    }

    @Override
    public void setSelected(boolean selected) {
        mRootLayout.setSelected(selected);
        if (mItemType == ItemType.Item_custom) {
            if (mCustomView != null)
                mCustomView.setSelected(selected);
        } else {
            if (ItemType.Item_Text_Image.equals(mItemType)) {
                if (selected) {
                    mBorderLayout.setBackgroundResource(R.drawable.coloritem_shape_bg);
                } else {
                    mBorderLayout.setBackgroundColor(AppResource.getColor(mContext, R.color.ux_color_translucent));
                }
            } else {
                if (mTextView != null) {
                    mTextView.setSelected(selected);
                    if (!mUseTextColorRes) {
                        if (selected) {
                            mTextView.setTextColor(mSelectTextColor);
                        } else {
                            mTextView.setTextColor(mNoSelectTextColor);
                        }
                    }
            }
            if (mImageView != null) {
                mImageView.setSelected(selected);
            }
            }

        }
    }

    @Override
    public boolean isSelected() {
        return mRootLayout.isSelected();
    }

    public void setChecked(boolean checked) {
        setSelected(checked);
    }

    @Override
    public boolean isChecked() {
        return isSelected();
    }

    View.OnClickListener mClickListenerImp = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            if (mClickListener != null) {
                mClickListener.onClick(v);
            } else if (mItemClickListener != null) {
                mItemClickListener.onClick(UIColorItem.this, v);
            }
        }
    };

    View.OnLongClickListener mLongClickListenerImp = new View.OnLongClickListener() {
        @Override
        public boolean onLongClick(View v) {
            if (mLongClickListener != null) {
                return mLongClickListener.onLongClick(v);
            } else if (mItemLongClickListener != null) {
                return mItemLongClickListener.onLongPress(UIColorItem.this, v);
            }
            return false;
        }
    };

    @Override
    public void setOnClickListener(View.OnClickListener l) {
        mClickListener = l;
        mRootLayout.setOnClickListener(mClickListenerImp);
        if (mImageView != null) {
            mImageView.setOnClickListener(mClickListenerImp);
        }
    }

    @Override
    public void setOnLongClickListener(View.OnLongClickListener l) {
        mLongClickListener = l;
        mRootLayout.setOnLongClickListener(mLongClickListenerImp);
    }

    @Override
    public void setOnItemClickListener(OnItemClickListener l) {
        mItemClickListener = l;
        mRootLayout.setOnClickListener(mClickListenerImp);
        if (mImageView != null) {
            mImageView.setOnClickListener(mClickListenerImp);
        }
    }

    @Override
    public void performClick() {
        if (mClickListener != null) {
            mClickListener.onClick(mRootLayout);
        } else if (mItemClickListener != null) {
            mItemClickListener.onClick(UIColorItem.this, mRootLayout);
        }
    }

    @Override
    public void performLongClick() {
        if (mLongClickListener != null) {
            mLongClickListener.onLongClick(mRootLayout);
        } else if (mItemLongClickListener != null) {
            mItemLongClickListener.onLongPress(UIColorItem.this, mRootLayout);
        }
    }

    @Override
    public void setOnItemLongPressListener(OnItemLongPressListener l) {
        mItemLongClickListener = l;
        mRootLayout.setOnLongClickListener(mLongClickListenerImp);
        if (mImageView != null) {
            mImageView.setOnLongClickListener(mLongClickListenerImp);
        }
    }

    @Override
    public void setTag(int tag) {
        mTag = tag;
    }

    @Override
    public int getTag() {
        return mTag;
    }

    @Override
    public void setId(int id) {
        mRootLayout.setId(id);
    }

    @Override
    public int getId() {
        if (mRootLayout != null) {
            return mRootLayout.getId();
        } else {
            return 0;
        }
    }

    @Override
    public void setInterval(int interval) {
        if (mTextView == null || mTextView.getLayoutParams() == null) {
            return;
        }
        if (!(mTextView.getLayoutParams() instanceof LinearLayout.LayoutParams)) {
            return;
        }
        ((LinearLayout.LayoutParams) mTextView.getLayoutParams()).setMargins(0, 0, 0, 0);
        if (mRelation == RELATION_LEFT) {
            ((LinearLayout.LayoutParams) mTextView.getLayoutParams()).rightMargin = interval;
        } else if (mRelation == RELATION_RIGNT) {
            ((LinearLayout.LayoutParams) mTextView.getLayoutParams()).leftMargin = interval;
        } else if (mRelation == RELATION_TOP) {
            ((LinearLayout.LayoutParams) mTextView.getLayoutParams()).bottomMargin = interval;
        } else {
            ((LinearLayout.LayoutParams) mTextView.getLayoutParams()).topMargin = interval;
        }
    }

    @Override
    public void setDisplayStyle(ItemType type) {
        if (ItemType.Item_Image.equals(type)) {
            if (mImageView != null) {
                mImageRL.setVisibility(View.VISIBLE);
            }
            if (mTextView != null) {
                mTextView.setVisibility(View.GONE);
            }
        } else if (ItemType.Item_Text.equals(type)) {
            if (mImageView != null) {
                mImageRL.setVisibility(View.GONE);
            }
            if (mTextView != null) {
                mTextView.setVisibility(View.VISIBLE);
            }
        } else if (ItemType.Item_Text_Image.equals(type)) {
            if (mImageView != null) {
                mImageRL.setVisibility(View.VISIBLE);
            }
            if (mTextView != null) {
                mTextView.setVisibility(View.VISIBLE);
            }
        } else {
            if (mImageView != null) {
                mImageRL.setVisibility(View.GONE);
            }
            if (mTextView != null) {
                mTextView.setVisibility(View.GONE);
            }
        }
    }

    public void setTextUnderline() {
        mTextView.getPaint().setFlags(Paint.UNDERLINE_TEXT_FLAG);
    }

    public void cleanTextFlags() {
        mTextView.getPaint().setFlags(0);
    }

    public void setImageContentDescription(String des) {
        if (mImageView != null) {
            mImageView.setContentDescription(des);
        }
    }

    public void setTextContentDescription(String des) {
        if (mTextView != null) {
            mTextView.setContentDescription(des);
        }
    }

    public interface IItemLayoutListener {
        void onItemLayout(int l, int t, int r, int b);
    }

    IBaseItem.IItemLayoutListener mItemLayoutListener;

    public void setItemLayoutListener(IBaseItem.IItemLayoutListener l) {
        mItemLayoutListener = l;
    }

    @Override
    public IBaseItem cloneItem() {
        //todo
        return null;
    }

    @Override
    public void updateThemeColor() {
        if (mCustomView == null) {
            if (mImageView != null) {
                mImageView.setColorStateList(ThemeUtil.getTextDesImageColorStateList(mContext));
            }
            if (mTextView != null) {
                mTextView.setTextColor(ThemeUtil.getTextDesTextColorStateList(mContext));
            }
            if (mBorderLayout != null) {
                if (mRootLayout.isSelected()) {
                    mBorderLayout.setBackgroundResource(0);
                    mBorderLayout.setBackgroundResource(R.drawable.coloritem_shape_bg);
                } else {
                    mBorderLayout.setBackgroundColor(AppResource.getColor(mContext, R.color.ux_color_translucent));
                }
            }
        }
    }

    @Override
    public void onItemLayout(int l, int t, int r, int b) {
        if (mItemLayoutListener != null) {
            mItemLayoutListener.onItemLayout(l, t, r, b);
        }
    }

    public void setCustomView(View view) {
        mRootLayout.removeAllViews();
        if (view != null)
            mRootLayout.addView(view);
        mImageRL = null;
        mTextView = null;
    }

    public void setAlphaColorBg(int color) {
        if (mCustomView != null && mCustomView instanceof UIToolView) {
            ((UIToolView) mCustomView).setFillColor(color);
            return;
        }

        if (mImageColorBgView != null) {
            mImageColorBgView.setBackgroundColor(color);
        }
    }

    public void setCoverImageResource(int resId) {
        if (mCoverImageView != null) {
            mCoverImageView.setImageResource(resId);
        }
    }

    public void setCoverImageTintList(ColorStateList tint) {
        if (mCoverImageView != null)
            ThemeUtil.setTintList(mCoverImageView, tint);
    }

    public View getCustomView() {
        return mCustomView;
    }

    public int getImageResId () {
        return mImageRes;
    }

    public View getImageView() {
        return mImageView;
    }

}
