/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

import com.foxit.uiextensions.R;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

public class E2ELinearLayout extends LinearLayout {

    private View immersiveTopView;

    public E2ELinearLayout(@NonNull Context context) {
        super(context);
        init(null);
    }

    public E2ELinearLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(attrs);
    }

    public E2ELinearLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(attrs);
    }

    private void init(AttributeSet attrs) {
        immersiveTopView = new View(getContext());
        immersiveTopView.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT, 0));

        addView(immersiveTopView, 0);
        if (attrs != null) {
            TypedArray a = getContext().obtainStyledAttributes(attrs, R.styleable.ImmersiveLayout);
            int topImmersiveColor = a.getColor(R.styleable.ImmersiveLayout_topImmersiveColor,
                    getResources().getColor(R.color.ui_color_top_bar_main));
            immersiveTopView.setBackgroundColor(topImmersiveColor);
            a.recycle();
        } else {
            immersiveTopView.setBackgroundColor(getResources().getColor(R.color.ui_color_top_bar_main));
        }

        ViewCompat.setOnApplyWindowInsetsListener(this, new androidx.core.view.OnApplyWindowInsetsListener() {
            @Override
            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat windowInsets) {
                androidx.core.graphics.Insets insets;
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
                    insets = windowInsets.getInsets(WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout());
                } else {
                    insets = windowInsets.getInsets(WindowInsetsCompat.Type.displayCutout());
                }
                immersiveTopView.getLayoutParams().height = insets.top;
                immersiveTopView.requestLayout();

                E2ELinearLayout.this.setPadding(insets.left, 0, insets.right, insets.bottom);
                return WindowInsetsCompat.CONSUMED;
            }
        });
    }

    public void setTopImmersiveColor(int color) {
        immersiveTopView.setBackgroundColor(color);
    }
}
