/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.compare;

import android.app.DialogFragment;
import android.os.Bundle;
import android.text.method.ScrollingMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;

public class CompareResultWindow extends DialogFragment {

    private View mCompareResultView;
    private TextView mTvTitle;
    private TextView mTvContent;
    private ImageView mIvDvider;
    private String mTitle;
    private String mContent;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        mCompareResultView = LayoutInflater.from(getActivity()).inflate(R.layout.compare_result_comment_layout, null, false);
        mTvTitle = mCompareResultView.findViewById(R.id.compare_result_title);
        mTvContent = mCompareResultView.findViewById(R.id.compare_result_content);
        mIvDvider = mCompareResultView.findViewById(R.id.ml_iv_page_divider);
        return mCompareResultView;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        mTvContent.setMovementMethod(ScrollingMovementMethod.getInstance());
        if (AppDisplay.isPad()) {
            mTvContent.setMinLines(10);
            mTvContent.setMaxLines(15);
        } else {
            mTvContent.setMinLines(5);
            mTvContent.setMaxLines(10);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        WindowManager.LayoutParams params = getDialog().getWindow().getAttributes();
        params.width = (int) (AppDisplay.getActivityWidth() * 0.4);
        params.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        getDialog().getWindow().setAttributes(params);
        getDialog().setCanceledOnTouchOutside(true);
        getDialog().getWindow().clearFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
        getDialog().getWindow().setBackgroundDrawableResource(R.drawable.dlg_title_bg_4circle_corner_white);
        mCompareResultView.setBackgroundResource(R.drawable.dlg_title_bg_4circle_corner_white);
        mTvTitle.setBackgroundResource(R.drawable.dlg_title_bg_circle_corner_blue);
        mTvTitle.setTextColor(AppResource.getColor(getActivity(), R.color.t4));
        mTvContent.setTextColor(AppResource.getColor(getActivity(), R.color.t4));
        mIvDvider.setBackgroundColor(AppResource.getColor(getActivity(), R.color.p1));
        mTvTitle.setText(mTitle);
        mTvContent.setText(mContent);
        super.onStart();
    }

    public void setContent(String content) {
        mContent=content;
    }

    public void setTitle(String title) {
        mTitle=title;
    }
}
