/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.more;

import com.foxit.uiextensions.controls.menu.IMenuView;

/**
 * The unique identifier of More menu group and group item {@link IMenuView} {@link MoreMenuModule}
 */
public class MoreMenuConstants {
    /**The primary menu, include{@link #ITEM_PRIMARY_PROTECT} and {@link #ITEM_PRIMARY_COMMENT_FIELDS}*/
    public static final int GROUP_ACTION_MENU_PRIMARY = 1000;
    /**The second menu, include start with {@link #ITEM_SECONDARY_SAVE_AS} and end with {@link #ITEM_SECONDARY_SCREEN}*/
    public static final int GROUP_ACTION_MENU_SECONDARY = 1001;

    //Primary Action Group
    /** The item of primary action group: protect */
    public static final int ITEM_PRIMARY_PROTECT = 1;
    /** The item of primary action group: comment&fields */
    public static final int ITEM_PRIMARY_COMMENT_FIELDS = 2;

    //Secondary Action Group
    /** The item of secondary action group: save as */
    public static final int ITEM_SECONDARY_SAVE_AS = 1;
    /** The item of secondary action group: reduce file size */
    public static final int ITEM_SECONDARY_REDUCE_FILE_SIZE = 2;
    /** The item of secondary action group: print */
    public static final int ITEM_SECONDARY_PRINT = 3;
    /** The item of secondary action group: flatten */
    public static final int ITEM_SECONDARY_FLATTEN = 4;
    /** The item of secondary action group: screen */
    public static final int ITEM_SECONDARY_SCREEN = 5;
    /** The item of secondary action group: info  */
    public static final int ITEM_SECONDARY_INFO = 6;

    //Protect Group
    /** The item of protect group: redaction */
    public static final int ITEM_PROTECT_REDACTION = 1;
    /** The item of protect group: remove password */
    public static final int ITEM_PROTECT_REMOVE_PASSWORD = 2;
    /** The item of protect group: file encryption */
    public static final int ITEM_PROTECT_FILE_ENCRYPTION = 3;
    /** The item of protect group: trusted certificates */
    public static final int ITEM_PROTECT_TRUSTED_CERTIFICATES = 4;

    //Comment&Fields Group
    /** The item of comment&fields group: import comments */
    public static final int ITEM_COMMENTS_FIELDS_IMPORT_COMMENTS = 1;
    /** The item of comment&fields group: export comments */
    public static final int ITEM_COMMENTS_FIELDS_EXPORT_COMMENTS = 2;
    /** The item of comment&fields group: summarize comments */
    public static final int ITEM_COMMENTS_FIELDS_SUMMARIZE_COMMENTS = 3;
    /** The item of comment&fields group: export highlight text */
    public static final int ITEM_COMMENTS_FIELDS_EXPORT_HIGHLIGHT_TEXT = 4;
    /** The item of comment&fields group: reset form fields*/
    public static final int ITEM_COMMENTS_FIELDS_RESET_FORM_FIELDS = 5;
    /** The item of comment&fields group: import form data*/
    public static final int ITEM_COMMENTS_FIELDS_IMPORT_FORM_DATA = 6;
    /** The item of comment&fields group: export form data*/
    public static final int ITEM_COMMENTS_FIELDS_EXPORT_FORM_DATA = 7;
}

