/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.more;

import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Typeface;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentTransaction;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.annots.redaction.RedactModule;
import com.foxit.uiextensions.controls.dialog.BaseDialogFragment;
import com.foxit.uiextensions.controls.dialog.FxProgressDialog;
import com.foxit.uiextensions.controls.dialog.fileselect.UIFileSelectDialog;
import com.foxit.uiextensions.controls.dialog.fileselect.UIFolderSelectDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.impl.BaseItemImpl;
import com.foxit.uiextensions.controls.toolbar.impl.TopBarImpl;
import com.foxit.uiextensions.modules.thumbnail.IThumbnailSupport;
import com.foxit.uiextensions.modules.thumbnail.ThumbnailAdapter;
import com.foxit.uiextensions.modules.thumbnail.ThumbnailFragment;
import com.foxit.uiextensions.modules.thumbnail.ThumbnailItem;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppUtil;

import java.util.ArrayList;
import java.util.List;

public class RedactPageFragment extends BaseDialogFragment implements IThumbnailSupport {

    private PDFViewCtrl mPDFView;
    private UIExtensionsManager mUIExtensionsManager;
    private BaseItemImpl mDoneItem;
    private List<ThumbnailItem> mAllItems;
    private Point mThumbnailSize;
    private ThumbnailFragment mPageFragment;
    private TopBarImpl topBar;
    private IBaseItem cancelItem;
    private IBaseItem titleItem;

    public void init(PDFViewCtrl pdfViewCtrl) {
        mPDFView = pdfViewCtrl;
        mUIExtensionsManager = (UIExtensionsManager) pdfViewCtrl.getUIExtensionsManager();
    }


    private void initTopBar(ViewGroup parent) {
        topBar = new TopBarImpl(mContext);
        topBar.setStartMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp));
        topBar.setEndMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp));
        cancelItem = new BaseItemImpl(mContext);
        cancelItem.setDisplayStyle(IBaseItem.ItemType.Item_Text);
        cancelItem.setText(AppResource.getString(mContext, R.string.fx_string_cancel));
        cancelItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
        cancelItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_15sp));
        cancelItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
        topBar.addView(cancelItem, BaseBar.TB_Position.Position_LT);
        titleItem = new BaseItemImpl(mContext);
        titleItem.setDisplayStyle(IBaseItem.ItemType.Item_Text);
        titleItem.setText(AppResource.getString(mContext.getApplicationContext(), R.string.menu_more_redact_pages));
        titleItem.setTextColorResource(R.color.t4);
        titleItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_16sp));
        titleItem.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
        topBar.addView(titleItem, BaseBar.TB_Position.Position_CENTER);
        mDoneItem = new BaseItemImpl(mContext);
        mDoneItem.setEnable(false);
        mDoneItem.setText(AppResource.getString(mContext, R.string.fx_string_done));
        mDoneItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
        mDoneItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_15sp));
        mDoneItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                RedactModule module = (RedactModule) mUIExtensionsManager.getModuleByName(Module.MODULE_NAME_REDACT);
                if (module == null) return;
                module.redactPages(mPageFragment.getAdapter().getSelectedItemIndexes());
            }
        });
        topBar.addView(mDoneItem, BaseBar.TB_Position.Position_RB);
        topBar.setMiddleButtonCenter(true);
        parent.addView(topBar.getContentView());
    }

    @Override
    protected View onCreateView(LayoutInflater inflater, ViewGroup container) {
        View dialogView = inflater.inflate(R.layout.fragment_select_page, container, false);
        initTopBar((ViewGroup) dialogView.findViewById(R.id.top_bar_container));
        showRedactPages();
        return dialogView;
    }

    @NonNull
    @Override
    protected PDFViewCtrl getPDFViewCtrl() {
        return getPDFView();
    }

    private void showRedactPages() {
        FragmentTransaction transaction = getChildFragmentManager().beginTransaction();
        if (mAllItems == null) {
            mAllItems = new ArrayList<>();
        } else {
            mAllItems.clear();
        }
        int pageCount = mPDFView.getPageCount();
        Point backgroundSize = getThumbnailBackgroundSize();
        PDFDoc doc = mPDFView.getDoc();
        PDFPage page;
        int pageIndex;
        try {
            for (int i = 0; i < pageCount; i++) {
                page = doc.getPage(i);
                pageIndex = page.getIndex();
                ThumbnailItem allItem = new ThumbnailItem(pageIndex, backgroundSize, mPDFView);
                mAllItems.add(allItem);
            }

        } catch (PDFException e) {
            e.printStackTrace();
        }
        if (mPageFragment == null) {
            mPageFragment = ThumbnailFragment.newInstance(0, mPDFView.getCurrentPage(), this, mPDFView, mAllItems);
        }
        transaction.replace(R.id.content_container, mPageFragment, AppResource.getString(mContext, R.string.menu_more_redact_pages));
        transaction.commit();
    }

    public PDFViewCtrl getPDFView() {
        return mPDFView;
    }

    @Override
    public FxProgressDialog getProgressDialog() {
        return null;
    }

    @Override
    public void switchPasteState(boolean isPasteState) {

    }

    @Override
    public void setSelectViewMode(boolean selectedAll) {
        if (mPageFragment == null || mPageFragment.getAdapter() == null) return;
        mDoneItem.setEnable(mPageFragment.getAdapter().getSelectedItemCount() > 0);
    }

    public Point getThumbnailBackgroundSize() {
        if (mThumbnailSize == null) {
            mThumbnailSize = AppUtil.getThumbnailBackgroundSize(mPDFView);
        }
        return mThumbnailSize;
    }

    @Override
    public UIFolderSelectDialog getFolderSelectDialog() {
        return null;
    }

    @Override
    public UIFileSelectDialog getFileSelectDialog() {
        return null;
    }

    @Override
    public boolean isEditMode() {
        return true;
    }

    @Override
    public ThumbnailAdapter.ThumbViewHolder getViewHolderByItem(int tabPosition, ThumbnailItem item) {
        return mPageFragment.getViewHolderByItem(item);
    }

    @Override
    public boolean isThumbnailItemVisible(int tabPosition, ThumbnailItem item) {
        return mPageFragment.isThumbnailItemVisible(item);
    }

    @Override
    public boolean isPasteState() {
        return false;
    }

    @Override
    public void updateRecycleLayout() {
    }

    @Override
    public void exitThumbnailDialog() {
    }

    @Override
    public void refreshOtherTab() {

    }

    @Override
    public boolean isSelectMode() {
        return true;
    }

    @Override
    protected void onLayoutChange(View v, int newWidth, int newHeight, int oldWidth, int oldHeight) {
        if (null != getDialog() && getDialog().isShowing()) {
            mPageFragment.onLayoutChange(v, newWidth, newHeight, oldWidth, oldHeight);
        }
    }

}