/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.panel.annot;


import android.content.Context;
import android.view.MotionEvent;
import android.view.View;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.config.modules.annotations.AnnotationsConfig;
import com.foxit.uiextensions.controls.dialog.UIMatchDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.thread.AppThreadManager;

import java.util.List;

import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

class AnnotFilterDialog extends UIMatchDialog {
    private UIExtensionsManager mUiExtensionsManager;
    private AnnotFilterAdapter mFilterAdapter;


    public AnnotFilterDialog(Context context, PDFViewCtrl viewCtrl) {
        super(context);
        mUiExtensionsManager = (UIExtensionsManager) viewCtrl.getUIExtensionsManager();

        initStyle();
        initView();
    }

    void notifyDataSetChanged(){
        AppThreadManager.getInstance().getMainThreadHandler().post(new Runnable() {
            @Override
            public void run() {
                mFilterAdapter.notifyDataSetChanged();
            }
        });
    }

    private void initStyle() {
        setTitle(AppResource.getString(mContext, R.string.fx_search_filter_comment));
        setBackButtonVisible(View.VISIBLE);
        setBackButtonStyle(TEXT_BACK);
        setBackButtonText(AppResource.getString(mContext, R.string.fx_string_close));
        setTitlePosition(BaseBar.TB_Position.Position_CENTER);
        setStyle(DLG_TITLE_STYLE_BG_DEFAULT);
    }

    private void initView() {
        View rootView = View.inflate(mContext, R.layout.rd_recyclerview_layout, null);
        RecyclerView filterListView = rootView.findViewById(R.id.rd_recyclerview_list);
        filterListView.setLayoutManager(new LinearLayoutManager(mContext, LinearLayoutManager.VERTICAL, false));
        filterListView.setItemAnimator(new DefaultItemAnimator());
        mFilterAdapter = new AnnotFilterAdapter(mContext);
        filterListView.setAdapter(mFilterAdapter);
        AnnotationsConfig annotConfig = mUiExtensionsManager.getConfig().modules.annotations;
        mFilterAdapter.addFilterNodes(annotConfig);
        mFilterAdapter.notifyUpdateData();

        setContentView(rootView);
    }

    List<String> getSelectedTypes() {
        return mFilterAdapter.getSelectedTypes();
    }

}
