/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.panel.annot;

import com.foxit.uiextensions.modules.panel.bean.BaseBean;
import com.foxit.uiextensions.utils.AppDmUtil;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AnnotNode extends BaseBean implements Comparable<AnnotNode> {
    public final static int FLAG_LABLE = 0;
    public final static int FLAG_CONTENT = 1;
    public final static int FLAG_TOTAL_COUNT = 2;

    private int index;
    private final String uid;
    private int objNum = -1;
    private final String replyTo;
    private int replyToObjNum = -1;
    protected int counter;

    private final boolean pageDivider;

    private String type;
    private String author;
    private CharSequence contents;
    private String modifiedDate;
    private String creationDate;
    private String intent;
    private boolean canDelete;
    private boolean canReply;
    private boolean canComment;
    private AnnotNode parent;
    private List<AnnotNode> children;
    private boolean checked;
    private boolean isLocked;
    private boolean isReadOnly;
    private boolean canEdit;
    private boolean canApplyRedaction;
    private boolean canModifyContents;
    private String groupHeaderNM;
    private boolean isExpanded;

    public AnnotNode(int index, int objNum, String uid, int replyToObjNum, String replyTo) {
        this.index = index;
        this.uid = uid;
        this.objNum = objNum;
        this.replyToObjNum = replyToObjNum;
        this.replyTo = replyTo;//annotation uid
        this.pageDivider = false;
    }

    public AnnotNode(int index) {
        this.index = index;
        this.uid = null;
        this.replyTo = null;
        this.pageDivider = true;
    }

    public boolean isPageDivider() {
        return this.pageDivider;
    }

    public int getPageIndex() {
        return index;
    }

    public void setPageIndex(int index) {
        this.index = index;
    }

    public String getUID() {
        return this.uid == null ? "" : this.uid;
    }

    public int getObjNum() {
        return objNum;
    }

    public int getReplyToObjNum() {
        return replyToObjNum;
    }

    public String getReplyTo() {
        return this.replyTo == null ? "" : this.replyTo;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAuthor() {
        return this.author == null ? "" : this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setContent(CharSequence contents) {
        this.contents = contents;
    }

    public CharSequence getContent() {
        return this.contents == null ? "" : this.contents;
    }

    public void setModifiedDate(String modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getModifiedDate() {
        return this.modifiedDate == null ? AppDmUtil.DEFAULT_MMM_DD_YYYY_HH_MM : this.modifiedDate;
    }

    public String getCreationDate() {
        return this.creationDate == null ? AppDmUtil.DEFAULT_MMM_DD_YYYY_HH_MM : this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public void setParent(AnnotNode parent) {
        this.parent = parent;
    }

    public AnnotNode getParent() {
        return this.parent;
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public boolean isLeafNode() {
        return this.children == null || this.children.size() == 0;
    }

    public boolean isExpanded() {
        return this.isExpanded || this.parent == null /*|| this.getLevel() != 0*/;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
        if (this.children != null && !this.children.isEmpty()) {
            for (int i = 0; i < this.children.size(); i++) {
                AnnotNode child = this.children.get(i);
                child.isExpanded = isExpanded;

                if (child.children != null && !child.children.isEmpty()) {
                    child.setExpanded(isExpanded);
                }
            }
        }
    }

    public void addChildNode(AnnotNode note) {
        if (this.children == null) {
            this.children = new ArrayList<AnnotNode>();
        }
        if (!this.children.contains(note)) {
            this.children.add(note);
        }
    }

    // Recursively delete all child nodes.
    public void removeChildren() {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); i++) {
                this.children.get(i).removeChildren();
                this.children.get(i).setParent(null);
            }
            this.children.clear();
        }
    }

    // Remove the node from the current node and will remove all the child nodes of the node.
    public void removeChild(AnnotNode node) {
        if (this.children != null && this.children.contains(node)) {
            node.removeChildren();
            node.setParent(null);
            this.children.remove(node);
        }
    }

    public List<AnnotNode> getChildren() {
        return this.children;
    }

    public int getLevel() {
        if (pageDivider) return -1;
        return this.parent == null ? 0 : parent.getLevel() + 1;
    }

    public void setChecked(boolean isChecked) {
        if (!this.pageDivider) {
            this.checked = isChecked;
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof AnnotNode)) return false;
        AnnotNode another = (AnnotNode) o;

        if (this.pageDivider == another.pageDivider
                && this.getPageIndex() == another.getPageIndex()
                && this.getAuthor().equals(another.getAuthor())) {
            if (this.getUID().equals(another.getUID())) {
                return this.getObjNum() == another.getObjNum();
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    @Override
    public int compareTo(AnnotNode another) {
        if (another == null) return 0;
        if (getPageIndex() != another.getPageIndex())
            return getPageIndex() - another.getPageIndex();
        if (getLevel() != another.getLevel()) {
            return getLevel() - another.getLevel();
        }
        try {
            Date lDate = AppDmUtil.documentDateToJavaDate(AppDmUtil.parseDocumentDate(getCreationDate()));
            Date rDate = AppDmUtil.documentDateToJavaDate(AppDmUtil.parseDocumentDate(another.getCreationDate()));
            if (lDate == null || rDate == null)
                return 0;

            return lDate.before(rDate) ? -1 : (lDate.after(rDate) ? 1 : 0);
        } catch (Exception e) {
        }
        return 0;
    }

    public boolean isRedundant() {
        return !(this.getReplyTo().equals("") || (this.parent != null && !this.parent.isRedundant()));

    }

    public boolean canDelete() {
        return canDelete;
    }

    public void setDeletable(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public boolean canReply() {
        return canReply;
    }

    public void setCanReply(boolean canReply) {
        this.canReply = canReply;
    }

    public String getIntent() {
        return intent;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }

    public boolean isReadOnly() {
        return isReadOnly;
    }

    public void setReadOnlyFlag(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean canEdit() {
        return canEdit;
    }

    public void setEditable(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public boolean canApplyRedaction() {
        return canApplyRedaction;
    }

    public void setApplyRedaction(boolean canApplyRedaction) {
        this.canApplyRedaction = canApplyRedaction;
    }

    public boolean canComment() {
        return canComment;
    }

    public void setCanComment(boolean canComment) {
        this.canComment = canComment;
    }

    public boolean isCanModifyContents() {
        return canModifyContents;
    }

    public void setCanModifyContents(boolean canModifyContents) {
        this.canModifyContents = canModifyContents;
    }

    public String getGroupHeaderNM() {
        return groupHeaderNM;
    }

    public void setGroupHeaderNM(String groupHeaderNM) {
        this.groupHeaderNM = groupHeaderNM;
    }

    private boolean withModificationPermission;
    private boolean withDeletePermission;
    private boolean withReplyPermission;

    public boolean isWithModificationPermission() {
        return withModificationPermission;
    }

    public void setWithModificationPermission(boolean withModificationPermission) {
        this.withModificationPermission = withModificationPermission;
    }

    public boolean isWithDeletePermission() {
        return withDeletePermission;
    }

    public void setWithDeletePermission(boolean withDeletePermission) {
        this.withDeletePermission = withDeletePermission;
    }

    public boolean isWithReplyPermission() {
        return withReplyPermission;
    }

    public void setWithReplyPermission(boolean withReplyPermission) {
        this.withReplyPermission = withReplyPermission;
    }
}
