/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.print;


import android.content.Context;
import android.content.res.Configuration;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.IThemeEventListener;
import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.UIExtensionsManager;

/**
 * This module provides function to print the PDF pages to wireless printer.
 */
public class PrintModule implements Module {

    private PrintSettingOptions settingOptions;
    private PDFViewCtrl mPDFViewCtrl;
    private PDFViewCtrl.UIExtensionsManager mUiExtensionsManager;
    private Context mContext;

    public PrintModule(Context context, PDFViewCtrl pdfViewCtrl, UIExtensionsManager uiExtensionsManager) {
        mContext = context;
        mPDFViewCtrl = pdfViewCtrl;
        mUiExtensionsManager = uiExtensionsManager;
    }

    @Override
    public String getName() {
        return Module.MODULE_NAME_PRINT;
    }

    private UIExtensionsManager.ConfigurationChangedListener mConfigurationChangedListener = new UIExtensionsManager.ConfigurationChangedListener() {
        @Override
        public void onConfigurationChanged(Configuration newConfig) {
            dismissPrintSetting();
        }
    };
    private IThemeEventListener mThemeEventListener = new IThemeEventListener() {
        @Override
        public void onThemeColorChanged(String type, int color) {
            if (settingOptions != null) {
                settingOptions.dismiss();
                settingOptions = null;
//                settingOptions.setDarkModeColor();
            }
        }
    };

    @Override
    public boolean loadModule() {
        if (mUiExtensionsManager != null) {
            ((UIExtensionsManager) mUiExtensionsManager).registerModule(this);
            ((UIExtensionsManager) mUiExtensionsManager).registerConfigurationChangedListener(mConfigurationChangedListener);
            ((UIExtensionsManager) mUiExtensionsManager).registerThemeEventListener(mThemeEventListener);
        }
        return true;
    }

    @Override
    public boolean unloadModule() {
        if (mUiExtensionsManager != null) {
            ((UIExtensionsManager) mUiExtensionsManager).unregisterConfigurationChangedListener(mConfigurationChangedListener);
            ((UIExtensionsManager) mUiExtensionsManager).unregisterThemeEventListener(mThemeEventListener);
        }
        return true;
    }

    public void showPrintSettingOptions() {
        if (settingOptions == null) {
            settingOptions = new PrintSettingOptions(((UIExtensionsManager) mPDFViewCtrl.getUIExtensionsManager()).getAttachedActivity(), mPDFViewCtrl);
        }
        settingOptions.showDialog();
    }

    public void dismissPrintSetting(){
        if (settingOptions != null && settingOptions.isShowing()) {
            settingOptions.dismiss();
            settingOptions = null;
        }
    }
}
