/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.print;


import android.content.Context;
import android.print.PrintDocumentAdapter;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.dialog.MatchDialog;
import com.foxit.uiextensions.controls.dialog.UIMatchDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppFileUtil;
import com.foxit.uiextensions.utils.AppResource;

import static com.foxit.uiextensions.utils.AppUtil.getSelectedButtonColorStateList;
import static com.foxit.uiextensions.utils.AppUtil.setSelectedButtonState;
import static com.foxit.uiextensions.utils.AppUtil.upperCaseTextView;

public class PrintSettingOptions extends UIMatchDialog {

    private final PDFViewCtrl mPDFViewCtrl;
    TextView mTvTips;
    FrameLayout switchPrintLayout;
    TextView mTvSwitchText;
    ImageView switchPrintButton;
    LinearLayout mllSwitch;

    public PrintSettingOptions(Context context, PDFViewCtrl viewCtrl) {
        super(context);

        this.mPDFViewCtrl = viewCtrl;
        createView();
    }

//    @Override
//    public void setDarkModeColor() {
//        super.setDarkModeColor();
//        mTvTips.setTextColor(AppResource.getColor(mContext, R.color.t3));
//        mTvSwitchText.setTextColor(mContext.getResources().getColor(R.color.fx_menu_text_selector));
//        mllSwitch.setBackgroundColor(mContext.getResources().getColor(R.color.b1));
//        ThemeUtil.setBackgroundTintList(switchPrintLayout, getSelectedButtonColorStateList(mContext));
//    }

    private View createView() {
        View view = View.inflate(mContext, R.layout.rv_print_setting, null);
        view.setOnTouchListener(new View.OnTouchListener() {

            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        mTvTips = view.findViewById(R.id.tips);
        upperCaseTextView(mTvTips);
        mllSwitch = view.findViewById(R.id.rv_switch_linear_layout);
        switchPrintLayout = view.findViewById(R.id.rv_switch_print_layout);
        mTvSwitchText = view.findViewById(R.id.tv_switch_text);
        ThemeUtil.setBackgroundTintList(switchPrintLayout, getSelectedButtonColorStateList(mContext));
        switchPrintButton = view.findViewById(R.id.rv_switch_print_button);
        switchPrintLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (switchPrintButton.getTag() != null) {
                    setSelectedButtonState(false, switchPrintButton);
                    switchPrintButton.setTag(null);
                } else {
                    setSelectedButtonState(true, switchPrintButton);
                    switchPrintButton.setTag(true);
                }
            }
        });
        setContentView(view);
        setTitle(mContext.getApplicationContext().getString(R.string.rv_print_setting_title));
        setTitlePosition(BaseBar.TB_Position.Position_CENTER);
        setBackButtonVisible(View.VISIBLE);
        setBackButtonStyle(TEXT_BACK);
        setBackButtonTintList(ThemeUtil.getItemIconColor(mContext));
        setRightButtonVisible(View.VISIBLE);
        setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
        setStyle(MatchDialog.DLG_TITLE_STYLE_BG_DEFAULT);

        setListener(new DialogListener() {
            @Override
            public void onResult(long btType) {
            }

            @Override
            public void onBackClick() {

            }

            @Override
            public void onTitleRightButtonClick() {
                UIExtensionsManager uiExtensionsManager = (UIExtensionsManager) mPDFViewCtrl.getUIExtensionsManager();
                String filename = AppFileUtil.getFileNameWithoutExt(mPDFViewCtrl.getFilePath());
                PrintDocumentAdapter adapter = null;
                if (mPDFViewCtrl.isDynamicXFA()) {
                    adapter = new XFAPrintAdapter(mContext,
                            mPDFViewCtrl.getXFADoc(),
                            filename,
                            switchPrintButton.getTag() != null,
                            null);
                } else {
                    try {
                        PDFDoc doc = mPDFViewCtrl.getDoc();
                        if (doc.getPageCount() <= 100) {//TODO SDKRD-8333
                            adapter = new PDFPrintAdapter(mContext,
                                    doc,
                                    filename,
                                    switchPrintButton.getTag() != null,
                                    null);
                        }
                    } catch (PDFException e) {
                        e.printStackTrace();
                    }
                }

                new PDFPrint.Builder(uiExtensionsManager.getAttachedActivity(), mPDFViewCtrl.getFilePath())
                        .setAdapter(adapter)
                        .setPageCount(mPDFViewCtrl.getPageCount())
                        .print();
                dismiss();
            }
        });

        return view;
    }
}
