/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.signature;

import android.graphics.Bitmap;
import android.graphics.Rect;

import com.foxit.uiextensions.modules.panel.bean.BaseBean;

public class SignatureInkItem extends BaseBean {
    public final static int FLAG_NORMAL = 0;
    public final static int FLAG_DSG = 1;
    public final static int FLAG_LABEL = 2;

    boolean selected;
    Bitmap bitmap;
    String key;
    Rect rect;
    int color;
    float diameter;
    String dsgPath;
    String title;
    boolean isLogo;
    String name;
    String distinguishedName;
    int reason;
    boolean isReasonOpen;
    boolean isLocationOpen;
    String location;
    String date;
    String version;
    boolean isLabels;
    boolean isNameOpen;
    boolean isDistinguishedNameOpen;
    boolean isDateOpen;
    boolean isVersionOpen;
    String signInfo;

    boolean isClearBg;

    boolean isPic;

    public boolean isClearBg() {
        return isClearBg;
    }

    public void setClearBg(int clearBg) {
        if (clearBg == 0) {
            isClearBg = false;
        } else {
            isClearBg = true;
        }
    }
    public boolean isPic() {
        return isPic;
    }

    public void setPic(int pic) {
        if (pic == 0) {
            isPic = false;
        } else {
            isPic = true;
        }
    }


    public String getSignInfo() {
        return signInfo;
    }

    public void setSignInfo(String signInfo) {
        this.signInfo = signInfo;
    }

    public String getName() {
        return name != null ? name:"";
    }

    public void setName(String name) {
        this.name = name;
    }


    public boolean isNameOpen() {
        return isNameOpen;
    }

    public void setNameOpen(int nameOpen) {
        if (nameOpen == 0) {
            isNameOpen = false;
        } else {
            isNameOpen = true;
        }
    }

    public boolean isDistinguishedNameOpen() {
        return isDistinguishedNameOpen;
    }

    public void setDistinguishedNameOpen(int distinguishedNameOpen) {
        if (distinguishedNameOpen == 0) {
            isDistinguishedNameOpen = false;
        } else {
            isDistinguishedNameOpen = true;
        }
    }

    public boolean isDateOpen() {
        return isDateOpen;
    }

    public void setDateOpen(int dateOpen) {
        if (dateOpen == 0) {
            isDateOpen = false;
        } else {
            isDateOpen = true;
        }
    }

    public boolean isVersionOpen() {
        return isVersionOpen;
    }

    public void setVersionOpen(int versionOpen) {
        if (versionOpen == 0) {
            isVersionOpen = false;
        } else {
            isVersionOpen = true;
        }
    }

    public static int getFlagNormal() {
        return FLAG_NORMAL;
    }

    public static int getFlagDsg() {
        return FLAG_DSG;
    }

    public static int getFlagLabel() {
        return FLAG_LABEL;
    }

    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Bitmap getBitmap() {
        return bitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Rect getRect() {
        return rect;
    }

    public void setRect(Rect rect) {
        this.rect = rect;
    }

    public int getColor() {
        return color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public float getDiameter() {
        return diameter;
    }

    public void setDiameter(float diameter) {
        this.diameter = diameter;
    }

    public String getDsgPath() {
        return dsgPath;
    }

    public void setDsgPath(String dsgPath) {
        this.dsgPath = dsgPath;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isLogo() {
        return isLogo;
    }

    public void setLogo(int logo) {
        if (logo == 0) {
            isLogo = false;
        } else {
            isLogo = true;
        }
    }


    public String getDistinguishedName() {
        return distinguishedName;
    }

    public void setDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
    }

    public int getReason() {
        return reason;
    }

    public void setReason(int reason) {
        this.reason = reason;
    }

    public boolean isReasonOpen() {
        return isReasonOpen;
    }

    public void setReasonOpen(int reasonOpen) {
        if (reasonOpen == 0) {
            isReasonOpen = false;
        } else {
            isReasonOpen = true;
        }
    }

    public boolean isLocationOpen() {
        return isLocationOpen;
    }

    public void setLocationOpen(int locationOpen) {
        if (locationOpen == 0) {
            isLocationOpen = false;
        } else {
            isLocationOpen = true;
        }
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getVersion() {
        return version != null ? version : "";
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isLabels() {
        return isLabels;
    }

    public void setLabels(int labels) {
        if (labels == 0) {
            isLabels = false;
        } else {
            isLabels = true;
        }
    }

    public SignatureInkItem clone() {
        SignatureInkItem inkItem = new SignatureInkItem();
        inkItem.selected = selected;
        inkItem.bitmap = bitmap;
        inkItem.key = key;
        inkItem.rect = rect;
        inkItem.color = color;
        inkItem.diameter = diameter;
        inkItem.dsgPath = dsgPath;
        inkItem.title = title;
        inkItem.isLogo = isLogo;
        inkItem.name = name;
        inkItem.distinguishedName = distinguishedName;
        inkItem.reason = reason;
        inkItem.isReasonOpen = isReasonOpen;
        inkItem.location = location;
        inkItem.isLocationOpen = isLocationOpen;
        inkItem.date = date;
        inkItem.version = version;
        inkItem.isLabels = isLabels;
        inkItem.isNameOpen = isNameOpen;
        inkItem.isDistinguishedNameOpen = isDistinguishedNameOpen;
        inkItem.isDateOpen = isDateOpen;
        inkItem.isVersionOpen = isVersionOpen;
        return inkItem;
    }
}
