/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.signature.appearance;

import android.content.Context;
import android.content.res.ColorStateList;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.IThemeEventListener;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.dialog.UIMatchDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.modules.panel.bean.SignatureBean;
import com.foxit.uiextensions.modules.signature.SignatureInkItem;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;

import java.util.ArrayList;
import java.util.List;

public class SignatureAppearanceReasonDialog extends UIMatchDialog {
    private Context mContext;
    private ViewGroup mParent;
    private PDFViewCtrl mPdfViewCtrl;
    private UIExtensionsManager mUIExtensionsManager;
    private ViewGroup mContentView;
    private RelativeLayout mSignReasonRl;
    private ImageView mSignReasonSwitchIv;
    private RecyclerView mSignReasonRecyclerView;
    private SignatureReasonAdapter mSignatureReasonAdapter;
    private LinearLayoutManager mLayoutManager;
    private ISignSwitchReasonCallback mSignSwitchReasonCallback;
    private boolean mIsOpen = false;
    private int mReason = 0;
    private SignatureReasonBean mSignReasonBean;
    private List<SignatureReasonBean> mReasonList = new ArrayList<>();

    public SignatureAppearanceReasonDialog(Context context,
                                           ViewGroup parent,
                                           PDFViewCtrl pdfViewCtrl,
                                           boolean reasonOpen,
                                           int reason
    ) {
        super(context);
        mContext = context.getApplicationContext();
        mParent = parent;
        mPdfViewCtrl = pdfViewCtrl;
        mIsOpen = reasonOpen;
        mReason = reason;
        mUIExtensionsManager = (UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager();
        initStyle();
        initView();

        setOnDLDismissListener(new DismissListener() {
            @Override
            public void onDismiss() {
                mUIExtensionsManager.unregisterThemeEventListener(mThemeColorChangedListener);
            }
        });
    }

    @Override
    public void onBackPressed() {
        if(mSignReasonBean != null){
            mReason = mSignReasonBean.getName();
        }
        mSignSwitchReasonCallback.switchReason(mIsOpen, mReason);
        dismiss();
    }

    private void initStyle() {
        setBackButtonTintList(ThemeUtil.getItemIconColor(mContext));
        setTitle(AppResource.getString(mContext, R.string.appearance_reason));
        setTitlePosition(BaseBar.TB_Position.Position_CENTER);
        setStyle(DLG_TITLE_STYLE_BG_DEFAULT);
        setListener(new DialogListener() {
            @Override
            public void onResult(long btType) {
            }

            @Override
            public void onBackClick() {
                if(mSignReasonBean != null){
                    mReason = mSignReasonBean.getName();
                }
                mSignSwitchReasonCallback.switchReason(mIsOpen, mReason);
            }

            @Override
            public void onTitleRightButtonClick() {
                dismiss();
            }
        });
    }

    private void initView() {
        mContentView = (ViewGroup) View.inflate(mContext, R.layout.sign_appearance_reason_layout, null);
        mSignReasonRl = mContentView.findViewById(R.id.sign_appearance_reason_rl);
        mSignReasonSwitchIv = mContentView.findViewById(R.id.sign_appearance_reason_switch);
        mSignReasonRecyclerView = mContentView.findViewById(R.id.sign_appearance_reason_rv);
        mLayoutManager = new LinearLayoutManager(mContext, LinearLayoutManager.VERTICAL, false);
        mSignReasonRecyclerView.setLayoutManager(mLayoutManager);
        mSignatureReasonAdapter = new SignatureReasonAdapter(mContext, mPdfViewCtrl);
        mSignReasonRecyclerView.setAdapter(mSignatureReasonAdapter);
        mSignatureReasonAdapter.setOnItemClickCallback(onItemClickCallback);
        setContentView(mContentView);
        ThemeUtil.setBackgroundTintList(mSignReasonRl, getSelectedButtonColorStateList());
        mSignReasonRl.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mIsOpen = !mIsOpen;
                if (mIsOpen) {
                    setSelectedButtonState(true, mSignReasonRl, mSignReasonSwitchIv);
                    mSignReasonRecyclerView.setVisibility(View.VISIBLE);
                } else {
                    setSelectedButtonState(false, mSignReasonRl, mSignReasonSwitchIv);
                    mSignReasonRecyclerView.setVisibility(View.GONE);
                }
                mSignatureReasonAdapter.notifyUpdateData();
            }
        });

    }

    public void loadData() {
        mUIExtensionsManager.registerThemeEventListener(mThemeColorChangedListener);
        if (mIsOpen) {
            setSelectedButtonState(true, mSignReasonRl, mSignReasonSwitchIv);
            mSignReasonRecyclerView.setVisibility(View.VISIBLE);
        } else {
            setSelectedButtonState(false, mSignReasonRl, mSignReasonSwitchIv);
            mSignReasonRecyclerView.setVisibility(View.GONE);
        }
        setReasonList();
    }

    public void setReasonList() {
        if(mReason==0){
            mReasonList.add(new SignatureReasonBean(0, true));
        }else{
            mReasonList.add(new SignatureReasonBean(0, false));
        }
        mReasonList.add(new SignatureReasonBean(1, false));
        mReasonList.add(new SignatureReasonBean(2, false));
        mReasonList.add(new SignatureReasonBean(3, false));
        mReasonList.add(new SignatureReasonBean(4, false));
        mReasonList.add(new SignatureReasonBean(5, false));
        mReasonList.add(new SignatureReasonBean(6, false));

        if (mReason != 0) {
            for (int i = 0; i < mReasonList.size(); i++) {
                if (mReason == mReasonList.get(i).getName()) {
                    mReasonList.get(i).setSelect(true);
                }
            }
        }
        mSignatureReasonAdapter.setReasonList(mReasonList);

    }

    private IThemeEventListener mThemeColorChangedListener = new IThemeEventListener() {
        @Override
        public void onThemeColorChanged(String type, int color) {
            dismiss();
        }
    };


    public void setSwitchReason(SignatureAppearanceReasonDialog.ISignSwitchReasonCallback signSwitchReasonCallback) {
        mSignSwitchReasonCallback = signSwitchReasonCallback;
    }

    public interface ISignSwitchReasonCallback {
        void switchReason(boolean open, int reason);
    }

    private SignatureReasonAdapter.OnItemClickCallback onItemClickCallback = new SignatureReasonAdapter.OnItemClickCallback() {
        @Override
        public void onItemClick(int position, SignatureReasonBean item) {
            mSignReasonBean = item;
        }
    };

    private void setSelectedButtonState(boolean isSelected, RelativeLayout switchLayout, ImageView switchIcon) {
        if (switchLayout == null || switchIcon == null) return;
        switchLayout.setSelected(isSelected);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) switchIcon.getLayoutParams();
        if (params == null) return;
        params.removeRule(isSelected ? RelativeLayout.ALIGN_PARENT_LEFT : RelativeLayout.ALIGN_PARENT_RIGHT);
        params.addRule(isSelected ? RelativeLayout.ALIGN_PARENT_RIGHT : RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);
        switchIcon.setLayoutParams(params);
    }

    private ColorStateList getSelectedButtonColorStateList() {
        int disabled = AppResource.getColor(mContext, R.color.p1);
        int selected = ThemeConfig.getInstance(mContext).getPrimaryColor();
        int normal = AppResource.getColor(mContext, R.color.p1);
        return AppResource.createColorStateList(selected, disabled, normal);
    }
}
