/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.signature.appearance;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;

import java.util.List;

public class SignatureOptionalAdapter extends SuperAdapter<SignatureOptionalBean> {
    private Context mContext;
    private UIExtensionsManager mUIExtensionsManager;
    private OnItemClickCallback mOnItemClickCallback;
    private List<SignatureOptionalBean> mOptionalList;

    public SignatureOptionalAdapter(Context context, PDFViewCtrl pdfViewCtrl) {
        super(context);
        mContext = context;
        mUIExtensionsManager = (UIExtensionsManager) pdfViewCtrl.getUIExtensionsManager();
    }

    void setOptionalList(List<SignatureOptionalBean> optionalList) {
        mOptionalList = optionalList;
    }

    @Override
    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    @Override
    public SignatureOptionalBean getDataItem(int position) {
        return mOptionalList.get(position);
    }

    @NonNull
    @Override
    public SuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int i) {
        return new SignatureOptionalHolder(LayoutInflater.from(getContext()).inflate(R.layout.sign_appearance_optional_item, parent, false));
    }

    @Override
    public int getItemCount() {
        return mOptionalList.size();
    }

    class SignatureOptionalHolder extends SuperViewHolder {
        private RelativeLayout mOptionalRl;
        private CheckBox mOptionalSelectCb;
        private TextView mOptionalTv;

        public SignatureOptionalHolder(View itemView) {
            super(itemView);
            mOptionalRl = itemView.findViewById(R.id.sign_appearance_optional_item);
            mOptionalSelectCb = itemView.findViewById(R.id.sign_appearance_optional_item_selected);
            mOptionalTv = itemView.findViewById(R.id.sign_appearance_optional_item_text);
            mOptionalRl.setOnClickListener(this);
        }

        @Override
        public void bind(BaseBean data, int position) {
            SignatureOptionalBean optionalBean = (SignatureOptionalBean) data;
            mOptionalSelectCb.setChecked(optionalBean.isSelect());
            mOptionalTv.setText(optionalBean.getName());
            ThemeUtil.setTintList(mOptionalSelectCb, ThemeUtil.getCheckboxColor(getContext()));
            mOptionalSelectCb.getBackground().setColorFilter(new
                    PorterDuffColorFilter(AppResource.getColor(getContext(), R.color.b1), PorterDuff.Mode.SRC_IN));
        }

        @Override
        public void onClick(View v) {
            int id = v.getId();
            int position = getAdapterPosition();
            SignatureOptionalBean item = mOptionalList.get(position);
            if (id == R.id.sign_appearance_optional_item) {
                if (mOnItemClickCallback != null) {
                    mOptionalList.get(position).setSelect(!item.isSelect());
                    mOnItemClickCallback.onItemClick(position, item);
                    notifyItemChanged(position);
                }
            }
        }
    }

    void setOnItemClickCallback(OnItemClickCallback callback) {
        mOnItemClickCallback = callback;
    }

    interface OnItemClickCallback {
        void onItemClick(int position, SignatureOptionalBean item);
    }
}
