/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.signature.appearance;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;

import java.util.List;

public class SignatureReasonAdapter extends SuperAdapter<SignatureReasonBean> {
    private Context mContext;
    private UIExtensionsManager mUIExtensionsManager;
    private OnItemClickCallback mOnItemClickCallback;
    private List<SignatureReasonBean> mReasonList;
    private int mOldSelectorPosition = -1;

    public SignatureReasonAdapter(Context context, PDFViewCtrl pdfViewCtrl) {
        super(context);
        mContext = context;
        mUIExtensionsManager = (UIExtensionsManager) pdfViewCtrl.getUIExtensionsManager();
    }

    void setReasonList(List<SignatureReasonBean> reasonList) {
        mReasonList = reasonList;
        for (int i = 0; i < mReasonList.size(); i++) {
            if (mReasonList.get(i).isSelect()) {
                mOldSelectorPosition = i;
            }
        }
    }

    List<SignatureReasonBean> getReasonList() {
        return mReasonList;
    }

    @Override
    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    @Override
    public SignatureReasonBean getDataItem(int position) {
        return mReasonList.get(position);
    }

    @NonNull
    @Override
    public SuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int i) {
        return new SignatureReasonHolder(LayoutInflater.from(getContext()).inflate(R.layout.sign_appearance_reason_item, parent, false));
    }

    @Override
    public int getItemCount() {
        return mReasonList.size();
    }

    class SignatureReasonHolder extends SuperViewHolder {
        private LinearLayout mReasonLl;
        private ImageView mReasonSelectIv;
        private TextView mReasonTv;

        public SignatureReasonHolder(View itemView) {
            super(itemView);
            mReasonLl = itemView.findViewById(R.id.sign_appearance_reason_item_ll);
            mReasonSelectIv = itemView.findViewById(R.id.sign_appearance_reason_item_selector);
            mReasonTv = itemView.findViewById(R.id.sign_appearance_reason_item_text);
            mReasonLl.setOnClickListener(this);
        }

        @Override
        public void bind(BaseBean data, int position) {
            SignatureReasonBean reasonBean = (SignatureReasonBean) data;
            if (reasonBean.isSelect()) {
                mReasonSelectIv.setVisibility(View.VISIBLE);
            } else {
                mReasonSelectIv.setVisibility(View.INVISIBLE);
            }
            mReasonTv.setText(getReason(reasonBean.getName()));
        }

        @Override
        public void onClick(View v) {
            int id = v.getId();
            int position = getAdapterPosition();
            SignatureReasonBean item = mReasonList.get(position);
            if (id == R.id.sign_appearance_reason_item_ll) {
                if (mOnItemClickCallback != null) {
                    if (mOldSelectorPosition != -1) {
                        mReasonList.get(mOldSelectorPosition).setSelect(false);
                    }
                    mReasonList.get(position).setSelect(true);
                    mOldSelectorPosition = position;
                    mOnItemClickCallback.onItemClick(position, item);
                    notifyUpdateData();
                }
            }
        }
        private String getReason(int reason){
            if(reason == 0){
                return mContext.getResources().getString(R.string.reason_author);
            }else if(reason == 1){
                return mContext.getResources().getString(R.string.reason_review);
            }else if(reason == 2){
                return mContext.getResources().getString(R.string.reason_approve);
            }else if(reason == 3){
                return mContext.getResources().getString(R.string.reason_approve_legally_binding);
            }else if(reason == 4){
                return mContext.getResources().getString(R.string.reason_accuracy_integrity);
            }else if(reason == 5){
                return mContext.getResources().getString(R.string.reason_sign_terms);
            }else if(reason == 6){
                return mContext.getResources().getString(R.string.reason_specified);
            }else{
                return mContext.getResources().getString(R.string.reason_author);
            }
        }
    }

    void setOnItemClickCallback(OnItemClickCallback callback) {
        mOnItemClickCallback = callback;
    }

    interface OnItemClickCallback {
        void onItemClick(int position, SignatureReasonBean item);
    }
}
