/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.textselect;


import static com.foxit.uiextensions.modules.textselect.TextSelectToolHandler.noSelectRedact;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.KeyEvent;
import android.view.MotionEvent;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.common.DateTime;
import com.foxit.sdk.common.Progressive;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.TextPage;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.uiextensions.DocumentManager;
import com.foxit.uiextensions.IPermissionProvider;
import com.foxit.uiextensions.IUIInteractionEventListener;
import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.ToolHandler;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.annots.AnnotEventListener;
import com.foxit.uiextensions.annots.freetext.typewriter.TypewriterToolHandler;
import com.foxit.uiextensions.annots.note.NoteAnnotContent;
import com.foxit.uiextensions.annots.redaction.RedactModule;
import com.foxit.uiextensions.annots.redaction.RedactToolHandler;
import com.foxit.uiextensions.controls.propertybar.AnnotMenu;
import com.foxit.uiextensions.controls.propertybar.MenuItem;
import com.foxit.uiextensions.controls.propertybar.imp.AnnotMenuImpl;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.ToolbarItemConfig;
import com.foxit.uiextensions.controls.toolbar.drag.HomeToolBar;
import com.foxit.uiextensions.modules.panzoom.PanZoomModule;
import com.foxit.uiextensions.modules.signature.SignatureModule;
import com.foxit.uiextensions.modules.signature.SignatureToolHandler;
import com.foxit.uiextensions.pdfreader.config.ReadStateConfig;
import com.foxit.uiextensions.pdfreader.impl.MainFrame;
import com.foxit.uiextensions.utils.AppAnnotUtil;
import com.foxit.uiextensions.utils.AppUtil;
import com.foxit.uiextensions.utils.UIToast;

import java.util.ArrayList;
import java.util.List;

public class BlankSelectToolHandler implements ToolHandler {

    private PDFViewCtrl mPdfViewCtrl;
    private AnnotMenu mAnnotationMenu;
    private AnnotEventListener mAnnotListener;

    private PointF mMenuPoint;
    private PointF mMenuPdfPoint;
    private RectF mMenuBox;
    private int mCurrentIndex;
    private boolean mIsMenuShow;
    public PDFViewCtrl.UIExtensionsManager mUiExtensionsManager;
    private Context mContext;
    private ArrayList<SelectExtentsionMenuItem> mExtMenuItems = new ArrayList<>();

    public BlankSelectToolHandler(Context context, PDFViewCtrl pdfViewCtrl, PDFViewCtrl.UIExtensionsManager uiExtensionsManager) {
        this.mPdfViewCtrl = pdfViewCtrl;
        mContext = context;
        mUiExtensionsManager = uiExtensionsManager;
        mMenuPoint = null;
        mAnnotationMenu = new AnnotMenuImpl(context, mPdfViewCtrl);

        mAnnotListener = new AnnotEventListener() {
            @Override
            public void onAnnotAdded(PDFPage page, Annot annot) {
            }

            @Override
            public void onAnnotWillDelete(PDFPage page, Annot annot) {
            }

            @Override
            public void onAnnotDeleted(PDFPage page, Annot annot) {

            }

            @Override
            public void onAnnotModified(PDFPage page, Annot annot) {
            }

            @Override
            public void onAnnotChanged(Annot lastAnnot, Annot currentAnnot) {
                if (currentAnnot != null && mIsMenuShow) {
                    mIsMenuShow = false;
                    mAnnotationMenu.dismiss();
                }
            }
        };

        ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().registerAnnotEventListener(mAnnotListener);
        if (mUiExtensionsManager instanceof UIExtensionsManager) {
            ((UIExtensionsManager) mUiExtensionsManager).registerMenuEventListener(mMenuEventListener);
            ((UIExtensionsManager) mUiExtensionsManager).registerToolHandlerChangedListener(mHandlerChangedListener);
        }
    }

    public void unload() {
        ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().unregisterAnnotEventListener(mAnnotListener);
        if (mUiExtensionsManager instanceof UIExtensionsManager) {
            ((UIExtensionsManager) mUiExtensionsManager).unregisterMenuEventListener(mMenuEventListener);
            ((UIExtensionsManager) mUiExtensionsManager).unregisterToolHandlerChangedListener(mHandlerChangedListener);
        }
    }

    protected AnnotMenu getAnnotationMenu() {
        return mAnnotationMenu;
    }

    @Override
    public String getType() {
        return TH_TYPE_BLANKSELECT;
    }

    @Override
    public void onActivate() {
    }

    @Override
    public void onDeactivate() {
        if (!mPdfViewCtrl.isPageVisible(mCurrentIndex)) return;
        dismissMenu();
    }

    @Override
    public boolean onTouchEvent(int pageIndex, MotionEvent motionEvent) {
        return false;
    }

    @Override
    public boolean onLongPress(final int pageIndex, final MotionEvent motionEvent) {
        final UIExtensionsManager uiExtensionsManager = (UIExtensionsManager) mUiExtensionsManager;
        final DocumentManager documentManager = uiExtensionsManager.getDocumentManager();
        PointF pointF = AppAnnotUtil.getPageViewPoint(mPdfViewCtrl, pageIndex, motionEvent);
        try {
            if (documentManager.getCurrentAnnot() != null) {
                documentManager.setCurrentAnnot(null);
                return false;
            }

            final TextSelectToolHandler toolHandler = (TextSelectToolHandler) uiExtensionsManager.getToolHandlerByType(ToolHandler.TH_TYPE_TEXTSELECT);
            if (toolHandler != null && toolHandler.getAnnotationMenu().isShowing()) {
                toolHandler.getAnnotationMenu().dismiss();
                return false;
            }

            if (mIsMenuShow) {
                mIsMenuShow = false;
                mAnnotationMenu.dismiss();
                return true;
            }

            mCurrentIndex = pageIndex;
            PointF pointPdfView = new PointF();
            mPdfViewCtrl.convertPageViewPtToPdfPt(pointF, pointPdfView, mCurrentIndex);

            if (mPdfViewCtrl.getDoc() == null || mPdfViewCtrl.getDoc().getPage(mCurrentIndex) == null)
                return false;

            final PDFPage page = mPdfViewCtrl.getDoc().getPage(mCurrentIndex);
            if (!page.isParsed()) {
                Progressive progressive = page.startParse(PDFPage.e_ParsePageNormal, null, false);
                int state = Progressive.e_ToBeContinued;
                while (state == Progressive.e_ToBeContinued) {
                    state = progressive.resume();
                }
            }
            TextPage textPage = new TextPage(page, TextPage.e_ParseTextNormal);

            int index = textPage.getIndexAtPos(pointPdfView.x, pointPdfView.y, 10);
            if (index == -1
                    && uiExtensionsManager.isEnableModification()
                    && (documentManager.canAddAnnot() || documentManager.canAddSignature())) {
                mIsMenuShow = true;
                mMenuPoint = new PointF(pointF.x, pointF.y);
                mMenuPdfPoint = new PointF(mMenuPoint.x, mMenuPoint.y);
                mPdfViewCtrl.convertPageViewPtToPdfPt(mMenuPdfPoint, mMenuPdfPoint, mCurrentIndex);

                mMenuBox = new RectF(pointF.x, pointF.y, pointF.x + 1, pointF.y + 1);
                mPdfViewCtrl.convertPageViewRectToDisplayViewRect(mMenuBox, mMenuBox, mCurrentIndex);

                mAnnotationMenu.setMenuItems(getBlankSelectItems());
//                if (mExtMenuItems.size() > 0) {
                    ArrayList<MenuItem> menuItems = new ArrayList<>();
                    for (int i = 0; i < mExtMenuItems.size(); i++) {
                        menuItems.add(mExtMenuItems.get(i).getMenuItem());
                    }
                    mAnnotationMenu.setExtensionMenuItems(menuItems);
//                }
                if (noSelectRedact(uiExtensionsManager))
                    mAnnotationMenu.show(mMenuBox);
                mAnnotationMenu.setListener(new AnnotMenu.ClickListener() {
                    @Override
                    public void onAMClick(int btType) {
                        if (btType == AnnotMenu.AM_BT_NOTE) {
                            uiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_LongPress_Comment);
                            PDFPage pdfPage = null;
                            try {
                                pdfPage = mPdfViewCtrl.getDoc().getPage(mCurrentIndex);
                            } catch (PDFException e1) {
                                e1.printStackTrace();
                            }
                            if (pdfPage == null || pdfPage.isEmpty()) return;
                            PointF p = new PointF(mMenuPdfPoint.x, mMenuPdfPoint.y);
                            documentManager.addAnnot(page, new TextAnnotContent(p, mCurrentIndex), true, null);
                        } else if (btType == AnnotMenu.AM_BT_TYPEWRITER) {
                            uiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_LongPress_Comment);
                            PDFPage pdfPage = null;
                            try {
                                pdfPage = mPdfViewCtrl.getDoc().getPage(mCurrentIndex);
                            } catch (PDFException e1) {
                                e1.printStackTrace();
                            }
                            if (pdfPage == null || pdfPage.isEmpty()) return;
                            PointF p = new PointF(mMenuPoint.x, mMenuPoint.y);

                            //uiExtensionsManager.getDocumentManager().addAnnot(page, new TypewriterAnnotContentImp(p, mCurrentIndex), true, null);
                            TypewriterToolHandler typewriterToolHandler = (TypewriterToolHandler) uiExtensionsManager.getToolHandlerByType(ToolHandler.TH_TYPE_TYPEWRITER);
                            typewriterToolHandler.addAnnotToPosition(pageIndex, p);

                            //    Module module = uiExtensionsManager.getModuleByName(Module.MODULE_NAME_TYPEWRITER);
                            //    MainFrame mainFrame = (MainFrame) uiExtensionsManager.getMainFrame();
                            //    if (module != null) {
                            //        if (uiExtensionsManager.getState() == ReadStateConfig.STATE_PANZOOM
                            //                || uiExtensionsManager.getState() == ReadStateConfig.STATE_REDACT
                            //                || uiExtensionsManager.getState() == ReadStateConfig.STATE_AUTOFLIP
                            //                || uiExtensionsManager.getState() == ReadStateConfig.STATE_TTS) {
                            //            uiExtensionsManager.changeState(ReadStateConfig.STATE_NORMAL);
                            //        }
                            //        if (mainFrame.isShowFullScreenToolBar()) {
                            //            HomeToolBar fullScreenHomeToolbar = mainFrame.getFullScreenHomeToolbar();
                            //            typewriterToolItemClick(fullScreenHomeToolbar.getToolItems().toolItems);
                            //        } else if (mainFrame.getCurrentTab() == ToolbarItemConfig.ITEM_HOME_TAB
                            //                || mainFrame.getCurrentTab() == ToolbarItemConfig.ITEM_COMMENT_TAB) {
                            //            if (mainFrame.isShowFullScreenUI()) {
                            //                mainFrame.updateFullScreenUI(false);
                            //            }
                            //            typewriterToolItemClick(mainFrame.getCurToolbar().getToolItems().toolItems);
                            //        } else {
                            //            if (mainFrame.isShowFullScreenUI()) {
                            //                mainFrame.updateFullScreenUI(false);
                            //            }
                            //            mainFrame.setCurrentTab(ToolbarItemConfig.ITEM_COMMENT_TAB);
                            //            typewriterToolItemClick(mainFrame.getCurToolbar().getToolItems().toolItems);
                            //        }
                            //    }
                        } else if (btType == AnnotMenu.AM_BT_PENCIL) {

                            Module module = uiExtensionsManager.getModuleByName(Module.MODULE_NAME_INK);
                            MainFrame mainFrame = (MainFrame) uiExtensionsManager.getMainFrame();
                            if (module != null) {
                                if (uiExtensionsManager.getState() == ReadStateConfig.STATE_PANZOOM
                                        || uiExtensionsManager.getState() == ReadStateConfig.STATE_REDACT
                                        || uiExtensionsManager.getState() == ReadStateConfig.STATE_SEARCH
                                        || uiExtensionsManager.getState() == ReadStateConfig.STATE_AUTOFLIP
                                        || uiExtensionsManager.getState() == ReadStateConfig.STATE_TTS) {
                                    uiExtensionsManager.changeState(ReadStateConfig.STATE_NORMAL);
                                }
                                if (mainFrame.isShowFullScreenToolBar()) {
                                    HomeToolBar fullScreenHomeToolbar = mainFrame.getFullScreenHomeToolbar();
                                    toolItemClick(fullScreenHomeToolbar.getToolItems().toolItems);
                                } else if (mainFrame.getCurrentTab() == ToolbarItemConfig.ITEM_HOME_TAB
                                        || mainFrame.getCurrentTab() == ToolbarItemConfig.ITEM_DRAWING_TAB) {
                                    if (mainFrame.isShowFullScreenUI()) {
                                        mainFrame.updateFullScreenUI(false);
                                    }
                                    toolItemClick(mainFrame.getCurToolbar().getToolItems().toolItems);
                                } else {
                                    if (mainFrame.isShowFullScreenUI()) {
                                        mainFrame.updateFullScreenUI(false);
                                    }
                                    mainFrame.setCurrentTab(ToolbarItemConfig.ITEM_DRAWING_TAB);
                                    toolItemClick(mainFrame.getCurToolbar().getToolItems().toolItems);
                                }
                            }
                        } else if (btType == AnnotMenu.AM_BT_SIGNATURE) {
                            uiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_LongPress_Sign);
                            Module module = uiExtensionsManager.getModuleByName(Module.MODULE_NAME_PSISIGNATURE);
                            if (module != null) {
                                SignatureToolHandler toolHandler = (SignatureToolHandler) ((SignatureModule) module).getToolHandler();
                                uiExtensionsManager.setCurrentToolHandler(toolHandler);
                                PointF p = new PointF(mMenuPdfPoint.x, mMenuPdfPoint.y);
                                mPdfViewCtrl.convertPdfPtToPageViewPt(p, p, mCurrentIndex);
                                toolHandler.showSignList(mCurrentIndex, p);
                            }
                        } else if (btType == AnnotMenu.AM_BT_REDACT) {
                            uiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_LongPress_Redaction);
                            final Runnable doRunnable = new Runnable() {
                                @Override
                                public void run() {
                                    if (AppAnnotUtil.hasModuleLicenseRight(Constants.e_ModuleNameRedaction)) {
                                        Module module = uiExtensionsManager.getModuleByName(Module.MODULE_NAME_REDACT);
                                        if (module != null) {
                                            RedactToolHandler toolHandler = (RedactToolHandler) ((RedactModule) module).getToolHandler();
                                            toolHandler.setContinueAddAnnot(true);
                                            uiExtensionsManager.setCurrentToolHandler(toolHandler);
                                        }
                                    } else {
                                        String message = AppUtil.getMessage(mContext, Constants.e_ErrNoRedactionModuleRight);
                                        UIToast.getInstance(mContext).show(message);
                                    }
                                }
                            };
                            if (uiExtensionsManager.getPermissionProvider() != null) {
                                uiExtensionsManager.getPermissionProvider().checkPermission(
                                        IPermissionProvider.FUNCTION_REDACTION, new IPermissionProvider.IPermissionState() {
                                            @Override
                                            public void onState(int state) {
                                                if (state == IPermissionProvider.PERMISSION_STATE_SHOW) {
                                                    doRunnable.run();
                                                }
                                            }
                                        }
                                );
                            } else {
                                doRunnable.run();
                            }
                        } else {
                            for (int i = 0; i < mExtMenuItems.size(); i++) {
                                if (mExtMenuItems.get(i).getMenuItem().getType() == btType) {
                                    PointF p = new PointF(mMenuPdfPoint.x, mMenuPdfPoint.y);
                                    mPdfViewCtrl.convertPdfPtToPageViewPt(p, p, mCurrentIndex);
                                    if (mExtMenuItems.get(i).getSelectListener() != null) {
                                        mExtMenuItems.get(i).getSelectListener().onSelected(mExtMenuItems.get(i).getMenuItem(), mCurrentIndex, p);
                                    }
                                }
                            }
                        }

                        mAnnotationMenu.dismiss();
                        mIsMenuShow = false;
                        mMenuPoint = null;
                    }
                });
                return true;
            }
        } catch (PDFException exception) {
            if (exception.getLastError() == Constants.e_ErrOutOfMemory) {
                mPdfViewCtrl.recoverForOOM();
                return true;
            }
        }
        return false;
    }

    private void toolItemClick(List<ToolItemBean> toolItems) {
        boolean isCheck = false;
        for (ToolItemBean toolItemBean : toolItems) {
            if (toolItemBean.type == ToolConstants.Pencil) {
                if (!toolItemBean.toolItem.isChecked()) {
                    toolItemBean.toolItem.performClick();
                    isCheck = true;
                }
                break;
            }
        }
        if (!isCheck) {
            MainFrame mainFrame = (MainFrame) ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getMainFrame();
            if (mainFrame.isShowFullScreenUI()) {
                mainFrame.updateFullScreenUI(false);
            }
            mainFrame.setCurrentTab(ToolbarItemConfig.ITEM_DRAWING_TAB);
            toolItemClick(mainFrame.getCurToolbar().getToolItems().toolItems);
        }
    }

    private void typewriterToolItemClick(List<ToolItemBean> toolItems) {
        boolean isCheck = false;
        for (ToolItemBean toolItemBean : toolItems) {
            if (toolItemBean.type == ToolConstants.Typewriter) {
                if (!toolItemBean.toolItem.isChecked()) {
                    toolItemBean.toolItem.performClick();
                    isCheck = true;
                }
                break;
            }
        }
        if (!isCheck) {
            MainFrame mainFrame = (MainFrame) ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getMainFrame();
            if (mainFrame.isShowFullScreenUI()) {
                mainFrame.updateFullScreenUI(false);
            }
            mainFrame.setCurrentTab(ToolbarItemConfig.ITEM_COMMENT_TAB);
            toolItemClick(mainFrame.getCurToolbar().getToolItems().toolItems);
        }
    }

    @Override
    public boolean onSingleTapConfirmed(int pageIndex, MotionEvent motionEvent) {
        if (mIsMenuShow) {
            mIsMenuShow = false;
            mAnnotationMenu.dismiss();
            return true;
        }
        return false;
    }

    @Override
    public boolean isContinueAddAnnot() {
        return false;
    }

    @Override
    public void setContinueAddAnnot(boolean continueAddAnnot) {
    }

    @Override
    public void onDraw(int i, Canvas canvas) {
        onDrawForAnnotMenu(canvas);
    }

    private ArrayList<Integer> getBlankSelectItems() {
        ArrayList<Integer> items = new ArrayList<>();
        UIExtensionsManager extensionsManager = (UIExtensionsManager) mUiExtensionsManager;

        if (extensionsManager.getDocumentManager().withAddPermission()
                && extensionsManager.getDocumentManager().canAddAnnot()
                && extensionsManager.isEnableModification()) {

            if (extensionsManager.getConfig().modules.annotations.isLoadNote
                    && extensionsManager.getAnnotHandlerByType(Annot.e_Note) != null) {
                items.add(AnnotMenu.AM_BT_NOTE);
            }
            if (extensionsManager.getConfig().modules.annotations.isLoadTypewriter
                    && extensionsManager.getAnnotHandlerByType(Annot.e_FreeText) != null) {
                items.add(AnnotMenu.AM_BT_TYPEWRITER);
            }
            if (extensionsManager.getConfig().modules.annotations.isLoadPencil
                    && extensionsManager.getAnnotHandlerByType(Annot.e_Ink) != null) {
                items.add(AnnotMenu.AM_BT_PENCIL);
            }
            if (extensionsManager.getConfig().modules.annotations.isLoadRedaction
                    && extensionsManager.getAnnotHandlerByType(Annot.e_Redact) != null
                    && extensionsManager.getState() != ReadStateConfig.STATE_REDACT) {
                items.add(AnnotMenu.AM_BT_REDACT);
            }
        }

        if (extensionsManager.getDocumentManager().canAddSignature()
                && extensionsManager.isEnableModification()
                && extensionsManager.getModuleByName(Module.MODULE_NAME_PSISIGNATURE) != null
                && extensionsManager.getDocumentManager().withAllPermission(null)) {
            items.add(AnnotMenu.AM_BT_SIGNATURE);
        }
        return items;
    }

    public void dismissMenu() {
        if (mIsMenuShow) {
            mIsMenuShow = false;
            mAnnotationMenu.dismiss();
        }
    }

    public void addExtensionMenuItem(SelectExtentsionMenuItem menuItem) {
        if (!mExtMenuItems.contains(menuItem)) {
            mExtMenuItems.add(menuItem);
        }
    }

    public void removeExtensionMenuItem(SelectExtentsionMenuItem menuItem) {
        mExtMenuItems.remove(menuItem);
    }

    private void onDrawForAnnotMenu(Canvas canvas) {
        if (!mPdfViewCtrl.isPageVisible(mCurrentIndex)) {
            return;
        }

        if (!mIsMenuShow) {
            return;
        }

        if (mMenuPoint != null) {
            PointF temp = new PointF(mMenuPdfPoint.x, mMenuPdfPoint.y);
            mPdfViewCtrl.convertPdfPtToPageViewPt(mMenuPdfPoint, temp, mCurrentIndex);
            RectF bboxRect = new RectF(temp.x, temp.y, temp.x + 1, temp.y + 1);

            mPdfViewCtrl.convertPageViewRectToDisplayViewRect(bboxRect, bboxRect, mCurrentIndex);
            mAnnotationMenu.update(bboxRect);
        }
    }

    private UIExtensionsManager.MenuEventListener mMenuEventListener = new UIExtensionsManager.MenuEventListener() {
        @Override
        public void onTriggerDismissMenu() {
            dismissMenu();
        }
    };

    private UIExtensionsManager.ToolHandlerChangedListener mHandlerChangedListener = new UIExtensionsManager.ToolHandlerChangedListener() {
        @Override
        public void onToolHandlerChanged(ToolHandler lastTool, ToolHandler currentTool) {
            if (currentTool != null && mIsMenuShow) {
                mAnnotationMenu.dismiss();
                mIsMenuShow = false;
            }
        }
    };

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK && event.getRepeatCount() == 0) {
            return onKeyBack();
        }
        return false;
    }

    public boolean onKeyBack() {
        if (mIsMenuShow) {
            mIsMenuShow = false;
            mAnnotationMenu.dismiss();
            return true;
        }
        return false;
    }
}

class TextAnnotContent implements NoteAnnotContent {
    private PointF p = new PointF();
    private int pageIndex;

    public TextAnnotContent(PointF p, int pageIndex) {
        this.p.set(p.x, p.y);
        this.pageIndex = pageIndex;
    }

    @Override
    public int getPageIndex() {
        return pageIndex;
    }

    @Override
    public int getType() {
        return Annot.e_Note;
    }

    @Override
    public String getNM() {
        return null;
    }

    @Override
    public RectF getBBox() {
        return new RectF(p.x, p.y, p.x, p.y);
    }

    @Override
    public int getColor() {
        return 0;
    }

    @Override
    public int getFillColor() {
        return 0;
    }

    @Override
    public int getOpacity() {
        return 0;
    }

    @Override
    public float getLineWidth() {
        return 0;
    }

    @Override
    public String getSubject() {
        return null;
    }

    @Override
    public DateTime getModifiedDate() {
        return null;
    }

    @Override
    public String getContents() {
        return null;
    }

    @Override
    public String getIntent() {
        return null;
    }

    @Override
    public String getAuthor() {
        return null;
    }

    @Override
    public String getIcon() {
        return "";
    }

    @Override
    public String getFromType() {
        return Module.MODULE_NAME_SELECTION;
    }

    @Override
    public String getParentNM() {
        return null;
    }
}
