/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.thumbnail;

import android.content.Context;
import android.graphics.Point;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.controls.dialog.FxProgressDialog;
import com.foxit.uiextensions.controls.dialog.fileselect.UIFileSelectDialog;
import com.foxit.uiextensions.controls.dialog.fileselect.UIFolderSelectDialog;

public interface IThumbnailSupport {
    Context getContext();

    PDFViewCtrl getPDFView();

    FxProgressDialog getProgressDialog();

    void switchPasteState(boolean isPasteState);

    void setSelectViewMode(boolean selectedAll);

    Point getThumbnailBackgroundSize();

    Context getActivity();

    UIFolderSelectDialog getFolderSelectDialog();

    UIFileSelectDialog getFileSelectDialog();

    boolean isEditMode();

    ThumbnailAdapter.ThumbViewHolder getViewHolderByItem(int tabPosition, ThumbnailItem item);

    boolean isThumbnailItemVisible(int tabPosition, ThumbnailItem thumbnailItem);

    boolean isPasteState();

    void updateRecycleLayout();

    void exitThumbnailDialog();

    void refreshOtherTab();

    boolean isSelectMode();
}
