/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.pdfreader;


import com.foxit.uiextensions.controls.toolbar.ToolItemBean;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

import androidx.annotation.IntDef;

public class AddToolsBean {
    public static final int EDIT_TOOLS = 0;
    public static final int COMMENT_TOOLS = 1;
    public static final int DRAWING_TOOLS = 2;
    public static final int FORM_TOOLS = 3;
    public static final int PROTECT_TOOLS = 4;

    @IntDef({
            EDIT_TOOLS,
            COMMENT_TOOLS,
            DRAWING_TOOLS,
            FORM_TOOLS,
            PROTECT_TOOLS
    })
    @Retention(RetentionPolicy.SOURCE)
    public @interface ToolsType {
    }

    public @ToolsType int toolsType;
    public List<ToolItemBean> toolItems;
}
