/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.pdfreader.config;

/**
 * The read state config
 * Note: If you want to switch status, you must make sure that the document is opened.
 */
public class ReadStateConfig {
    /**
     * Read State: normal view
     */
    public static final int STATE_NORMAL = 1;
    /**
     * Read State: reflow
     */
    public static final int STATE_REFLOW = 2;
    /**
     * Read State: search
     */
    public static final int STATE_SEARCH = 3;

    /**
     * Read State: pan zoom.
     */
    public static final int STATE_PANZOOM = 4;

    /**
     * Read State: compare
     */
    public static final int STATE_COMPARE = 5;

    /**
     * Read State: TextToSpeech
     */
    public static final int STATE_TTS = 6;

    /**
     * Read State: fillsign
     */
    public static final int STATE_FILLSIGN = 7;

    /**
     * Read State: Auto Flip
     */
    public static final int STATE_AUTOFLIP = 8;

    /**
     * Read State: Redaction
     */
    public static final int STATE_REDACT = 9;
}
