/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.pdfreader.tab;


import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.pdfreader.MainCenterItemBean;

import java.util.List;

public interface ITabViewControl {

    boolean addTabs(List<MainCenterItemBean> items);

    void sortTabs(List<MainCenterItemBean> centerItemBeans);

    void setCurrentTab(int tabId);

    void setCurrentTab(IBaseItem tabItem);

    IBaseItem getCurrentTab();

    int getTabCount();

    IBaseItem getTabItem(int tabId);

    List<IBaseItem> getTabItems();

    int getOnTabCount();

    IBaseItem getOnTabItem(int index);

    void removeTab(int tabId);

    void updateTheme();

    void updateLayout();

    void release();

    boolean isShowingTabPop();

    public void dismissTabPop();

    void setTabSelectedListener(ITabSelectedListener tabSelectedListener);

    void setTabRemovedListener(ITabRemovedListener tabRemovedListener);

    void asynInitTaskFinished();
}
