/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.security.certificate;

import android.content.ContentResolver;
import android.content.Context;
import android.content.UriPermission;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.provider.DocumentsContract;

import com.foxit.uiextensions.utils.AppFileUtil;
import com.foxit.uiextensions.utils.AppStorageManager;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class CertificateSearchRunnable implements Runnable {
	
	private boolean				mShouldStop;
	private boolean				mbOnlyPfx;
	private Handler				mHandler;
	private Context mContext;

	public CertificateSearchRunnable(Context context) {
		mContext = context;
	}

	public void init(Handler handler, boolean isOnlyPfxFile) {
		mHandler = handler;
		mShouldStop = false;
		mbOnlyPfx = isOnlyPfxFile;
	}

	public void stopSearch() {
		mShouldStop = true;
	}

	public boolean isStoped() {
		return mShouldStop;
	}

	private  boolean  filterFile(String filename) {
		if (filename.toLowerCase(Locale.ROOT).endsWith(".pfx")) {
			return true;
		}
        if (filename.toLowerCase(Locale.ROOT).endsWith(".p12")) {
            return true;
        }
		if (!mbOnlyPfx && filename.toLowerCase(Locale.ROOT).endsWith(".cer")) {
			return true;
		}
		
		return false;
	}
	
	@Override
	public void run() {
		if (mHandler == null) return ;
		List<File> folderList = new ArrayList<File>();
		AppStorageManager storageManager = AppStorageManager.getInstance(mContext);
		List<String> listFiles = storageManager.getVolumePaths();
		if (listFiles != null) {
			for (int i = 0 ; i < listFiles.size(); i ++) {
				if (mShouldStop) {
					return ;
				}
				File file = new File(listFiles.get(i));
				if (file.isDirectory() && !file.isHidden()) {
					folderList.add(file);
				} else if (file.isFile() && !file.isHidden()) {
					if (mShouldStop) {
						return ;
					}
					if (!filterFile(file.getName())) {
						continue;
					}
					Message msg = mHandler.obtainMessage(CertificateFragment.MESSAGE_UPDATE, file);
					msg.sendToTarget();
				}
			}
		}
		AppFileUtil.updateIsExternalStorageManager();
		if (!AppFileUtil.needScopedStorageAdaptation()) {
			while (folderList.size() > 0) {
				if (mShouldStop) {
					return;
				}
				File tempFile = (File) folderList.remove(0);
				File[] tempFolderFileList = tempFile.listFiles();
				if (tempFolderFileList != null) {
					for (int i = 0; i < tempFolderFileList.length; i++) {
						if (mShouldStop) {
							return;
						}
						if (tempFolderFileList[i].isDirectory() && !tempFolderFileList[i].isHidden()) {
							folderList.add(tempFolderFileList[i]);
						} else if (tempFolderFileList[i].isFile() && !tempFolderFileList[i].isHidden()) {
							if (mShouldStop) {
								return;
							}
							if (!filterFile(tempFolderFileList[i].getName())) {
								continue;
							}
							Message msg = mHandler.obtainMessage(CertificateViewSupport.MESSAGE_UPDATE, tempFolderFileList[i]);
							msg.sendToTarget();
						}
					}
				}
			}
		}else{
			try{
				for (UriPermission permission : mContext.getContentResolver().getPersistedUriPermissions()) {
					if (mShouldStop)
						return;
					listDocumentTree(permission.getUri());
				}
			}catch (Exception ignored){
			}
		}
		Message msg = mHandler.obtainMessage(CertificateViewSupport.MESSAGE_FINISH);
		msg.sendToTarget();
		mShouldStop = true;
	}

	public void listDocumentTree(Uri uri){
		if (uri == null || mShouldStop)return;
		final Uri childrenUri;
		if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP) {
			String documentId;
			Cursor cursor = null;
			try {
				childrenUri = DocumentsContract.buildChildDocumentsUriUsingTree(uri,
						uri.getLastPathSegment());
				final ContentResolver resolver = mContext.getContentResolver();
				cursor = resolver.query(childrenUri, new String[]{
						DocumentsContract.Document.COLUMN_DOCUMENT_ID, DocumentsContract.Document.COLUMN_MIME_TYPE}, null, null, null);
				while (cursor.moveToNext()) {
					if (mShouldStop) return;
					documentId = cursor.getString(0);
					uri = DocumentsContract.buildDocumentUriUsingTree(uri,documentId);
					if (DocumentsContract.Document.MIME_TYPE_DIR.equals(cursor.getString(1))){
						listDocumentTree(uri);
					}else if (filterFile(documentId)){
						Message msg = mHandler.obtainMessage(CertificateViewSupport.MESSAGE_UPDATE, new File(AppFileUtil.getFilePathFromUri(mContext, uri)));
						msg.sendToTarget();
					}
				}
			} catch (Exception ignored) {
			} finally {
				AppFileUtil.closeQuietly(cursor);
			}
		}
	}
}
