/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.security.standard;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.InputType;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.NumberKeyListener;
import android.util.Log;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.core.view.MarginLayoutParamsCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.dialog.AppDialogManager;
import com.foxit.uiextensions.controls.dialog.MatchDialog;
import com.foxit.uiextensions.controls.dialog.UIEncryptionDialogFragment;
import com.foxit.uiextensions.controls.dialog.UIMatchDialog;
import com.foxit.uiextensions.controls.dialog.fileselect.UISaveAsDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.theme.IThemeChangeObserver;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.UIToast;

import java.util.ArrayList;

import static android.view.View.VISIBLE;
import static com.foxit.uiextensions.utils.AppUtil.getSelectedButtonColorStateList;
import static com.foxit.uiextensions.utils.AppUtil.setSelectedButtonState;
import static com.foxit.uiextensions.utils.AppUtil.upperCaseTextView;


public class PasswordSettingFragment extends UIMatchDialog {

    public static final String TAG = "PasswordSettingTag";
    private static final String DIALOGTAG = "FOXIT_SAVEDOC_ENCRYPT_STANDARD";

    public static final int SWITCH_TAG_USER = 1;
    public static final int SWITCH_TAG_OWNER = 2;

    public static final int SWITCH_TAG_PRINT = 3;
    public static final int SWITCH_TAG_FILLFORM = 4;
    public static final int SWITCH_TAG_ANNOT = 5;
    public static final int SWITCH_TAG_PAGE = 6;
    public static final int SWITCH_TAG_MODIFYDOC = 7;
    public static final int SWITCH_TAG_TEXTACCESS = 8;
    public static final int SWITCH_TAG_COPY = 9;

    public static final int EYES_TAG_USER = 10;
    public static final int EYES_TAG_OWNER = 11;


    private PasswordStandardSupport mSupport;

    private LinearLayout mLinearLayout;
    private Boolean mSettingUserPassword = false;
    private Boolean mSettingOwnerPassword = false;
    private LinearLayout mSpaceLine;

    private Boolean mIsPrint = true;
    private Boolean mFillForm = true;
    private Boolean mIsAddAnnot = true;
    private Boolean mIsManagePage = true;
    private Boolean mIsModifyDoc = true;
    private Boolean mTextAccess = true;
    private Boolean mIsCopy = true;

    private EditText mUserEditText = null;
    private EditText mOwnerEditText = null;
    private ImageView mUserEye;
    private ImageView mOwnerEye;
    private ArrayList<ImageView> mImageList = null;
    private ArrayList<View> mViewList = null;

    private String userpassword = null;
    private String ownerpassword = null;

    private PDFViewCtrl mPdfViewCtrl;
    private TextView mTips;

    public PasswordSettingFragment(Context context) {
        super(context);
    }

    public void init(PasswordStandardSupport support, PDFViewCtrl pdfViewCtrl) {
        mPdfViewCtrl = pdfViewCtrl;
        mSupport = support;
        createView();
    }

    public void setDarkModeColor() {
        for (int i = 0; i < mViewList.size(); i++) {
            if (mViewList.get(i) instanceof RelativeLayout) {
                mViewList.get(i).setBackgroundColor(mContext.getResources().getColor(R.color.b3));
                for (int k = 0; k < ((RelativeLayout) mViewList.get(i)).getChildCount(); k++) {
                    View view = ((RelativeLayout) mViewList.get(i)).getChildAt(k);
                    setChildDarkModeColor(view);
                }
            }
        }
        mTips.setTextColor(mContext.getResources().getColor(R.color.t3));
    }

    private void setChildDarkModeColor(View view) {
        if (view instanceof EditText) {
            ((EditText) view).setTextColor(mContext.getResources().getColor(R.color.t4));
            ((EditText) view).setHintTextColor(mContext.getResources().getColor(R.color.t2));
        } else if (view instanceof TextView) {
            ((TextView) view).setTextColor(mContext.getResources().getColor(R.color.t4));
        } else if (view instanceof ImageView) {
            ThemeUtil.setTintList(view, ThemeUtil.getPrimaryIconColor(mContext));
        } else if (view instanceof FrameLayout) {
            ThemeUtil.setBackgroundTintList(view, getSelectedButtonColorStateList(mContext));
            if (((FrameLayout) view).getChildAt(0) != null && ((FrameLayout) view).getChildAt(0) instanceof ImageView) {
                ImageView iv = (ImageView) ((FrameLayout) view).getChildAt(0);
                if (iv.getTag() != null && (int) iv.getTag() != EYES_TAG_OWNER && (int) iv.getTag() != EYES_TAG_USER)
                    refreshSwitchView((int) iv.getTag(), iv);
            }
        }
    }

    private View createView() {
        View view = View.inflate(mContext, R.layout.rv_password_setting, null);
        view.setOnTouchListener(new OnTouchListener() {

            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        mTips = view.findViewById(R.id.tips);
        upperCaseTextView((mTips));
        mSettingUserPassword = false;
        mSettingOwnerPassword = false;
        mIsAddAnnot = true;
        mIsCopy = true;
        mIsManagePage = true;
        mIsPrint = true;
        mLinearLayout = view.findViewById(R.id.settinglist);
        mSpaceLine = new LinearLayout(mContext);
        mSpaceLine.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_8dp)));
        mImageList = new ArrayList<>();
        mViewList = new ArrayList<>();
        mViewList.add(getSwitchItem(mContext.getString(R.string.rv_doc_encrpty_standard_openfile), SWITCH_TAG_USER));
        View tip1 = getOnlyTextItem(mContext.getString(R.string.rv_doc_encrpty_standard_bottom_tip1));
        mViewList.add(tip1);
        mViewList.add(getPasswordInputItem(mContext.getString(R.string.rv_doc_encrpty_standard_password), EYES_TAG_USER));
        mViewList.add(mSpaceLine);
        mViewList.add(getSwitchItem(mContext.getString(R.string.rv_doc_encrpty_standard_owner_permission), SWITCH_TAG_OWNER));
        View tip2 = getOnlyTextItem(mContext.getString(R.string.rv_doc_encrpty_standard_bottom_tip2));
        mViewList.add(tip2);
        mViewList.add(getSwitchItem(mContext.getString(R.string.rv_doc_info_permission_print), SWITCH_TAG_PRINT));
        mViewList.add(getSwitchItem(mContext.getString(R.string.rv_doc_info_permission_fillform), SWITCH_TAG_FILLFORM));
        mViewList.add(getSwitchItem(mContext.getString(R.string.rv_doc_info_permission_annotform), SWITCH_TAG_ANNOT));
        mViewList.add(getSwitchItem(mContext.getString(R.string.rv_doc_info_permission_assemble), SWITCH_TAG_PAGE));
        mViewList.add(getSwitchItem(mContext.getString(R.string.rv_doc_info_permission_modify), SWITCH_TAG_MODIFYDOC));
        mViewList.add(getSwitchItem(mContext.getString(R.string.rv_doc_info_permission_extractaccess), SWITCH_TAG_TEXTACCESS));
        mViewList.add(getSwitchItem(mContext.getString(R.string.rv_doc_info_permission_extract), SWITCH_TAG_COPY));
        mViewList.add(getPasswordInputItem(mContext.getString(R.string.rv_doc_encrpty_standard_password), EYES_TAG_OWNER));
        refreshViewList(mSettingUserPassword, mSettingOwnerPassword);
        setContentView(view);
        setTitle(mContext.getString(R.string.rv_encrypt_dialog_title));
        setBackButtonVisible(VISIBLE);
        setBackButtonStyle(TEXT_BACK);
        setBackButtonText(AppResource.getString(mContext, R.string.fx_string_close));
        setRightButtonEnable(false);
        setRightButtonText(AppResource.getString(mContext, R.string.fx_string_done));
        setRightButtonVisible(VISIBLE);
        setTitlePosition(BaseBar.TB_Position.Position_CENTER);
        setBackgroundColor(AppResource.getColor(mContext, R.color.g1));
        setStyle(MatchDialog.DLG_TITLE_STYLE_BG_DEFAULT);
        setListener(new DialogListener() {
            @Override
            public void onResult(long btType) {
            }

            @Override
            public void onBackClick() {

            }

            @Override
            public void onTitleRightButtonClick() {
                if (mSettingUserPassword) userpassword = mUserEditText.getText().toString();
                else userpassword = "";
                if (mSettingOwnerPassword) ownerpassword = mOwnerEditText.getText().toString();
                else ownerpassword = "";

                if (userpassword.equals(ownerpassword)) {
                    UIToast.getInstance(mContext).show(mContext.getString(R.string.rv_doc_encrpty_standard_same_password));
                    return;
                }
                dismiss();

                if (mPdfViewCtrl == null) {
                    return;
                }
                boolean bModified = ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().isDocModified();

                if ((bModified) || (((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().canSaveAsFile() && !((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().canModifyFile())) {//if document is modified, show dialog to confirm save document first, then setting password
                    Activity activity = ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getAttachedActivity();
                    if (activity == null) {
                        return;
                    }

                    if (!(activity instanceof FragmentActivity)) {
                        UIToast.getInstance(mContext).show(mContext.getString(R.string.the_attached_activity_is_not_fragmentActivity));
                        return;
                    }
                    FragmentManager fm = ((FragmentActivity) activity).getSupportFragmentManager();
                    UIEncryptionDialogFragment newFragment = (UIEncryptionDialogFragment) fm.findFragmentByTag(DIALOGTAG);
                    if (newFragment == null) {
                        newFragment = UIEncryptionDialogFragment.newInstance(true);
                    }

                    AppDialogManager.getInstance().showAllowManager(newFragment, fm, DIALOGTAG, new AppDialogManager.CancelListener() {

                        @Override
                        public void cancel() {
                        }
                    });
                    newFragment.setEncryptionDialogEventListener(new UIEncryptionDialogFragment.UIEncryptionDialogEventListener() {

                        @Override
                        public void onConfirmed(boolean encrypt) {
                            if (mSettingUserPassword)
                                userpassword = mUserEditText.getText().toString();
                            else userpassword = "";
                            if (mSettingOwnerPassword)
                                ownerpassword = mOwnerEditText.getText().toString();
                            else ownerpassword = "";
                            if (((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().canSaveAsFile() && !((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().canModifyFile()) {
                                if (mPdfViewCtrl.getUIExtensionsManager() == null) {
                                    return;
                                }
                                Context context = ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getAttachedActivity();
                                if (context == null) {
                                    return;
                                }
                                UISaveAsDialog dialog = new UISaveAsDialog(context, mSupport.getFilePath(), "pdf", new UISaveAsDialog.ISaveAsOnOKClickCallBack() {
                                    @Override
                                    public void onOkClick(String newFilePath) {
                                        mSupport.addPassword(userpassword, ownerpassword, mIsAddAnnot, mIsCopy, mIsManagePage, mIsPrint, mFillForm, mIsModifyDoc, mTextAccess, newFilePath);
                                    }

                                    @Override
                                    public void onCancelClick() {

                                    }
                                });
                                dialog.showDialog();
                            } else {
                                mSupport.addPassword(userpassword, ownerpassword, mIsAddAnnot, mIsCopy, mIsManagePage, mIsPrint, mFillForm, mIsModifyDoc, mTextAccess, null);
                            }
                        }

                        @Override
                        public void onCancel() {
                        }
                    });
                } else {
                    mSupport.addPassword(userpassword, ownerpassword, mIsAddAnnot, mIsCopy, mIsManagePage, mIsPrint, mFillForm, mIsModifyDoc, mTextAccess, null);
                }
            }
        });
        return view;
    }

    private View getOnlyTextItem(String tip) {
//        tip = "\r\n" + tip;
        View item = View.inflate(mContext, R.layout.rv_password_setting_item, null);
        TextView tv = item.findViewById(R.id.rv_password_item_textview);
        tv.setTextSize(12);
        tv.setTextColor(mContext.getResources().getColor(R.color.t3));
        tv.setMinHeight(0);
        tv.setText(tip);
        if (Build.VERSION.SDK_INT >= 29) {// 29 == Build.VERSION_CODES.Q
            item.findViewById(R.id.rv_select_item_layout).setForceDarkAllowed(false);
        }
        item.findViewById(R.id.rv_select_item_layout).setVisibility(View.GONE);
        EditText et = item.findViewById(R.id.rv_password_item_edittext);
        et.setVisibility(View.GONE);
        return item;
    }

    private View getSwitchItem(String tip, int tag) {
        RelativeLayout item = (RelativeLayout) View.inflate(mContext, R.layout.rv_password_setting_item, null);
        item.setBackgroundResource(R.color.b3);
//        if (AppDisplay.isPad()) {
//            item.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, (int) mContext.getResources().getDimension(R.dimen.ux_list_item_height_1l_pad)));
//        } else {
//            item.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, (int) mContext.getResources().getDimension(R.dimen.ux_list_item_height_1l_phone)));
//        }
        ImageView iv = item.findViewById(R.id.select_image_button);
        if (Build.VERSION.SDK_INT >= 29) {// 29 == Build.VERSION_CODES.Q
            iv.setForceDarkAllowed(false);
            item.findViewById(R.id.rv_select_item_layout).setForceDarkAllowed(false);
        }
        View ivParent = (View) iv.getParent();
        ivParent.setTag(tag);
        ThemeUtil.setBackgroundTintList(item.findViewById(R.id.rv_select_item_layout), getSelectedButtonColorStateList(mContext));
        switch (tag) {
            case SWITCH_TAG_USER:
                ivParent.setId(R.id.id_encrpty_standard_openfile);
                break;
            case SWITCH_TAG_OWNER:
                ivParent.setId(R.id.id_encrpty_standard_owner_permission);
                break;
            case SWITCH_TAG_PRINT:
                ivParent.setId(R.id.id_encrpty_info_permission_print);
                break;
            case SWITCH_TAG_FILLFORM:
                ivParent.setId(R.id.id_encrpty_info_permission_fillform);
                break;
            case SWITCH_TAG_ANNOT:
                ivParent.setId(R.id.id_encrpty_info_permission_annotform);
                break;
            case SWITCH_TAG_PAGE:
                ivParent.setId(R.id.id_encrpty_permission_assemble);
                break;
            case SWITCH_TAG_MODIFYDOC:
                ivParent.setId(R.id.id_encrpty_info_permission_modify);
                break;
            case SWITCH_TAG_TEXTACCESS:
                ivParent.setId(R.id.id_encrpty_info_permission_extractaccess);
                break;
            case SWITCH_TAG_COPY:
                ivParent.setId(R.id.id_encrpty_info_permission_extract);
                break;
            default:
                break;
        }
        ivParent.setOnClickListener(mOnClickListener);
        mImageList.add(iv);
        TextView tv = item.findViewById(R.id.rv_password_item_textview);
        tv.setText(tip);
        tv.setPadding(0, 0, AppDisplay.dp2px(66), 0);
        EditText et = item.findViewById(R.id.rv_password_item_edittext);
        et.setVisibility(View.GONE);
        refreshSwitchView(tag, iv);
        return item;
    }

    private View getPasswordInputItem(String tip, final int tag) {
        RelativeLayout item = (RelativeLayout) View.inflate(mContext, R.layout.rv_password_setting_item, null);
        item.setBackgroundResource(R.color.b3);
        if (AppDisplay.isPad()) {
            item.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, (int) mContext.getResources().getDimension(R.dimen.ux_list_item_height_1l_pad)));
        } else {
            item.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, (int) mContext.getResources().getDimension(R.dimen.ux_list_item_height_1l_phone)));
        }
        ImageView iv = item.findViewById(R.id.rv_password_item_imagebutton);
        iv.setVisibility(VISIBLE);
        item.findViewById(R.id.rv_select_item_layout).setVisibility(View.GONE);
        if (Build.VERSION.SDK_INT >= 29) {// 29 == Build.VERSION_CODES.Q
            iv.setForceDarkAllowed(false);
            item.findViewById(R.id.rv_select_item_layout).setForceDarkAllowed(false);
        }
        iv.setImageResource(R.drawable.rv_password_check_eye_normal);
        ThemeUtil.setTintList(iv, ThemeUtil.getPrimaryIconColor(mContext));
        iv.setTag(tag);
        iv.setOnTouchListener(mOnTouchListener);
        iv.setVisibility(View.INVISIBLE);
        if (tag == EYES_TAG_USER) {
            iv.setId(R.id.id_encrpty_iv_user_password);
            mUserEye = iv;
        }
        if (tag == EYES_TAG_OWNER){
            iv.setId(R.id.id_encrpty_iv_standard_password);
            mOwnerEye = iv;
        }
        TextView tv = item.findViewById(R.id.rv_password_item_textview);
        tv.setText(tip);
        final EditText et = item.findViewById(R.id.rv_password_item_edittext);
        if (AppDisplay.isPad()) { // SDKRD-9313
            et.setImeOptions(EditorInfo.IME_FLAG_NO_EXTRACT_UI);
        }
        et.setHeight(AppDisplay.dp2px(30));
        et.setKeyListener(new NumberKeyListener() {

            @Override
            public int getInputType() {
                return InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD;
            }

            @Override
            protected char[] getAcceptedChars() {
                return PasswordConstants.mAcceptChars;
            }
        });
        et.addTextChangedListener(new TextWatcher() {

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                if (et.getText().length() != 0 && et.getText().length() <= 32) {
                    setRightButtonEnable(true);
                    if (tag == EYES_TAG_USER) mUserEye.setVisibility(View.VISIBLE);
                    if (tag == EYES_TAG_OWNER) mOwnerEye.setVisibility(View.VISIBLE);
                } else {
                    setRightButtonEnable(false);
                    if (tag == EYES_TAG_USER) mUserEye.setVisibility(View.INVISIBLE);
                    if (tag == EYES_TAG_OWNER) mOwnerEye.setVisibility(View.INVISIBLE);
                }
                refreshButton(tag);
            }
        });
        et.setFilters(new InputFilter[]{new InputFilter.LengthFilter(32)});
        et.setHint(mContext.getString(R.string.rv_doc_encrpty_standard_must_input));
        if (tag == EYES_TAG_USER) {
            et.setId(R.id.id_encrpty_user_password);
            mUserEditText = et;
        }
        if (tag == EYES_TAG_OWNER) {
            et.setId(R.id.id_encrpty_standard_password);
            mOwnerEditText = et;
        }
        return item;
    }

    //i = 0 to 9 means row 1 to 10 of password setting UI
    private void refreshViewList(boolean user, boolean owner) {
        mLinearLayout.removeAllViews();
        if (user && owner) {
            for (int i = 0; i < mViewList.size(); i++) {
                mLinearLayout.addView(mViewList.get(i));
            }
        } else if (user && !owner) {
            for (int i = 0; i < 6; i++) {
                mLinearLayout.addView(mViewList.get(i));
            }
        } else if (!user && owner) {
            for (int i = 0; i < mViewList.size(); i++) {
                if (i == 2 || i == 3) continue;
                mLinearLayout.addView(mViewList.get(i));
            }
        } else if (!user && !owner) {
            mLinearLayout.addView(mViewList.get(0));
            mLinearLayout.addView(mViewList.get(1));
            mLinearLayout.addView(mViewList.get(4));
            mLinearLayout.addView(mViewList.get(5));
        }
    }

    private final View.OnClickListener mOnClickListener = new View.OnClickListener() {

        @Override
        public void onClick(View v) {

            int tag = (Integer) v.getTag();

            if (tag == SWITCH_TAG_USER) {
                mSettingUserPassword = !mSettingUserPassword;
            } else if (tag == SWITCH_TAG_OWNER) {
                mSettingOwnerPassword = !mSettingOwnerPassword;
            } else if (tag == SWITCH_TAG_PRINT) {
                mIsPrint = !mIsPrint;
            } else if (tag == SWITCH_TAG_FILLFORM) {
                mFillForm = !mFillForm;
                if (mFillForm == false) {
                    mIsAddAnnot = false;
                    mIsModifyDoc = false;
                }
            } else if (tag == SWITCH_TAG_ANNOT) {
                mIsAddAnnot = !mIsAddAnnot;
                if (mIsAddAnnot) mFillForm = true;
            } else if (tag == SWITCH_TAG_PAGE) {
                mIsManagePage = !mIsManagePage;
                if (mIsManagePage == false) mIsModifyDoc = false;
            } else if (tag == SWITCH_TAG_MODIFYDOC) {
                mIsModifyDoc = !mIsModifyDoc;
                if (mIsModifyDoc) {
                    mFillForm = true;
                    mIsManagePage = true;
                }
            } else if (tag == SWITCH_TAG_COPY) {
                mIsCopy = !mIsCopy;
                if (mIsCopy) mTextAccess = true;
            } else if (tag == SWITCH_TAG_TEXTACCESS) {
                mTextAccess = !mTextAccess;
                if (mTextAccess == false) mIsCopy = false;
            }

            refreshButton(EYES_TAG_USER);
            refreshButton(EYES_TAG_OWNER);
            refreshAllSwitchView();
            refreshViewList(mSettingUserPassword, mSettingOwnerPassword);
        }
    };

    private final OnTouchListener mOnTouchListener = new OnTouchListener() {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            EditText editText = null;
            int tag = (Integer) v.getTag();
            if (tag == EYES_TAG_USER) editText = mUserEditText;
            if (tag == EYES_TAG_OWNER) editText = mOwnerEditText;
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN: {
                    ((ImageView) v).setImageResource(R.drawable.rv_password_check_eye_pressed);
                    editText.setInputType(InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
                    editText.setHeight(AppDisplay.dp2px(30));
                    CharSequence text = editText.getText();
                    if (text instanceof Spannable) {
                        Spannable spanText = (Spannable) text;
                        Selection.setSelection(spanText, text.length());
                    }
                    break;
                }
                case MotionEvent.ACTION_UP:
                case MotionEvent.ACTION_CANCEL: {
                    ((ImageView) v).setImageResource(R.drawable.rv_password_check_eye_normal);
                    editText.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD);
                    editText.setKeyListener(new NumberKeyListener() {

                        @Override
                        public int getInputType() {
                            return InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD;
                        }

                        @Override
                        protected char[] getAcceptedChars() {
                            return PasswordConstants.mAcceptChars;
                        }
                    });

                    CharSequence text = editText.getText();
                    if (text instanceof Spannable) {
                        Spannable spanText = (Spannable) text;
                        Selection.setSelection(spanText, text.length());
                    }
                    break;
                }

                default:
                    break;
            }
            return true;

        }
    };

    private void refreshSwitchView(int tag, ImageView iv) {
        if (tag == SWITCH_TAG_USER) {
            setSelectedButtonState(mSettingUserPassword, iv);
        } else if (tag == SWITCH_TAG_OWNER) {
            setSelectedButtonState(mSettingOwnerPassword, iv);
        } else if (tag == SWITCH_TAG_ANNOT) {
            setSelectedButtonState(mIsAddAnnot, iv);
        } else if (tag == SWITCH_TAG_COPY) {
            setSelectedButtonState(mIsCopy, iv);
        } else if (tag == SWITCH_TAG_PAGE) {
            setSelectedButtonState(mIsManagePage, iv);
        } else if (tag == SWITCH_TAG_PRINT) {
            setSelectedButtonState(mIsPrint, iv);
        } else if (tag == SWITCH_TAG_FILLFORM) {
            setSelectedButtonState(mFillForm, iv);
        } else if (tag == SWITCH_TAG_MODIFYDOC) {
            setSelectedButtonState(mIsModifyDoc, iv);
        } else if (tag == SWITCH_TAG_TEXTACCESS) {
            setSelectedButtonState(mTextAccess, iv);
        }
    }

    private void refreshAllSwitchView() {
        setSelectedButtonState(mSettingUserPassword, mImageList.get(0));
        setSelectedButtonState(mSettingOwnerPassword, mImageList.get(1));
        setSelectedButtonState(mIsPrint, mImageList.get(2));
        setSelectedButtonState(mFillForm, mImageList.get(3));
        setSelectedButtonState(mIsAddAnnot, mImageList.get(4));
        setSelectedButtonState(mIsManagePage, mImageList.get(5));
        setSelectedButtonState(mIsModifyDoc, mImageList.get(6));
        setSelectedButtonState(mTextAccess, mImageList.get(7));
        setSelectedButtonState(mIsCopy, mImageList.get(8));
    }

    private void refreshButton(int tag) {
        if (tag == EYES_TAG_USER) {
            if (mSettingUserPassword) {
                setRightButtonEnable(mUserEditText.getText().toString().length() != 0);
            }
        }
        if (tag == EYES_TAG_OWNER) {
            if (mSettingOwnerPassword) {
                setRightButtonEnable(mOwnerEditText.getText().toString().length() != 0);
            }
        }
        if (!mSettingOwnerPassword && !mSettingUserPassword) {
            setRightButtonEnable(false);
        }
    }
}

