/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.security.trustcertificate;


import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.IThemeEventListener;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.browser.treeview.TreeNode;
import com.foxit.uiextensions.browser.treeview.TreeView;
import com.foxit.uiextensions.controls.dialog.BaseDialogFragment;
import com.foxit.uiextensions.controls.dialog.sheetmenu.ISheetMenu;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.impl.BaseItemImpl;
import com.foxit.uiextensions.controls.toolbar.impl.TopBarImpl;
import com.foxit.uiextensions.security.certificate.CertificateFileInfo;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.SystemUiHelper;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class CertificateViewerFragment extends BaseDialogFragment {

    private PDFViewCtrl mPDFViewCtrl;
    private List<CertificateFileInfo> mCertFileInfos = new ArrayList<>();

    private View mRootView;
    private LinearLayout mTitleLayout;
    private RelativeLayout mCerListView;

    public void init(PDFViewCtrl pdfViewCtrl, List<CertificateFileInfo> certificateFileInfos) {
        mPDFViewCtrl = pdfViewCtrl;
        mCertFileInfos = certificateFileInfos;
    }

    @Override
    protected View onCreateView(LayoutInflater inflater, ViewGroup container) {
        mRootView = inflater.inflate(R.layout.cert_viewer_layout, container, false);
        mTitleLayout = mRootView.findViewById(R.id.panel_verify_cert_list_title);
        mCerListView = mRootView.findViewById(R.id.treeview_container);

        initTopBar();
        initTreeView();
        ((UIExtensionsManager) mPDFViewCtrl.getUIExtensionsManager()).registerThemeEventListener(mThemeEventListener);
        return mRootView;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (!AppDisplay.isPad() && SystemUiHelper.getInstance().isFullScreen())
            SystemUiHelper.getInstance().showNavigationBar(getActivity());
    }

    @Override
    public void onDetach() {
        super.onDetach();
        ((UIExtensionsManager) mPDFViewCtrl.getUIExtensionsManager()).unregisterThemeEventListener(mThemeEventListener);
    }

    @NonNull
    @Override
    protected PDFViewCtrl getPDFViewCtrl() {
        return mPDFViewCtrl;
    }

    @Override
    protected void onLayoutChange(View v, int newWidth, int newHeight, int oldWidth, int oldHeight) {
        onLayoutChange();
    }

    private void initTopBar() {
        TopBarImpl topBar = new TopBarImpl(mContext);
        topBar.setStartMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp));
        topBar.setBackgroundColor(ThemeConfig.getInstance(mContext).getB2());
        IBaseItem backItem = new BaseItemImpl(mContext);
        backItem.setText(AppResource.getString(mContext, R.string.fx_string_close));

        backItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
        backItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_15sp));

        backItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                CertificateViewerFragment.this.dismiss();
            }
        });
        topBar.addView(backItem, BaseBar.TB_Position.Position_LT);

        IBaseItem titleItem = new BaseItemImpl(mContext);
        titleItem.setText(AppResource.getString(mContext, R.string.rv_view_certificate_info));
        titleItem.setTextColor(AppResource.getColor(mContext, R.color.t4));
        titleItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_16sp));
        titleItem.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
        topBar.addView(titleItem, BaseBar.TB_Position.Position_CENTER);
        mTitleLayout.addView(topBar.getContentView());
    }

    private void initTreeView() {
        TreeNode root = new TreeNode(null);
        TreeNode parentNode = new TreeNode(mCertFileInfos.get(0));
        parentNode.setViewHolder(new ItemCertViewerHolder(getContext(), mPDFViewCtrl).setSheetMenuListener(mSheetMenuListener));
        TreeNode currentNode = parentNode;
        for (int i = 1; i < mCertFileInfos.size(); i++) {
            TreeNode certInfo = new TreeNode(mCertFileInfos.get(i));
            certInfo.setViewHolder(new ItemCertViewerHolder(getContext(), mPDFViewCtrl).setSheetMenuListener(mSheetMenuListener));
            currentNode.addChild(certInfo);
            currentNode = certInfo;
        }
        root.addChild(parentNode);

        TreeView treeView = new TreeView(mContext, root);
        mCerListView.addView(treeView.getView());
    }

    private ISheetMenu mSheetMenu;
    private View mShowMenuView;

    private ItemCertViewerHolder.OnSheetMenuListener mSheetMenuListener = new ItemCertViewerHolder.OnSheetMenuListener() {

        @Override
        public void onSheetMenuShow(ISheetMenu sheetMenu, View v) {
            mSheetMenu = sheetMenu;
            mShowMenuView = v;
        }

        @Override
        public void onSheetMenuDismiss(ISheetMenu sheetMenu, View v) {
            mSheetMenu = null;
            mShowMenuView = null;

            if (mbFullScreen && getDialog() != null)
                SystemUiHelper.getInstance().hideStatusBar(getDialog().getWindow());
        }

        @Override
        public boolean isFullScreen() {
            return mbFullScreen;
        }
    };

    private void onLayoutChange() {
        if (mSheetMenu != null && mSheetMenu.isShowing()) {
            if (AppDisplay.isPad()) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (mShowMenuView != null) {
                            Rect rect = new Rect();
                            mShowMenuView.getGlobalVisibleRect(rect);
                            UIExtensionsManager uiExtensionsManager = (UIExtensionsManager) mPDFViewCtrl.getUIExtensionsManager();
                            if (SystemUiHelper.getInstance().isStatusBarShown(uiExtensionsManager.getAttachedActivity()))
                                rect.offset(0, SystemUiHelper.getInstance().getStatusBarHeight(uiExtensionsManager.getAttachedActivity()));
                            mSheetMenu.show(uiExtensionsManager.getRootView(), rect);
                        } else {
                            if (mSheetMenu != null && mSheetMenu.isShowing())
                                mSheetMenu.dismiss();
                        }
                    }
                }, 200);
            } else {
                mSheetMenu.show(((UIExtensionsManager) mPDFViewCtrl.getUIExtensionsManager())
                        .getRootView(), new Rect());
            }
        }
    }

    private IThemeEventListener mThemeEventListener = new IThemeEventListener() {
        @Override
        public void onThemeColorChanged(String type, int color) {
            if (mSheetMenu != null && mSheetMenu.isShowing()) {
                mSheetMenu.dismiss();
            }

            mTitleLayout.removeAllViews();
            mCerListView.removeAllViews();
            initTopBar();
            initTreeView();
            mCerListView.setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
        }
    };

}
