/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.security.trustcertificate;


import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;

import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.annots.common.UIBtnImageView;
import com.foxit.uiextensions.controls.dialog.UIMatchDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;

import static android.view.View.VISIBLE;

public class TrustCertificateListDialog extends UIMatchDialog {

    private PDFViewCtrl mPDFViewCtrl;
    private TrustCertificateListAdapter mAdapter;
    private UIBtnImageView mUIImg;
    private TextView mTvTips;

    public TrustCertificateListDialog(Context context, PDFViewCtrl viewCtrl) {
        super(context);
        mPDFViewCtrl = viewCtrl;
        createView();
    }

    protected void createView() {
        View view = View.inflate(mContext, R.layout.panel_trust_certificate_layout, null);
        initListView(view);
        initTitle();
        setContentView(view);
    }

    private void initTitle() {
        setTitle(mContext.getString(R.string.menu_more_item_trust_certificate));
        setBackButtonVisible(VISIBLE);
        setBackButtonStyle(TEXT_BACK);
        setBackButtonText(AppResource.getString(mContext, R.string.fx_string_close));
        setRightButtonText(AppResource.getString(mContext, R.string.fx_string_add));
        setRightButtonVisible(VISIBLE);
        setTitlePosition(BaseBar.TB_Position.Position_CENTER);
        setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
        setListener(new DialogListener() {
            @Override
            public void onResult(long btType) {

            }

            @Override
            public void onBackClick() {

            }

            @Override
            public void onTitleRightButtonClick() {
                int index = mAdapter.getIndex();
                if (index != -1) {
                    mAdapter.reset();
                    mAdapter.notifyItemChanged(index);
                }
                mAdapter.addCert();
            }
        });
    }

    @SuppressLint("ClickableViewAccessibility")
    private void initListView(View parentView) {
        RecyclerView recyclerView = parentView.findViewById(R.id.panel_trust_certificate_list);
        mAdapter = new TrustCertificateListAdapter(mContext, mPDFViewCtrl);
        mUIImg = parentView.findViewById(R.id.no_certificate_image);
        mTvTips = parentView.findViewById(R.id.no_certificate_tips);
        mUIImg.setColorStateList(ThemeUtil.getItemIconColor(mContext));
        mAdapter.setNoContentView(parentView.findViewById(R.id.no_trust_certificate_view));
        recyclerView.setAdapter(mAdapter);
        recyclerView.setLayoutManager(new LinearLayoutManager(mContext, LinearLayoutManager.VERTICAL, false));
        recyclerView.setItemAnimator(new DefaultItemAnimator());
        recyclerView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                int index = mAdapter.getIndex();
                if (index != -1) {
                    mAdapter.reset();
                    mAdapter.notifyItemChanged(index);
                }
                return false;
            }
        });
    }

    void loadData(){
        mAdapter.loadData();
    }

}
