/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.theme;


import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppUtil;

import androidx.annotation.NonNull;

public class ThemeUtil {

    public static ColorStateList getCheckboxColor(Context context) {
        int pressed = ThemeConfig.getInstance(context).getI2();
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        int checked = ThemeConfig.getInstance(context).getPrimaryColor();
        int disabled = ThemeConfig.getInstance(context).getI2();
        int normal = ThemeConfig.getInstance(context).getI3();
        return AppResource.createColorStateList(pressed, selected, checked, disabled, normal);
    }

    public static ColorStateList getToolbarTextColor(Context context) {
        int pressed = ThemeConfig.getInstance(context).getT2();
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        int disabled = ThemeConfig.getInstance(context).getT2();
        int normal = ThemeConfig.getInstance(context).getT4();
        return AppResource.createColorStateList(pressed, selected, selected, disabled, normal);
    }

    public static ColorStateList getPrimaryTextColor(Context context) {
        int pressed = ThemeConfig.getInstance(context).getT2();
        int disabled = ThemeConfig.getInstance(context).getT2();
        int normal = ThemeConfig.getInstance(context).getPrimaryColor();
        return AppResource.createColorStateList(pressed, pressed, pressed, disabled, normal);
    }

    public static ColorStateList getPrimaryIconColor(Context context) {
        return getPrimaryIconColor(context, false);
    }

    public static ColorStateList getPrimaryIconColor(Context context, boolean is_no_pressed_state) {
        int pressed = ThemeConfig.getInstance(context).getI2();
        int disabled = ThemeConfig.getInstance(context).getI2();
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        int normal = ThemeConfig.getInstance(context).getI3();
        if (is_no_pressed_state) {
            return AppResource.createColorStateList(selected, disabled, normal);
        } else {
            return AppResource.createColorStateList(pressed, selected, pressed, disabled, normal);
        }
    }

    public static ColorStateList getListIconColor(Context context) {
        int disabled = ThemeConfig.getInstance(context).getI2();
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        int normal = ThemeConfig.getInstance(context).getI3();
        return AppResource.createColorStateList(selected, disabled, normal);
    }

    public static ColorStateList getListTextColor(Context context) {
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        int disabled = ThemeConfig.getInstance(context).getT2();
        int normal = ThemeConfig.getInstance(context).getT4();
        return AppResource.createColorStateList(selected, disabled, normal);
    }

    public static ColorStateList getSelectedIconColor(Context context) {
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        int disabled = ThemeConfig.getInstance(context).getI2();
        int normal = ThemeConfig.getInstance(context).getI1();
        return AppResource.createColorStateList(selected, disabled, normal);
    }

    public static ColorStateList getEnableIconColor(Context context) {
        int disabled = ThemeConfig.getInstance(context).getI2();
        int normal = ThemeConfig.getInstance(context).getI3();

        return AppResource.createColorStateList(context, disabled, normal);
    }

    public static ColorStateList getEnableTextColor(Context context) {
        int disabled = ThemeConfig.getInstance(context).getT2();
        int normal = ThemeConfig.getInstance(context).getT4();

        return AppResource.createColorStateList(context, disabled, normal);
    }

    public static ColorStateList getItemIconColor(Context context, boolean withPressed) {
        int pressed = ThemeConfig.getInstance(context).getI2();
        int disabled = ThemeConfig.getInstance(context).getI2();
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        int normal = ThemeConfig.getInstance(context).getPrimaryColor();
        if (withPressed) {
            return AppResource.createColorStateList(pressed, selected, pressed, disabled, normal);
        } else {
            return AppResource.createColorStateList(selected, disabled, normal);
        }
    }

    public static ColorStateList getItemIconColor(Context context) {
        int pressed = ThemeConfig.getInstance(context).getI2();
        int disabled = ThemeConfig.getInstance(context).getI2();
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        int normal = ThemeConfig.getInstance(context).getPrimaryColor();
        return AppResource.createColorStateList(pressed, selected, pressed, disabled, normal);
    }

    public static ColorStateList getTabTintList(Context context) {
        int pressed = ThemeConfig.getInstance(context).getPrimaryColor();
        int disabled = ThemeConfig.getInstance(context).getB2();
        int normal = ThemeConfig.getInstance(context).getB2();
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        return AppResource.createColorStateList(pressed, selected, selected, disabled, normal);
    }

    public static void setTintList(View view, ColorStateList colorStateList) {
        if (view instanceof CheckBox) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                ((CheckBox) view).setButtonTintList(colorStateList);
            } else {
                Drawable drawable = AppResource.getDrawable(view.getContext(), R.drawable.fb_checkbox_selector);
                drawable = AppResource.createTintedDrawable(drawable, ThemeUtil.getCheckboxColor(view.getContext()));
                ((CheckBox) view).setButtonDrawable(drawable);
            }
        } else if (view instanceof ImageView) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                ((ImageView) view).setImageTintList(colorStateList);
            } else {
                Drawable drawable = ((ImageView) view).getDrawable();
                drawable = AppResource.createTintedDrawable(drawable, colorStateList);
                ((ImageView) view).setImageDrawable(drawable);
            }
            ((ImageView) view).refreshDrawableState();
        } else if (view instanceof TextView) {
            ((TextView) view).setTextColor(colorStateList);
        } else {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                view.setBackgroundTintList(colorStateList);
            } else {
                Drawable drawable = view.getBackground();
                drawable = AppResource.createTintedDrawable(drawable, colorStateList);
                view.setBackground(drawable);
            }
        }
    }

    public static void setViewTintList(@NonNull View view, ColorStateList imageTint, ColorStateList textTint) {
        if (view instanceof CheckBox) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                ((CheckBox) view).setButtonTintList(imageTint);
            } else {
                Drawable drawable = AppResource.getDrawable(view.getContext(), R.drawable.fb_checkbox_selector);
                drawable = AppResource.createTintedDrawable(drawable, ThemeUtil.getCheckboxColor(view.getContext()));
                ((CheckBox) view).setButtonDrawable(drawable);
            }
        } else if (view instanceof ImageView) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                ((ImageView) view).setImageTintList(imageTint);
            } else {
                Drawable drawable = ((ImageView) view).getDrawable();
                drawable = AppResource.createTintedDrawable(drawable, imageTint);
                ((ImageView) view).setImageDrawable(drawable);
            }
            ((ImageView) view).refreshDrawableState();
        } else if (view instanceof TextView) {
            ((TextView) view).setTextColor(textTint);
        } else if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup) view).getChildCount(); i++) {
                setViewTintList(((ViewGroup) view).getChildAt(i), imageTint, textTint);
            }
        }
    }

    public static void setBackgroundTintList(View view, ColorStateList colorStateList) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            view.setBackgroundTintList(colorStateList);
        } else {
            Drawable drawable = view.getBackground();
            drawable = AppResource.createTintedDrawable(drawable, colorStateList);
            view.setBackground(drawable);
        }
    }

    public static ColorStateList getTextDesTextColorStateList(Context context) {
        int pressed =   ThemeConfig.getInstance(context).getT2();
        int selected = ThemeConfig.getInstance(context).getT4();
        int disabled = ThemeConfig.getInstance(context).getT2();
        int normal = ThemeConfig.getInstance(context).getT4();
        return  AppResource.createColorStateList(pressed, selected, selected, disabled, normal);
    }

    public static ColorStateList getTextDesImageColorStateList(Context context) {
        int pressed = ThemeConfig.getInstance(context).getI2();
        int disabled = ThemeConfig.getInstance(context).getI2();
        int selected = ThemeConfig.getInstance(context).getI3();
        int normal = ThemeConfig.getInstance(context).getI3();
        return AppResource.createColorStateList(pressed, selected, pressed, disabled, normal);
    }

    public static ColorStateList getTopBarIconColorStateList(Context context){
        int pressed =  ThemeConfig.getInstance(context).getT2();
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        if(AppUtil.isDarkMode(context)){
            selected = AppResource.getColor(context,R.color.ui_color_top_bar_main);
        }

        int disabled = ThemeConfig.getInstance(context).getT2();
        int normal = AppResource.getColor(context,R.color.ui_color_top_bar_icon);
        return  AppResource.createColorStateList(pressed, selected, selected, disabled, normal);
    }

    public static ColorStateList getTopBarTextColorStateList(Context context){
        int pressed =  ThemeConfig.getInstance(context).getT2();
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        if(AppUtil.isDarkMode(context)){
            selected = AppResource.getColor(context,R.color.ui_color_top_bar_center_text_select);
        }
        int disabled = ThemeConfig.getInstance(context).getT2();
        int normal = AppResource.getColor(context,R.color.ui_color_top_bar_center_text);
        return  AppResource.createColorStateList(pressed, selected, selected, disabled, normal);
    }


    public static ColorStateList getTopBarIcon2ColorStateList(Context context){
        int pressed =  ThemeConfig.getInstance(context).getT2();
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        if(!AppUtil.isDarkMode(context)){
            selected = AppResource.getColor(context,R.color.ui_color_center_layout_f4f4f4);
        }
        int disabled = ThemeConfig.getInstance(context).getT2();
        int normal = AppResource.getColor(context,R.color.ui_color_top_bar_icon);
        return  AppResource.createColorStateList(pressed, selected, selected, disabled, normal);
    }
}
