/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.util.Log;


public class AppDarkUtil {
    private Context mContext;
    private static AppDarkUtil instance;
    private int mNightMode = -1;

    private AppDarkUtil(Context context) {
        mContext = context.getApplicationContext();
    }

    public static AppDarkUtil getInstance(Context context) {
        if (instance == null) {
            instance = new AppDarkUtil(context);
        }
        return instance;
    }

    public boolean isSystemModified(int newMode) {
        return mNightMode != newMode;
    }

    public void setCurNightMode(int mode){
        mNightMode = mode;
    }

    public int getCurNightMode(){
        return mNightMode;
    }

    public boolean isDarkMode() {
        return mNightMode == Configuration.UI_MODE_NIGHT_YES;
    }

}
