/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import androidx.documentfile.provider.DocumentFile;

import com.foxit.home.R;
import com.foxit.pdfreader.MultiTabView;
import com.foxit.pdfreader.fragment.AppTabsManager;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.common.Library;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.home.local.LocalModule;
import com.foxit.uiextensions.utils.AppDarkUtil;
import com.foxit.uiextensions.utils.AppFileUtil;
import com.foxit.uiextensions.utils.AppStorageManager;
import com.foxit.uiextensions.utils.UIToast;

import java.io.File;
import java.util.HashMap;

import static com.foxit.home.HomeFragment.REQUEST_SELECT_DEFAULT_FOLDER;

public class App {
    private static String sn = "aKEpCRKu0/BkCmRFhavCoXOP9xI8QwJzIAEe4+CuldzMNJGzf4mKvQ==";
    private static String key = "ezJvjt3GpGp399sXJUWUjY5Q4Cy/RvybylNKusfzMufW5k1ziSNqlwk6IKRg++yKjh3VA44Jx0t3zTngokyX78qqdQX2n9Dq3DEulcv/f5XN1B6EX2jESCT4K53PBEncOAqvgam7qmIxuVj0yIJMcVzRju9BID1xQKOFHiRSUUXupPrEKTraVBJgzsphlgudAsQAk3xS56wpFAEAMJE9RhgHlzLd758GK5viOEglYUHl7n31UilbrvpOKiGEfQ52D54IwAofHdHamOMSlSYXhh2/JXWNKi+EMyegfB26Qg04+sry01n6SqLofbxC+6WtcRuwEj2I1Yb0lc6yFESdJWPGv7Dgz0COyGQbM6GDTNE33vaeFIa4MQdnKZuXABj9kGmTjeiZbcy8vkY7Lmm0gmnVu09VIpqZhYZwJM/aYdBRMPxBnKDGVw1t7hLD8jeOJAZX1Ua1jKjsLcni7s5+W7WU0sGKr7DJTwsEzcLqyr160onAaU3/M8ZQs7wy43rZ//oPYpx/mZHJs927TP7oVeRHx0sffTGpKPN7lctjA2hStQTkhCPl7nZhEz7c5EC3t9GJ+z4l5Sf+XLDILXyVTBkfDX897CFt1ozEU46y5TokHjpufDXSZxxBGcLxOiMfbW2MzfiB/BTL6/rbn/6kYM4aoGxhP4xWYEcVTpipDTzXlJ062+f4FEFoEt1YS5ufFA2v2nc9pqAzMpkciPXID6Wn822/PW/8cOu/bzVC1CH9lCG6YQtDV0PQyrjiOWkRQMN19N1Mfwooay7gA59NL01iSNYn5qx8R0O3oH2UfFBde3wCSqo+08ZvLnVPV0HJjacNHsuRlQvnGmBJvkNoeL/zb4O5t15dFBCrBUGRdlqTQl22r1n3sTNVoCkQfCGtY5wI/UbsCRWsjxphWBa0Edh1COD62UeY7Gq6oWy7O5b4kRjXVfMfc0q848KgUxfB03QFw7H40lHXODQOyKGfcCGMNdvA8zYRqSgg35DH9pmDqDB2rFyohlXy1fR+3e/Fud5tdlosppauZ/6rbFPiM5k4IAPQGRs0P/hW9MCeMZR8xnhcXO6Dabfnc7cdfkZqt+CI/+U0Jy+piWwCTnq97r5hba1Ng6eaCuvK9kzirBX1+HyQ+Fc6PEnIdi/lQNm7XjLy7aoWiUuNYoCFLHwdxV/XgGNyNALGz+HmHpESRMjjOjlhPIahkl9ENAZKW3Oq+k+K6d/fsht4ACz4sWSgTmiY+odH3OiwZ8wIhio0onqea9F9sHfWtHUcP+UYgxjVrH+/b32KhWaxwrtKiIg=";
    private Context mContext;
    private int errCode = Constants.e_ErrSuccess;
    private static App INSTANCE = new App();

    public static App instance() {
        return INSTANCE;
    }

    private App() {
        errCode = Library.initialize(sn, key);
    }

    public boolean checkLicense() {
        switch (errCode) {
            case Constants.e_ErrSuccess:
                break;
            case Constants.e_ErrInvalidLicense:
                UIToast.getInstance(mContext).show(mContext.getString(R.string.fx_the_license_is_invalid));
                return false;
            default:
                UIToast.getInstance(mContext).show(mContext.getString(R.string.fx_failed_to_initialize_the_library));
                return false;
        }
        return true;
    }

    public void setApplicationContext(Context context) {
        mContext = context;
        AppDarkUtil.getInstance(mContext).setCurNightMode(mContext.getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK);
    }

    public Context getApplicationContext() {
        return mContext;
    }

    HashMap<String, LocalModule> mLocalModules = new HashMap<String, LocalModule>();

    public LocalModule getLocalModule(String filter) {
        if (mLocalModules.get(filter) == null) {
            LocalModule module = new LocalModule(mContext);
            module.loadModule();
            mLocalModules.put(filter, module);
        }
        return mLocalModules.get(filter);
    }

    public void onDestroy() {
        for (LocalModule module : mLocalModules.values()) {
            module.unloadModule();
        }

        mLocalModules.clear();
    }

    public void unloadLocalModule(String filter) {
        LocalModule module = mLocalModules.get(filter);
        if (module != null) {
            module.unloadModule();

            mLocalModules.remove(filter);
        }
    }

    HashMap<String, MultiTabView> mMultiTabViews = new HashMap<String, MultiTabView>();

    public MultiTabView getMultiTabView(String filter) {
        if (mMultiTabViews.get(filter) == null) {
            MultiTabView view = new MultiTabView();
            view.initialize();
            mMultiTabViews.put(filter, view);
        }
        return mMultiTabViews.get(filter);
    }

    boolean mIsMultiTab = false;

    public boolean isMultiTab() {
        return mIsMultiTab;
    }

    public void setMultiTabFlag(boolean isMultiTab) {
        mIsMultiTab = isMultiTab;
    }

    HashMap<String, AppTabsManager> mTabsManagers = new HashMap<String, AppTabsManager>();

    public AppTabsManager getTabsManager(String filter) {
        if (mTabsManagers.get(filter) == null) {
            AppTabsManager manager = new AppTabsManager();
            mTabsManagers.put(filter, manager);
        }
        return mTabsManagers.get(filter);
    }

    public void copyGuideFiles(LocalModule localModule) {
        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            String curPath = AppStorageManager.getInstance(mContext).getDefaultFolder();
            if (!AppFileUtil.needScopedStorageAdaptation()){
                curPath = AppFileUtil.getDefaultDocumentDirectory();
                File file = new File(curPath);
                if (!file.exists()){
                    if (!file.mkdirs())
                        return;
                }
                File sampleFile = new File(curPath + File.separator + "Sample.pdf");
                if (!sampleFile.exists()) {
                    localModule.copyFileFromAssertsToTargetFile(sampleFile);
                }

                File guideFile = new File(curPath + File.separator + "complete_pdf_viewer_guide_android.pdf");
                if (!guideFile.exists()) {
                    localModule.copyFileFromAssertsToTargetFile(guideFile);
                }
            }else if (!TextUtils.isEmpty(curPath)){
                Uri uri = AppFileUtil.toDocumentUriFromPath(curPath);
                if (AppFileUtil.isDocumentTreeUri(uri)){
                    DocumentFile directory = AppStorageManager.getInstance(mContext).getExistingDocumentFile(uri);
                    if (directory == null)return;
                    String fileName = "Sample.pdf";
                    DocumentFile file = directory.findFile(fileName);
                    if (file == null){
                        file = directory.createFile(AppFileUtil.getMimeType(fileName), fileName);
                        localModule.copyFileFromAssertsToTargetFile(file);
                    }

                    fileName = "complete_pdf_viewer_guide_android.pdf";
                    file = directory.findFile(fileName);
                    if (file == null){
                        file = directory.createFile(AppFileUtil.getMimeType(fileName), fileName);
                        localModule.copyFileFromAssertsToTargetFile(file);
                    }
                }
                localModule.setCurrentPath(curPath);
            }
        }
    }

    HashMap<String, IBaseItem> mTabsButtons = new HashMap<String, IBaseItem>();

    public void setTabsButton(String filter, IBaseItem button) {
        mTabsButtons.put(filter, button);
    }

    public IBaseItem getTabsButton(String filter) {
        return mTabsButtons.get(filter);
    }

    public void onBack() {
        mTabsButtons.clear();
        mTabsManagers.clear();
        mMultiTabViews.clear();
    }

    public static final String FILTER_DEFAULT = "default_filter";

    public void selectDefaultFolderOrNot(Activity activity) {
        if (AppFileUtil.needScopedStorageAdaptation()){
            if (activity != null && TextUtils.isEmpty(AppStorageManager.getInstance(activity).getDefaultFolder())) {
                AppFileUtil.checkCallDocumentTreeUriPermission(activity, REQUEST_SELECT_DEFAULT_FOLDER,
                        Uri.parse(AppFileUtil.getExternalRootDocumentTreeUriPath()));
                UIToast.getInstance(activity).show(R.string.select_default_folder_toast_content);
            }
        }
    }
}
