/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function;

import android.content.Context;
import android.widget.Toast;

import com.foxit.pdf.function_demo.R;
import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.Bookmark;
import com.foxit.sdk.pdf.PDFDoc;

public class Outline {
    private Context mContext;
    private int index = 0;

    public Outline(Context context) {
        mContext = context;
    }

    public void modifyOutline() {
        String inputPath = Common.getFixFolder() + "Outline.pdf";
        String outputPath = Common.getOutputFilesFolder(Common.OUTLINE) + "Outline_edit.pdf";

        PDFDoc doc = Common.loadPDFDoc(mContext, inputPath, null);
        if (doc == null || doc.isEmpty()) {
            return;
        }
        try {
            Bookmark bookmarkRoot = doc.getRootBookmark();
            if (bookmarkRoot == null) {
                return;
            }

            Bookmark firstChild = bookmarkRoot.getFirstChild();
            modifyOutline(firstChild);

            if (!doc.saveAs(outputPath, PDFDoc.e_SaveFlagNormal)) {
                Toast.makeText(mContext, mContext.getString(R.string.fx_save_doc_error), Toast.LENGTH_LONG).show();
                return;
            }
        } catch (PDFException e) {
            Toast.makeText(mContext, mContext.getString(R.string.fx_outline_run_error, e.getMessage()), Toast.LENGTH_LONG).show();
            return;
        }
        Toast.makeText(mContext, Common.getSuccessInfo(mContext, outputPath), Toast.LENGTH_LONG).show();
    }

    private void modifyOutline(Bookmark bookmark) {
        try {
            if (bookmark.isEmpty())
                return;

            if (index % 2 == 0) {
                bookmark.setColor(0xFFFF0000);
                bookmark.setStyle(Bookmark.e_StyleBold);
            } else {
                bookmark.setColor(0xFF00FF00);
                bookmark.setStyle(Bookmark.e_StyleItalic);
            }

            bookmark.setTitle("foxitbookmark" + index);
            index++;

            //Traverse the brother nodes and modify their appearance and titles.
            Bookmark nextSibling = bookmark.getNextSibling();
            modifyOutline(nextSibling);

            //Traverse the children nodes and modify their appearance and titles.
            Bookmark child = bookmark.getFirstChild();
            modifyOutline(child);

        } catch (PDFException e) {
            Toast.makeText(mContext, mContext.getString(R.string.fx_outline_run_error, e.getMessage()), Toast.LENGTH_LONG).show();
        }
    }
}
