/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function;

import android.content.Context;
import android.widget.Toast;

import com.foxit.pdf.function_demo.R;
import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.TextPage;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Pdf2text {
    private Context mContext;

    public Pdf2text(Context context) {
        mContext = context;
    }

    public void doPdfToText() {
        String inputPath = Common.getFixFolder() + "FoxitBigPreview.pdf";
        String outputPath = Common.getOutputFilesFolder(Common.PDF_TO_TXT) + "FoxitBigPreview.txt";

        StringBuilder strText = new StringBuilder();
        PDFDoc doc = Common.loadPDFDoc(mContext, inputPath, null);
        if (doc == null) {
            return;
        }

        PDFPage page = null;
        try {
            int pageCount = doc.getPageCount();

            //Traverse pages and get the text string.
            for (int i = 0; i < pageCount; i++) {
                page = Common.loadPage(mContext, doc, i, PDFPage.e_ParsePageNormal);
                if (page == null || page.isEmpty()) {
                    continue;
                }

                TextPage textSelect = new TextPage(page, TextPage.e_ParseTextNormal);
                if (textSelect.isEmpty()) {
                    continue;
                }

                strText.append(textSelect.getChars(0, textSelect.getCharCount())).append("\r\n");
            }
        } catch (PDFException e) {
            Toast.makeText(mContext, mContext.getString(R.string.fx_pdf_to_text_error, e.getMessage()), Toast.LENGTH_LONG).show();
            return;
        }

        //Output the text string to the TXT file.
        FileWriter fileWriter = null;
        try {
            File fileTxt = new File(outputPath);
            fileWriter = new FileWriter(fileTxt);
            fileWriter.write(strText.toString());
            fileWriter.flush();
            fileWriter.close();
        } catch (IOException e) {
            Toast.makeText(mContext, e.getMessage(), Toast.LENGTH_LONG).show();
            return;
        }

        Toast.makeText(mContext, Common.getSuccessInfo(mContext, outputPath), Toast.LENGTH_LONG).show();
    }
}
