/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function;


import android.content.Context;
import android.graphics.Bitmap;
import android.widget.Toast;

import com.foxit.pdf.function_demo.R;
import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.common.Font;
import com.foxit.sdk.common.Image;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.WatermarkSettings;
import com.foxit.sdk.pdf.WatermarkTextProperties;

public class Watermark {

    private Context mContext;

    public Watermark(Context context) {
        this.mContext = context;
    }

    public void addWatermark() {
        String inputPath = Common.getFixFolder() + "AboutFoxit.pdf";
        String outputPath = Common.getOutputFilesFolder(Common.WATERMARK) + "watermark_add.pdf";

        PDFDoc doc = Common.loadPDFDoc(mContext, inputPath, null);
        if (doc == null) return;
        try {
            int nCount = doc.getPageCount();
            for (int i = 0; i < nCount; i++) {
                PDFPage page = Common.loadPage(mContext, doc, i, PDFPage.e_ParsePageNormal);
                if (page == null) continue;

                addTextWatermark(doc, page);
                String wm_bmp = Common.getFixFolder() + "image/watermark.bmp";
                addBitmapWatermark(doc, page, wm_bmp);
                String wm_image = Common.getFixFolder() + "image/sdk.png";
                addImageWatermark(doc, page, wm_image);
                addSingleWatermark(doc, page);
            }
            Common.saveDFDoc(mContext, doc, outputPath);
        } catch (PDFException e) {
            Toast.makeText(mContext, mContext.getString(R.string.fx_add_watermark_failed, e.getMessage()), Toast.LENGTH_LONG).show();
        }
    }

    private void addTextWatermark(PDFDoc doc, PDFPage page) throws PDFException {
        WatermarkSettings settings = new WatermarkSettings();
        settings.setFlags(WatermarkSettings.e_FlagASPageContents | WatermarkSettings.e_FlagOnTop);
        settings.setOffset_x(0);
        settings.setOffset_y(0);
        settings.setOpacity(90);
        settings.setPosition(Constants.e_PosTopRight);
        settings.setRotation(-45.f);
        settings.setScale_x(1.f);
        settings.setScale_y(1.f);

        WatermarkTextProperties text_properties = new WatermarkTextProperties();
        text_properties.setAlignment(Constants.e_AlignmentCenter);
        text_properties.setColor(0xF68C21);
        text_properties.setFont_size(WatermarkTextProperties.e_FontStyleNormal);
        text_properties.setLine_space(1);
        text_properties.setFont_size(12.f);
        text_properties.setFont(new Font(Font.e_StdIDTimesB));

        com.foxit.sdk.pdf.Watermark watermark = new com.foxit.sdk.pdf.Watermark(doc, "Foxit PDF SDK\nwww.foxitsoftware.com", text_properties, settings);
        watermark.insertToPage(page);
    }

    private void addBitmapWatermark(PDFDoc doc, PDFPage page, String bitmap_file) throws PDFException {
        WatermarkSettings settings = new WatermarkSettings();
        settings.setFlags(WatermarkSettings.e_FlagASPageContents | WatermarkSettings.e_FlagOnTop);
        settings.setOffset_y(0.f);
        settings.setOffset_y(0.f);
        settings.setOpacity(60);
        settings.setPosition(Constants.e_PosCenterLeft);
        settings.setRotation(90.f);

        Image image = new Image(bitmap_file);
        Bitmap bitmap = image.getFrameBitmap(0);
        settings.setScale_x(page.getHeight() * 1.0f / bitmap.getWidth());
        settings.setScale_y(settings.getScale_x());
        com.foxit.sdk.pdf.Watermark watermark = new com.foxit.sdk.pdf.Watermark(doc, bitmap, settings);
        watermark.insertToPage(page);
    }


    private void addImageWatermark(PDFDoc doc, PDFPage page, String image_file) throws PDFException {
        WatermarkSettings settings = new WatermarkSettings();
        settings.setFlags(WatermarkSettings.e_FlagASPageContents | WatermarkSettings.e_FlagOnTop);
        settings.setOffset_x(0.f);
        settings.setOffset_y(0.f);
        settings.setOpacity(20);
        settings.setPosition(Constants.e_PosCenter);
        settings.setRotation(0.0f);

        Image image = new Image(image_file);
        Bitmap bitmap = image.getFrameBitmap(0);
        settings.setScale_x(page.getWidth() * 0.618f / bitmap.getWidth());
        settings.setScale_y(settings.getScale_x());

        com.foxit.sdk.pdf.Watermark watermark = new com.foxit.sdk.pdf.Watermark(doc, image, 0, settings);
        watermark.insertToPage(page);
    }

    private void addSingleWatermark(PDFDoc doc, PDFPage page) throws PDFException {
        WatermarkSettings settings = new WatermarkSettings();
        settings.setFlags(WatermarkSettings.e_FlagASPageContents | WatermarkSettings.e_FlagOnTop);
        settings.setOffset_x(0.f);
        settings.setOffset_y(0.f);
        settings.setOpacity(90);
        settings.setPosition(Constants.e_PosBottomRight);
        settings.setRotation(0.0f);
        settings.setScale_x(0.1f);
        settings.setScale_y(0.1f);

        com.foxit.sdk.pdf.Watermark watermark = new com.foxit.sdk.pdf.Watermark(doc, page, settings);
        watermark.insertToPage(page);
    }

}
