/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.BorderInfo;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

public class JSAnnot {

    public static JSONObject exportToJSON(Annot annot) {
        JSONObject object = new JSONObject();
        try {
            object.put("type", JSAnnotUtil.type2String(annot));
            object.put("color", JSAnnotUtil.colorConvertor(annot.getBorderColor() & 0x00ffffff));
            object.put("flags", JSAnnotUtil.flags2String(annot));
            object.put("date", JSAnnotUtil.formatDocumentDate(annot.getModifiedDateTime()));
            object.put("name", annot.getUniqueID());
            object.put("page", annot.getPage().getIndex());
            object.put("rect", JSAnnotUtil.rect2String(annot));
            object.put("contents", annot.getContent());
            object.put("width", annot.getBorderInfo().getWidth());

            JSONObject customEntries = new JSONObject();
            object.put("customEntries", customEntries);
            if (annot.getDict() != null && annot.getDict().hasKey("customEntries")) {
                try {
                    String customEntriesStr = annot.getDict().getElement("customEntries").getWideString();
                    JSONObject customJson = new JSONObject(customEntriesStr);
                    Map<String, Object> jsonMap = JSUtil.parseJSONObject(customJson);
                    for (Map.Entry<String, Object> entry : jsonMap.entrySet()) {
                        customEntries.put(entry.getKey() ,entry.getValue());
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            object.put("style", JSAnnotUtil.borderStyle2String(annot));
            BorderInfo borderInfo = annot.getBorderInfo();
            if (borderInfo.getStyle() == BorderInfo.e_Dashed) {
                object.put("dashPhase", borderInfo.getDash_phase());
                StringBuilder dashes = new StringBuilder();
                for (int i = 0; i < borderInfo.getDashes().getSize(); i++) {
                    dashes.append(borderInfo.getDashes().getAt(i));
                    dashes.append(",");
                }
                object.put("dashes", dashes.substring(0, dashes.length() - 1));
            } else if (borderInfo.getStyle() == BorderInfo.e_Cloudy) {
                object.put("intensity", borderInfo.getCloud_intensity());
            }
        } catch (JSONException | PDFException e) {
            e.printStackTrace();
        }
        return object;
    }




}
