/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.FileAttachment;
import com.foxit.sdk.pdf.objects.PDFObject;

import org.json.JSONException;
import org.json.JSONObject;

public class JSFileAttachment {

    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject jsonObject = JSMarkupAnnot.exportToJSON(doc, annot);

        try {
            FileAttachment attachment = new FileAttachment(annot);
            jsonObject.put("icon", attachment.getIconName());

            JSONObject raw = new JSONObject();
            jsonObject.put("raw", raw);
            PDFObject pdfObject = attachment.getDict().getElement("FS");
            if (pdfObject != null) {
                Object object = JSAnnotUtil.retriveDict(raw, pdfObject.getDirectObject());
                raw.put("FS", object);
            }
        } catch (JSONException | PDFException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

}
