/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.fxcrt.PointFArray;
import com.foxit.sdk.common.fxcrt.RectF;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.DefaultAppearance;
import com.foxit.sdk.pdf.annots.FreeText;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;

public class JSFreeText {

    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject object = JSMarkupAnnot.exportToJSON(doc, annot);
        try {
            FreeText freeText = new FreeText(annot);
            object.put("justification", freeText.getAlignment());

            DefaultAppearance defaultAppearance = freeText.getDefaultAppearance();
            String DA = "";
            if (defaultAppearance.getFont() != null && !defaultAppearance.getFont().isEmpty()) {
                DA += "/" + defaultAppearance.getFont().getName() + " ";
            }
            DA += defaultAppearance.getText_size() + " Tf ";

            int[] rgba = JSAnnotUtil.convertFromNumberToRGBA(freeText.getBorderColor());
            DA += String.format(Locale.getDefault(), "%.2f", (rgba[0] / 255f))
                    + " " + String.format(Locale.getDefault(), "%.2f", (rgba[1] / 255f))
                    + " " + String.format(Locale.getDefault(), "%.2f", (rgba[2] / 255f)) + " rg";

            object.put("defaultappearance", DA);
            object.put("fontColor", JSAnnotUtil.colorConvertor(defaultAppearance.getText_color() & 0x00ffffff));

            if (freeText.getFillColor() != 0) {
                String fillColor = JSAnnotUtil.convertFromNumberToHex(freeText.getFillColor() & 0x00ffffff);
                object.put("interior-color", fillColor);
                object.put("interiorColor", fillColor);
            }
            String intent = freeText.getIntent();
            if ("FreeTextCallout".equals(intent)) {
                RectF pdfRect = freeText.getRect();
                RectF innerRect = freeText.getInnerRect();
                String fringe = String.valueOf(innerRect.getLeft() - pdfRect.getLeft());
                fringe += ",";
                fringe += String.valueOf(innerRect.getBottom() - pdfRect.getBottom());
                fringe += ",";
                fringe += String.valueOf(pdfRect.getRight() - innerRect.getRight());
                fringe += ",";
                fringe += String.valueOf(pdfRect.getTop() - innerRect.getTop());
                object.put("fringe", fringe);

                PointFArray pointFArray = freeText.getCalloutLinePoints();
                String callout = pointFArray.getAt(0).getX() + "," + pointFArray.getAt(0).getY();
                callout += "," + pointFArray.getAt(1).getX() + "," + pointFArray.getAt(1).getY();
                callout += "," + pointFArray.getAt(2).getX() + "," + pointFArray.getAt(2).getY();

                object.put("callout", callout);
                object.put("head", JSAnnotUtil.makeupEndingStyle(freeText.getCalloutLineEndingStyle()));
            }
        } catch (PDFException | JSONException e) {
            e.printStackTrace();
        }
        return object;
    }

}
