/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.Path;
import com.foxit.sdk.common.fxcrt.PointF;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.Ink;

import org.json.JSONException;
import org.json.JSONObject;

public class JSInk {

    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject object = JSMarkupAnnot.exportToJSON(doc, annot);
        try {
            Ink ink = new Ink(annot);
            Path inkListInfo = ink.getInkList();
            String inklist = "[";
            for (int index = 0; index < inkListInfo.getPointCount(); index++) {
                PointF pointF = inkListInfo.getPoint(index);
                int type = inkListInfo.getPointType(index);
                if (index != 0 && type == 1) {
                    inklist = inklist.substring(0, inklist.length() - 1);
                    inklist += "],[";
                }
                inklist += (pointF.getX() + "," + pointF.getY() + ";");
            }
            inklist = inklist.substring(0, inklist.length() - 1) + "]";

            object.put("inklist", inklist);
        } catch (JSONException | PDFException e) {
            e.printStackTrace();
        }
        return object;
    }

}
