/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.Markup;
import com.foxit.sdk.pdf.annots.Note;
import com.foxit.sdk.pdf.objects.PDFObject;

import org.json.JSONException;
import org.json.JSONObject;

public class JSNote {

    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject object = JSMarkupAnnot.exportToJSON(doc, annot);
        try {
            Note note = new Note(annot);
            object.put("icon", note.getIconName());
            if (note.isStateAnnot()) {
                object.put("statemodel", note.getStateModel() == 1 ? "Marked" : "Review");
                String IRT = null;
                PDFObject IRTObj = annot.getDict().getElement("IRT");
                if (IRTObj != null) {
                    IRTObj = IRTObj.getDict();
                    int IRTNum = IRTObj.getObjNum();
                    IRTObj = doc.getIndirectObject(IRTNum).getDict().getElement("NM");
                    IRT = IRTObj.getWideString();
                }
                object.put("inreplyto", IRT);
                object.put("state", state2String(note.getState()));

                object.remove("contents");
                object.remove("color");
            }
        } catch (JSONException | PDFException e) {
            e.printStackTrace();
        }
        return object;
    }

  private static String state2String(int state){
        switch (state){
            case Markup.e_StateMarked:
                return "Marked";
            case Markup.e_StateUnmarked:
                return "Unmarked";
            case Markup.e_StateAccepted:
                return "Accepted";
            case Markup.e_StateRejected:
                return "Rejected";
            case Markup.e_StateCancelled:
                return "Cancelled";
            case Markup.e_StateCompleted:
                return "Completed";
            case Markup.e_StateNone:
            default:
                return "None";
        }

    }
}
