/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.fxcrt.PointF;
import com.foxit.sdk.common.fxcrt.PointFArray;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.PolyLine;
import com.foxit.sdk.pdf.annots.Polygon;

import org.json.JSONException;
import org.json.JSONObject;

public class JSPolyLine {
    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject object = JSMarkupAnnot.exportToJSON(doc, annot);
        try {
            PolyLine polyLine = new PolyLine(annot);

            if (polyLine.getStyleFillColor() != 0){
                String color = JSAnnotUtil.convertFromNumberToHex(polyLine.getStyleFillColor() & 0x00ffffff);
                object.put("interior-color", color);
                object.put("interiorColor", color);
            }
            object.put("head", JSAnnotUtil.makeupEndingStyle(polyLine.getLineStartStyle()));
            object.put("tail", JSAnnotUtil.makeupEndingStyle(polyLine.getLineEndStyle()));

            PointFArray vertices = polyLine.getVertexes();
            String pointList = "";
            for (int index = 0; index < vertices.getSize(); index++) {
                PointF pointF = vertices.getAt(index);
                pointList += pointF.getX() + "," + pointF.getY() + ";";
            }
            pointList = pointList.substring(0, pointList.length() - 1);
            object.put("vertices", pointList);
        } catch (JSONException | PDFException e) {
            e.printStackTrace();
        }
        return object;
    }
}
