/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.fxcrt.RectF;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.Popup;

import org.json.JSONException;
import org.json.JSONObject;

public class JSPopup {

    public static JSONObject exportToJSON(Annot annot) {
        JSONObject object = new JSONObject();
        try {
            Popup popup = new Popup(annot);

            object.put("flags", JSAnnotUtil.flags2String(popup));
            object.put("name", popup.getUniqueID());
            object.put("page", popup.getPage().getIndex());
            object.put("open", popup.getOpenStatus() ? "yes" : "no");
            RectF rect = popup.getRect();
            object.put("rect", String.format("%s,%s,%s,%s",
                    rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop()));
            object.put("type", "popup");
        } catch (JSONException | PDFException e) {
            e.printStackTrace();
        }
        return object;
    }
}
