/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.fxcrt.RectF;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.Markup;
import com.foxit.sdk.pdf.annots.Square;

import org.json.JSONException;
import org.json.JSONObject;

public class JSSquare {

    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject object = JSMarkupAnnot.exportToJSON(doc, annot);
        try {
            Square square = new Square(annot);
            RectF pdfRect = square.getRect();
            RectF innerRect = square.getInnerRect();
            String fringe = String.valueOf(innerRect.getLeft() - pdfRect.getLeft());
            fringe += ",";
            fringe += String.valueOf(innerRect.getBottom() - pdfRect.getBottom());
            fringe += ",";
            fringe += String.valueOf(pdfRect.getRight() - innerRect.getRight());
            fringe += ",";
            fringe += String.valueOf(pdfRect.getTop() - innerRect.getTop());
            object.put("fringe", fringe);

            if (square.getFillColor() != 0) {
                String fillColor = JSAnnotUtil.colorConvertor(square.getFillColor() & 0x00ffffff);
                object.put("interior-color", fillColor);
                object.put("interiorColor", fillColor);
            }
            if ("CustomDimension".equals(square.getIntent())) {
                object.put("measureConversionFactor", square.getMeasureConversionFactor(Markup.e_MeasureTypeD));
                object.put("measureRatio", square.getMeasureRatioW());
                object.put("measureUnit", square.getMeasureUnit(Markup.e_MeasureTypeD));
            }
        } catch (JSONException | PDFException e) {
            e.printStackTrace();
        }
        return object;
    }
}
