/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.main;


import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.foxit.pdf.function_demo.R;

class FunctionAdapter extends RecyclerView.Adapter<FunctionAdapter.FunctionViewHolder> {

    private OnItemClickListener mItemClickListener;
    private Context mContext;
    private List<FunctionItemBean> mDatas;

    FunctionAdapter(Context context, List<FunctionItemBean> functions) {
        this.mContext = context;
        this.mDatas = functions;
    }

    @NonNull
    @Override
    public FunctionAdapter.FunctionViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.main_item, parent, false);
        return new FunctionViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull FunctionViewHolder holder, int position) {
        holder.bind(mDatas.get(position));
    }

    @Override
    public int getItemCount() {
        return mDatas == null ? 0 : mDatas.size();
    }

    class FunctionViewHolder extends RecyclerView.ViewHolder {

        private TextView mTvDesc;
        private Button mBtnName;

        FunctionViewHolder(@NonNull View itemView) {
            super(itemView);

            mTvDesc = itemView.findViewById(R.id.tv_desc);
            mBtnName = itemView.findViewById(R.id.btn_name);

            mBtnName.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mItemClickListener != null) {
                        int position = getAdapterPosition();
                        mItemClickListener.onItemClick(position, mDatas.get(position));
                    }
                }
            });
        }

        void bind(FunctionItemBean itemBean) {
            mTvDesc.setText(itemBean.desc);
            mBtnName.setText(itemBean.name);
        }
    }

    static class FunctionItemBean {
        int type;
        String desc;
        String name;

        FunctionItemBean(int type, String name, String desc) {
            this.type = type;
            this.desc = desc;
            this.name = name;
        }
    }

    void setOnItemClickListener(OnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    interface OnItemClickListener {
        void onItemClick(int positon, FunctionItemBean itemBean);
    }

}
