"use strict";var e=require("@nestjs/core"),t=require("body-parser"),r=require("nestjs-pino"),n=require("@nestjs/common"),o=require("cuid"),i=require("@foxitsoftware/collab-db"),a=require("jsonwebtoken"),s=require("rxjs/operators"),c=require("yjs"),d=require("process"),l=require("redis"),u=require("lib0/encoding"),m=require("lib0/decoding"),p=require("@nestjs/websockets"),y=require("ws"),S=require("@nestjs/common/utils/load-package.util"),h=require("@nestjs/websockets/constants"),f=require("http"),g=require("rxjs"),b=require("qs");function v(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var _,w,I,E=v(e),O=v(t),C=v(r),M=v(n),D=v(o),A=v(i),P=v(a),R=v(s),N=v(c),T=v(d),j=v(l),U=v(u),L=v(m),B=v(p),x=v(y),F=v(S),Y=v(h),k=v(f),q=v(g),$=v(b),G="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{},H={},J={},V={},z={},W={},Q={};_=Q,Object.defineProperty(_,"__esModule",{value:!0}),_.UserStatus=_.UserType=void 0,(w=_.UserType||(_.UserType={})).ANONYMOUS="ANONYMOUS",w.STANDARD="STANDARD",w.PRE_REGISTRATION="PRE-REGISTRATION",(I=_.UserStatus||(_.UserStatus={})).ACTIVE="ACTIVE",I.INACTIVE="INACTIVE";var Z,K,X,ee={},te={};function re(){if(Z)return te;Z=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)};Object.defineProperty(te,"__esModule",{value:!0}),te.ConfigService=void 0;const r=M.default,n=Nt();let o=class{constructor(){}get dbConfig(){return process.env.db_config&&JSON.parse(process.env.db_config)||{type:"postgres",host:"localhost",port:5432,database:"collab-db",user:"postgres",password:"123456"}}async getLoggerConfig(){return{pinoHttp:Object.assign({useLevel:"debug",autoLogging:!1,transport:{target:"pino-pretty"},level:"info"},n.customLoggerOptions)}}};return o=e([(0,r.Injectable)(),t("design:paramtypes",[])],o),te.ConfigService=o,te}function ne(){if(K)return ee;K=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)};Object.defineProperty(ee,"__esModule",{value:!0}),ee.PrismaService=void 0;const r=D.default,n=M.default,o=A.default,i=Q,a=re();function s(e){return{id:e.id,user_name:e.name||void 0,password:e.password||void 0,email:e.email||void 0,status:e.status,type:e.type,created_at:e.createdAt?parseInt(String(e.createdAt)):void 0,updated_at:e.updatedAt?parseInt(String(e.updatedAt)):void 0}}function c(e){return{id:e.id||void 0,name:e.name,file_url:e.fileURL,author_id:e.authorId||void 0,is_public:e.isPublic,permission:e.permission||void 0,status:e.status||void 0,created_at:e.createdAt?parseInt(String(e.createdAt)):void 0,updated_at:e.updatedAt?parseInt(String(e.updatedAt)):void 0}}function d(e){return encodeURIComponent(e).replace(/\./g,"%2E")}let l=class{constructor(e){this.configService=e,this.dbConfig=e.dbConfig}get prismaClient(){return this.prisma}async onModuleInit(){const e=this.dbConfig,t=function(e){if(e.connectionURL)return e.connectionURL;const{user:t,password:r,host:n,port:o,database:i}=e;switch(e.type){case"sqlserver":case"mssql":return`sqlserver://${n}:${o};initial catalog=${i};user=${t};password=${r}`;case"oracle":return`oracle:thin://${t}/${d(r)}@//${n}:${o}/${i}`;case"mysql":return`mysql://${d(t)}:${d(r)}@${n}:${o}/${i}`;default:return`postgresql://${d(t)}:${d(r)}@${n}:${o}/${i}?schema=public`}}(e);this.prisma=new o.PrismaClient({datasources:{db:{url:t}},log:e.log}),await this.prisma.$connect()}async enableShutdownHooks(e){this.prisma.$on("beforeExit",async()=>{await e.close()})}async createUser(e){const{id:t,user_name:r,email:n,password:o,status:i,type:a}=e;let s;if(s=t?await this.prisma.user.findUnique({where:{id:t}}):await this.prisma.user.findFirst({where:{name:r}}),s)return;let c=Date.now(),d={name:r,email:n,password:o,status:i,type:a,createdAt:c,updatedAt:c};t&&(d.id=t);return{id:(await this.prisma.user.create({data:d})).id}}async createUsersByEmails(e){let t=i.UserStatus.ACTIVE,r=i.UserType.PRE_REGISTRATION,n=Date.now();const o=e.map(e=>({name:e,email:e,password:"",status:t,type:r,createdAt:n,updatedAt:n}));await this.prisma.user.createMany({data:o});return(await this.prisma.user.findMany({where:{email:{in:e}}})).map(e=>({id:e.id,email:e.email}))}async getUserByEmail(e){return s(await this.prisma.user.findFirstOrThrow({where:{email:e}}))}async getUsersByEmails(e){return(await this.prisma.user.findMany({where:{name:{in:e}}})).map(e=>s(e))}async createAnonymousUser(e){let t=i.UserStatus.ACTIVE,r=i.UserType.ANONYMOUS;return this.createUser({user_name:e,status:t,type:r})}async getUserByName(e){const t=await this.prisma.user.findFirst({where:{name:e}});return t?s(t):null}async getUserByPassword(e,t){return s(await this.prisma.user.findFirstOrThrow({where:{email:e,password:t}}))}async getUserById(e){return s(await this.prisma.user.findUniqueOrThrow({where:{id:e}}))}async editUserType(e){let t=Date.now();await this.prisma.user.update({where:{id:e},data:{type:i.UserType.ANONYMOUS,updatedAt:t}})}async getUsersByIdList(e){if(0===e.length)return[];return(await this.prisma.user.findMany({where:{id:{in:e}}})).map(e=>s(e))}async createDocument(e){const{name:t,file_url:n,author_id:o,is_public:i,id:a,permission:s}=e;let c=a||r(),d=Date.now();return{id:(await this.prisma.document.create({data:{id:c,name:t,fileURL:n,authorId:o,isPublic:i,permission:s,createdAt:d,updatedAt:d}})).id}}async updateDocument(e,{isPublic:t,permission:r}){const n={updatedAt:Date.now()};void 0!==r&&(n.permission=r),void 0!==t&&(n.isPublic=t);const o=await this.prisma.document.update({data:n,where:{id:e}});return o?c(o):null}async deleteDocument(e){let t=Date.now();const r=await this.prisma.document.update({data:{status:0,updatedAt:t},where:{id:e}});return r?c(r):null}async getDocument(e){const t=await this.prisma.document.findUnique({where:{id:e}});if(1===(null==t?void 0:t.status))return c(t);throw new n.NotFoundException(`collaboration with id ${e} not found!`)}async getDocuments(e,t){const r=(await this.prisma.documentMember.findMany({where:{userId:e},select:{documentId:!0}})).map(({documentId:e})=>e);return(await this.prisma.document.findMany({where:{AND:{status:{gt:0},OR:[{authorId:e},{id:{in:r},permission:{gt:t}}]}},orderBy:{createdAt:"desc"}})).map(c)}async findUsersNotInTheMemberList(e,t){let r=(await this.prisma.documentMember.findMany({where:{documentId:e,userId:{in:t}}})).map(({userId:e})=>e);return t.filter(e=>!r.includes(e))}async addDocumentMembers(e,t,r=!1){let n=Date.now();const o=t.map(({userId:t,isAllowComment:o})=>({userId:t,documentId:e,permission:o?65535:65534,createdAt:n,updatedAt:n,lastReadAt:r?n:void 0}));await this.prisma.documentMember.createMany({data:o});return(await this.prisma.documentMember.findMany({where:{userId:{in:t.map(({userId:e})=>e)},documentId:e}})).map(e=>({id:e.id,userId:e.userId}))}async editDocumentMembers(e,t){let r=Date.now();const n=t.map(({userId:t,isAllowComment:n})=>{const o={permission:n?65535:65534,createdAt:r,updatedAt:r};return this.prisma.documentMember.updateMany({data:o,where:{userId:t,documentId:e}})});await this.prisma.$transaction(n);return(await this.prisma.documentMember.findMany({where:{documentId:e,userId:{in:t.map(e=>e.userId)}}})).map(e=>({id:e.id,userId:e.userId}))}async isDocMember(e,t){return!!await this.prisma.documentMember.findFirst({where:{documentId:e,userId:t}})}async getDocumentMember(e,t){return await this.prisma.documentMember.findFirst({where:{documentId:e,userId:t}})}async updateDocumentMemberLastReadAt(e){let t=Date.now();await this.prisma.documentMember.update({where:{id:e},data:{lastReadAt:t,updatedAt:t}})}async getDocumentMembers(e,t){const r={documentId:e};t.length>0&&(r.userId={in:t});return(await this.prisma.documentMember.findMany({where:r})).map(e=>({user_id:e.userId,permission:e.permission,last_read:String(e.lastReadAt)}))}async deleteDocumentMembers(e,t){const r=await this.prisma.documentMember.findMany({where:{documentId:e,userId:{in:t}}});return 0===r.length?[]:(await this.prisma.documentMember.deleteMany({where:{id:{in:r.map(e=>e.id)}}}),r.map(e=>({id:e.id,userId:e.userId,user_id:e.userId})))}async getAnnotations(e,t,r){if(0===t.length&&"notIn"===r)return[];const n={documentId:e};t.length>0&&Object.assign(n,{annotationId:{[r]:t}});return(await this.prisma.annotation.findMany({where:n})).map(e=>function(e){return{id:e.id||void 0,author_id:e.authorId||void 0,annotation_id:e.annotationId,document_id:e.documentId||void 0,page_number:e.pageNumber,xfdf:e.xfdf||void 0,annot_contents:e.annotContents||void 0,in_reply_to:e.inReplyTo||void 0,created_at:e.createdAt?parseInt(String(e.createdAt)):void 0,updated_at:e.updatedAt?parseInt(String(e.updatedAt)):void 0}}(e))}async addAnnotations(e,t){if(!t||!t[0])return Promise.resolve([]);let r=Date.now();const n=t.map(t=>({xfdf:t.xfdf,pageNumber:t.page_number,inReplyTo:t.in_reply_to,authorId:t.author_id,documentId:e,annotationId:t.annotation_id,createdAt:r,updatedAt:r})),{count:o}=await this.prisma.annotation.createMany({data:n,skipDuplicates:!0});return[{id:o}]}async changeAnnotations(e,t){let r=Date.now();const n=t.map(t=>this.prisma.annotation.updateMany({where:{documentId:e,annotationId:t.annotation_id},data:{xfdf:t.xfdf,pageNumber:t.page_number,inReplyTo:t.in_reply_to,updatedAt:r,authorId:t.author_id}}));await this.prisma.$transaction(n);return(await this.prisma.annotation.findMany({where:{documentId:e,annotationId:{in:t.map(e=>e.annotation_id)}}})).map(e=>({id:e.id}))}async filterDuplicateAnnotations(e,t){let r=t.map(({annotation_id:e})=>e),n=t.map(({page_number:e})=>e);const o=(await this.prisma.annotation.findMany({where:{documentId:e,pageNumber:{in:n},annotationId:{in:r}}})).map(e=>e.annotationId);return t.filter(e=>!o.includes(e.annotation_id))}async deleteAnnotations(e,t){const r=t.map(t=>this.prisma.annotation.deleteMany({where:{documentId:e,annotationId:t.annotation_id,pageNumber:t.page_number}})),n=await this.prisma.$transaction(r);return t.filter((e,t)=>n[t].count>0).map(e=>({id:-1,annotation_id:e.annotation_id,page_number:e.page_number}))}async createInvitation(e,t){let n,o=r(),i=Date.now();t&&(n=i+t);const a=await this.prisma.invitation.create({data:{id:o,documentId:e,expiresAt:n,createdAt:i,updatedAt:i}});return{id:a.id,expiresAt:Number(a.expiresAt.toString())}}async getInvitationById(e){const t=await this.prisma.invitation.findUniqueOrThrow({where:{id:e}});return{id:t.id,expiresAt:Number(t.expiresAt.toString()),collaborationId:t.documentId}}async addYLog(e,t){let r=await this.getLatestYLogs(e);return r?await this.prisma.yLog.update({where:{id:r.id},data:{update:t}}):r=await this.prisma.yLog.create({data:{documentId:e,update:t}}),{id:r.id}}async getYLogs(e){return await this.prisma.yLog.findMany({where:{documentId:e},orderBy:{id:"desc"}})}async getLatestYLogs(e){return await this.prisma.yLog.findFirst({where:{documentId:e},orderBy:{id:"desc"}})}};return l=e([(0,n.Injectable)(),t("design:paramtypes",[a.ConfigService])],l),ee.PrismaService=l,ee}function oe(){if(X)return W;X=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)};Object.defineProperty(W,"__esModule",{value:!0}),W.UserService=void 0;const r=M.default,n=Q,o=ne(),i=P.default,a=72e6,s="custom_secret_key",c=Nt();let d=class{constructor(e){this.db=e,this.logger=new r.Logger("UserService")}async createUser(e){return await this.db.createUser(e)}async getUserByToken(e){if(c.customUserService){let t,n;try{t=await c.customUserService.getUserByToken(e)}catch(e){throw this.logger.error("getUserByToken from custom service error",e),new r.UnauthorizedException(e)}if(!t)throw new r.UnauthorizedException("invalid token");try{n=await this.getOrCreateUser(t)}catch(e){throw this.logger.error("getOrCreateUser from database error",e),new r.HttpException("getOrCreateUser from database error",500)}return{id:n.id}}{const{id:t}=await this.verifyToken(e);return{id:(await this.getUserById(t)).id}}}async getUserById(e){let t=await this.db.getUserById(e);return t&&delete t.password,t}async getOrCreateUserByName(e){let t=await this.db.getUserByName(e);t||(t=await this.db.createAnonymousUser(e));const r=null==t?void 0:t.id;return await this.db.editUserType(r),await this.getToken(r)}async getOrCreateUser(e){const t=e.username;let r;if(e.id)try{r=await this.db.getUserById(e.id)}catch(e){r=null}else r=await this.db.getUserByName(t);return r||await this.createUser({id:e.id,user_name:t,email:e.email,type:n.UserType.PRE_REGISTRATION,status:n.UserStatus.ACTIVE,custom_data:JSON.stringify(e)})}async getToken(e){const t=a,r=s;return{token:i.sign({id:e},r,{expiresIn:t}),expiration:Date.now()+1e3*t,user_id:e}}async verifyToken(e){return new Promise((t,r)=>{i.verify(e,s,(e,n)=>{e&&r(new Error(e.message)),t(n)})})}async logout(e){return null}};return d=e([(0,r.Injectable)(),t("design:paramtypes",[o.PrismaService])],d),W.UserService=d,W}var ie={};Object.defineProperty(ie,"__esModule",{value:!0}),ie.SecurityContext=void 0;const ae=M.default;var se;ie.SecurityContext=(0,ae.createParamDecorator)((e,t)=>{const r=t.switchToHttp().getRequest().user;if(!r)throw new ae.UnauthorizedException;const n={user:r};return e?n[e]:n});var ce={},de={},le=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a};Object.defineProperty(de,"__esModule",{value:!0}),de.TransformInterceptor=void 0;const ue=M.default,me=R.default;let pe=class{intercept(e,t){return t.handle().pipe((0,me.map)(e=>({ret:0,data:e})))}};pe=le([(0,ue.Injectable)()],pe),de.TransformInterceptor=pe;var ye={},Se=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a};Object.defineProperty(ye,"__esModule",{value:!0}),ye.AuthGuard=void 0;const he=M.default;let fe=class{canActivate(e){return!0}};fe=Se([(0,he.Injectable)()],fe),ye.AuthGuard=fe;var ge={},be={};!function(e){var t,r,n;Object.defineProperty(e,"__esModule",{value:!0}),e.ScreenSyncEvent=e.DocumentAction=e.MetaEvent=void 0,(t=e.MetaEvent||(e.MetaEvent={})).HEART="heart",t.HEART_REPLY="heart-reply",t.SUBSCRIBE_DOC="subscribe-doc",t.SUBSCRIBE_DOC_DONE="doc-subscribed",t.UNSUBSCRIBE_DOC="unsubscribe-doc",t.DOC_EVENT_REPLY="doc-event-reply",(r=e.DocumentAction||(e.DocumentAction={})).MEMBER_ONLINE="member-online",r.MEMBER_OFFLINE="member-offline",r.ADD_MEMBERS="add-members",r.EDIT_MEMBERS="edit-members",r.DELETE_MEMBERS="delete-members",r.ADD_ANNOTS="add-annots",r.CHANGE_ANNOTS="change-annots",r.DELETE_ANNOTS="delete-annots",r.DELETE_SHARE="delete-share",r.MOUSE_POINTER_SYNC="mouse-pointer-sync",r.PAGE_MEASURE_SCALE_SYNC="page-measure-scale-sync",r.SYNC_YLOG="sync-ylog",r.SYNC_YLOG_STEP_1="sync-ylog-s1",r.SYNC_YLOG_STEP_2="sync-ylog-s2",(n=e.ScreenSyncEvent||(e.ScreenSyncEvent={})).CREATED="screen-sync-created",n.STOPPED="screen-sync-stopped",n.MEMBER_JOINED="screen-sync-member-joined",n.MEMBER_LEAVE="screen-sync-member-leave",n.SCREENSYNC_DATA="screen-sync-data"}(be);var ve={};Object.defineProperty(ve,"__esModule",{value:!0}),ve.MemberStateRedisService=void 0;const _e=j.default;ve.MemberStateRedisService=class{constructor(e){this.client=(0,_e.createClient)({url:e})}async addOnlineMember(e,t){let r=1;return await this.zcard(e)>0&&(r=await this.getNextScore(e)),await this.zadd(e,r,t+"--$"),!0}async getOnlineMembers(e){const t=await this.zrange(e),r=new Set;return t.forEach(e=>{let t=e.split("--"),n=t[0];t&&n&&2==t.length&&r.add(n)}),r}async removeOnlineMember(e,t){return await this.zrem(e,t+"--$"),!0}zadd(e,t,r){return new Promise((n,o)=>{this.client.zadd(e,t,r,(e,t)=>e?o(e):n(t))})}async zrange(e){return new Promise((t,r)=>{this.client.zrange(e,0,-1,(e,n)=>e?r(e):t(n))})}zcard(e){return new Promise((t,r)=>{this.client.zcard(e,(e,n)=>e?r(e):t(n))})}zrem(e,t){return new Promise((r,n)=>{this.client.zrem(e,t,(e,t)=>e?n(e):r(t))})}zrangeWithscores(e,t,r,n){return new Promise((o,i)=>{this.client.zrange(e,t,r,n,(e,t)=>e?i(e):o(t))})}del(e){return new Promise((t,r)=>{this.client.del(e,(e,n)=>e?r(e):t(n))})}async getNextScore(e){let t=1;if(await this.zcard(e)>0){t=+(await this.zrangeWithscores(e,-1,-1,"WITHSCORES"))[1]+1}return t}};var we={};Object.defineProperty(we,"__esModule",{value:!0}),we.MessageQueueRedis=void 0;const Ie=j.default,Ee=M.default;we.MessageQueueRedis=class{constructor(e,t){this.logger=new Ee.Logger("MessageQueueRedis"),this.ready=!1,this.callbacks={},this.url=e,this.subscriber=(0,Ie.createClient)({url:e}),this.publisher=(0,Ie.createClient)({url:e}),this.serverId=t,this.connect()}connect(){this.subscriber.on("ready",()=>{this.logger.log("connect to redis successfully, url: ",this.url),this.ready=!0}),this.subscriber.on("subscribe",(e,t)=>{this.logger.log("server ["+this.serverId+"] subscribed to "+e+","+t+" total subscriptions")}),this.subscriber.on("message",(e,t)=>{this.callbacks[e]&&this.callbacks[e](t)}),this.subscriber.on("error",e=>{this.logger.log("Redis error",e)})}subscribe(e,t){this.callbacks[e]=e=>{try{const r=JSON.parse(e),n=r.meta.serverId;this.serverId!=n&&t(r)}catch(e){}},this.subscriber.subscribe(e)}publish(e,t){this.ready?this.publisher.publish(e,t,(e,t)=>{e&&this.logger.log("publish ~ err, reply",e,t)}):this.logger.log("client not ready")}};var Oe={};Object.defineProperty(Oe,"__esModule",{value:!0}),Oe.convertMessage=void 0;const Ce=be;Oe.convertMessage=function(e){const t=e.data;return e.type===Ce.DocumentAction.MEMBER_OFFLINE?{type:"MEMBER_OFFLINE",payload:{memberId:t.user_id},meta:{collaborationId:t.docId,userId:t.user_id}}:e.type===Ce.DocumentAction.MEMBER_ONLINE?{type:"MEMBER_ONLINE",payload:{memberId:t.user_id},meta:{collaborationId:t.docId,userId:t.user_id}}:e.type===Ce.DocumentAction.ADD_ANNOTS?{type:"COLLAB_ANNOT_ADDED",payload:{annots:t.annots},meta:{collaborationId:e.data.docId,userId:e.data.user_id}}:e.type===Ce.DocumentAction.CHANGE_ANNOTS?{type:"COLLAB_ANNOT_UPDATED",payload:{annots:t.annots},meta:{collaborationId:e.data.docId,userId:e.data.user_id}}:e.type===Ce.DocumentAction.DELETE_ANNOTS?{type:"COLLAB_ANNOT_REMOVED",payload:{annots:t.annots},meta:{collaborationId:e.data.docId,userId:e.data.user_id}}:e.type===Ce.DocumentAction.ADD_MEMBERS?{type:"MEMBER_ADDED",payload:{memberIds:t.memberIds},meta:{collaborationId:t.docId,userId:t.user_id}}:e.type===Ce.DocumentAction.DELETE_MEMBERS?{type:"MEMBER_REMOVED",payload:{memberIds:t.members},meta:{collaborationId:t.docId,userId:t.user_id}}:e.type===Ce.DocumentAction.EDIT_MEMBERS?{type:"MEMBER_UPDATED",payload:{memberIds:t.members},meta:{collaborationId:t.docId,userId:t.user_id}}:e.type===Ce.DocumentAction.DELETE_SHARE?{type:"COLLAB_REMOVED",payload:{collaborationId:t.docId},meta:{collaborationId:t.docId,userId:t.user_id}}:void 0};var Me={};Object.defineProperty(Me,"__esModule",{value:!0}),Me.encode=Me.decode=void 0;const De=U.default,Ae=L.default,Pe=be;function Re(e,t){const r=De.createEncoder();return De.writeUint8(r,e),De.writeVarUint8Array(r,t),De.toUint8Array(r)}Me.decode=function(e){return e instanceof Buffer?function(e){const t=Ae.createDecoder(e),r=Ae.readUint8(t),n=Ae.readVarUint8Array(t);if(0===r)return{event:"sync",data:{type:"sync-ylog",ylog:n}};if(1===r)return{event:"sync",data:{type:"sync-ylog-s1",ylog:n}};if(2===r)return{event:"sync",data:{type:"sync-ylog-s2",ylog:n}}}(e):JSON.parse(e)},Me.encode=function(e){return e.type===Pe.DocumentAction.SYNC_YLOG?Re(0,e.data.ylog):e.type===Pe.DocumentAction.SYNC_YLOG_STEP_1?Re(1,e.data.ylog):e.type===Pe.DocumentAction.SYNC_YLOG_STEP_2?Re(2,e.data.ylog):JSON.stringify(e)};var Ne,Te={};function je(){if(Ne)return ge;Ne=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a};Object.defineProperty(ge,"__esModule",{value:!0}),ge.CollaborationService=void 0;const t=M.default,r=Nt(),n=be,o=N.default,i=T.default,a=ve,s=we,c=Oe,d=Me,l=Te,u=i.env.REDIS_URL||"redis://127.0.0.1:6379";class m extends o.Doc{constructor(e){super({gc:!0}),this.collaborationId=e}}const p={};let y=class{constructor(){this.logger=new t.Logger("CollaborationService"),this.clients={},this.memberIdsInScreenSync=new Set,this.mousePointerStates={},this.addYLog=null,this.getLatestYLog=null,this.mq=r.cluster&&(r.cluster.messageQueue||new s.MessageQueueRedis(u,r.cluster.serverId)),this.memberStateService=r.cluster&&(r.cluster.memberStateService||new a.MemberStateRedisService(u)),this.onYDocUpdate=(e,t,r)=>{var o,i;const a=r.collaborationId;this.logger.log("start broadcasting ydoc update to all clients");const s={type:n.DocumentAction.SYNC_YLOG,data:{docId:a,ylog:e},meta:{collaborationId:a,serverId:null===(o=this.mq)||void 0===o?void 0:o.serverId}};this.getAllConnectedClients(r.collaborationId).forEach(e=>{e!==t&&e.send(d.encode(s),t=>{t&&(this.logger.log(t),e.close(),this.removeClient(a,e))})}),"remote-server"!==t&&(this.logger.log("send update to remote servers"),null===(i=this.mq)||void 0===i||i.publish("events",JSON.stringify(s)))}}getAllConnectedClients(e){return this.clients[e]||[]}async getSharedDoc(e,t=!0){return!p[e]&&t&&(p[e]=this.createSharedDoc(e)),p[e]}async createSharedDoc(e){this.logger.debug(`no shared doc with id ${e}, start creating`);const t=await this.getLatestYLog(e),r=new m(e);return t&&(o.applyUpdate(r,t),this.logger.debug(`restored from db with size: ${t.length} `)),await this.syncWithClusterServers(e,r),r.on("update",this.onYDocUpdate),this.logger.debug(`shared doc with id ${e} created`),r}async syncWithClusterServers(e,t){var r,i;this.logger.log("send sync step 1 to remote servers");const a=o.encodeStateVector(t),s={type:n.DocumentAction.SYNC_YLOG_STEP_1,data:{docId:e,ylog:a}};s.meta={collaborationId:e,serverId:null===(r=this.mq)||void 0===r?void 0:r.serverId},null===(i=this.mq)||void 0===i||i.publish("events",JSON.stringify(s))}destroySharedDoc(e){let t=p[e];t&&t.then(t=>{this.addYLog(e,o.encodeStateAsUpdate(t)),t.destroy(),delete p[e]})}setupHeartCheck(e,t){let r=!0;const{uid:n}=t._collab_meta,o=setInterval(()=>{r||(this.logger.log(`pong not received, closing connection of client: ${n}`),t.close(),this.removeClient(e,t));try{this.logger.log(`sending ping to client: ${n}`),r=!1,t.ping()}catch(r){this.logger.log("ping error",r),t.close(),this.removeClient(e,t)}},3e4);return t.on("pong",()=>{r=!0,this.logger.log(`received pong from client: ${n}`)}),o}async addClient(e,t){this.clients[e]||(this.clients[e]=[]),this.clients[e].push(t),t.heartCheckInterval=this.setupHeartCheck(e,t);const r=await this.getSharedDoc(e),i=o.encodeStateVector(r),{uid:a,sessionId:s}=t._collab_meta;this.memberStateService&&await this.memberStateService.addOnlineMember(e,a);const c={type:n.DocumentAction.SYNC_YLOG_STEP_1,data:{docId:e,ylog:i}};t.send(d.encode(c),e=>{e&&t.close()})}async handleSyncUpdate(e,t,r){const n=r.ylog;if(!n)return void this.logger.error("no ylog in sync update");const i=n,a=await this.getSharedDoc(e,"remote-server"!==t);a&&a.collaborationId===e&&o.applyUpdate(a,i,t)}async handleSyncStep1(e,t,r){const i=r.ylog,a=await this.getSharedDoc(e);if(a.collaborationId!==e)return;const s=i,c=o.encodeStateAsUpdate(a,s),d={type:n.DocumentAction.SYNC_YLOG_STEP_2,data:{docId:e,ylog:c}};return this.logger.log(`send sync step 2 (incremental update) to client with size:: ${c.length}`),d}async handleSyncStep1FromRemoteServer(e,t,r){var i,a;const s=r.ylog,c=await this.getSharedDoc(e,!1);if(!c||c.collaborationId!==e)return;if(!s)return void this.logger.error("no ylog present");const d=o.encodeStateAsUpdate(c,s),u={type:n.DocumentAction.SYNC_YLOG_STEP_2,data:{docId:e,ylog:d},meta:{collaborationId:e,serverId:null===(i=this.mq)||void 0===i?void 0:i.serverId}};this.logger.log(`send sync step 2 (incremental update) to remote server with size:: ${d.length}`),null===(a=this.mq)||void 0===a||a.publish(l.CLUSTER_EVENT_CHANNEL,JSON.stringify(u))}async handleSyncStep2(e,t,r){const n=r.ylog,i=await this.getSharedDoc(e,"remote-server"!==t);i&&o.applyUpdate(i,n,t)}removeClient(e,t){if(this.clients[e]){t.heartCheckInterval&&clearInterval(t.heartCheckInterval),this.clients[e]=this.clients[e].filter(e=>e!==t);const{uid:r,sessionId:n}=t._collab_meta;this.memberStateService&&this.memberStateService.removeOnlineMember(e,r),this.logger.log(`clients remaining: collaborationId ${e}, [${this.clients[e].map(e=>e._collab_meta.uid)}]`),0===this.clients[e].length&&(this.logger.log(`no more clients remaining for collaboration: ${e}, starting to destroy`),this.clients[e]=null,this.destroySharedDoc(e))}}getMousePointerStates(e,t){return this.mousePointerStates[e]||{}}addOrUpdateMousePointerState(e,t,r,n){this.mousePointerStates[e]||(this.mousePointerStates[e]={}),this.mousePointerStates[e][r]=n}deleteMousePointerState(e,t,r){r?this.mousePointerStates[e]&&this.mousePointerStates[e][r]&&delete this.mousePointerStates[e][r]:delete this.mousePointerStates[e]}async getOnlineMembers(e){if(this.memberStateService){const t=await this.memberStateService.getOnlineMembers(e);return this.logger.log("get online userIds from member state service",t),Array.from(t).map(e=>e)}return this.clients[e]?this.clients[e].map(e=>e._collab_meta.uid):[]}broadcastDocDataToClients(e,t,o,i){var a,s;if(r.msgHandler){const e=(0,c.convertMessage)(o);(0,r.msgHandler)(e)}this.getAllConnectedClients(e).filter(e=>!i||i.indexOf(e._collab_meta.uid)>-1).forEach(e=>{e.send(JSON.stringify(o),e=>{})}),o.type!==n.ScreenSyncEvent.CREATED&&o.type!==n.ScreenSyncEvent.STOPPED&&o.type!==n.ScreenSyncEvent.SCREENSYNC_DATA&&o.type!==n.ScreenSyncEvent.MEMBER_JOINED&&o.type!==n.ScreenSyncEvent.MEMBER_LEAVE&&(o.meta={collaborationId:e,serverId:null===(a=this.mq)||void 0===a?void 0:a.serverId},null===(s=this.mq)||void 0===s||s.publish(l.CLUSTER_EVENT_CHANNEL,JSON.stringify(o)))}broadcastToLocalClients(e){const{collaborationId:t,serverId:r}=e.meta,o=this.getAllConnectedClients(t);if(e.type===n.DocumentAction.SYNC_YLOG){const n=Buffer.from(Object.values(e.data.ylog));return this.logger.log(`received sync ylog from remote server: ${r} with size: ${n.length}`),void this.handleSyncUpdate(t,"remote-server",{ylog:n})}if(e.type===n.DocumentAction.SYNC_YLOG_STEP_1){const r=Buffer.from(Object.values(e.data.ylog));return this.logger.log(`received sync step 1 from remote server: ${e.meta.serverId} with size: ${r.length}`),void this.handleSyncStep1FromRemoteServer(t,"remote-server",{ylog:r})}if(e.type===n.DocumentAction.SYNC_YLOG_STEP_2){const t=Buffer.from(Object.values(e.data.ylog));return this.logger.log(`received sync step 2 from remote server: ${e.meta.serverId} with size: ${t.length}`),void this.handleSyncStep2(e.meta.collaborationId,"remote-server",{ylog:t})}o.forEach(t=>{t.send(JSON.stringify(e),e=>{})})}async removeMemberFromScreenSync(e){return this.memberIdsInScreenSync.delete(e)}async addMemberToScreenSync(e){return this.memberIdsInScreenSync.add(e)}async isInScreenSync(e){return this.memberIdsInScreenSync.has(e)}};return y=e([(0,t.Injectable)()],y),ge.CollaborationService=y,ge}Object.defineProperty(Te,"__esModule",{value:!0}),Te.CLUSTER_EVENT_CHANNEL=void 0,Te.CLUSTER_EVENT_CHANNEL="events";var Ue,Le={};var Be={},xe=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},Fe=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)};Object.defineProperty(Be,"__esModule",{value:!0}),Be.AllExceptionsFilter=void 0;const Ye=M.default,ke=E.default,qe=M.default;let $e=class{constructor(e){this.httpAdapterHost=e,this.logger=new qe.Logger("AllExceptionsFilter")}catch(e,t){const{httpAdapter:r}=this.httpAdapterHost,n=t.switchToHttp();this.logger.error(e);let o=Ye.HttpStatus.INTERNAL_SERVER_ERROR,i="Internal Server Error";e instanceof Ye.HttpException&&(o=e.getStatus(),i=e.message);const a={ret:o,message:i};r.reply(n.getResponse(),a,o)}};var Ge,He;function Je(){if(Ge)return ce;Ge=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a};Object.defineProperty(ce,"__esModule",{value:!0}),ce.CommonModule=void 0;const t=M.default,r=ne(),n=E.default,o=de,i=ye,a=je(),s=function(){if(Ue)return Le;Ue=1;var e,t=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a};Object.defineProperty(Le,"__esModule",{value:!0}),Le.ConfigModule=void 0;const r=M.default,n=re();let o=e=class{static register(t){return{module:e,providers:[n.ConfigService],exports:[n.ConfigService]}}};return o=e=t([(0,r.Module)({})],o),Le.ConfigModule=o,Le}(),c=Be,d=re();let l=class{};return l=e([(0,t.Global)(),(0,t.Module)({providers:[r.PrismaService,a.CollaborationService,d.ConfigService,{provide:n.APP_INTERCEPTOR,useClass:o.TransformInterceptor},{provide:n.APP_GUARD,useClass:i.AuthGuard},{provide:n.APP_FILTER,useClass:c.AllExceptionsFilter}],imports:[s.ConfigModule.register({})],exports:[r.PrismaService,a.CollaborationService,d.ConfigService]})],l),ce.CommonModule=l,ce}function Ve(){if(He)return V;He=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a};Object.defineProperty(V,"__esModule",{value:!0}),V.UserModule=void 0;const t=M.default,r=function(){if(se)return z;se=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)},r=G&&G.__param||function(e,t){return function(r,n){t(r,n,e)}};Object.defineProperty(z,"__esModule",{value:!0}),z.UserController=void 0;const n=M.default,o=oe(),i=ie;let a=class{constructor(e){this.userService=e}async getUser(e){const t=e.user.id;return await this.userService.getUserById(t)}async loginAnonymously(e){return await this.userService.getOrCreateUserByName(e.user_name)}async auth(e){const{id:t}=await this.userService.verifyToken(e),r=await this.userService.getUserById(t);return{id:r.id.toString(),username:r.user_name}}async loginOut(e){return await this.userService.logout(e)}async getVersion(){return{version:"ea7055b0@release/1_4_0"}}};return e([(0,n.Get)("user"),r(0,(0,i.SecurityContext)()),t("design:type",Function),t("design:paramtypes",[Object]),t("design:returntype",Promise)],a.prototype,"getUser",null),e([(0,n.Post)("user/login-anonymously"),r(0,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object]),t("design:returntype",Promise)],a.prototype,"loginAnonymously",null),e([(0,n.Post)("user/auth"),r(0,(0,n.Query)("token")),t("design:type",Function),t("design:paramtypes",[String]),t("design:returntype",Promise)],a.prototype,"auth",null),e([(0,n.Get)("/user/login-out"),r(0,(0,n.Query)("token")),t("design:type",Function),t("design:paramtypes",[String]),t("design:returntype",Promise)],a.prototype,"loginOut",null),e([(0,n.Get)("version"),t("design:type",Function),t("design:paramtypes",[]),t("design:returntype",Promise)],a.prototype,"getVersion",null),a=e([(0,n.Controller)("api"),t("design:paramtypes",[o.UserService])],a),z.UserController=a,z}(),n=oe(),o=Je();let i=class{};return i=e([(0,t.Module)({controllers:[r.UserController],providers:[n.UserService],imports:[o.CommonModule],exports:[n.UserService]})],i),V.UserModule=i,V}$e=xe([(0,Ye.Catch)(),Fe("design:paramtypes",[ke.HttpAdapterHost])],$e),Be.AllExceptionsFilter=$e;var ze={},We={},Qe={},Ze={},Ke={};!function(e){var t,r;Object.defineProperty(e,"__esModule",{value:!0}),e.DOC_ACTION_PERMISSION=e.DOC_ACCESS_PERMISSION=e.USER_ACCESS_TYPE=e.DOC_ALL_PERMISSIONS=void 0,e.DOC_ALL_PERMISSIONS=65535,e.USER_ACCESS_TYPE={OWNER:"owner",MEMBER:"member",UNJOINED:"unjoined"},(t=e.DOC_ACCESS_PERMISSION||(e.DOC_ACCESS_PERMISSION={}))[t.allowNone=0]="allowNone",t[t.allowAnyone=65280]="allowAnyone",t[t.allowUserJoin=65024]="allowUserJoin",t[t.allowMembers=64512]="allowMembers",(r=e.DOC_ACTION_PERMISSION||(e.DOC_ACTION_PERMISSION={}))[r.allowComment=255]="allowComment",r[r.onlyView=254]="onlyView"}(Ke),Object.defineProperty(Ze,"__esModule",{value:!0});const Xe=Ke;Ze.default=class{constructor(e,t){let r="number"==typeof e?e:parseInt(e);this.permission=-1===r?Xe.DOC_ALL_PERMISSIONS:r,this.userAccessType=t}isOwner(){return"owner"===this.userAccessType}isMember(){return"member"===this.userAccessType}isAllowComment(){return(255&this.permission)===Xe.DOC_ACTION_PERMISSION.allowComment}isAllowAnyone(){return(65280&this.permission)===Xe.DOC_ACCESS_PERMISSION.allowAnyone}isAllowMembers(){return(65280&this.permission)===Xe.DOC_ACCESS_PERMISSION.allowMembers}},function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.USER_ACCESS_TYPE=e.DOC_ALL_PERMISSIONS=e.DOC_ACTION_PERMISSION=e.DOC_ACCESS_PERMISSION=e.Permission=void 0;const t=Ze;e.Permission=t.default;const r=Ke;Object.defineProperty(e,"DOC_ACCESS_PERMISSION",{enumerable:!0,get:function(){return r.DOC_ACCESS_PERMISSION}}),Object.defineProperty(e,"DOC_ACTION_PERMISSION",{enumerable:!0,get:function(){return r.DOC_ACTION_PERMISSION}}),Object.defineProperty(e,"DOC_ALL_PERMISSIONS",{enumerable:!0,get:function(){return r.DOC_ALL_PERMISSIONS}}),Object.defineProperty(e,"USER_ACCESS_TYPE",{enumerable:!0,get:function(){return r.USER_ACCESS_TYPE}})}(Qe);var et={};Object.defineProperty(et,"__esModule",{value:!0}),et.validateEmail=void 0,et.validateEmail=function(e){return/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/.test(e)};var tt,rt,nt,ot={};function it(){if(tt)return ot;tt=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)};Object.defineProperty(ot,"__esModule",{value:!0}),ot.PermService=void 0;const r=M.default,n=ne(),o=Nt(),i=Qe;let a=class{constructor(e){this.db=e,this.logger=new r.Logger("PermService")}async getPermission(){}async checkUserPermission(e,t,r,n){if("function"==typeof(null===o.customUserService||void 0===o.customUserService?void 0:o.customUserService.checkUserPermission)){this.logger.debug(`start custom permission check, userId: ${e}, resourceType: ${t}, operation: ${r}, resourceId: ${n}`);const i=await o.customUserService.checkUserPermission(e,t,r,n);return this.logger.debug(`custom permission check result: ${i}`),null===i?await this.defaultPermissionCheck(e,t,r,n):i}return await this.defaultPermissionCheck(e,t,r,n)}async defaultPermissionCheck(e,t,r,n){if("collaboration"===t){if("comment"===r)return await this._isAllowComment(e,n);if("join"===r)return await this._canJoinCollaboration(e,n);if("create"===r)return await this._canCreateCollaboration(e);if("delete"===r)return await this._canDeleteCollaboration(e,n);if("update"===r)return await this._canUpdateCollaboration(e,n)}return!0}async canJoinCollaboration(e,t){return await this.checkUserPermission(e,"collaboration","join",t)}async _canJoinCollaboration(e,t){let r;r="string"==typeof t?await this.db.getDocument(t):t;const{author_id:n,permission:o}=r;if(n===e)return!0;return!!new i.Permission(o||-1).isAllowAnyone()||await this.isDocMember(e,r.id)}async isAllowComment(e,t){return await this.checkUserPermission(e,"collaboration","comment",t)}async _isAllowComment(e,t){var r;const n=await this.db.getDocument(t);if(n.permission,n.author_id===e)return!0;const o=await this.db.getDocumentMember(n.id,e);if(o){return(255&(null!==(r=null==o?void 0:o.permission)&&void 0!==r?r:n.permission))===i.DOC_ACTION_PERMISSION.allowComment}return(255&n.permission)===i.DOC_ACTION_PERMISSION.allowComment}fixDocPermission(e,t){if(void 0!==e){const r=e?i.DOC_ACCESS_PERMISSION.allowAnyone:i.DOC_ACCESS_PERMISSION.allowMembers,n=t?function(e){return 255&e}(t):i.DOC_ACTION_PERMISSION.allowComment;return r+n}return null!=t?t:-1}async isDocOwner(e,t){return(await this.db.getDocument(t)).author_id===e}async isDocMember(e,t){return!!await this.db.getDocumentMember(t,e)}async computeUserAccessType(e,t){if(t===e.author_id)return i.USER_ACCESS_TYPE.OWNER;return await this.isDocMember(t,e.id)?i.USER_ACCESS_TYPE.MEMBER:i.USER_ACCESS_TYPE.UNJOINED}async canCreateCollaboration(e){return await this.checkUserPermission(e,"collaboration","create")}async _canCreateCollaboration(e){return!0}async canUpdateCollaboration({author_id:e,id:t},r){return await this.checkUserPermission(r,"collaboration","update",t)}async _canUpdateCollaboration(e,t){return await this.isDocOwner(e,t)}async canDeleteCollaboration({author_id:e,id:t},r){return await this.checkUserPermission(r,"collaboration","delete",t)}async _canDeleteCollaboration(e,t){return await this.isDocOwner(e,t)}async canDeleteMember(e,t){return await this._canDeleteMember(e,t)}async _canDeleteMember(e,t){return await this.isDocOwner(e,t)}};return a=e([(0,r.Injectable)(),t("design:paramtypes",[n.PrismaService])],a),ot.PermService=a,ot}function at(){if(rt)return We;rt=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)};Object.defineProperty(We,"__esModule",{value:!0}),We.DocService=void 0;const r=M.default,n=ne(),o=Qe,i=je(),a=be,s=et,c=it();let d=class{constructor(e,t,n){this.db=e,this.collaborationService=t,this.permService=n,this.logger=new r.Logger("DocService")}async createCollaboration(e){const{fileUrl:t,isDocPublic:r,docName:n,ownerId:o}=e;return await this.createDocument({file_url:t,is_public:r,author_id:o,name:n})}async createDocument(e){if(!e.author_id)throw new r.HttpException("Author id is required",r.HttpStatus.BAD_REQUEST);if(!await this.permService.canCreateCollaboration(e.author_id))throw new r.ForbiddenException("The user is not allowed to create a collaboration.");e.permission=this.permService.fixDocPermission(e.is_public,e.permission);const{id:t}=await this.db.createDocument(e);return await this.addDocumentMembers(t,[{userId:e.author_id,isAllowComment:!0}],!0),{id:t}}async getAllDocuments(e){const t=o.DOC_ACCESS_PERMISSION.allowMembers,r=await this.db.getDocuments(e,t);for(const t of r)t.access=await this.permService.computeUserAccessType(t,e);return r}async getDocument(e,{userId:t}){const n=await this.db.getDocument(e);let i,a,s=await this.permService.computeUserAccessType(n,t);if(i=s===o.USER_ACCESS_TYPE.OWNER||await this.permService.canJoinCollaboration(t,e),!i)throw new r.ForbiddenException("The user is not allowed to join the collaboration.");s===o.USER_ACCESS_TYPE.UNJOINED?(a=await this.addDocumentMember(e,t),s=o.USER_ACCESS_TYPE.MEMBER):a=await this.updateDocumentMemberPermission(e,t);const c=65280&n.permission;return n.is_public=c===o.DOC_ACCESS_PERMISSION.allowAnyone,n.access=s,n.permission=(65280&n.permission)+(a?o.DOC_ACTION_PERMISSION.allowComment:o.DOC_ACTION_PERMISSION.onlyView),n}async updateDocumentMemberLastReadAt(e,t){const r=await this.db.getDocumentMember(e,t);this.logger.debug("starting to update DocumentMember LastReadAt %s, %s",e,t),r?await this.db.updateDocumentMemberLastReadAt(r.id):this.logger.error("no doc member found for docId: %s, userId: %s",e,t)}async updateDocumentMemberPermission(e,t){if(await this.db.getDocumentMember(e,t)){const r=await this.permService.isAllowComment(t,e);return await this.db.editDocumentMembers(e,[{userId:t,isAllowComment:r}]),r}return!0}async editDocument(e,t,{is_public:n,permission:o}){const i=await this.db.getDocument(e);if(!await this.permService.canUpdateCollaboration(i,t))throw new r.ForbiddenException("The user is not allowed to edit the collaboration.");let a=this.permService.fixDocPermission(n,null!=o?o:i.permission);return this.db.updateDocument(e,{isPublic:n,permission:a})}async deleteDocument(e,t,n){const o=await this.db.getDocument(e);if(!await this.permService.canDeleteCollaboration(o,t))throw new r.ForbiddenException("The user is not allowed to delete the collaboration.");const i=await this.db.deleteDocument(e);return this.collaborationService.broadcastDocDataToClients(e,n,{type:a.DocumentAction.DELETE_SHARE,data:{docId:e,user_id:t,session_id:n}}),i}async addDocumentMember(e,t){const r=await this.permService.isAllowComment(t,e);return await this.addDocumentMembers(e,[{userId:t,isAllowComment:r}],!0),r}async addDocumentMembers(e,t,r=!1){const n=await this.db.findUsersNotInTheMemberList(e,t.map(({userId:e})=>e));if(!n[0])return[];const o=t.filter(e=>n.indexOf(e.userId)>-1);return this.collaborationService.broadcastDocDataToClients(e,null,{type:a.DocumentAction.ADD_MEMBERS,data:{memberIds:o,docId:e}}),this.db.addDocumentMembers(e,o,r)}async addDocMembers(e,t,n,o,i){if(!((await this.db.getDocument(e)).author_id===t))throw new r.ForbiddenException("The user is not allowed to add members to the collaboration.");const a={},c={};function d(e,t){return void 0!==a[String(t)]?a[String(t)]:void 0===c[e]||c[e]}n.forEach(({email:e,isAllowComment:t})=>{if(!(0,s.validateEmail)(e))throw new r.BadRequestException("Invalid Email format.");a[e]=t}),o.forEach(({id:e,isAllowComment:t})=>{c[e]=t});const l=(await this.prepareMembers(n,o)).map(({id:e,email:t})=>({userId:e,isAllowComment:d(e,t)}));return await this.addDocumentMembers(e,l)}async prepareMembers(e,t){const r=e.map(({email:e})=>e),n=t.map(({id:e})=>e),o=[];if(e[0]){const e=(await this.db.getUsersByEmails(r)).map(({user_name:e,email:t,id:r})=>(r&&o.push({id:r,email:t?String(t):null}),e)),t=r.filter(t=>!e.includes(t));if(t[0]){(await this.db.createUsersByEmails(t)).map(({id:e,email:t})=>{o.push({id:e,email:t})})}}if(t[0]){(await this.db.getUsersByIdList(n)).forEach(({id:e,email:t})=>{e&&o.push({id:e,email:t?String(t):null})})}return o}async editDocMembers(e,t,n,o,i){for(const t of o){if(!await this.permService.isDocMember(t.id,e))throw new r.ForbiddenException("The user is not a collaboration member")}if(!((await this.db.getDocument(e)).author_id===t))throw new r.ForbiddenException("The user is not allowed to edit the collaboration members.");const s=await this.db.editDocumentMembers(e,o.map(e=>({userId:e.id,isAllowComment:e.isAllowComment})));return this.collaborationService.broadcastDocDataToClients(e,i,{type:a.DocumentAction.EDIT_MEMBERS,data:{docId:e,user_id:t,session_id:i,members:o.map(({id:e})=>e)}}),s}async getDocMembers(e,t,r){const n=await this.db.getDocumentMembers(e,r),o={},i={},a=n.map(({user_id:e,permission:t,last_read:r})=>(o[e]=t,i[e]=r,e)),s=await this.db.getUsersByIdList(a);for(const e of s){const t=o[e.id],r=i[e.id];e.isAllowComment=!(255&~t),e.last_read=r,e.isInScreenSync=await this.collaborationService.isInScreenSync(e.id)}return s.sort(function(e,t){const r=e.created_at||0,n=t.created_at||0;return r<n?1:r>n?-1:0})}async deleteDocMembers(e,t,n,o){const i=await this.permService.canDeleteMember(t,e),s=1===n.length&&n[0]===t;if(!i&&!s)throw new r.ForbiddenException("The user is not allowed to delete members from the collaboration.");const c=await this.db.deleteDocumentMembers(e,n);if(0===c.length)throw new r.HttpException("The user is not a collaboration member",r.HttpStatus.BAD_REQUEST);return this.collaborationService.broadcastDocDataToClients(e,o,{type:a.DocumentAction.DELETE_MEMBERS,data:{docId:e,user_id:t,session_id:o,members:n}}),c}async getOnlineMembers(e,t){const r=await this.collaborationService.getOnlineMembers(e);return 0===r.length?[]:await this.getDocMembers(e,t,r)}async createInvitation(e,t,r){const n=await this.db.getDocument(e);return await this.db.createInvitation(n.id,r)}async getDocIdByInvitation(e,t){const r=await this.db.getInvitationById(e),n=Date.now();if(Number(r.expiresAt)<n)throw new Error("Invitation has expired");return{id:(await this.db.getDocument(r.collaborationId)).id}}async addYLog(e,t){return await this.db.addYLog(e,t)}async getYLogs(e){return await this.db.getYLogs(e)}async getLatestYLogs(e){return await this.db.getLatestYLogs(e)}};return d=e([(0,r.Injectable)(),t("design:paramtypes",[n.PrismaService,i.CollaborationService,c.PermService])],d),We.DocService=d,We}var st,ct={};var dt,lt={},ut={};var mt,pt,yt,St={},ht={};function ft(){if(mt)return ht;mt=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)};Object.defineProperty(ht,"__esModule",{value:!0}),ht.AnnotService=void 0;const r=M.default,n=ne(),o=Qe,i=je(),a=be,s=at(),c=it();let d=class{constructor(e,t,n,o){this.db=e,this.collaborationService=t,this.docService=n,this.permService=o,this.logger=new r.Logger("AnnotService")}async getAnnotations(e,t,n,o){if(!await this.canReadDocument(e,t))throw new r.ForbiddenException("DOC_RESTRICT_ACCESS");return await this.db.getAnnotations(e,n,o)}async addAnnotations(e,t,n,o,i){if(!n||0===n.length)return[];if(!await this.canWriteDocument(e,t))throw new r.ForbiddenException("DOC_RESTRICT_ACCESS");n.forEach(e=>{e.author_id=t});const s=await this.db.filterDuplicateAnnotations(e,n);if(!s[0])return[];await this.db.addAnnotations(e,s);const c=s.map(({annotation_id:e,page_number:t})=>({annotation_id:e,page_number:t}));return o||this.collaborationService.broadcastDocDataToClients(e,i,{type:a.DocumentAction.ADD_ANNOTS,data:{docId:e,user_id:t,session_id:i,annots:s.map(({annotation_id:e,page_number:t,xfdf:r})=>({annotation_id:e,page_number:t,annotJSON:JSON.parse(r)}))}}),c}async changeAnnotations(e,t,n,o){if(!n||0===n.length)throw new r.ForbiddenException("PARAMS_ERROR");if(!await this.canWriteDocument(e,t))throw new r.ForbiddenException("DOC_RESTRICT_ACCESS");const i=await this.db.changeAnnotations(e,n);return this.collaborationService.broadcastDocDataToClients(e,o,{type:a.DocumentAction.CHANGE_ANNOTS,data:{docId:e,user_id:t,session_id:o,annots:n.map(({annotation_id:e,page_number:t,xfdf:r})=>({annotation_id:e,page_number:t,annotJSON:JSON.parse(r)}))}}),i}async deleteAnnotations(e,t,n,o){if(!n||0===n.length)throw new r.ForbiddenException("PARAMS_ERROR");if(!await this.canWriteDocument(e,t))throw new r.ForbiddenException("DOC_RESTRICT_ACCESS");const i=await this.db.deleteAnnotations(e,n);return this.collaborationService.broadcastDocDataToClients(e,o,{type:a.DocumentAction.DELETE_ANNOTS,data:{docId:e,user_id:t,session_id:o,annots:n.map(({annotation_id:e,page_number:t})=>({annotation_id:e,page_number:t}))}}),i}async canReadDocument(e,t){return await this.permService.canJoinCollaboration(t,e)}async canWriteDocument(e,t){const r=await this.docService.getDocument(e,{userId:t});let n=!1;return r.access,o.USER_ACCESS_TYPE.UNJOINED,r.access===o.USER_ACCESS_TYPE.OWNER&&(n=!0),r.access===o.USER_ACCESS_TYPE.MEMBER&&(n=!0),n}};return d=e([(0,r.Injectable)(),t("design:paramtypes",[n.PrismaService,i.CollaborationService,s.DocService,c.PermService])],d),ht.AnnotService=d,ht}function gt(){if(yt)return lt;yt=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a};Object.defineProperty(lt,"__esModule",{value:!0}),lt.DocModule=void 0;const t=M.default,r=function(){if(dt)return ut;dt=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)},r=G&&G.__param||function(e,t){return function(r,n){t(r,n,e)}};Object.defineProperty(ut,"__esModule",{value:!0}),ut.DocController=void 0;const n=M.default,o=at(),i=ie;let a=class{constructor(e){this.docService=e}async create(e,t){return t.author_id=e.user.id,await this.docService.createDocument(t)}async list(e){let t=e.user.id;return await this.docService.getAllDocuments(t)}async detail(e,t){const r=e.user.id,n=await this.docService.getDocument(t,{userId:r});return await this.docService.updateDocumentMemberLastReadAt(t,r),n}async update(e,t,r){const n=e.user.id;return await this.docService.editDocument(t,n,r)}async delete(e,t,r){const n=e.user.id;return await this.docService.deleteDocument(r,n,t)}async addMembers(e,t,r,n){const o=e.user.id,{members:i,emails:a}=n;return await this.docService.addDocMembers(t,o,a,i,r)}async editMembers(e,t,r,n){const o=e.user.id,{members:i,emails:a}=n;return await this.docService.editDocMembers(t,o,a,i,r)}async getAllMembers(e,t){const r=e.user.id;return await this.docService.getDocMembers(t,r,[])}async getMembersByIds(e,t,r){const n=e.user.id,{members:o}=t;return await this.docService.getDocMembers(r,n,o.map(e=>e)||[])}async getOnlineMembers(e,t){const r=e.user.id;return await this.docService.getOnlineMembers(t,r)}async deleteMembersByIds(e,t,r,n){const o=e.user.id,{members:i}=r;return await this.docService.deleteDocMembers(n,o,i,t)}async createInvitation(e,t,{expiresInMilliSeconds:r}){const o=e.user.id;if(void 0!==r&&r<1)throw new n.BadRequestException("Invalid expiration time.");return await this.docService.createInvitation(t,o,r)}async getDocIdByInvitation(e,t){const r=e.user.id;return await this.docService.getDocIdByInvitation(t,r)}async getYLogs(e,t){return e.user.id,await this.docService.getYLogs(t)}async addInitialYLogs(e,t){const r=t;return await this.docService.addYLog(e,r)}};return e([(0,n.Post)("create"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object,Object]),t("design:returntype",Promise)],a.prototype,"create",null),e([(0,n.Get)("list"),r(0,(0,i.SecurityContext)()),t("design:type",Function),t("design:paramtypes",[Object]),t("design:returntype",Promise)],a.prototype,"list",null),e([(0,n.Get)(":id"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,String]),t("design:returntype",Promise)],a.prototype,"detail",null),e([(0,n.Post)(":id/edit"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Param)("id")),r(2,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object,String,Object]),t("design:returntype",Promise)],a.prototype,"update",null),e([(0,n.Post)(":id/delete"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Query)("session_id")),r(2,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,String,String]),t("design:returntype",Promise)],a.prototype,"delete",null),e([(0,n.Post)(":id/add/members"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Param)("id")),r(2,(0,n.Query)("session_id")),r(3,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object,String,String,Object]),t("design:returntype",Promise)],a.prototype,"addMembers",null),e([(0,n.Post)(":id/edit/members"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Param)("id")),r(2,(0,n.Query)("session_id")),r(3,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object,String,String,Object]),t("design:returntype",Promise)],a.prototype,"editMembers",null),e([(0,n.Get)(":id/members"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,String]),t("design:returntype",Promise)],a.prototype,"getAllMembers",null),e([(0,n.Post)(":id/query/members"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Body)()),r(2,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,Object,String]),t("design:returntype",Promise)],a.prototype,"getMembersByIds",null),e([(0,n.Get)(":id/members/online"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,String]),t("design:returntype",Promise)],a.prototype,"getOnlineMembers",null),e([(0,n.Post)(":id/delete/members"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Query)("session_id")),r(2,(0,n.Body)()),r(3,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,String,Object,String]),t("design:returntype",Promise)],a.prototype,"deleteMembersByIds",null),e([(0,n.Post)(":id/create/invitation"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Param)("id")),r(2,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object,String,Object]),t("design:returntype",Promise)],a.prototype,"createInvitation",null),e([(0,n.Get)("invitation/:id"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,String]),t("design:returntype",Promise)],a.prototype,"getDocIdByInvitation",null),e([(0,n.Get)(":id/ylogs"),r(0,(0,i.SecurityContext)()),r(1,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,String]),t("design:returntype",Promise)],a.prototype,"getYLogs",null),e([(0,n.Post)(":id/ylogs"),r(0,(0,n.Param)("id")),r(1,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[String,Buffer]),t("design:returntype",Promise)],a.prototype,"addInitialYLogs",null),a=e([(0,n.Controller)("api/doc"),t("design:paramtypes",[o.DocService])],a),ut.DocController=a,ut}(),n=at(),o=Je(),i=function(){if(pt)return St;pt=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)},r=G&&G.__param||function(e,t){return function(r,n){t(r,n,e)}};Object.defineProperty(St,"__esModule",{value:!0}),St.AnnotController=void 0;const n=M.default,o=ie,i=ft();let a=class{constructor(e){this.annotService=e}async getAnnotations(e,t,r,n="in"){const o=e.user.id;return await this.annotService.getAnnotations(t,o,r||[],n)}async addAnnotations(e,t,r,n){const o=e.user.id;return await this.annotService.addAnnotations(t,o,n.annots,n.is_init,r)}async changeAnnotations(e,t,r,n){const o=e.user.id;return await this.annotService.changeAnnotations(t,o,n.annots,r)}async deleteAnnotations(e,t,r,n){const o=e.user.id;return await this.annotService.deleteAnnotations(t,o,n.annots,r)}};return e([(0,n.Get)(":id/annotations"),r(0,(0,o.SecurityContext)()),r(1,(0,n.Param)("id")),r(2,(0,n.Query)("annotation_ids")),r(3,(0,n.Query)("strategy")),t("design:type",Function),t("design:paramtypes",[Object,String,Array,String]),t("design:returntype",Promise)],a.prototype,"getAnnotations",null),e([(0,n.Post)(":id/add/annotations"),r(0,(0,o.SecurityContext)()),r(1,(0,n.Param)("id")),r(2,(0,n.Query)("session_id")),r(3,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object,String,String,Object]),t("design:returntype",Promise)],a.prototype,"addAnnotations",null),e([(0,n.Post)(":id/change/annotations"),r(0,(0,o.SecurityContext)()),r(1,(0,n.Param)("id")),r(2,(0,n.Query)("session_id")),r(3,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object,String,String,Object]),t("design:returntype",Promise)],a.prototype,"changeAnnotations",null),e([(0,n.Post)(":id/delete/annotations"),r(0,(0,o.SecurityContext)()),r(1,(0,n.Param)("id")),r(2,(0,n.Query)("session_id")),r(3,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object,String,String,Object]),t("design:returntype",Promise)],a.prototype,"deleteAnnotations",null),a=e([(0,n.Controller)("api/doc"),t("design:paramtypes",[i.AnnotService])],a),St.AnnotController=a,St}(),a=ft(),s=it();let c=class{};return c=e([(0,t.Module)({controllers:[r.DocController,i.AnnotController],providers:[n.DocService,a.AnnotService,s.PermService],imports:[o.CommonModule],exports:[n.DocService,a.AnnotService,s.PermService]})],c),lt.DocModule=c,lt}var bt,vt={},_t={};function wt(){return bt||(bt=1,function(e){var t=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},r=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)};Object.defineProperty(e,"__esModule",{value:!0}),e.ScreenSyncService=e.ScreenSyncRole=void 0;const n=M.default,o=je(),i=be,a=at(),s=D.default;var c;!function(e){e.LEADER="leader",e.FOLLOWER="follower"}(c=e.ScreenSyncRole||(e.ScreenSyncRole={}));let d=class{constructor(e,t){var r;this.collaborationService=e,this.docService=t,this.screenSyncMap={},null===(r=this.collaborationService.mq)||void 0===r||r.subscribe("screen-sync",async e=>{if("createScreenSync"===e.type){const{docId:t,userId:r,sessionId:n,memberIds:o,screenSyncId:i}=e.data;return void await this.createScreenSync(t,r,n,o,i,"remote-server")}if("joinScreenSync"===e.type){const{screenSyncId:t,userId:r}=e.data;return void await this.joinScreenSync(t,r,"remote-server")}if("quitScreenSync"===e.type){const{screenSyncId:t,userId:r}=e.data;return void await this.quitScreenSync(t,r,"remote-server")}if("createScreenSyncForMember"===e.type){const{docId:t,userId:r,sessionId:n,memberId:o,screenSyncId:i}=e.data;return void await this.createScreenSyncForMember(o,r,t,n,i,"remote-server")}if("sync"===e.type){const{screenSyncId:t,userId:r,body:n}=e.data;return void await this.sync(t,r,n,"remote-server")}})}async createScreenSync(e,t,r,n,o=null,a=null){var c,d;const l=this.screenSyncMap;for(let n of Object.keys(l)){const o=l[n];if(o&&(o.collaborationInfo.docId===e&&o.leader.id==t)){await this.collaborationService.removeMemberFromScreenSync(t);const a=o.members.map(e=>e.id);for(const e of a)await this.collaborationService.removeMemberFromScreenSync(e);delete this.screenSyncMap[n],await this.collaborationService.broadcastDocDataToClients(e,r,{type:i.ScreenSyncEvent.STOPPED,data:{docId:e,creatorId:o.creatorId,leader:o.leader,screenSyncId:n}},a)}}const u=o||s(),m=await this.docService.getDocMembers(e,t,[t]);await this.collaborationService.addMemberToScreenSync(t);const p=m[0],y={id:u,leader:p,creatorId:t,collaborationInfo:{docId:e,sessionId:r},members:[p]};return this.screenSyncMap[y.id]=y,"remote-server"!==a&&(null===(c=this.collaborationService.mq)||void 0===c||c.publish("screen-sync",JSON.stringify({type:"createScreenSync",data:{docId:e,userId:t,sessionId:r,memberIds:n,screenSyncId:u},meta:{collaborationId:e,serverId:null===(d=this.collaborationService.mq)||void 0===d?void 0:d.serverId}}))),await this.collaborationService.broadcastDocDataToClients(e,r,{type:i.ScreenSyncEvent.CREATED,data:{docId:e,screenSyncId:u,leader:p,members:[p]}},0===n.length?null:n),y}async getScreenSync(e,t){const r=this.screenSyncMap[e];if(!r)throw new n.NotFoundException("The screenSync does not exist, or the initiator has canceled the screenSync.");return r}async joinScreenSync(e,t,r=null){var o,a;"remote-server"!==r&&(null===(o=this.collaborationService.mq)||void 0===o||o.publish("screen-sync",JSON.stringify({type:"joinScreenSync",data:{screenSyncId:e,userId:t},meta:{collaborationId:null,serverId:null===(a=this.collaborationService.mq)||void 0===a?void 0:a.serverId}})));const s=this.screenSyncMap[e];if(!s)throw new n.NotFoundException("The screenSync does not exist, or the initiator has canceled the screenSync.");const{docId:c,sessionId:d}=s.collaborationInfo,l=(await this.docService.getDocMembers(c,t,[t]))[0];l&&(l.screenSyncInfo={role:"follower"});const u=s.members.filter(e=>e.id===t).length;return Boolean(u)||(s.members.push(l),await this.collaborationService.addMemberToScreenSync(l.id)),await this.collaborationService.broadcastDocDataToClients(c,d,{type:i.ScreenSyncEvent.MEMBER_JOINED,data:{docId:c,creatorId:s.creatorId,screenSyncId:e,leader:s.leader,member:l}},s.members.map(e=>e.id)),!0}async quitScreenSync(e,t,r=null){var n,o;"remote-server"!==r&&(null===(n=this.collaborationService.mq)||void 0===n||n.publish("screen-sync",JSON.stringify({type:"quitScreenSync",data:{screenSyncId:e,userId:t},meta:{collaborationId:null,serverId:null===(o=this.collaborationService.mq)||void 0===o?void 0:o.serverId}})));const a=this.screenSyncMap[e];if(!a)return!0;const{docId:s,sessionId:c}=a.collaborationInfo;let d;try{d=(await this.docService.getDocMembers(s,t,[t]))[0]}catch(r){delete this.screenSyncMap[e],await this.collaborationService.removeMemberFromScreenSync(t);const n=a.members.map(e=>e.id);for(const e of n)await this.collaborationService.removeMemberFromScreenSync(e);return!0}if(t===a.leader.id){await this.collaborationService.removeMemberFromScreenSync(t);const r=a.members.map(e=>e.id);for(const e of r)await this.collaborationService.removeMemberFromScreenSync(e);delete this.screenSyncMap[e],await this.collaborationService.broadcastDocDataToClients(s,c,{type:i.ScreenSyncEvent.STOPPED,data:{docId:s,creatorId:a.creatorId,leader:a.leader,screenSyncId:e}},r)}else a.members=a.members.filter(e=>e.id!==t),await this.collaborationService.removeMemberFromScreenSync(t),await this.collaborationService.broadcastDocDataToClients(s,c,{type:i.ScreenSyncEvent.MEMBER_LEAVE,data:{docId:s,screenSyncId:e,leader:a.leader,member:d,followerNumber:a.members.length-1}},a.members.map(e=>e.id));return!0}async getMembers(e,t,r){const n=this.screenSyncMap[e];return r===c.LEADER?n.members.filter(e=>n.leader.id===e.id):r===c.FOLLOWER?n.members.filter(e=>n.leader.id!==e.id):n.members}async sync(e,t,r,n=null){var o,a;const s=this.screenSyncMap[e],{docId:c,sessionId:d}=s.collaborationInfo;return"remote-server"!==n&&(null===(o=this.collaborationService.mq)||void 0===o||o.publish("screen-sync",JSON.stringify({type:"sync",data:{screenSyncId:e,userId:t,body:r},meta:{collaborationId:null,serverId:null===(a=this.collaborationService.mq)||void 0===a?void 0:a.serverId}}))),await this.collaborationService.broadcastDocDataToClients(c,d,{type:i.ScreenSyncEvent.SCREENSYNC_DATA,data:{docId:c,screenSyncId:e,leader:s.leader,screenSyncData:r}},s.members.filter(e=>e.id!==t).map(e=>e.id)),!0}async getScreenSyncListByCollaborationId(e,t,r){return Object.keys(this.screenSyncMap).map(e=>{const t=this.screenSyncMap[e];if(t)return t}).filter(t=>t.collaborationInfo.docId===e)}async getScreenSyncByUserId(e,t){const r=this.screenSyncMap;for(let n of Object.keys(r)){const o=r[n];if(o&&(o.collaborationInfo.docId===e&&o.leader.id==t))return o}}async recursiveFindFollowerById(e,t,r){let o=await this.getScreenSyncByUserId(e,t);if(!o)return;let i=await this.getMembers(o.id,t,c.FOLLOWER);if(i.length>0)for(let t=0;t<i.length;t++){if(i[t].id===r)throw new n.ForbiddenException("The current member exists in your follower group");await this.recursiveFindFollowerById(e,i[t].id,r)}}async getScreenSyncByMemberId(e,t,r,n){await this.recursiveFindFollowerById(r,t,e);const o=this.screenSyncMap;for(let t of Object.keys(o)){const n=o[t];if(n&&(n.collaborationInfo.docId===r&&n.leader.id==e))return n}return await this.createScreenSyncForMember(e,t,r,n)}async createScreenSyncForMember(e,t,r,n,o=s(),i=null){var a,c;"remote-server"!==i&&(null===(a=this.collaborationService.mq)||void 0===a||a.publish("screen-sync",JSON.stringify({type:"createScreenSyncForMember",data:{docId:r,userId:t,sessionId:n,memberId:e,screenSyncId:o},meta:{collaborationId:r,serverId:null===(c=this.collaborationService.mq)||void 0===c?void 0:c.serverId}}))),await this.collaborationService.addMemberToScreenSync(e);const d=(await this.docService.getDocMembers(r,e,[e]))[0],l={id:o,leader:d,creatorId:t,collaborationInfo:{docId:r,sessionId:n},members:[d]};return this.screenSyncMap[l.id]=l,l}};d=t([(0,n.Injectable)(),r("design:paramtypes",[o.CollaborationService,a.DocService])],d),e.ScreenSyncService=d}(_t)),_t}var It,Et,Ot,Ct={};function Mt(){if(Et)return vt;Et=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a};Object.defineProperty(vt,"__esModule",{value:!0}),vt.ScreenSyncModule=void 0;const t=M.default,r=Je(),n=wt(),o=gt(),i=function(){if(It)return Ct;It=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)},r=G&&G.__param||function(e,t){return function(r,n){t(r,n,e)}};Object.defineProperty(Ct,"__esModule",{value:!0}),Ct.ScreenSyncController=void 0;const n=M.default,o=ie,i=wt();let a=class{constructor(e){this.screenSyncService=e}async listByCollaborationId(e,t,r){const n=e.user.id;return await this.screenSyncService.getScreenSyncListByCollaborationId(t,n,r)}async create(e,t,r,n){const o=e.user.id,i=n.members||[];return await this.screenSyncService.createScreenSync(t,o,r,i)}async get(e,t){const r=e.user.id;return await this.screenSyncService.getScreenSync(t,r)}async getScreenSyncByMemberId(e,t,r,n){const o=e.user.id;return await this.screenSyncService.getScreenSyncByMemberId(t,o,r,n)}async join(e,t){const r=e.user.id;return await this.screenSyncService.joinScreenSync(t,r)}async leave(e,t){const r=e.user.id;return await this.screenSyncService.quitScreenSync(t,r)}async getMembers(e,t,r){const n=e.user.id;return await this.screenSyncService.getMembers(t,n,r)}async sync(e,t,r){const n=e.user.id;return await this.screenSyncService.sync(t,n,r)}};return e([(0,n.Get)("list"),r(0,(0,o.SecurityContext)()),r(1,(0,n.Query)("doc_id")),r(2,(0,n.Query)("session_id")),t("design:type",Function),t("design:paramtypes",[Object,String,String]),t("design:returntype",Promise)],a.prototype,"listByCollaborationId",null),e([(0,n.Post)(),r(0,(0,o.SecurityContext)()),r(1,(0,n.Query)("doc_id")),r(2,(0,n.Query)("session_id")),r(3,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object,String,String,Object]),t("design:returntype",Promise)],a.prototype,"create",null),e([(0,n.Get)(":id"),r(0,(0,o.SecurityContext)()),r(1,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,String]),t("design:returntype",Promise)],a.prototype,"get",null),e([(0,n.Get)(),r(0,(0,o.SecurityContext)()),r(1,(0,n.Query)("memberId")),r(2,(0,n.Query)("doc_id")),r(3,(0,n.Query)("session_id")),t("design:type",Function),t("design:paramtypes",[Object,String,String,String]),t("design:returntype",Promise)],a.prototype,"getScreenSyncByMemberId",null),e([(0,n.Post)(":id/join"),r(0,(0,o.SecurityContext)()),r(1,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,String]),t("design:returntype",Promise)],a.prototype,"join",null),e([(0,n.Post)(":id/leave"),r(0,(0,o.SecurityContext)()),r(1,(0,n.Param)("id")),t("design:type",Function),t("design:paramtypes",[Object,String]),t("design:returntype",Promise)],a.prototype,"leave",null),e([(0,n.Get)(":id/members"),r(0,(0,o.SecurityContext)()),r(1,(0,n.Param)("id")),r(2,(0,n.Query)("role")),t("design:type",Function),t("design:paramtypes",[Object,String,String]),t("design:returntype",Promise)],a.prototype,"getMembers",null),e([(0,n.Post)(":id/sync"),r(0,(0,o.SecurityContext)()),r(1,(0,n.Param)("id")),r(2,(0,n.Body)()),t("design:type",Function),t("design:paramtypes",[Object,String,Object]),t("design:returntype",Promise)],a.prototype,"sync",null),a=e([(0,n.Controller)("api/screen-sync"),t("design:paramtypes",[i.ScreenSyncService])],a),Ct.ScreenSyncController=a,Ct}();let a=class{};return a=e([(0,t.Module)({controllers:[i.ScreenSyncController],providers:[n.ScreenSyncService],imports:[r.CommonModule,o.DocModule]})],a),vt.ScreenSyncModule=a,vt}function Dt(){if(Ot)return J;Ot=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a};Object.defineProperty(J,"__esModule",{value:!0}),J.AppModule=void 0;const t=M.default,r=C.default,n=Ve(),o=function(){if(nt)return ze;nt=1;var e,t,r,n=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},o=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)};Object.defineProperty(ze,"__esModule",{value:!0}),ze.EventGateway=void 0;const i=B.default,a=x.default,s=M.default,c=je(),d=be,l=at(),u=Nt(),m=it(),p=Te;let y=e=class{constructor(t,r,n){var o;this.collaborationService=t,this.docService=r,this.permService=n,this.logger=new s.Logger(e.name),t.addYLog=this.addYLog.bind(this),t.getLatestYLog=this.getLastestYLog.bind(this),null===(o=t.mq)||void 0===o||o.subscribe(p.CLUSTER_EVENT_CHANNEL,e=>{t.broadcastToLocalClients(e)})}async handleEvents(e,t){var r;if(!e._collab_meta)return void this.logger.log("client._collab_meta is null");const{uid:n,sessionId:o,collaborationId:i}=e._collab_meta;t.type!==d.DocumentAction.MOUSE_POINTER_SYNC&&this.logger.debug(`received msg from websocket : ${t.type} , userId: ${n}`);const a=t,s=null===(r=a.data)||void 0===r?void 0:r.docId;if(a.type===d.MetaEvent.HEART)return{type:d.MetaEvent.HEART_REPLY,data:{id:n,collaborationId:i,state:!0}};if(i===s)switch(a.type){case d.MetaEvent.SUBSCRIBE_DOC:return await this.collaborationService.addClient(s,e),e._collab_meta.docId=s,this.collaborationService.broadcastDocDataToClients(s,o,{type:d.DocumentAction.MEMBER_ONLINE,data:{docId:s,user_id:n,session_id:o}}),this.collaborationService.deleteMousePointerState(s,o,n),{type:d.MetaEvent.SUBSCRIBE_DOC_DONE,data:{id:n,mousePointerStates:this.collaborationService.getMousePointerStates(s,o),docId:s,serverId:(null===u.cluster||void 0===u.cluster?void 0:u.cluster.serverId)||"1"}};case d.MetaEvent.UNSUBSCRIBE_DOC:return this.collaborationService.removeClient(s,e),this.collaborationService.broadcastDocDataToClients(s,o,{type:d.DocumentAction.MEMBER_OFFLINE,data:{docId:s,user_id:n,session_id:o}}),this.collaborationService.deleteMousePointerState(s,o,n),{type:d.MetaEvent.DOC_EVENT_REPLY,data:{id:n,state:!0,docId:s}};case d.DocumentAction.MOUSE_POINTER_SYNC:this.collaborationService.broadcastDocDataToClients(s,o,{type:d.DocumentAction.MOUSE_POINTER_SYNC,data:{docId:s,user_id:n,session_id:o,state:a.data.state}}),this.collaborationService.addOrUpdateMousePointerState(s,o,n,a.data.state);break;case d.DocumentAction.PAGE_MEASURE_SCALE_SYNC:this.collaborationService.broadcastDocDataToClients(s,o,{type:d.DocumentAction.PAGE_MEASURE_SCALE_SYNC,data:{docId:s,user_id:n,session_id:o,measureScaleRatioInfo:a.data.measureScaleRatioInfo}});break;default:return null}else this.logger.error(`collaborationId not match ${i} !== ${s}`)}async handleYlogSync(e,t){const{uid:r,collaborationId:n,isAllowComment:o}=e._collab_meta;return this.logger.debug(`received ${t.type} from user: ${r} of collaboration: ${n}  with size: ${t.ylog.length}`),t.type===d.DocumentAction.SYNC_YLOG&&o&&await this.collaborationService.handleSyncUpdate(n,e,t),t.type===d.DocumentAction.SYNC_YLOG_STEP_1?await this.collaborationService.handleSyncStep1(n,e,t):t.type===d.DocumentAction.SYNC_YLOG_STEP_2&&o?await this.collaborationService.handleSyncStep2(n,e,t):void 0}async handleConnection(e,...t){const r=e._collab_meta;this.logger.log(`user: ${r.uid} connected with collabId: ${r.collaborationId} and sessionId: ${r.sessionId}`)}handleDisconnect(e){const{uid:t,sessionId:r,collaborationId:n}=e._collab_meta;this.logger.log(`client disconnected: userId [${t}] collaborationId [${n}]`),n&&(this.collaborationService.removeClient(n,e),this.collaborationService.broadcastDocDataToClients(n,r,{type:d.DocumentAction.MEMBER_OFFLINE,data:{docId:n,user_id:t,session_id:r}}),this.collaborationService.deleteMousePointerState(n,r,t))}afterInit(e){this.logger.log("websocket server after init")}async addYLog(e,t){await this.docService.addYLog(e,Buffer.from(Object.values(t)))}async getLastestYLog(e){const t=await this.docService.getLatestYLogs(e);return t?t.update:null}};return n([(0,i.SubscribeMessage)("events"),o("design:type",Function),o("design:paramtypes",["function"==typeof(t=void 0!==a.Socket&&a.Socket)?t:Object,String]),o("design:returntype",Promise)],y.prototype,"handleEvents",null),n([(0,i.SubscribeMessage)("sync"),o("design:type",Function),o("design:paramtypes",["function"==typeof(r=void 0!==a.Socket&&a.Socket)?r:Object,Object]),o("design:returntype",Promise)],y.prototype,"handleYlogSync",null),y=e=n([(0,i.WebSocketGateway)({path:"/ws"}),o("design:paramtypes",[c.CollaborationService,l.DocService,m.PermService])],y),ze.EventGateway=y,ze}(),i=Je(),a=function(){if(st)return ct;st=1;var e=G&&G.__decorate||function(e,t,r,n){var o,i=arguments.length,a=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,r,n);else for(var s=e.length-1;s>=0;s--)(o=e[s])&&(a=(i<3?o(a):i>3?o(t,r,a):o(t,r))||a);return i>3&&a&&Object.defineProperty(t,r,a),a},t=G&&G.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)};Object.defineProperty(ct,"__esModule",{value:!0}),ct.AuthenticationMiddleware=void 0;const r=M.default,n=oe();let o=class{constructor(e){this.userService=e}async use(e,t,r){var n;let o;if(e.headers.authorization&&(o=e.headers.authorization,o.startsWith("Bearer")&&(o=o.replace("Bearer ",""))),!o&&(null===(n=e.query)||void 0===n?void 0:n.token)&&(o=e.query.token),o)try{e.user=await this.userService.getUserByToken(o)}catch(e){throw e}r()}};return o=e([(0,r.Injectable)(),t("design:paramtypes",[n.UserService])],o),ct.AuthenticationMiddleware=o,ct}(),s=gt(),c=Mt(),d=re();let l=class{configure(e){e.apply(a.AuthenticationMiddleware).exclude("api/user/login-anonymously","api/user/auth","api/version").forRoutes("*")}};return l=e([(0,t.Module)({providers:[o.EventGateway],imports:[n.UserModule,s.DocModule,i.CommonModule,c.ScreenSyncModule,r.LoggerModule.forRootAsync({imports:[i.CommonModule],inject:[d.ConfigService],useFactory:async e=>await e.getLoggerConfig()})]})],l),J.AppModule=l,J}var At,Pt,Rt={};function Nt(){if(Pt)return H;Pt=1,Object.defineProperty(H,"__esModule",{value:!0}),H.WebCollabServer=H.cluster=H.customLoggerOptions=H.customUserService=H.msgHandler=H.bootstrap=void 0;const e=E.default,t=O.default,r=C.default,n=Dt(),o=function(){if(At)return Rt;At=1;var e=G&&G.__rest||function(e,t){var r={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.indexOf(n)<0&&(r[n]=e[n]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(n=Object.getOwnPropertySymbols(e);o<n.length;o++)t.indexOf(n[o])<0&&Object.prototype.propertyIsEnumerable.call(e,n[o])&&(r[n[o]]=e[n[o]])}return r};Object.defineProperty(Rt,"__esModule",{value:!0}),Rt.WsAdapter=void 0;const t=M.default,r=F.default,n=B.default,o=Y.default,i=k.default,a=q.default,s=R.default,c=Me,d=E.default,l=oe(),u=$.default,m=it();let p={};var y;!function(e){e[e.CONNECTING_STATE=0]="CONNECTING_STATE",e[e.OPEN_STATE=1]="OPEN_STATE",e[e.CLOSING_STATE=2]="CLOSING_STATE",e[e.CLOSED_STATE=3]="CLOSED_STATE"}(y||(y={}));class S extends n.AbstractWsAdapter{constructor(e){super(e),this.logger=new t.Logger(S.name),this.httpServersRegistry=new Map,this.wsServersRegistry=new Map,e&&e instanceof d.NestApplication&&(this.nestApplication=e,this.userService=this.nestApplication.get(l.UserService),this.permService=this.nestApplication.get(m.PermService)),p=(0,r.loadPackage)("ws","WsAdapter",()=>x.default)}create(t,r){const{server:n}=r,o=e(r,["server"]);if(null==o?void 0:o.namespace){const e=new Error('"WsAdapter" does not support namespaces. If you need namespaces in your project, consider using the "@nestjs/platform-socket.io" package instead.');throw this.logger.error(e),e}if(0===t&&this.httpServer){this.ensureHttpServerExists(t,this.httpServer);const e=this.bindErrorHandler(new p.Server(Object.assign({noServer:!0},o)));return this.addWsServerToRegistry(e,t,r.path||"/"),e}if(n)return n;if(r.path&&0!==t){const e=this.ensureHttpServerExists(t);null==e||e.listen(t);const n=this.bindErrorHandler(new p.Server(Object.assign({noServer:!0},o)));return this.addWsServerToRegistry(n,t,r.path),n}return this.bindErrorHandler(new p.Server(Object.assign({port:t},o)))}bindMessageHandlers(e,t,r){const n=(0,a.fromEvent)(e,o.CLOSE_EVENT).pipe((0,s.share)(),(0,s.first)());(0,a.fromEvent)(e,"message").pipe((0,s.mergeMap)(e=>this.bindMessageHandler(e,t,r).pipe((0,s.filter)(e=>e))),(0,s.takeUntil)(n)).subscribe(t=>{e.readyState===y.OPEN_STATE&&e.send(c.encode(t))})}bindMessageHandler(e,t,r){try{const n=c.decode(e.data),o=t.find(e=>e.message===n.event),{callback:i}=o;return r(i(n.data))}catch(e){return a.EMPTY}}bindErrorHandler(e){return e.on(o.CONNECTION_EVENT,e=>e.on(o.ERROR_EVENT,e=>this.logger.error(e))),e.on(o.ERROR_EVENT,e=>this.logger.error(e)),e}bindClientDisconnect(e,t){e.on(o.CLOSE_EVENT,t)}async dispose(){const e=Array.from(this.httpServersRegistry).filter(([e])=>0!==e).map(([e,t])=>new Promise(e=>t.close(e)));await Promise.all(e),this.httpServersRegistry.clear(),this.wsServersRegistry.clear()}async authenticate(e){if(!this.userService)throw new Error("ws authentication failed: user service is not initialized");const t=u.parse(e.url.split("?")[1]);try{await this.userService.getUserByToken(t.token)}catch(e){throw new Error("ws authentication failed: invalid user token "+t.token)}try{const e=await this.permService.canJoinCollaboration(t.uid,t.collaborationId),r=await this.permService.isAllowComment(t.uid,t.collaborationId);if(!e)throw new Error("can not join collaboration");return Object.assign(Object.assign({},t),{isAllowComment:r})}catch(e){throw new Error("ws authentication failed: not permitted to join collaboration "+t.collaborationId)}}ensureHttpServerExists(e,t=i.createServer()){if(!this.httpServersRegistry.has(e))return this.httpServersRegistry.set(e,t),t.on("upgrade",(t,r,n)=>{const o="ws://"+t.headers.host+"/",i=new URL(t.url,o).pathname,a=this.wsServersRegistry.get(e);this.authenticate(t).then(e=>{let o=!1;for(const s of a)if(i===s.path){s.handleUpgrade(t,r,n,r=>{r._collab_meta=e,s.emit("connection",r,t)}),o=!0;break}o||r.destroy()}).catch(e=>{r.write("HTTP/1.1 401 Unauthorized\r\n\r\n"),r.destroy()})}),t}addWsServerToRegistry(e,t,r){var n;const o=null!==(n=this.wsServersRegistry.get(t))&&void 0!==n?n:[];o.push(e),e.path=r,this.wsServersRegistry.set(t,o)}}return Rt.WsAdapter=S,Rt}(),i=at();async function a(i){const a=await e.NestFactory.create(n.AppModule,Object.assign({cors:!0,bufferLogs:!0},i));return a.use(t.raw({limit:"100mb"})),a.use(t.json({limit:"20mb"})),a.use(t.urlencoded({limit:"20mb",extended:!0})),a.useLogger(a.get(r.Logger)),a.useWebSocketAdapter(new o.WsAdapter(a)),a}H.bootstrap=a;return H.WebCollabServer=class{constructor(e){process.env.db_config=JSON.stringify(e.databaseConfig),H.msgHandler=e.messageHandler,H.customUserService=e.userService,H.cluster=e.cluster;void 0!==e.logger&&(H.customLoggerOptions=e.logger),this.bootstrapPromise=a({})}async applyConfig(e){this.instance=await this.bootstrapPromise,e(this.instance.getHttpAdapter())}async start(e=8080){this.instance=await this.bootstrapPromise,this.serverPromise=this.instance.listen(e),await this.serverPromise}async stop(){this.instance&&await this.instance.close()}async createCollaboration(e){return await this.serverPromise,await this.instance.get(i.DocService).createCollaboration(e)}},H}var Tt=Nt();module.exports=Tt;
