(window.webpackJsonp=window.webpackJsonp||[]).push([[84],{408:function(t,a,s){"use strict";s.r(a);var e=s(14),n=Object(e.a)({},(function(){var t=this,a=t._self._c;return a("ContentSlotsDistributor",{attrs:{"slot-key":t.$parent.slotKey}},[a("h1",{attrs:{id:"bookmark-api-migration-guide"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#bookmark-api-migration-guide"}},[t._v("#")]),t._v(" Bookmark API Migration Guide")]),t._v(" "),a("p",[t._v("This guide is intended to help developers upgrade from an older version of the Bookmark APIs to the newest version. Starting from version 10.0.0, we have refactored the Bookmark APIs, which provides more powerful features and performance improvements. Next, we will further discuss which old Bookmark APIs are being deprecated and how to migrate to the new APIs.")]),t._v(" "),a("h2",{attrs:{id:"confirm-the-current-version-of-the-api-in-use"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#confirm-the-current-version-of-the-api-in-use"}},[t._v("#")]),t._v(" Confirm the current version of the API in use")]),t._v(" "),a("p",[t._v("If your application was developed based on versions prior to 10.0.0, when upgrading to versions after 10.0.0, please note that you will need to search for relevant API calls in your code, or check if the old bookmark component has been used in your component templates. The names of the old APIs and components will be listed subsequently.")]),t._v(" "),a("h2",{attrs:{id:"deprecated-apis"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#deprecated-apis"}},[t._v("#")]),t._v(" Deprecated APIs")]),t._v(" "),a("p",[t._v("The table below lists the deprecated bookmark APIs and alternative solutions.")]),t._v(" "),a("table",[a("thead",[a("tr",[a("th",[t._v("Old API")]),t._v(" "),a("th",[t._v("Description")]),t._v(" "),a("th",[t._v("Alternative API")])])]),t._v(" "),a("tbody",[a("tr",[a("td",[a("s",[t._v("PDFDoc.getRootBookmark")])]),t._v(" "),a("td",[t._v("Get the root bookmark of the document, this method will load all bookmarks in the document at once")]),t._v(" "),a("td",[a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService.getFirstLevelBookmarks"),a("OutboundLink")],1)])]),t._v(" "),a("tr",[a("td",[a("s",[t._v("PDFDoc.createRootBookmark")])]),t._v(" "),a("td",[t._v("Create the root bookmark of the document. The new version will automatically create the root bookmark, making it unnecessary to create via an interface")]),t._v(" "),a("td",[t._v("none")])]),t._v(" "),a("tr",[a("td",[a("s",[t._v("PDFBookmark.insertBookmark")])]),t._v(" "),a("td",[t._v("Insert a new bookmark at the specified location")]),t._v(" "),a("td",[a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html#ab0e0cac040e0494042066bcced59aa14",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService.addBookmark"),a("OutboundLink")],1),t._v(", "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_u_i_service.html#a1a241aff478761006c8d46ad5ccf7b1c",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkUIService.addBookmark"),a("OutboundLink")],1)])]),t._v(" "),a("tr",[a("td",[a("s",[t._v("PDFBookmark.setProperty")])]),t._v(" "),a("td",[t._v("Set the properties of the bookmark")]),t._v(" "),a("td",[a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html#a2ae2ac21f7bf1f8ac75532df9f7e2617",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService.renameBookmark"),a("OutboundLink")],1),t._v(", "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html#a824b5601969e8f183d4c06b1f38d888b",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService.setColor"),a("OutboundLink")],1),t._v(", "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html#a909eee762e5cb2d6ee34e6894d3f5974",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService.setFontStyle"),a("OutboundLink")],1),t._v(", "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html#a7f1555842488d159b7f8bcca35c1fdce",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService.setDestination"),a("OutboundLink")],1),t._v(", "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_u_i_service.html#ae9bb0c5f3286893a28f71519dd5328ec",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkUIService.renameBookmark"),a("OutboundLink")],1),t._v(", "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_u_i_service.html#a5991b2db45ffb4c1707ae768b577063b",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkUIService.setColor"),a("OutboundLink")],1),t._v(", "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_u_i_service.html#ad559f988d25d1868ba3ce27c5c9286ef",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkUIService.setFontStyle"),a("OutboundLink")],1),t._v(", "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_u_i_service.html#ac00661b52a6e57107eea51fc165b5817",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkUIService.setDestination"),a("OutboundLink")],1)])]),t._v(" "),a("tr",[a("td",[a("s",[t._v("PDFBookmark.remove")])]),t._v(" "),a("td",[t._v("Remove a specified bookmark")]),t._v(" "),a("td",[a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html#a2d08d64c16c0702d7ca869c32062304b",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService.deleteBookmark"),a("OutboundLink")],1),t._v(", "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_u_i_service.html#ac0f407eddcca3042f16af3ecf6a74db9",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkUIService.deleteBookmark"),a("OutboundLink")],1)])]),t._v(" "),a("tr",[a("td",[a("s",[t._v("PDF.constant.DataEvents.bookmarkAdded")])]),t._v(" "),a("td",[t._v("Triggered when bookmark has been added")]),t._v(" "),a("td",[a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html#a4c3f17d62eaac4506c672f57b08f95ff",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService.onBookmarkAdded"),a("OutboundLink")],1)])]),t._v(" "),a("tr",[a("td",[a("s",[t._v("PDF.constant.DataEvents.bookmarkUpdated")])]),t._v(" "),a("td",[t._v("Triggered when bookmark has been updated")]),t._v(" "),a("td",[a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html#aff853b7f50ab1f4e24f29cbd28e3a013",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService.onBookmarkPropertiesUpdated"),a("OutboundLink")],1)])]),t._v(" "),a("tr",[a("td",[a("s",[t._v("PDF.constant.DataEvents.bookmarkRemoved")])]),t._v(" "),a("td",[t._v("Triggered when bookmark has been removed")]),t._v(" "),a("td",[a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html#af2ef883ec2c6bcd270d7db4513ffc8ff",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService.onBookmarkDeleted"),a("OutboundLink")],1)])])])]),t._v(" "),a("p",[t._v("Below are the deprecated bookmark UIExtension components and their alternatives:")]),t._v(" "),a("table",[a("thead",[a("tr",[a("th",[t._v("Old Component")]),t._v(" "),a("th",[t._v("Description")]),t._v(" "),a("th",[t._v("Alternative Component")])])]),t._v(" "),a("tbody",[a("tr",[a("td",[a("s",[a("code",[t._v("<bookmark-sidebar-panel>")])])]),t._v(" "),a("td",[t._v("Sidebar bookmark panel component")]),t._v(" "),a("td",[a("code",[t._v("<bookmark-v2:sidebar-panel>")])])]),t._v(" "),a("tr",[a("td",[a("s",[a("code",[t._v("<bookmark-contextmenu>")])])]),t._v(" "),a("td",[t._v("Bookmark contextmenu component")]),t._v(" "),a("td",[a("code",[t._v("<bookmark-v2:bookmark-contextmenu>")])])])])]),t._v(" "),a("p",[t._v("When these old components are replaced with new ones, the previously registered bookmark events will not be triggered. At this time, it is necessary to replace the registration method of these events. Examples will be provided later to illustrate.")]),t._v(" "),a("p",[t._v("If your application requires a custom bookmark UI, please refer to "),a("RouterLink",{attrs:{to:"/ui-extension/customization/custom-bookmark.html"}},[t._v("Customize bookmark")]),t._v(".")],1),t._v(" "),a("h2",{attrs:{id:"example"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#example"}},[t._v("#")]),t._v(" Example")]),t._v(" "),a("p",[t._v("The following will provide examples to demonstrate how to use the new bookmark APIs to replace the old ones, as well as compare the differences between the two versions.")]),t._v(" "),a("h3",{attrs:{id:"example-1-listen-to-the-event-of-adding-a-bookmark"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#example-1-listen-to-the-event-of-adding-a-bookmark"}},[t._v("#")]),t._v(" Example 1 - Listen to the event of adding a bookmark")]),t._v(" "),a("p",[t._v("This example demonstrates how to listen to the event of adding a bookmark, and modify the properties of the bookmark through the instance of "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService"),a("OutboundLink")],1),t._v(".")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20500px%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%20%20%20%20%3Cdiv%20id%3D%22pdf-ui%22%3E%3C%2Fdiv%3E%0A%3C%2Fhtml%3E%0A%3Cstyle%3E%0Ahtml%7B%0A%20%20%20%20%20%20%20%20overflow%3Ahidden%3B%0A%20%20%20%20%7D%0A%20%20%20%20body%20%7B%0A%20%20%20%20%20%20%20%20height%3A%20100vh%3B%0A%20%20%20%20%7D%0A%20%20%20%20%23pdf-ui%20%7B%0A%20%20%20%20%20%20%20%20position%3A%20relative%3B%0A%20%20%20%20%20%20%20%20top%3A%2050px%3B%0A%20%20%20%20%7D%0A%3C%2Fstyle%3E%0A%0A%3Cscript%3E%0Aconst%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0Aconst%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D%2C%0A%20%20%20%20renderTo%3A%20'%23pdf-ui'%2C%0A%20%20%20%20appearance%3A%20UIExtension.appearances.adaptive%2C%0A%20%20%20%20addons%3A%20%5B%5D%0A%7D)%3B%0A%0Apdfui.getBookmarkDataService().then(bookmarkDataService%20%3D%3E%20%7B%0A%20%20%20%20bookmarkDataService.onBookmarkAdded((event)%20%3D%3E%20%7B%0A%20%20%20%20%20%20%20%20bookmarkDataService.setColor(event.bookmarkId%2C%20'%23FF0000')%3B%0A%20%20%20%20%20%20%20%20bookmarkDataService.setFontStyle(event.bookmarkId%2C%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20bold%3A%20true%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20italic%3A%20true%0A%20%20%20%20%20%20%20%20%7D)%3B%0A%20%20%20%20%7D)%0A%7D)%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("div")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("id")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("pdf-ui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("div")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token style"}},[a("span",{pre:!0,attrs:{class:"token language-css"}},[t._v("\n"),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("overflow")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v("hidden"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v("body")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("height")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 100vh"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v("#pdf-ui")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("position")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" relative"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("top")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 50px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'#pdf-ui'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\npdfui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getBookmarkDataService")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("then")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("bookmarkDataService")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    bookmarkDataService"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("onBookmarkAdded")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("event")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        bookmarkDataService"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("setColor")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("event"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("bookmarkId"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'#FF0000'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        bookmarkDataService"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("setFontStyle")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("event"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("bookmarkId"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("bold")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token boolean"}},[t._v("true")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("italic")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token boolean"}},[t._v("true")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 500px"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("p",[t._v("After running the above example and opening a document, then adding a new bookmark through the bookmark panel, you will find that the font color of the new bookmark is set to red, and the font style is set to bold and italic.")]),t._v(" "),a("p",[t._v("For versions "),a("code",[t._v("9.*")]),t._v(" and earlier, bookmark events are registered in the following way:")]),t._v(" "),a("div",{staticClass:"language-js extra-class"},[a("pre",{pre:!0,attrs:{class:"language-js"}},[a("code",[t._v("pdfui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("addViewerEventListener")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("PDFViewCtrl"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ViewerEvents"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("bookmarkAdded"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("bookmark")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Here operates the bookmark object")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n")])])]),a("h3",{attrs:{id:"example-2-get-the-nodes-of-bookmark-tree"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#example-2-get-the-nodes-of-bookmark-tree"}},[t._v("#")]),t._v(" Example 2 - Get the nodes of bookmark tree")]),t._v(" "),a("p",[t._v("In versions "),a("code",[t._v("9.*")]),t._v(" and earlier, bookmarks were loaded into memory all at once and inserted into the DOM tree, loading speed could be slow, even to the point of lag, when there were many bookmarks. After refactoring, bookmarks are loaded and rendered based on the number of bookmarks visible to the user, which speeds up the loading process. Furthermore, bookmarks are rendered through the "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_tree_component.html",target:"_blank",rel:"noopener noreferrer"}},[t._v("TreeComponent"),a("OutboundLink")],1),t._v(" component, reserving some space for user customization. The following example shows how to get the nodes of the bookmark tree and modify the node styles:")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20500px%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%20%20%20%20%3Cdiv%20id%3D%22pdf-ui%22%3E%3C%2Fdiv%3E%0A%3C%2Fhtml%3E%0A%3Cstyle%3E%0Ahtml%7B%0A%20%20%20%20%20%20%20%20overflow%3Ahidden%3B%0A%20%20%20%20%7D%0A%20%20%20%20body%20%7B%0A%20%20%20%20%20%20%20%20height%3A%20100vh%3B%0A%20%20%20%20%7D%0A%20%20%20%20%23pdf-ui%20%7B%0A%20%20%20%20%20%20%20%20position%3A%20relative%3B%0A%20%20%20%20%20%20%20%20top%3A%2050px%3B%0A%20%20%20%20%7D%0A%3C%2Fstyle%3E%0A%0A%3Cscript%3E%0Aconst%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0Aconst%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D%2C%0A%20%20%20%20renderTo%3A%20'%23pdf-ui'%2C%0A%20%20%20%20appearance%3A%20UIExtension.appearances.adaptive%2C%0A%20%20%20%20addons%3A%20%5B%5D%0A%7D)%3B%0A%0A(async%20()%20%3D%3E%20%7B%0A%20%20%20%20const%20rootComponent%20%3D%20await%20pdfui.getRootComponent()%3B%0A%20%20%20%20const%20bookmarkTreeComponent%20%3D%20rootComponent.querySelector('%40bookmark-v2%3Abookmark-tree')%3B%0A%20%20%20%20const%20treeComponent%20%3D%20bookmarkTreeComponent.getTree()%0A%20%20%20%20treeComponent.on('create-tree-node'%2C%20treeNode%20%3D%3E%20%7B%0A%20%20%20%20%20%20%20%20const%20titleElement%20%3D%20treeNode.element.querySelector('.fv__ui-tree-node-title')%3B%0A%20%20%20%20%20%20%20%20titleElement.style.cssText%20%2B%3D%20'font-family%3A%20system-ui%2C%20--apple-system%2C%20BlinkMacSystemFont%3B'%3B%0A%20%20%20%20%7D)%0A%7D)()%0A%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("div")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("id")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("pdf-ui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("div")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token style"}},[a("span",{pre:!0,attrs:{class:"token language-css"}},[t._v("\n"),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("overflow")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v("hidden"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v("body")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("height")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 100vh"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v("#pdf-ui")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("position")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" relative"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("top")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 50px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'#pdf-ui'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("async")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" rootComponent "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" pdfui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getRootComponent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" bookmarkTreeComponent "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" rootComponent"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("querySelector")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'@bookmark-v2:bookmark-tree'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" treeComponent "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" bookmarkTreeComponent"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getTree")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n    treeComponent"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("on")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'create-tree-node'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("treeNode")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" titleElement "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" treeNode"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("element"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("querySelector")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'.fv__ui-tree-node-title'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        titleElement"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("style"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("cssText "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'font-family: system-ui, --apple-system, BlinkMacSystemFont;'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 500px"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("p",[t._v("Unlike the old version, all DOM nodes of the old bookmarks can be obtained through "),a("code",[t._v("querySelector")]),t._v(" once the bookmarks were loaded. However, the new version requires listening to the "),a("code",[t._v("create-tree-node")]),t._v(" event to get these nodes.")]),t._v(" "),a("h3",{attrs:{id:"example-3-support-for-undo-redo"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#example-3-support-for-undo-redo"}},[t._v("#")]),t._v(" Example 3 - Support for undo/redo")]),t._v(" "),a("p",[t._v("In version 10.0.0, a "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_u_i_service.html",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkUIService"),a("OutboundLink")],1),t._v(" instance is provided, which is available only when the application layer is based on the implementation of UIExtension. It offers the same API as "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_bookmark_data_service.html",target:"_blank",rel:"noopener noreferrer"}},[t._v("BookmarkDataService"),a("OutboundLink")],1),t._v(", but supports undo/redo operations.")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20500px%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%20%20%20%20%3Cdiv%20id%3D%22pdf-ui%22%3E%3C%2Fdiv%3E%0A%3C%2Fhtml%3E%0A%3Cstyle%3E%0Ahtml%7B%0A%20%20%20%20%20%20%20%20overflow%3Ahidden%3B%0A%20%20%20%20%7D%0A%20%20%20%20body%20%7B%0A%20%20%20%20%20%20%20%20height%3A%20100vh%3B%0A%20%20%20%20%7D%0A%20%20%20%20%23pdf-ui%20%7B%0A%20%20%20%20%20%20%20%20position%3A%20relative%3B%0A%20%20%20%20%20%20%20%20top%3A%2050px%3B%0A%20%20%20%20%7D%0A%3C%2Fstyle%3E%0A%0A%3Cscript%3E%0Aconst%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0Aconst%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D%2C%0A%20%20%20%20renderTo%3A%20'%23pdf-ui'%2C%0A%20%20%20%20appearance%3A%20UIExtension.appearances.adaptive%2C%0A%20%20%20%20addons%3A%20%5B%0A%20%20%20%20%20%20%20%20libPath%20%2B%20'%2Fuix-addons%2Fundo-redo'%0A%20%20%20%20%5D%0A%7D)%3B%0A%0A(async%20()%20%3D%3E%20%7B%0A%20%20%20%20%2F%2F%20Create%20a%20custom%20menu%20item%20component.%0A%20%20%20%20class%20HighlightBookmarkContextMenuItem%20extends%20UIExtension.SeniorComponentFactory.createSuperClass(%7B%0A%20%20%20%20%20%20%20%20%2F%2F%20Listen%20to%20the%20click%20event%20through%20the%20%40on.click%20directive.%0A%20%20%20%20%20%20%20%20template%3A%20%60%3Ccontextmenu-item%20%40on.click%3D%22%24component.onClick()%22%3EHighlight%20it%3C%2Fcontextmenu-item%3E%60%0A%20%20%20%20%7D)%20%7B%0A%20%20%20%20%20%20%20%20static%20getName()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20'highlight-bookmark-contextmenu-item'%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20async%20onClick()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20const%20treeNode%20%3D%20this.parent.getCurrentTarget()%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20const%20nodeData%20%3D%20treeNode.getData()%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20const%20bookmarkData%20%3D%20nodeData.data%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20const%20bookmarkId%20%3D%20bookmarkData.id%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20const%20bookmarkUIService%20%3D%20pdfui.getBookmarkUIService()%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20await%20bookmarkUIService.setColor(bookmarkId%2C%20'%23FF0000'%2C%20bookmarkData.color)%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D%0A%20%20%20%20const%20module%20%3D%20UIExtension.modular.module('custom'%2C%20%5B%5D)%3B%0A%20%20%20%20module.registerComponent(HighlightBookmarkContextMenuItem)%3B%0A%20%20%20%20const%20rootComponent%20%3D%20await%20pdfui.getRootComponent()%3B%0A%20%20%20%20%2F%2F%20Get%20the%20bookmark%20contextmenu%20instance.%0A%20%20%20%20const%20bookmarkContextMenu%20%3D%20rootComponent.querySelector('%40bookmark-v2%3Abookmark-contextmenu')%3B%0A%20%20%20%20%2F%2F%20Insert%20a%20custom%20menu%20item%20at%20the%20end%20of%20the%20bookmark%20contextmenu.%0A%20%20%20%20bookmarkContextMenu.append('%3Ccustom%3Ahighlight-bookmark-contextmenu-item%3E')%3B%0A%7D)()%0A%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("div")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("id")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("pdf-ui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("div")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token style"}},[a("span",{pre:!0,attrs:{class:"token language-css"}},[t._v("\n"),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("overflow")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v("hidden"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v("body")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("height")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 100vh"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v("#pdf-ui")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("position")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" relative"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("top")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 50px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'#pdf-ui'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),t._v("\n        libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/uix-addons/undo-redo'")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("async")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Create a custom menu item component.")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("class")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("HighlightBookmarkContextMenuItem")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("extends")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("SeniorComponentFactory"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("createSuperClass")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Listen to the click event through the @on.click directive.")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('<contextmenu-item @on.click="$component.onClick()">Highlight it</contextmenu-item>')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("static")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getName")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'highlight-bookmark-contextmenu-item'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("async")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("onClick")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" treeNode "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("parent"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getCurrentTarget")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" nodeData "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" treeNode"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getData")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" bookmarkData "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" nodeData"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("data"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" bookmarkId "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" bookmarkData"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("id"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" bookmarkUIService "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" pdfui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getBookmarkUIService")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" bookmarkUIService"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("setColor")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("bookmarkId"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'#FF0000'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" bookmarkData"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("color"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" module "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("modular"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("module")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'custom'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    module"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("registerComponent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("HighlightBookmarkContextMenuItem"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" rootComponent "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" pdfui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getRootComponent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the bookmark contextmenu instance.")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" bookmarkContextMenu "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" rootComponent"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("querySelector")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'@bookmark-v2:bookmark-contextmenu'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Insert a custom menu item at the end of the bookmark contextmenu.")]),t._v("\n    bookmarkContextMenu"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("append")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'<custom:highlight-bookmark-contextmenu-item>'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 500px"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("p",[t._v("This example inserts a custom menu item at the end of the bookmark contextmenu. Clicking this item allows you to set the currently selected bookmark to red. Moreover, this action can be undone or redone using "),a("code",[t._v("Ctrl+Z")]),t._v("/"),a("code",[t._v("Ctrl+Y")]),t._v(". Please note, to enable the undo/redo feature, you need to include "),a("code",[t._v("libPath + '/uix-addons/undo-redo'")]),t._v(" in the "),a("code",[t._v("addons")]),t._v(" configuration when initializing PDFUI, or you can simply configure "),a("code",[t._v("addons: libPath + '/uix-addons/allInOne.js'")]),t._v(" to load all addons.")])])}),[],!1,null,null,null);a.default=n.exports}}]);