(window.webpackJsonp=window.webpackJsonp||[]).push([[80],{417:function(t,a,n){"use strict";n.r(a);var s=n(14),e=Object(s.a)({},(function(){var t=this,a=t._self._c;return a("ContentSlotsDistributor",{attrs:{"slot-key":t.$parent.slotKey}},[a("h1",{attrs:{id:"pdf-action-api-migration-guide"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#pdf-action-api-migration-guide"}},[t._v("#")]),t._v(" PDF Action API Migration Guide")]),t._v(" "),a("p",[t._v("This chapter focuses on the migration of PDF Action related APIs from the previou version to the new version, aiming to assist developers in upgrading their code smoothly.")]),t._v(" "),a("h2",{attrs:{id:"changes-in-action-retrieval-and-manipulation-apis"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#changes-in-action-retrieval-and-manipulation-apis"}},[t._v("#")]),t._v(" Changes in Action Retrieval and Manipulation APIs")]),t._v(" "),a("h3",{attrs:{id:"previous-version"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#previous-version"}},[t._v("#")]),t._v(" Previous Version")]),t._v(" "),a("div",{staticClass:"language-javascript extra-class"},[a("pre",{pre:!0,attrs:{class:"language-javascript"}},[a("code",[a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get Additional Action object")]),t._v("\nWidget"),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("#getAdditionalAction")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("type"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get Action object  ")]),t._v("\nWidget"),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("#getAction")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Remove Additional Action object from a Link ")]),t._v("\nLink"),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("#removeAction")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("trigger"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" action"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Remove Additional Action object from a Screen")]),t._v("\nScreen"),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("#removeAction")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("trigger"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" action"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),a("h3",{attrs:{id:"new-version"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#new-version"}},[t._v("#")]),t._v(" New Version")]),t._v(" "),a("div",{staticClass:"language-javascript extra-class"},[a("pre",{pre:!0,attrs:{class:"language-javascript"}},[a("code",[a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Note: Here, Annot refers to Widget, Screen, Link, and Sound  ")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get Action information  ")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" Annot"),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("#getActionData")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get all Action information (including Additional Action and regular Action)  ")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" Annot"),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("#getAllActionData")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Update a specific Action ")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" Annot"),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("#updateAction")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("targetActionObjNumber"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" actionData"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Remove a specific Action")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" Annot"),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("#removeAction")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("targetActionObjNumber"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the AdditionalAction object ")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" additionalAction "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" Annot"),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("#getAdditionalAction")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Remove an Additional Action based on trigger type and Action object number ")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" additionalAction"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("removeAction")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("trigger"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" targetActionObjNumber"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Add a new Action ")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" additionalAction"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("addAction")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("trigger"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" actionSpec"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Update the information of a specific Action ")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" additionalAction"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("updateActionData")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("trigger"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" targetActionObjNumber"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" actionData"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Override all Action for a specific trigger type")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" additionalAction"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAction")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("trigger"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" actionSpec"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),a("h3",{attrs:{id:"key-changes-description"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#key-changes-description"}},[t._v("#")]),t._v(" Key Changes Description")]),t._v(" "),a("ul",[a("li",[a("p",[t._v("In the previous version, Action was accessed using "),a("code",[t._v("Widget#getAction")]),t._v(" and "),a("code",[t._v("Widget#getAdditionalAction(type)")]),t._v(" methods.")])]),t._v(" "),a("li",[a("p",[t._v("In the new version, Action is managed uniformly through asynchronous methods of the "),a("code",[t._v("Annot")]),t._v(" object, which includes Widget, Screen, Link, and Sound.")])]),t._v(" "),a("li",[a("p",[t._v("The new version adds more granular capabilities for handling Action, such as batch retrieval, updates, and deletions.")])]),t._v(" "),a("li",[a("p",[t._v("For operations related to AdditionalAction, the new version requires first obtaining the AdditionalAction object via the "),a("code",[t._v("Annot#getAdditionalAction()")]),t._v(" method, followed by performing actions such as adding, removing, updating, and querying.")])])]),t._v(" "),a("h2",{attrs:{id:"actioncallbackmanager-setembeddedgotocallback-callback-parameter-changes"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#actioncallbackmanager-setembeddedgotocallback-callback-parameter-changes"}},[t._v("#")]),t._v(" ActionCallbackManager.setEmbeddedGotoCallback - Callback Parameter Changes")]),t._v(" "),a("h3",{attrs:{id:"previous-version-2"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#previous-version-2"}},[t._v("#")]),t._v(" Previous Version")]),t._v(" "),a("p",[t._v("In the previous version, the callback parameter was an "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_embedded_goto_action.html",target:"_blank",rel:"noopener noreferrer"}},[a("code",[t._v("EmbeddedGotoAction")]),a("OutboundLink")],1),t._v(" object:")]),t._v(" "),a("div",{staticClass:"language-javascript extra-class"},[a("pre",{pre:!0,attrs:{class:"language-javascript"}},[a("code",[a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" actionCallbackManager "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" actionpdfviewer"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getActionCallbackManager")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\nactionCallbackManager"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("setEmbeddedGotoCallback")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("async")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    console"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("log")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("action"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getDestination")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),a("h3",{attrs:{id:"new-version-2"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#new-version-2"}},[t._v("#")]),t._v(" New Version")]),t._v(" "),a("p",[t._v("In the new version, the callback parameter is an "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_execute_action_options.html",target:"_blank",rel:"noopener noreferrer"}},[a("code",[t._v("ExecuteActionOptions")]),a("OutboundLink")],1),t._v(" object:")]),t._v(" "),a("div",{staticClass:"language-javascript extra-class"},[a("pre",{pre:!0,attrs:{class:"language-javascript"}},[a("code",[a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" actionCallbackManager "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" actionpdfviewer"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getActionCallbackManager")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\nactionCallbackManager"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("setEmbeddedGotoCallback")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("async")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("options")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    console"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("log")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("\n        options"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("data"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n        options"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("doc"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n        options"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ownerQuery"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n        options"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("pdfViewer"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n        options"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("trigger\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),a("h4",{attrs:{id:"major-changes-description"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#major-changes-description"}},[t._v("#")]),t._v(" Major Changes Description")]),t._v(" "),a("ul",[a("li",[t._v("The callback parameter in the new version is more comprehensive, including action data, document objects, and trigger sources, making it easier for developers to implement more complex business logic.")]),t._v(" "),a("li",[t._v("For specific fields, please refer to the "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html",target:"_blank",rel:"noopener noreferrer"}},[t._v("API Documentation"),a("OutboundLink")],1),t._v(".")])]),t._v(" "),a("hr"),t._v(" "),a("p",[t._v("For more detailed information, please refer to the "),a("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html",target:"_blank",rel:"noopener noreferrer"}},[t._v("API Reference Documentation"),a("OutboundLink")],1),t._v(".")])])}),[],!1,null,null,null);a.default=e.exports}}]);