(window.webpackJsonp=window.webpackJsonp||[]).push([[83],{410:function(e,t,r){"use strict";r.r(t);var s=r(14),a=Object(s.a)({},(function(){var e=this,t=e._self._c;return t("ContentSlotsDistributor",{attrs:{"slot-key":e.$parent.slotKey}},[t("h1",{attrs:{id:"integration-of-serviceworker"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#integration-of-serviceworker"}},[e._v("#")]),e._v(" Integration of ServiceWorker")]),e._v(" "),t("h2",{attrs:{id:"purpose"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#purpose"}},[e._v("#")]),e._v(" Purpose")]),e._v(" "),t("p",[e._v("This section aims to provide developers a comprehensive guide for integrating and consolidating the built-in ServiceWorker functionality in the SDK at the application layer. It addresses the ServiceWorker conflict issues and common problems.")]),e._v(" "),t("p",[e._v("Although the browser allows multiple Service Workers to be registered in the same domain, these Service Workers must have different scopes. In this way, each Service Worker can independently control the resources under different scopes. However, "),t("code",[e._v("MessageWorker.js")]),e._v(" occupies a scope (default is '/'), which will cause the application layer's Service Worker to fail to register successfully in the same scope. Therefore, when the Service Worker at the application layer needs to share the same scope with the SDK's built-in "),t("code",[e._v("MessageWorker.js")]),e._v(", they need to be merged into a single file.")]),e._v(" "),t("p",[e._v("This section will introduce how to merge and customize parameters related to Service Worker configuration.")]),e._v(" "),t("h2",{attrs:{id:"introduction-to-serviceworker"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#introduction-to-serviceworker"}},[e._v("#")]),e._v(" Introduction to ServiceWorker")]),e._v(" "),t("p",[e._v("Service Worker is a script that runs in the background of a browser, which can be used to implement offline capabilities, push notifications, background synchronization, and other features. After the webpage is fully loaded, it operates in the background and can intercept network requests, cache resources, and provide other functions.")]),e._v(" "),t("p",[t("strong",[e._v("Key features of ServiceWorker：")])]),e._v(" "),t("ul",[t("li",[t("strong",[e._v("Offline Capabilities")]),e._v(": ServiceWorker can cache resources, allowing users to access websites even when the network is disconnected.")]),e._v(" "),t("li",[t("strong",[e._v("Push Notifications")]),e._v(": ServiceWorker can receive push notifications from the server and display messages to the user.")]),e._v(" "),t("li",[t("strong",[e._v("Background Synchronization")]),e._v(": ServiceWorker can perform tasks in the background, such as uploading data or updating data.")]),e._v(" "),t("li",[t("strong",[e._v("Network Interception")]),e._v(": ServiceWorker can intercept network requests and process them as needed, such as caching data or modifying request headers.")])]),e._v(" "),t("h2",{attrs:{id:"overview-of-messageworker-js"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#overview-of-messageworker-js"}},[e._v("#")]),e._v(" Overview of MessageWorker.js")]),e._v(" "),t("p",[t("code",[e._v("MessageWorker.js")]),e._v(" is a Service Worker script provided by the SDK to implement synchronous communication in the Web Worker layer. Since "),t("code",[e._v("MessageWorker.js")]),e._v(" occupies an independent scope, when the application layer's Service Worker needs to use the same scope, the two need to be merged into a single file.")]),e._v(" "),t("h2",{attrs:{id:"environment-setup"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#environment-setup"}},[e._v("#")]),e._v(" Environment Setup")]),e._v(" "),t("p",[e._v("Before starting to integrate Service Worker, please ensure your development environment meets the following requirements:")]),e._v(" "),t("ul",[t("li",[t("p",[e._v("Browser supporting Service Worker: Ensure your target browser supports Service Worker, such as Chrome, Firefox, and Edge. For more specific information, you can refer to "),t("a",{attrs:{href:"https://caniuse.com/serviceworkers",target:"_blank",rel:"noopener noreferrer"}},[e._v("Can I use"),t("OutboundLink")],1),e._v(".")])]),e._v(" "),t("li",[t("p",[t("code",[e._v("@foxitsoftware/foxit-pdf-sdk-for-web-library")]),e._v(": The version must be "),t("code",[e._v("10.0.0")]),e._v(" or higher, and the "),t("code",[e._v("lib")]),e._v(" directory should contain the "),t("code",[e._v("MessageWorker.js")]),e._v(" file.")])]),e._v(" "),t("li",[t("p",[e._v("HTTPS support: Your website must be accessed via HTTPS to use Service Worker. However, there are exceptions for the development environment. "),t("code",[e._v("localhost")]),e._v(" and "),t("code",[e._v("127.0.0.1")]),e._v(" can use Service Worker without enabling HTTPS access.")])])]),e._v(" "),t("h2",{attrs:{id:"registration-and-configuration-of-service-worker"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#registration-and-configuration-of-service-worker"}},[e._v("#")]),e._v(" Registration and Configuration of Service Worker")]),e._v(" "),t("p",[e._v("Starting from "),t("code",[e._v("10.0.0")]),e._v(", a new "),t("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_p_d_f_viewer.html",target:"_blank",rel:"noopener noreferrer"}},[t("code",[e._v("messageSyncServiceWorker")]),t("OutboundLink")],1),e._v(" parameter has been added to the "),t("code",[e._v("PDFViewer")]),e._v(" constructor arguments, used for specifying the registration method of the Service Worker.")]),e._v(" "),t("p",[e._v("There are two ways to use "),t("code",[e._v("messageSyncServiceWorker")]),e._v(":")]),e._v(" "),t("ol",[t("li",[t("p",[e._v("Method 1: Specify "),t("code",[e._v("url")]),e._v(" and "),t("code",[e._v("options")]),e._v(":")]),e._v(" "),t("ul",[t("li",[t("code",[e._v("url")]),e._v(" is the registration path for the Service Worker;")]),e._v(" "),t("li",[t("code",[e._v("options")]),e._v(" are the registration options for the Service Worker, you can refer to the specific description in "),t("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/ServiceWorkerContainer/register#options",target:"_blank",rel:"noopener noreferrer"}},[e._v("MDN"),t("OutboundLink")],1),e._v(".")])]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("const")]),e._v(" viewer "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("new")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token class-name"}},[e._v("PDFViewer")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("messageSyncServiceWorker")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("url")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'/your-service-worker.js'")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("options")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// Optional")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("scope")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'/foxit-lib/'")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// ... Other parameters")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v("\n")])])])]),e._v(" "),t("li",[t("p",[e._v("Method 2: Specify "),t("code",[e._v("registration")]),e._v(":")]),e._v(" "),t("ul",[t("li",[t("code",[e._v("registration")]),e._v(" is the "),t("code",[e._v("Promise<ServiceWorkerRegistration>")]),e._v(" object returned by the "),t("code",[e._v("navigator.serviceWorker.register()")]),e._v(" method.")])]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("const")]),e._v(" viewer "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("new")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token class-name"}},[e._v("PDFViewer")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("messageSyncServiceWorker")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("registration")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("register")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'/your-service-worker.js'")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("scope")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'/foxit-lib/'")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// ... Other parameters")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v("\n")])])])])]),e._v(" "),t("p",[e._v("Method 1 will be determined by the SDK internally as to when to register the ServiceWorker. If you need to manually control the registration of the ServiceWorker, you must use method 2.")]),e._v(" "),t("p",[e._v("In the SDK release package, we have provided a complete example ("),t("code",[e._v("/examples/PDFViewCtrl/integrate-service-worker")]),e._v("). You can directly refer to its implementation and run and view the effects according to the README.md document.")]),e._v(" "),t("h2",{attrs:{id:"service-worker-allowed-response-header"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#service-worker-allowed-response-header"}},[e._v("#")]),e._v(" "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" Response Header")]),e._v(" "),t("p",[e._v("By default, the max scope allowed by a Service Worker is determined by its script location. Specifically, the scope of the Service Worker can only cover the directory where its script is located and its subdirectories. For example, if the Service Worker script is located at "),t("code",[e._v("https://example.com/sub/worker.js")]),e._v(", it can only control resources under "),t("code",[e._v("https://example.com/sub/")]),e._v(" and its subpaths by default. If you forcibly specify the scope parameter to a larger scope, it will lead to the failure of the Service Worker registration, and the error message will be: "),t("code",[e._v("The path of the provided scope ('/') is not under the max scope allowed ('/sub/')")]),e._v(".")]),e._v(" "),t("p",[e._v("However, in some cases, you may want to expand the scope of the Service Worker so that it can control resources within a larger range. At this point, the "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" response header becomes particularly important. By configuring this response header, you can specify a broader path, allowing the Service Worker to be effective within a larger scope.")]),e._v(" "),t("h3",{attrs:{id:"configuring-service-worker-allowed-response-header"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#configuring-service-worker-allowed-response-header"}},[e._v("#")]),e._v(" Configuring "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" Response Header")]),e._v(" "),t("p",[e._v("To use the "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" response header, you need to include the following field in the HTTP response header of the Service Worker script. Its value is the max scope path allowed:")]),e._v(" "),t("div",{staticClass:"language-http extra-class"},[t("pre",{pre:!0,attrs:{class:"language-http"}},[t("code",[e._v("Service-Worker-Allowed /;\n")])])]),t("h4",{attrs:{id:"nginx-configuration-example"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#nginx-configuration-example"}},[e._v("#")]),e._v(" Nginx Configuration Example")]),e._v(" "),t("p",[e._v("If you are using Nginx as your server, you can include the "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" response header by modifying the Nginx configuration file. Below is a configuration example:")]),e._v(" "),t("div",{staticClass:"language-nginx extra-class"},[t("pre",{pre:!0,attrs:{class:"language-nginx"}},[t("code",[t("span",{pre:!0,attrs:{class:"token directive"}},[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("server")])]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token directive"}},[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("location")]),e._v(" /sw.js")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token directive"}},[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("add_header")]),e._v(" Service-Worker-Allowed /")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n")])])]),t("h4",{attrs:{id:"webpack-dev-server-configuration-example"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#webpack-dev-server-configuration-example"}},[e._v("#")]),e._v(" Webpack Dev Server Configuration Example")]),e._v(" "),t("p",[e._v("If you are using Webpack Dev Server for local development, you can include the "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" response header by configuring devServer. Below is a configuration example:")]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// webpack.config.js")]),e._v("\nmodule"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("exports "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("//  Other configurations")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("devServer")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("headers")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token string-property property"}},[e._v("'Service-Worker-Allowed'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'/'")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n")])])]),t("h4",{attrs:{id:"vue-config-js-configuration-example"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#vue-config-js-configuration-example"}},[e._v("#")]),e._v(" vue.config.js Configuration Example")]),e._v(" "),t("p",[e._v("If you are using Vue CLI, you can adjust the Webpack Dev Server by modifying "),t("code",[e._v("vue.config.js")]),e._v(". Below is a configuration example:")]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// vue.config.js")]),e._v("\nmodule"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("exports "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("devServer")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("headers")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token string-property property"}},[e._v("'Service-Worker-Allowed'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'/'")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n")])])]),t("h2",{attrs:{id:"special-request-address"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#special-request-address"}},[e._v("#")]),e._v(" Special Request Address")]),e._v(" "),t("p",[e._v("In the "),t("code",[e._v("fetch")]),e._v(" event listened by the Service Worker in the application layer, if the request address matches "),t("code",[e._v("__foxitwebsdk-syncmsg__")]),e._v(", please ignore this request directly. This is also mentioned in our example code ("),t("code",[e._v("examples/PDFViewCtrl/integrate-service-worker/src/service-worker.js")]),e._v(").")]),e._v(" "),t("h2",{attrs:{id:"common-questions-and-troubleshooting"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#common-questions-and-troubleshooting"}},[e._v("#")]),e._v(" Common Questions and Troubleshooting")]),e._v(" "),t("ol",[t("li",[t("p",[e._v("ServiceWorker Not Registered")]),e._v(" "),t("ul",[t("li",[t("p",[e._v("Issue description: Unable to find the ServiceWorker registration results in the developer tools.")])]),e._v(" "),t("li",[t("p",[e._v("Possible reasons:")]),e._v(" "),t("ol",[t("li",[e._v("The path is set incorrectly, and the Service Worker js request returns 404 or other errors.")]),e._v(" "),t("li",[e._v("The browser does not support ServiceWorker.")]),e._v(" "),t("li",[e._v("The HTTPS protocol is not enabled. For security reasons, ServiceWorker can only be used under the HTTPS protocol. An exception to this is localhost and 127.0.0.1, which do not require HTTPS.")])])]),e._v(" "),t("li",[t("p",[e._v("Solutions:")]),e._v(" "),t("ol",[t("li",[e._v("Check the Service Worker's registration code and path configurations.")]),e._v(" "),t("li",[e._v("Check browser compatibility. For Service Worker compatibility, please refer to "),t("a",{attrs:{href:"https://caniuse.com/serviceworkers",target:"_blank",rel:"noopener noreferrer"}},[e._v("Can I use"),t("OutboundLink")],1),e._v(".")]),e._v(" "),t("li",[e._v("Enable HTTPS protocol.")])])])])]),e._v(" "),t("li",[t("p",[e._v("ServiceWorker Registration Failed")]),e._v(" "),t("ul",[t("li",[e._v("Issue description：A prompt during registration indicates that the scope exceeds the max scope allowed.\nExample of error message:")])]),e._v(" "),t("div",{staticClass:"language-log extra-class"},[t("pre",{pre:!0,attrs:{class:"language-log"}},[t("code",[e._v("    register a ServiceWorker for scope "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'http://localhost:9899/'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),e._v(" with script "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'http://localhost:9899/lib/MessageWorker.js?b=http://localhost:9899/__foxitwebsdk-syncmsg__'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" The path of the provided scope "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'/'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),e._v(" is not under the max scope allowed "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'/lib/'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v(" Adjust the scope"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v(" move the Service Worker script"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v(" or use the Service"),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("-")]),e._v("Worker"),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("-")]),e._v("Allowed HTTP header to allow the scope"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("\n")])])]),t("ul",[t("li",[t("p",[e._v("Possible reasons: The registration path or scope of the Service Worker is not set correctly. It should be noted that the max scope allowed by the Service Worker depends on the location of the Service Worker script itself (refer to: "),t("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API/Using_Service_Workers#why_is_my_service_worker_failing_to_register",target:"_blank",rel:"noopener noreferrer"}},[e._v("MDN"),t("OutboundLink")],1),e._v(").")])]),e._v(" "),t("li",[t("p",[e._v("Solutions:")]),e._v(" "),t("ol",[t("li",[e._v("Understand the scope rules of Service Worker.")]),e._v(" "),t("li",[e._v("Check the registration code and scope settings of Service Worker.")]),e._v(" "),t("li",[e._v("Adjust the scope of Service Worker, that is, modify the "),t("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/ServiceWorkerContainer/register#scope",target:"_blank",rel:"noopener noreferrer"}},[e._v("scope"),t("OutboundLink")],1),e._v(" parameter.")]),e._v(" "),t("li",[e._v("Adjust the "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" HTTP response header to allow a larger scope.")]),e._v(" "),t("li",[e._v("Check the path of Service Worker script and server configuration.")])])])])]),e._v(" "),t("li",[t("p",[e._v("ServiceWorker Registration Indicates Unsupported MIME Type")]),e._v(" "),t("ul",[t("li",[e._v("Issue description: A prompt during registration indicates an unsupported MIME type ('***/***').\nExample of error message:")])]),e._v(" "),t("div",{staticClass:"language-log extra-class"},[t("pre",{pre:!0,attrs:{class:"language-log"}},[t("code",[e._v("Failed to register a ServiceWorker for scope "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'http://localhost:5173/assets/'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),e._v(" with script "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'http://localhost:5173/assets/service-worker.js'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" The script has an unsupported MIME type "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'text/html'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("\n")])])]),t("ul",[t("li",[e._v("Possible reasons: The registration path of the ServiceWorker is incorrect or the target file does not exist.")]),e._v(" "),t("li",[e._v("Solutions:\n"),t("ol",[t("li",[e._v("Check the registration path of the ServiceWorker.")]),e._v(" "),t("li",[e._v("Check if the target file exists.")]),e._v(" "),t("li",[e._v("Check the server configuration.")])])])])]),e._v(" "),t("li",[t("p",[e._v("Browser Forced Refresh Prevents ServiceWorker from Intercepting Requests")]),e._v(" "),t("ul",[t("li",[e._v("Issue Description: Refer to the "),t("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/ServiceWorkerContainer/controller",target:"_blank",rel:"noopener noreferrer"}},[e._v("MDN: ServiceWorkerContainer: controller property"),t("OutboundLink")],1),e._v(" documentation, which describes that after a user performs a forced refresh (Shift + Refresh) of the page, the service worker loses control of the page, and the "),t("code",[e._v("navigator.serviceWorker.controller")]),e._v(" property is set to null.")]),e._v(" "),t("li",[e._v("Possible Cause: The built-in "),t("code",[e._v("MessageWorker.js")]),e._v(" of the SDK has automatically handled this issue. If your ServiceWorker code does not reuse MessageWorker.js and does not handle this situation, this phenomenon may occur.")]),e._v(" "),t("li",[e._v("Solution:\n"),t("ol",[t("li",[e._v("After successfully registering the serviceWorker, check if "),t("code",[e._v("navigator.serviceWorker.controller")]),e._v(" is null.")]),e._v(" "),t("li",[e._v("If it is null, send a message to the ServiceWorker via the "),t("em",[t("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/ServiceWorkerRegistration",target:"_blank",rel:"noopener noreferrer"}},[e._v("registration"),t("OutboundLink")],1),e._v(".active.postMessage")]),e._v(" method, for example, the message we send is: "),t("code",[e._v("{id: 'clientsClaim'}")]),e._v(".")]),e._v(" "),t("li",[e._v("Listen for this message in the ServiceWorker context and call the "),t("code",[e._v("clients.claim()")]),e._v(" method after receiving the message.")])])])]),e._v(" "),t("p",[e._v("Here is a simple example:")]),e._v(" "),t("p",[e._v("main.js:")]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("const")]),e._v(" registration "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("await")]),e._v(" navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("register")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"service-worker.js"')]),e._v(" "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("/* ... more options */")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("if")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("!")]),e._v("navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("controller "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("&&")]),e._v(" registration"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("active"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("function")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("onControllerChange")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("removeEventListener")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"controllerchange"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n            onControllerChange\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("if")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("controller"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("resolve")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token boolean"}},[e._v("true")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n    navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("addEventListener")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"controllerchange"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n        onControllerChange\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n    registration"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("active"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("postMessage")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("id")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"clientsClaim"')]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("const")]),e._v(" pdfViewer "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v("  "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("new")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token class-name"}},[e._v("PDFViewCtrl"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("PDFViewer")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n   "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("messageSyncServiceWorker")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n       "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("registration")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" registration"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n   "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n")])])]),t("p",[e._v("service-worker.js")]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// ......")]),e._v("\nself"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("addEventListener")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"message"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token parameter"}},[e._v("e")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=>")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("if")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("e"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("data"),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("?.")]),e._v("id "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("===")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"clientsClaim"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// Set the current service worker as the controller for all clients within its scope")]),e._v("\n        clients"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("claim")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n")])])])])]),e._v(" "),t("h2",{attrs:{id:"serviceworker-use-cases"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#serviceworker-use-cases"}},[e._v("#")]),e._v(" ServiceWorker Use Cases")]),e._v(" "),t("p",[e._v("Foxit PDF SDK for Web uses ServiceWorker to optimize the user's interactive experience and solve interaction-related issues. Currently, ServiceWorker is utilized to handle local font access authorization, form filling functionality, and execution of JavaScript scripts for form fields and dynamic XFA elements in the user interface.")])])}),[],!1,null,null,null);t.default=a.exports}}]);