(window.webpackJsonp=window.webpackJsonp||[]).push([[78],{408:function(t,a,s){"use strict";s.r(a);var n=s(14),e=Object(n.a)({},(function(){var t=this,a=t._self._c;return a("ContentSlotsDistributor",{attrs:{"slot-key":t.$parent.slotKey}},[a("h1",{attrs:{id:"signature-service-api"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#signature-service-api"}},[t._v("#")]),t._v(" Signature Service API")]),t._v(" "),a("h2",{attrs:{id:"overview"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#overview"}},[t._v("#")]),t._v(" Overview")]),t._v(" "),a("p",[t._v("The "),a("code",[t._v("SignatureService")]),t._v(" class is designed for customizing the PDF signature validation logic. By configuring a custom signature verification callback, developers can forward signature validation requests to backend services or integrate third-party verification mechanisms.")]),t._v(" "),a("h2",{attrs:{id:"main-methods"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#main-methods"}},[t._v("#")]),t._v(" Main Methods")]),t._v(" "),a("h3",{attrs:{id:"setverifyhandler-handler-verifysignaturehandler"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#setverifyhandler-handler-verifysignaturehandler"}},[t._v("#")]),t._v(" setVerifyHandler(handler: VerifySignatureHandler)")]),t._v(" "),a("ul",[a("li",[a("strong",[t._v("Functionality")]),t._v(": Set the signature verification callback function. When the PDF viewer needs to validate a signature, it will invoke this "),a("code",[t._v("handler")]),t._v(".")]),t._v(" "),a("li",[a("strong",[t._v("Parameters")]),t._v(":\n"),a("ul",[a("li",[a("code",[t._v("handler")]),t._v(": A function of type "),a("code",[t._v("VerifySignatureHandler")]),t._v(", which handles signature verification.")])])]),t._v(" "),a("li",[a("strong",[t._v("Return Value")]),t._v(": None")]),t._v(" "),a("li",[a("strong",[t._v("Version")]),t._v(": Supported since version 11.0.0")])]),t._v(" "),a("h4",{attrs:{id:"description-of-handler"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#description-of-handler"}},[t._v("#")]),t._v(" Description of "),a("code",[t._v("handler")])]),t._v(" "),a("ul",[a("li",[a("p",[a("code",[t._v("handler")]),t._v(" is an asynchronous function, typically defined as follows")]),t._v(" "),a("div",{staticClass:"language-js extra-class"},[a("pre",{pre:!0,attrs:{class:"language-js"}},[a("code",[a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("async")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("signatureField"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" plainContent"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" signedData"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" hasDataOutOfScope")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("...")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("li",[a("p",[t._v("Within the "),a("code",[t._v("handler")]),t._v(", developers can access information related to the signature field (e.g., "),a("code",[t._v("filter")]),t._v(", "),a("code",[t._v("subfilter")]),t._v(", "),a("code",[t._v("signer")]),t._v(") and forward the original content and signature data to backend services for validation.")])])]),t._v(" "),a("h2",{attrs:{id:"signature-verification-process-description"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#signature-verification-process-description"}},[t._v("#")]),t._v(" Signature Verification Process Description")]),t._v(" "),a("ul",[a("li",[a("p",[t._v("The signature verification process is triggered in the following scenarios:")]),t._v(" "),a("ol",[a("li",[a("p",[a("strong",[t._v("Triggered by JavaScript Action")]),t._v(": For example, when the document is opened (PDFDoc open action) or when the mouse button is released over the annotation area (ANNOT_MOUSE_BUTTON_RELEASED), signature verification is performed automatically.")])]),t._v(" "),a("li",[a("p",[a("strong",[t._v("Triggered by User Action")]),t._v(": When the user clicks on a signed signature field, the signature verification process is initiated.")])]),t._v(" "),a("li",[a("p",[a("strong",[t._v("Calling the "),a("code",[t._v("PDFSignature.verify")]),t._v(" Method")]),t._v(": When using the "),a("code",[t._v("verify")]),t._v(" method in "),a("code",[t._v("PDFSignature")]),t._v(", if the "),a("code",[t._v("verifyHandler")]),t._v(" option is not specified, the "),a("code",[t._v("handler")]),t._v(" set via "),a("code",[t._v("SignatureService.setVerifyHandler")]),t._v(" will be used by default.")])])])]),t._v(" "),a("li",[a("p",[a("strong",[t._v("Note")]),t._v("：")]),t._v(" "),a("ul",[a("li",[t._v("The "),a("code",[t._v("PDFDoc.verifySignature")]),t._v(" method does not use the "),a("code",[t._v("handler")]),t._v(" set in "),a("code",[t._v("SignatureService")]),t._v(" by default; you need to specify it explicitly.")])])])]),t._v(" "),a("h2",{attrs:{id:"example"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#example"}},[t._v("#")]),t._v(" Example")]),t._v(" "),a("div",{staticClass:"language-js extra-class"},[a("pre",{pre:!0,attrs:{class:"language-js"}},[a("code",[a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" service "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" pdfViewer"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getSignatureService")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\nservice"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("setVerifyHandler")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("async")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("signatureField"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" plainContent"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" signedData"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" hasDataOutOfScope")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" filter "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" signatureField"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getFilter")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" subfilter "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" signatureField"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getSubfilter")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" signer "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" signatureField"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getSigner")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" formdata "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("FormData")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    formdata"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("append")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"filter"')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" filter"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    formdata"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("append")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"subfilter"')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" subfilter"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    formdata"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("append")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"signer"')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" signer"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    formdata"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("append")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"plainContent"')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("Blob")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),t._v("plainContent"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"plainContent"')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    formdata"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("append")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"signedData"')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("Blob")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),t._v("signedData"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"signedData"')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    \n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" response "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("fetch")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'https://<server>:<port>/<path/to/>verify'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("method")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'POST'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("body")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" formdata\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("parseInt")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" response"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("text")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),a("hr"),t._v(" "),a("h2",{attrs:{id:"notes"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#notes"}},[t._v("#")]),t._v(" Notes")]),t._v(" "),a("ul",[a("li",[a("p",[a("strong",[t._v("Must Set a Verification Callback")]),t._v(": Before initiating the signature verification process, make sure to set the "),a("code",[t._v("handler")]),t._v(" using "),a("code",[t._v("SignatureService.setVerifyHandler")]),t._v("; otherwise, the verification process will throw an exception.")])]),t._v(" "),a("li",[a("p",[a("strong",[t._v("Handler Return Value")]),t._v(": The "),a("code",[t._v("handler")]),t._v(" should return a numeric value representing the verification result (refer to the "),a("RouterLink",{attrs:{to:"/main/form/signature-fields.html"}},[t._v("Form Signature Fields")]),t._v(" documentation for related information).")],1)]),t._v(" "),a("li",[a("p",[a("strong",[t._v("Asynchronous Support")]),t._v(": The "),a("code",[t._v("handler")]),t._v(" supports asynchronous operations, making it convenient for integration with backend services.")])]),t._v(" "),a("li",[a("p",[a("strong",[t._v("Scope of Applicability")]),t._v(": The "),a("code",[t._v("handler")]),t._v(" set in "),a("code",[t._v("SignatureService")]),t._v(" is only effective for JavaScript Action verification processes and when "),a("code",[t._v("PDFSignature.verify")]),t._v(" does not specify a "),a("code",[t._v("handler")]),t._v(". It does not apply to "),a("code",[t._v("PDFDoc.verifySignature")]),t._v(".\n:")])])])])}),[],!1,null,null,null);a.default=e.exports}}]);