# Foxit PDF SDK for Web 11.0.5

**Version**: 11.0.5 Hotfix  
**Release Date**: November 7, 2025

## Overview

Foxit PDF SDK for Web 11.0.5 provides a hotfix addressing several critical issues related to annotation functionality, shortcut key handling, printing, digital signatures, stamp customization, and document loading performance.

## Bug Fixes

### Annotation Functionality Fixes

#### Annotation Display and Loading  
- Fixed an issue where not all annotations in a PDF were displayed correctly. The problem occurred when certain special highlight annotations caused errors during annotation loading, preventing all annotations from being rendered properly.

#### Annotation Permission Control Fixes 
- Fixed an issue where annotation permission settings were not fully effective. When annotation permissions were restricted to only allow deletion (using `setAnnotPermissionCallback()` with `ANNOTATION_PERMISSION.deletable`), the right-click context menu still allowed position adjustments such as Center and other alignment options.

### Shortcut Key Functionality Fixes

- Fixed an issue where the method `offShortcutKey("ctrl+v")` for disabling paste shortcut keys was ineffective.

### Printing Functionality Fixes

- Fixed an issue where printing failed when using the system dialog for printing. The issue was caused by the `print-js` library removing the hidden iframe element too quickly after the print dialog closed.  

### Digital Signature Functionality Fixes

- Fixed an issue where reopening a document did not automatically navigate to the signature field location.

### Stamp Functionality Fixes

- Fixed the issue where custom dynamic stamp icons added via `pdfui.callAddonAPI()` were displayed without layut spacing style between icons in the stamp list after initialization.

## Performance Optimizations

- Optimized the first-page loading performance of linearized documents - reduced loading time from 30 minutes to 1 second.

# Foxit PDF SDK for Web 11.0.4

**Version**: 11.0.4 Hotfix  
**Release Date**: September 19, 2025

## Overview

Foxit PDF SDK for Web 11.0.4 fixes multiple critical issues, primarily involving annotation functionality, form processing, rendering performance, and user interface. This version includes multiple important bug fixes that improve overall stability and user experience.

## Bug Fixes

### Annotation Functionality Fixes

#### Callout Annotation Improvements
- Fixed multiple display and editing issues with Callout annotations, including:
  - Annotations not displaying properly in specific documents
  - Inability to add annotations on the left side of pages
  - Text input loss issues
  - Abnormal default rectangle size problems
  - Extra whitespace added during text scaling

#### TextBox and Rich Text Annotation Optimization
- Fixed TextBox annotation width display issues - no longer shrinks abnormally when adding large amounts of text
- Optimized rich text annotation font handling, resolving display anomalies during font setting and modification

#### Note Annotation Configuration Fix
- Fixed the issue where `setDefaultAnnotConfig` was ineffective for Note annotations - now properly sets default colors and other properties

### Form Functionality Fixes

- Fixed the issue where form fields remained editable in read-only mode - `getDocPermissions` read-only mode now correctly controls form field editing permissions
- Fixed the reversed logic issue in form field copy creation quantity handling - vertical and horizontal copy field quantities are now processed correctly

### Rendering and Performance Fixes

- Fixed the issue where large file `render` conversion would error midway - optimized image resource release mechanism, now handles large file image conversion properly
- Fixed the issue where `page.render` converted images had no background color - converted image background colors now remain consistent with version 10

### User Interface Fixes

- Fixed the issue where sidebar dragging was not smooth - dragging operations are now more fluid and natural

### Other Functionality Fixes

- Fixed FDF export/import display inconsistency issues - exported and re-imported content now displays consistently with the original
- Fixed the issue where page links could not navigate - now properly navigates to target pages
- Fixed the area highlight export/import issues - area highlights can now be correctly exported and imported.

### Browser Compatibility Fixes

- Fixed compatibility issues with older browser kernels Chromium v86.x - now runs properly in more browser environments


# What's new in Foxit PDF SDK for Web 11.0.3
**Version**: 11.0.3 Hotfix  
**Release Date**: July 15, 2025

## Bug Fixes
- Fixed the issue where custom stamps display abnormally after page rotation - stamps now display correctly without compression.



# What's new in Foxit PDF SDK for Web 11.0.2
**Version**: 11.0.2 Hotfix  
**Release Date**: July 9, 2025

## Bug Fixes
* Fixed abnormal image content generated when using the page.render() method for page rendering.
* Fixed interaction conflicts between annotation selection and form elements.
* Fixed relative path resolution issue for fontMaps loading.
* Fixed page not refreshing when rotating left thumbnail in text editing mode.



# What's new in Foxit PDF SDK for Web 11.0  
**Release Date: June 30, 2025**

## Major Changes

### Form Module Refactor

The form module (including Form scripting execution) has been completely refactored in version 11.0 to deliver **faster rendering**, **native-like visual fidelity**, and **more robust API capabilities**. These changes introduce breaking updates and are **not backward-compatible** with old versions.

**Removed APIs**

The following legacy form-related APIs have been removed and replaced with a new form architecture:

* `PDF.form.PDFControl`
* `PDF.form.PDFField`
* `PDF.form.PDFForm`
* `PDFDoc.loadPDFForm`

**Impact**

- **API Changes**: Any code relying on the removed interfaces must be updated to the new APIs.
- **Rendering Behavior Change**: Form fields are no longer rendered using separate DOM elements. They are now drawn directly by the PDF rendering engine.
- **Form JavaScript Scripting Architecture Upgrade**:
    * Form JavaScript execution context has been migrated to `Web Worker`, ensuring the main thread security operations.
    * Core Form JavaScript APIs have been refactored to `C++/WebAssembly` implementation.

**Replacement**

* Use the following new form-related APIs:

   * `PDF.form.PDFForm`
   * `PDF.form.PDFFormField`
   * `PDFViewCtrl.form.FormFillerService`
   * `addons.form_designer_addon`

* Refer to the **PDF Form API Migration Guide** in the Developer Guide for complete migration details.

---

### Signature Workflow Refactor

The signature and verification workflow for both **standard AcroForm** and **dynamic XFA forms** has been redesigned for improved usability and maintainability.

**Deprecated APIs**

- `PDFUI.registerSignatureFlowHandler`
- `PDFUI.setVerifyHandler`

**Impact**

These APIs remain available in version 11.0 for backward compatibility but will be **removed in a future release**. Please plan your migration accordingly.

**Replacement**

* Use the new signature workflow interfaces:

  * `PDF.form.signatureService`
  * `PDF.form.SignatureWorkflowService` 

* Refer to the **Signature Workflow API Migration Guide** in the Developer Guide for full details and examples.
---
### Action Module Refactor

Deprecated old action API system in favor of more efficient approaches.

**Deprecated APIs**

* PDF.actions.action

**Impact**
These APIs are still available in version 11.0 for backward compatibility but will be **removed in a future release**. If your application depends on these APIs, we strongly recommend migrating to the new API system now.

**Replacement**

* Refer to the `Upgrade Guide for Action APIs` in the Developer Guide for instructions on migrating to the new Action API system.

---

### Legacy Bookmark API Cleanup

All legacy bookmark-related APIs deprecated in earlier versions have now been fully removed.

**Impact**

* Any applications still using the old bookmark APIs will no longer function correctly in version 11.0.

**Replacement**

* Refer to the **Bookmark API Migration Guide** in the Developer Guide for the proper migration path.

---

## New Features & Enhancements

### Form Enhancements

- New `form-designer-addon` plugin API module for controling and update field properties with real-time listeners.
- New `FormFillerService` class for managing PDF form field filling, interactive behaviors, and design mode, including event handling and state control during interaction.
- New API `pdfDoc.autoRecognitionForm({ isSetTooltip: true })` controls whether tooltips are set during auto-recognition.

### Signature Enhancements
- New API `IViewerUI.getSignatureUI()` to customize the signature-related UI (e.g., signing, verification, and signature property UI). 
- New class `PDFViewCtrl.annotComponents.SignatureAnnot` to enable creating, signing, verifying, and handling interactions with signature fields.
- New Class `SignatureWorkflowService` to control the signature workflow.
- New class `SignatureService` to enable integration with backend systems or third-party services to perform custom signature verification logic.
- New additional parameters to `pdfDoc.sign()` that includes `FontName`, `FontSize`, `iconFontName`, and `iconFontSize`.
- New API `pdfsignature.getSignatureType()` to retrieve the signature type.

### Action Enhancements

- **GoToR Action Support**:
  - UI now supports creating `GoToR` actions.
  - New class: `RemoteGotoAction` for setting local file, destination, and open behavior.

- **Document-Level Actions**:
  - New APIs
    - `PDFDoc.setOpenAction(action)`
    - `PDFDoc.removeOpenAction()`
    - `PDFDoc.getOpenAction()`

- **Annotation and Widget Action Management**:
  - New APIs:
    - `Annot.getAllActionData()`
    - `Annot.updateAction()`
    - `Annot.removeAction()`
    - `Annot.appendAction()`
    - `Annot.supportsAction()`
    - `PDFFormPropertiesService.updateAction()`
    - `PDFFormPropertiesService.removeAction()`
    - `PDFFormPropertiesService.updateAdditionalAction()`
    - `PDFFormPropertiesService.appendAdditionalAction()`

- **Additional Action Management**:
  - New class `actions.AdditionalAction<T>` supports managing additional actions triggered by annotations, widgets, or pages.

###  Annotation Enhancements

- Separate border and fill opacity:
  - `MarkupAnnot.setBorderOpacity()`, `getBorderOpacity()`
  - `MarkupAnnot.setFillOpacity()`, `getFillOpacity()`
- Support for WebP images in stamps
- Stamp icon caching via IndexedDB
- Support for custom URL protocols in link annotations
- New config property `AnnotComponentConfig.moveDirection` to control move direction

### Text Editing Enhancements

- `page.splitTextInRect()` now supports splitting text at the character level.
- `PageEditorAddon.changeTextColorByRect()` supports text color changes in a specified area.

###  Document Sanitization

- UI automatically detects and removes hidden/private information.
- New APIs:
  - `PDFDoc.sanitize()`
  - `PDFDoc.removeHiddenData()`

###  Viewer Preferences Support

- New class: `PDFViewPreference`
- New APIs:
  - `PDFDocsetOpenAction()`
  - `PDFDocgetOpenAction()`
  - `PDFDocremoveOpenAction()`
  - `PDFDocgetViewPreference()`

###  PDF/A Enhancements

- Prompt added for enabling PDF/A editing in the UI
- New API: `PDFViewer.grantEditPDFAPermission(permission)`

### Font Access Control

- UI prompt added when accessing system fonts
- New API: `grantQueryLocalFontsPermission(permission)`

###  Portfolio Accessibility Enhancements

- Improved keyboard navigation in Layout and Detail views: supports Home, End, Tab, Enter, and Arrow keys
- Better screen reader compatibility

###  File Download Progress

- `getFile()` now supports a `progressHandler` callback for real-time download tracking

### New Examples

- github.com/foxitsoftware/foxit-CollaborationAddon-example - Vue3
- examples/UIExtension/form/custom-form-properties-editor/
- examples/UIExtension/form/custom-widget-contextmenu/ 
- examples/UIExtension/form/interaction-event-interceptor/ 
- examples/PDFViewCtrl/custom-date-time-picker/


---
## Bug Fixes

### Annotation-Related Fixes
* Fixed an issue where the eraser’s circular indicator did not scale according to the page zoom level.
* Fixed an issue where adding a Callout annotation in certain engineering drawings would cause the annotation position to shift after entering text.
* Fixed a problem that caused failure when adding a Callout annotation to the first page in specific documents.
* Fixed an issue where Checkmark icon marked by the SDK Viewer could not be displayed correctly in other PDF readers.
* Fixed a bug where FreeText annotations were not visible in the comment list for specific documents.
* Fixed an issue where multiple selected annotations in the comment list could not be deselected.
* Fixed a problem where drawing annotations could extend beyond page boundaries.
* Fixed a bug where the color selection in the drawing annotation palette failed or was not updated correctly after being changed via code.
* Fixed an issue where Typewriter annotation colors were lost after exporting to JSON and reimporting.
* Fixed an issue where FreeText annotations with font changes displayed abnormally after exporting to XFDF and reimporting.
* Fixed a problem where FreeText annotations display Icorrectly on some pages of specific documents.
* Fixed an issue where exporting FreeText annotations containing non-English characters using `exportAnnotsToFDF` caused the file size to increase significantly.
* Fixed a bug where Circle Area measurement annotations did not respond to `page.setMeasureScaleRatio()` settings.
* Fixed an issue where Distance measurement annotations displayed incorrect scale values.
* Fixed a rendering issue with Pencil drawings due to inaccurate unit conversion logic from PDF points to screen pixels.
* Fixed a console error that occurred when right-clicking annotation properties in specific documents.
* Fixed a bug where rightClickAnnotation events were not triggered for Link annotations.
* Fixed an issue where resizing Stamp annotations would not preserve their aspect ratio.
* Fixed a bug where adding custom Stamps using `PDFViewer::addAnnotationIcon` failed.

### Page Display & Operation Fixes
* Fixed an issue where comparing specific engineering drawings with the SDK produced incorrect comparison results.
* Fixed a problem where extracted text using `getText` did not match the actual document content.
* Fixed an issue where some text and image objects disappeared after applying a transformation matrix.
* Fixed a compatibility issue where using the SDK in the Electron framework triggered `nodePath.dirname is not a function error`.
* Fixed a problem where PDF documents could not be loaded in Safari due to failed Service-Worker registration.
* Fixed a console error that occurred when opening certain PDF documents.
* Fixed a bug that caused PDF loading failure due to empty layer content.
* Fixed an issue where parsing failed when loading a document using `openPDFByHttpRangeRequest()` due to incorrect range parsing.
* Fixed a bug where incorrect font encoding caused custom fonts configured via SDK not to display in other PDF readers.
* Fixed a problem where only the first font setting took effect when matching arbitrary fonts in the UI layer.
* Fixed a bug where incorrect Redaction region calculations caused the entire page to be redacted.
* Fixed an issue where calling `pdfViewer.rotateTo` did not update the view as expected.
* Fixed a bug where the signature appearance failed to display due to Base Font Name retrieval failure in signed forms.
* Fixed an issue where the `FindNext` function caused a memory overflow when switching pages during a search.
* Fixed a performance issue that reduced the first-page rendering time of linearized PDFs from ~60 seconds to just 1 second.

### Permissions & JavaScript Execution Fixes
* Fixed a JavaScript form issue where focus events were not triggered properly, causing scripts to fail.
* Fixed an issue where improper handling of asynchronous JavaScript in PDF forms caused unexpected behaviors.
* Fixed a permissions issue where documents with editable text rights still prevented text modification.
* Fixed a bug where calling `setPagesBox` on a document without permission incorrectly prompted a permission error.
* Fixed an issue where the `Search & Highlight` checkbox remained enabled even when the document lacked annotation permissions.

### UI & Interaction Fixes
* Fixed an issue where `pdfUI.confirm()` parameters could not be customized.
* Fixed a problem where the print preview was incorrect when printing from Chrome on iOS.
* Fixed a scrolling issue where PDF pages scrolled too quickly when using a Trackpad due to over-sensitive input.
* Fixed an issue where repeatedly resizing the left panel caused the document display area to go blank.


# # What's new in Foxit PDF SDK for Web 10.0.0   
**Release Date:** June 28, 2024

*****Major Changes*****
* Dramatically improved bookmark loading time efficiency by refactoring the bookmark module.
* Completely remove support for ASM.JS engine and no longer support for older Safari version below 11.

*****Enhancements*****

* Switched WASM library loading approach from static to dynamic. The dynamically loaded libraries consist of a main module and several side modules. Only the main module is loaded into memory initially. Side modules are loaded only when needed.
* Enhanced Stamp's APIs 'addAnnotationIcon()' and 'setDynamicStamp()', and UI  to accept special characters: hyphen (dash), colon, semicolon, slash, and space.
* Improved the Edit Text and Add Text tool of Advanced Editor to support the global undo/redo functionality and custom fonts. 

## New Features

* Introduced Dynamic XFA form-fill functionality.
* Enabled PDF Basic 3D model rendering and viewing support.
* Enabled creating multiple signatures by sharing /v dictionary.
* Enabled the z-order change for stacking annotations through newly added API 'PDFPage::changeAnnotOrder()' and UI options.
* Added an event 'activeMultipleAnnotations' for selecting multiple annotations or form widgets.
* Added 'Annot::setCustomAPStream()' to set the appearance streams of an annotation object.
* Added a constructor parameter [options.customs.syncTextScaling=false] in PDFViewer to enable TextBox and Callout to scale with container resizing.
* Added an event 'FormFieldImported' to emit a notification once the data importing has been completed.
* Added 'setFileSpec()' and 'getFileSpec()' to enable programmatically setting launch action.
* Added 'PDFViewer::registerMultimediaPlayers()' to enable embedding custom players to play the target format media files.
* Added APIs to enable programmatically adding and removing layers within a PDF.
	Relevant APIs:
	addLayerNode
	removeLayerNode
	addLayerGraphicObject
	removeLayerGraphicObject


*****API Changes*****

* Updated 'PDFDoc.sign()' with two enhancements: a new parameter 'signInfo.shareVDictType' for adding signatures with a single /V dictionary, and support for array objects in 'signInfo.pageIndex' and 'signInfo.rect' parameters. 
* Updated the'PDFDoc.exportFormToFile()' to allow for importing/exporting form data from/to a JSON file.
* Updated the 'setStateHandlerConfig()' with a new option 'enableAnnotationSelectionTool' to toggle on or off the annotation selection.


## Bug Fixes
* [Demo] Updated the overlay-comparison third-party dependency to address security issues.
* Fixed a console error that occurred when quickly paging to the last page using thumbnails in specific documents.
* Fixed an issue where the attached file inside a PDF could not be downloaded.
* Fixed an issue where users couldn't copy and paste text within the AddText tool using the right-click menu.
* Fixed an issue where enabling or disabling the comment-list-sidebar-panel component through Fragments was not effective.
* Fixed a console error when loading the SDK after hiding PDFUI DOM nodes
* Fixed an issue where calling the pdfDoc.rotatePages() API resulted in incorrect page rotations.
* Fixed an issue where TextMarkup::getText() did not retrieve the correct text.
* Fixed an issue where adding a shape object with fill color to one page of the document resulted in blank pages when scrolling.
* Fixed an issue with PDFDoc::exportFormToFile (fileType = csv/txt) where the format was incorrect.
* Fixed an issue where a cross-origin iframe was unable to properly interact with the FoxitPDFSDKForWeb library.
* Fixed an issue related to the display of custom fonts. 
* Fixed an issue where black ink annotations with the hex color value #000000 were not rendering correctly in documents.
* Fixed an issue where annotations without an AP stream were not drawing borders correctly.
* Fixed an issue where adjusting the size of the callout annotation caused the callout's container to collapse.
* Fixed an issue where dragging a stamp annotation across pages caused DataEvents.annotationPositionMoved to return incorrect data.
* Fixed an issue where appending text to the Note comment was not allowed. 
* Fixed an issue where the Note annotation could not be locked.
* Fixed an issue where setting the border of a Link annotation to 0 was ineffective.
* Fixed a permission issue where when the comment content is empty, content could not be added.
* Fixed permission issues where the Image, Video & Audio, and Link annotations could not be edited in PDFs with annotation modification  permissions.
* Fixed an issue where adding a Textbox and keeping the cursor inside the box, then scrolling past pages, would cause the content to be  cleared.
* Fixed an issue where tapAnnotation could not be triggered on mobile devices.
* Fixed an issue where setting custom fonts with rich text format for free text annotations was not working. 
 
# What's new in Foxit PDF SDK for Web 9.2.0   
Release Date: November 14, 2023

## New Features
* Enabled annotation APIs to support undo/redo functionality:Added a new callback addon function "UndoRedoAddon.invoke" to enable annotation APIs to support undo/redo functionality.
* Support removing watermark:Added new API "pdfdoc.removeAllWatermarks" to remove all watermark in the document.
* Support to collapse/expand Ribbon bar:New directives, @retractable and @retractable-body, have been added to control the tab component, allowing to toggle on or off the ribbon bar.
* Support for rendering tile watermark at viewer level:Updated the APIs PDFPageRender:setWatermarkConfig and PDFDocRender:setWatermarkConfig to provide support for rendering tile watermarks.
* Check a PDF Owner Password:Added new APIs "checkPassword" to check the password type of the current document and "hasOwnerPassword" to check if the current PDF has an owner password.
* Support non-proportionally resizing stamps:Added a new attribute "enableFrame" to AnnotComponentConfig to allow for resizing stamp UI shape horizontally or vertically.
* Optimized UIX Addon APIs: This optimization introduced UIExtension.addons to replace the old PDFUI.callAddonAPI class, and added a new API "PDFUI.getAddonInstance" to allow asynchronous retrieval ofaddons instances.
* Themes color customization: Added a new API 'setThemeColor' to allowing themes customization. 
* Suport for Rendering Dynamic XFA forms.
* Support advanced editor on Mobile.
* Exposed new UI APIs and Events for the Advanced Editor addon.
* Support for Editing/Deleting Polygon/Polyline with /path entry.

*****Demo*****
* Demo for the Storage API:New Demo "examples/UIExtension/custom-storage-driver/index.html" showing how to store and retrive data for some opterations. 
* Show/Hide ribbon bar:New Demo "examples/UIExtension/retractable-tab/" to demostrate how to show/hide the ribbon bar.

## Bug Fixes
* Fixed the issue of positional inaccuracy after executing pdfviewer.zoomAtPosition.
* Resolved an error that occurred in specific files after verifying signatures, showing "Uncaught (in promise) RangeError: offset is out of bounds."
* Fixed the problem where, due to caching issues, subsequently added custom stamps always used the image of the first stamp added.
* Addressed the issue of ink discontinuity and content loss when writing with a stylus pen.
* Corrected the lag in drawing with the pencil tool when zooming during editing.
* Fixed the problem where, in documents with inconsistent page sizes, changing page display or resizing the browser would not center the pages.
* Resolved a specific document rendering issue, where parsing failed when flipping pages during the rendering process.

# What's new in Foxit PDF SDK for Web 9.1.0
Release Date: August 29, 2023

## New Features
* New capability to render and edit annotations using CA, ca, and BM dictionaries from PDF2.0.
* Added a backend font-matching strategy for increased font mapping accuracy.
* Added new APIs to configure properties such as moveable, resizable, rotatable, and enableDiagonally for different annotation UI shapes.
  Relevant APIs:
  PDFViewCtrl::interfaces::CustomOptionsUpdater::updateGetAnnotComponentConfig ( )    
  PDFViewer::constructor [options.customs.getAnnotComponentConfig=function(){}] 
* All measurement tools now support setting Caption colors and Label text through UI or APIs.
  Relevant API: ***.setCaptionColor; ***.setContent
* New APIs setImage added to programmatically set the stamp and screen.
* New API PDFDoc.AddAnnots added to insert annotations into PDF in batch to improve performance.
* Added support for paging seal signature to add, update, delete, and sign stamps.
  Relevant APIs:
  PDFDoc::addPagingSealSignature; 
  PDFDoc::getAllPagingSealSignatures; 
  PDFDoc::removePagingSealSignature; 
  PDFDoc::updatePagingSealSignature; 
  PDFDoc::sign()
* Updated parameters email, reason, and location of PDFDoc.sign to change the default value of the Signer's Contact Information that appears on the Signature Properties window.
* New APIs for obtaining signature images, detecting the last signature, and removing the signature.
  Relevant APIs:
  PDFSignature::getImage
  PDFDoc::removeSignature
  PDFSignature::isLast
* Enabled Page Thumbnails to synchronize with the Page View in Rotate View mode.
* Added support for displaying and customizing task progress for Signing, Watermarking, Adding Annotations, Form Recognition, and Printing.
  Relevant APIs:
  PDFViewer::interfaces:ProgressComponent
  PDFViewer::registerProgressHandler(callback)     
  PDFUI::constructor(customs.progress)
* New API HandStateHandlerConfig::enablePasting to enable or disable paste functionality in the hand state.
* Exposed UIExtension Controllers for Basic and Advanced Editor.
* New API PDFViewer:RegisterPrintHandler added to override default print behavior and allow for executing custom print logic.
* Added support for dark mode at UI.
* Implemented a built-in and customizable storage driver for saving and retrieving data, enabling users to reuse measurement settings in the last session.
  Relevant APIs:
  PDFViewCtrl: Storage
  PDFViewer::getInstanceId ()     
  PDFViewer::constructor [options.instanceId]
* New API PDFViewer::getActionCallbackManager added to open an embedded file associated with a link.
* New APIs PDFField::getMappingName and PDFField::setMappingName added to form for exporting or importing form data.
* New API PDFField::setAlternateName added to set alternate text to the form field for enhanced accessibility to the PDF form.
* New APIs added to programmatically extract, update, and embed files from PDF documents.
  Relevant APIs:
  PDFDoc::addEmbeddedFile()
  PDFDoc::setEmbeddedFile()
  PDFDoc::getEmbeddedFile()
*****Enhancements*****
* Improved Snapping to work with the existing measurements.
* Enhanced Annotation Undo/Redo functionality for broader editing scenarios.
* Improved interaction of measurement distance lines for enhanced readability.
* Enhanced rendering of annotations with Multiply Blend Mode in the Appearance Stream.
* Updated parameter format of ‘PDFViewer::initAnnotationIcons’ using an array of objects for simplified API use.

*****Demo*****
* New Demo ”server\signature-server-for-linux" for demonstrating how to configure and start up service for a signature.
* New Demo “examples/UIExtension/dark/” to demonstrate how to implement dark mode.  
* New Demo “examples/UIExtension/custom-measurement-properties-dialog/index“ to demonstrate the customization of the right-side measurement properties component.
* New Vue.js3  example added on the Github.
* New Next.JS example added on the Github.
* New Integration demo with low-code platform Mendix. 

## Bug Fixes

* Addressed an issue where transparent annotations with a Multiply blending mode were not rendering correctly in the Appearance stream.
* [Demo] Fixed a problem with the commentlist-loadmode demo not loading all comments as expected.
* Resolved crashes occurring during the re-rendering of newly created annotations on specific files.
* Corrected annotation tooltips that were not displaying completely when hovering the mouse over them.
* Fixed the issue where the reply function was disabled when the Annotation property was set to Locked.
* Fixed the content reset issue upon double-clicking a newly created TextBox or Callout.
* Restored the functionality of the Typewriter tool's plain text paste.
* Addressed annotation rendering errors when zooming in and out using ctrl+mouse wheel.
* Fixed the issue of the Annotation CreationDate failing to update with time zone changes.
* Resolved the issue where creating an ink annotation on mobile via pinch zoom triggered an unintended add annotation event.
* Fixed the issue where stamps were added but their icons didn't appear in the stamp list.
* [Demo] Fixed an issue where the ScrollTo method wasn't working as expected while scrolling with the mouse wheel in the basicViewer.
* [Vue3] Fixed the "L.filter is not a function" error when deploying a Vue3 app to Ngix.
* Resolved the issue of specific files displaying blank pages upon scrolling.
* Rectified the problem where "Replace All" was not effectively applying to every page.
* Rectified the problem where CheckBox and RadioBox annotations created by the SDK were not appearing in other PDF readers.
* Resolved the issue where exporting and then importing data files through the UI interface with documents having uppercase "PDF" file extensions would result in a "File is corrupted" message.
* Fixed interdependent calculation errors within specific form fields.
* Corrected the incorrect rendering of "1 bpp with a mask" images.
* Fixed an error "Cannot set properties of undefined" when tapping a page on mobile.
* Resolved the "unknown engine error" when merging documents.
* Fixed an issue where printing documents containing layer resulted in incorrect output.
* Eliminated memory leaks in the getFile and getStream functions.
* Corrected the issue in specific files where text could only be selected on a per-line basis.
* Fixed the inability to draw dots on the Create Signature panel.
* Rectified the problem where the text couldn't be edited after applying an Ink signature into text.
* Addressed the issue where inaccuracies in the handling of existing signatures resulted in incorrect signature validation information within the document after saving.
* Fixed a situation on Windows where Context Menu events were triggering twice upon mouse release.
* Addressed the issue of "image size points" being inaccessible when beyond the page mediabox.
* Fixed the issue where right-clicking on a page in selection mode didn't trigger the expected rightClickPage event.
* Improved the slow scrolling issue when using the scroll bar on Laptop.
* Fixed the "undefined" error when partially loading components of the Advanced Editor.
* Corrected the problem where hiding the Left Side Panel was effective only for the current session, despite executing "component.hide()".
* Checked: Addressed an SDK JavaScript initialization error caused by attempts to read improperly named properties on the window object, which were added by Chrome extensions.
* Fixed the content disappearance issue when resizing the Loup Tool window.
* Resolved the issue where the maxScale setting didn't apply as expected on mobile devices.

# What's new in Foxit PDF SDK for Web 9.0.0
Release Date: March 07, 2023

NOTE: Microsoft Internet Explorer is no longer be supported starting from this version.

## New Features and Updates
*	Advanced Page Editor on UI
	This version offers powerful PDF page editing capabilities, allowing you to easily manipulate text 
	blocks with font styles, alignment, and join/split functionality, perform text search and replace operations, and create and customize shape objects with preset paths, shading, and other properties. 
*	Image Diff Comparison  
	Relevant APIs: OverlayComparisonService::compareImageData(), PDFViewer::getOverlayComparisonService(), PDFViewer::getOverlayComparisonOptionsService()
	This function compares image pixel-by-pixel for differences between two documents, and then generates an output image. You can use relevant APIs to implement the overlay comparison feature for your application. 
*	Support TypeScript declarations
	New d.ts files have been added into SDK package includes: lib/index.d.ts,lib/UIExtension.d.ts,lib/UIExtension.full.d.ts,lib/PDFViewCtrl.d.ts, and lib/PDFViewCtrl.full.d.ts
*	Custom Dynamic Stamp 
	Relevant APIs: PDFUI::callAddonAPI(), setDynamicStamp,getDynamicStamp,removeDynamicStamp
	This feature allows for creating a dynamic stamp with any custom image, text, or logo, and can be reused throughout a document or across multiple documents.
*	Multiline Tiled Watermark
	Relevant API: PDFDoc::addWatermark（）
	This feature allows for specifying a range of pages by using "pageStart" and "pageEnd" when adding watermarks. It also provides the ability to set multi-line tiles with the "isMultiline" option, as well as adjust the distance between tiles with the "rowSpace" and "columnSpace" options. 
*	Programmatically paste annotation into a destination page
	Relevant APIs:PDFPage::pasteAnnot(srcAnnot,position )
*	Set default font properties for FreeText annotations
	The default font for FreeText, which includes typewriter, callout, and textbox. can be set using either the PDFViewer::setDefaultAnnotConfig() method or by accessing the UI annotation properties menu and selecting "set current properties as default".
*	Obtain data about mouseover stamp 
	Relevant API: PDFViewCtrl:Stamp class PDFUI::getStampService()
	With this new features, developers can now not only retrieve mouseover stamp information, but also monitor stamp state handler switching. This provides greater flexibility and control when working with stamps. For instance, developers can adjust the size of selected stamps before placing them on a page.
*	Keep the formatting when copying and pasting text with hand tool
	This feature is to preserve the formatting of text when pasting from sources like Word, WordPad, or a web page using the hand tool. The pasted text will be added as a FreeText annotation, with supported richText formatting including font color, size, bold, italic, underline, and strikeout. When pasting in the Web Viewer, any link URLs and images included in the copied content will be ignored. In case the font used in the copied content is not available in the Web Viewer, the default font used will be Helvetica.
*	Show labels and values for Perimeter and Area measurements
	Relevant APis:Polygon::enableCaption, PolyLine::enableCaption
*	PDFDoc.sign supports rotation
	This feature allows the user to rotate the signature field to a desired angle (0|90|180|270) before adding it to the document.
*	Access details on signed signature
	Relevant API:PDFSignature::getSignInfo()
*	Hand state handler supports text selection. 
	Relevant API: PDFViewCtrl::stateHandlerManager
	This version introduces an option to turn on/off the text selection with the hand tool. When hand text selection is enabled, the cursor changes to the text select shape when it hovers over a string of text, indicating that it is ready to select text with a mouse drag.
*	Custom snapshot interaction
	Relevant API and Classes: PDFUI::setSnapshotInteractionClass(), UIExtension::Sanpshot, UIExtension::SnapshotInteraction
	With this new feature support in this release, you can rewrite the snapshot interaction, and implement it as needed.
*	UI Component state management
	Relevant APIs: Component::keepState(), Component::revokeKeepState(),Component::isStateKept()
	The visibility of UI components can be controlled by calling Component::show()/Component::hide(). But this shown/hidden action is always overridden by the SDK default behavior. To maintain these user changes, we provide state management APIs to hold the state and prevent the SDK from changing the state. Below is an example showing how to hide the Apply menu for redaction and call keepState() to hold the current state.
*	Improvements to UI redaction component
	The redaction component "Mark for Redaction" contains 3 drop-down options "Mark Text & Image", "Mark Area", and "Mark Page". These options were wrapped in one component and cannot be separated in previous versions. With this improvement, the options are separated into 3 elements in the component, and making it easier to customize.
*	Collaboration Addon
	This addon offers a range of build-in client and server functionalities that enable developers to implement collaboration, improve organization's productivity and streamline PDF document workflows.
	
*****API Changes*****
The second parameter of PDFDoc::sign(signInfo, DigestSignHandler) has been updated:
	OLD: DigestSignHandler(signInfo,buffer),where the buffer data type is ArrayBuffer.
	NEW: DigestSignHandler(signInfo,plainContent),where the plainContent data type is Blob.

*****Demo*****
*	Image Diff Comparison Demo
	This demo renders three synced instances where the middle instance shows pixel differences between the two documents.
*	Multiple Instances Demo
	Shows how to run PDFViewer in multiple instances.

## Bug Fixes
*	The typewriter annotation may not render correctly if the text entered exceeds the allotted area.
*	The rendering order of the screen image annotation is inconsistent with Foxit PDF Editor.
*	Only the last signature is considered valid when validating multiple signatures in a PDF document.
*	One of the signatures may not be displayed on page when there are multiple signatures with the same name.
*	The right click menu of annotation is not displayed in full screen mode.
*	Gray texts may appear as black when changing the background color of a PDF file.
*	Signing and validating on large files leads to browser crashes. 
*	If the border of the annotation's shape is set to 0 the fill color is not applied.
*	The font name is not displayed in the font list after being modified through the form field properties.
*	The link annotation action executed even when mouse cursor is not above it.
*	Certain specific images with rotation are displayed incorrectly when input into the image form field.
*	Calling page.addAnnot to set the icon for the file attachment is ineffective.
*	The mapped font via setJRFontMap() is rendered incorrectly.
*	[Mobile]Long press on the annotation or page doesn't trigger correctly on mobile.
*	[iPad]Fixed the stylus touch compatibility issues on some versions of iPad.

# What's new in Foxit PDF SDK for Web 8.5.2
Release Date: November 11, 2022

## Updates
* Updated the event graphicsUpdated with a new parameter to get the current graphics object. 
* Optimized the "Add text" feature to improve the graphics text edit with bold/italic.
* Optimized the pen annotations so they could be created and handled rightly even in a delay period.

## Bug Fixes
* Adding annotation resulted in garbled code when the custom entries contain Chinese characters. 
* The double tap on Textbox in iPad Chrome wasn't correctly triggered. 
* Certain form fields have no action set after being destroyed. 
* The exportAnnotsToFDF() doesn't work when set the "annots" parameter. 
* The page and thumbnail doesn't render correctly when call setPageBox to crop pages.
* Unable to edit the content text in the form Xobject containers in certain PDFs.

# What's new in Foxit PDF SDK for Web 8.5.1
Release Date: October 24, 2022

*  This is a maintenance release focused on fixing bugs discovered by the QA team.
 
# What's new in Foxit PDF SDK for Web 8.5.0
Release Date: September 05, 2022

## New Features and Updates
* Support for reading text on PDF documents.
  Relevant APIs: PDFPage.getGraphicsObjectsByRect()
* Support for document comparison
  Relevant APIs: PDFViewer.compareDocuments(), PDFDoc.getComparisonFilterCountSummary()
* New functions to delete file attachments inside a PDF document. 
  Relevant APIs: PDFDoc.removeEmbeddedFileByName(); PDFDoc.removeAllEmbeddedFiles(); PDFDoc.getEmbeddedFileNames()
* Signing appearance creation supports Typed signature with custom CSS Fonts on UI. 
  Relevant API: PDFUI.addCssFonts()
* Ink signatures support to export data in Blob.
  Relevant API: PDFViewer.getInkSignList()
* New option to set signing date field format. 
  Relevant APIs: PDFUI.registerSignHandler(); PDFDoc.sign()
* Disable/Enable scroll-by-drag in viewer. 
  Relevant APIs: PDFDocRender.disableDragToScroll(); ***.enableDragToScroll()
* New function to get the currently focused form field.
  Relevant API: PDFViewer.getFocusField() 
* Support Reply to FreeText annotation on UI. 
* Performance improvements to Document rendering and zoom scaling.

*****Demo*****
* New carousel demo for rewriting mouse events in a single page layout.

## Bug Fixes
* Fixed an issue where the rectangle box of the text selection does not have the same height. 
* Fixed an issue where removing annotations by APIs cause an error when there were form fields on the page. 
* Fixed an issue where calling setDefaultAnnotConfig() voided all the annotation's default changes.
* Fixed an issue where the search results highlight is incorrect on watermarked PDF pages.
* Fixed an issue where the added annotations didn't show up on certain specific PDFs。
* Fixed an issue where the page content on the lower right corner was truncated.
* Fixed an issue where the stamps failed to be added to the PDF document on Mobile. 
* Fixed an issue where the markup annotation's intent was lost when exporting/importing JSON.
* Fixed an issue where the signed signature field was automatically highlighted. 
* Fixed an issue where deleting comments in the CommentList caused errors. 
* Fixed an issue where PDF pages containing ARGB bitmaps rendered slowly.

# What's new in Foxit PDF SDK for Web 8.4.0
Release Date: May 31, 2022 

## New Features and Updates
* Added support for getting text on a specific area.  
  Relevant API: PDFpage::getTextInRect       
* Added support for Rich text on FreeText Annotation.  
  Relevant APIs:  PDF::annots:Markup::setRichText, .addRichText, *insertRichText, *.removeRichText，PDFPage::addAnnot(richText)
* Added support for rendering image inside a square annotation.
  Relevant API: PDFViewer::constructor::[options.annotRenderingMode.square='canvas']
* New function PDFUI::registerSignatureFlowHandler() to rewrite the pop-up interaction dialog for signing document. 
* New print function PDFViewer.printEx() to pass only the document data to browser printer.
* Added support for programmatically cropping pages. 
  Relevant API: PDFDoc::setPagesBox(); PDFDoc::getAllBoxesByPageIndex()   
* Added support for embed scale information for measurements. 
  Relevant APIs: PDFPage::getViewportRect(); PDFPage::getMeasureScaleRatio(); PDFPage::setMeasureScaleRatio(); 

*****Improvements*****
* Optimized the annotation loading performance on large documents.
* Enhanced the line drawing in distance line annotation. 
* Optimized the strategy for loading all form fields in side panel to improve the page rendering efficiency. 

## Bug Fixes
* [Vue] Fixed the statehandler register issue after PDFUI initializing. 
* Fixed the annotation import issue after setting annotRenderingMode to canvas.
* Fixed the form field keystroke script issue.
* Fixed the memory leak issue when reloading the same file multiple times.
* Fixed the form Tab key navigation issue. 
* Fixed the XFDF export issue.
* Fixed the incorrect page dimension issue showing on the Document properties window. 
* Fixed the annotation moving issue with mouse. 
* Fixed the watermarks adding issue. 
* Fixed the undefined error when right clicking the signature field.
* Fixed the window displaying issue with Actions when right clicking on an image.
* Fixed the permission control issue with combined bitmasks.
* [Mobile] Fixed the issue where the form checkbox doesn't update correctly.
* [Mobile} Fixed the Pinch Zoom position issue on mobile. 
* Fixed the deleting issue when editing the text annotation's content.
* Fixed issues where the custom permission doesn't respond correct at UI. 
* Fixed the page number inconsistent issue between document viewer and thumbnail panel after removing pages. 
* Fixed an issue where the event annotationPositionMoved was not triggered correctly when moving some annotations. 
* Fixed an issue where the text field could not be edited on certain PDFs.
* Fixed an issue where the polyline disappeared after the page is is flattened. 
* Fixed an issue where the snap option for distance measurement did not  work.
* Fixed the rendering lag issue when rotating pages using "rotateTo" function.
* Fixed an issue where the viewMode switching lagged specially in the facing mode. 

# What's new in Foxit PDF SDK for Web 8.3.0
Release Date: March 07, 2022 

## New Features and Updates
* New option for UI signature to set the default length of signature contents.
  Relevant API: PDFUI::registerSignHandler()
* Redaction supports fill opacity percentage and overlay text.
  Relevant API: PDF::annots:redact
* More PDF JavaScript annotation properties Support
* New parameters for setting measurement ratio on polyline and polygon annotations. 
  Relevant API: PDF::annots
* New functions for copy and paste annotations
  Relevant API: PDFViewer::copyAnnots, PDFViewer:pasteAnnots 
* New functions with scale control, multi-pages selection event and multi-pages deletion on Page Thumbnails
  Relevant API: PDFDoc::loadThumbnail, PDFUI::callAddonAPI::Thumbnail
* Merging documents automatically or by drag&drop approach.
  Relevant API: PDFViewer::loadPDFDocByFile(), PDFViewer::loadPDFDocByHttpRangeRequest(), PDFDoc::mergePDFDoc
* ARIA and Keyboard Accessibility support.
* Improved the tile rendering to avoid blank displaying when mouse scrolls.

## Bug Fixes
* The Fit page with zoom setting was cut at the bottom. 
* The error when importing the stamp data.
* The "Properties" of the redaction cannot be read.
* The JavaScript code can't trigger the notifications of the input validation.
* The contents of the signature displayed incorrectly.
* The render error in the single page mode.
* A couple of issues related to UIExtension.PDFUI.
 
# What's new in Foxit PDF SDK for Web 8.2.0
Release Date: November 29, 2021  

## New Features and Updates
* New UI Styles and right-side components
* Keyboard shortcuts for accessing top toolbars and dialog boxes. 
* New snapshot functions for getting, capturing, copying and uploading images.
	Relevant API:PDFViewer.takeSnapshot(), **copySnapshot(), *uploadSnapshot(), PDFViewer.[options.snapshotServer]
* Extend PDFViewer.addFontMaps() to set custom font on form module. 
* Support for searching contents in form text field. 
* Being able to select overlapping annotation on UI.
* More Acrobat JavaScript API support on annotation objects.
* New rotation API for FreeText, stamp and screen annotation.
	Relevant APIs: PDF.annots, PDFPage.addAnnot()
* Update FreeText:setDefaultAppearance() to set custom font for freetext annotation.
	Relevant APIs: PDFPage.getAnnotObjectNumAtDevicePoint
* New PDF2Txt API. 
	Relevant APIs: PDF.Progress, PDFViewCtrl.shared.getRanges(), PDFDoc.getText

*****Demo*****
* New UIExtension redaction demo.
* New PDFViewCtrl text-research demo.

## Bug Fixes
* The highlights of certain calculated form fields isn't reset correctly when printed. 
* The pageTap event doesn't work in single-page-view-mode. 
* The filesize increases when calling PDFDoc.getFile or PDFDoc.getStream.
* Throwing exception on calling PDFDoc.exportAnnotsToFDF() when there are empty pages.
* The PDFViewer.setDefaultPrintSetting doesn't take effect when print through the browser Print.
* Annotation line-ending displays incorrectly.
* Specific PDFs with name tree null failed to open.

# What's new in Foxit PDF SDK for Web 8.1.1
Release Date: September 10, 2021  

***** Fixes *****
* Optimized performance including load time overhead and memory consumption.

# What's new in Foxit PDF SDK for Web 8.1.0 
Release Date: August 31, 2021   

## New Features and Updates
* Measurement annotation supports for editing line leader and measurement text on both UI and API. 
	Relevant APIs: PDF::annots:Line::setLeaderLineOffset，***setLeaderLineExtend，***setCaptionOffset，***getCaptionOffset
* New function PDFPage::isVirtual for detecting anomalous pages.  
* Viewer watermark allows multiple insertions at one time.
	Relevant APIs:  PDFDocRender::setWatermarkConfig, ***getWatermarkConfig, PDFPageRender::getWatermarkConfig, ***:setWatermarkConfig
* New function PDFViewer::printCurrentView() to print current view when a single page is in view. 
* New function PDF:PDFDoc::getFile() to get PDF object. 
* Update PDFViewer::print() to print a selected area.
* Update jquery to version 3.5.0
* Update PDFViewer::getPDFDocIdByHttpRangeRequest() to return specific exception data when error occurs. 
* Update FoxitPDFSDKForWeb-VueJS-Example document to include font referencing introduction.
* Rewrite the logic of "PDFUI.loading" to make the customization more flexible.
	Relevant API: PDFUI::constructor::[options.customs.loading]; IViewerUI::loading
* Enhance copy/past multiple lines of text objects. 
	* In previous version, copying/pasting multiple lines of text objects results in overlay.
* Enhance the page load scrolling UX on mobile.
* Enhance PDFViewer::setJRFontMap() for a 3rd party font rendering.  
	
*****Demo*****
* Create-react-app using effect hook

## Bug Fixes
* Unknown type annotations in a particular file now can be correctly displayed. 
* The signed document can be verified by Adobe.
* The Thai input with annotation tools can be displayed correctly. 
* Reference only UIExtension.vendor.js and UIExtension.js no longer generates console errors.
* Continuously scrolling after magnifying the document no more causes a freezing error. 
* Inserting watermark and zooming in the current page cause no error. 
* The Field sidebar component can be removed by fragments.
* PDF pages lacks necessary dictionaries now can be processed correctly.
* The Ok button responds correctly if right-click and paste an URL when adding a link. 
* GoTo action takes to the correct position.
* Link annotation can be triggered without document edit permission.
* PDF font renders correctly when calling PDFUI:setJRFontMap.
* Fixed an rendering blur issue on a particular scanned PDF file.
* The annotation shows up with the correct timestamp at UI.
* The UI now can correctly responds to the getDocPermissions settings that was set in the viewer constructors.
* The allInOne.js file now imports correctly without errors. 
	
# What's new in Foxit PDF SDK for Web 8.0.0

## New Features and Updates

•	Form Designer full support (PC platform only)  
•	High Contrast support 
•	Read Aloud is available for reading page’s text using either a built-in browser speech API or third party speech service 
•	Chinese Traditional Localization support 
•	Signature properties such as signing reason, date, location now available on context menu of signature fields 
•	Optimized UIExtension.css size from 5179kb to 1512kb 
•	Enhanced Acrobat JavaScript API support 
•	Clipboard copied text now displayed as text annotation object instead of text object  
•	The Returns of 'PDF.PDFForm.addControl()' was changed to object instead of boolean 

## New Methods and Classes

### PDFViewCtrl
•	New viewer events for monitoring actions before  page rendering and document loading.
	Relevant API:  ViewerEvents.beforeRenderPage, ***beforeLoadPDFDoc
•	New parameter 'fileOpen.cipher' was added to viewer open methods to decrypt FileOpen PDFs encrypted with AES algorithm. 
	Relevant API: PDFViewer.openPDFByFile(); PDFViewer.openPDFByHttpRangeRequest() and PDFViewer.reopenPDFDoc()
•	New viewer Class, interface and APIs for Read Aloud module.
	Relevant API and Module: PDFViewer.getReadAloudService, PDFViewCtrl.readAloud
•	New ‘PDFViewer.addFontMaps()’ for adding custom fonts to the Font list.
### PDF
•	New API ' PDFField.setFlags()' was added to set flags for form fields. 
### PDFUI
•	New parameter 'autoDownloadAfterSign' was added to 'PDFUI.constructor' to control the download action once the current document is signed with a certificate-based signature. 
•	A callback 'getSignedDocument' was added to 'PDFUI.constructor' to allow getting the signed document stream. 
•	New 'PDFUI.setDefaultMeasurementRatio()' for specifying measurement ratio.
•	New ‘PDFUI.waitForInitialization()’ for translating localization entries. 
•	New ‘PDFUI.registerSignaturePropertyHandler()’ for customizing signature properties panel.

## Sample Projects

•	New custom-font project which shows how to map a font and add it to the Font list for text editing. 
•	New custom-measurement project for creating a custom measurement object. 
•	New Integration project for React.js application created using create-react-app.  
•	New project for pseudo-time progress bar.

## Bug Fixes

1.	Fixed an issue where a PDF file with an oversized layout renders incorrectly in FitWidth mode. 
2.	Fixed a crash issue on opening PDF files with size larger 150MB on mobile devices. 
3.	Fixed a glyph rendering issue on a specific file.
4.	Annotation count now works correctly on the 'getAnnotCount()' method.
5.	Show/hide form field action responds correctly.
6.	'PDFui.activateAnnotation' correctly activates and locates annotation on page. 
7.	Change annotation rectangle with cloud style to solid now follows the object’s original geometry
8.	Fixed an issue where exporting Dynamic Stamps as FDF causes an error message in Adobe Reader DC.
9.	Fixed an issue with creation of new instances after destroying current in IE11.
10.	Fixed issues where customizing thumbnail context-menu causes errors.
11.	Linearized PDFs created by 'pdfdoc.getStream()' now can be opened in other PDF readers. 
 
# What's new in Foxit PDF SDK for Web 7.6.0

## Features

Complete Web Viewer project was updated to add the following new features:
•	Portfolio Support for viewing and downloading.
•	Added Snap functionality to measurement tools, Line, Arrow, Polyline, Polygon and Cloud.
•	Added First/Last page for page navigation. 
•	Added a functionality to add bookmark while viewing a PDF.
•	Added the functionality to drag and rotate a stamp.
•	Added SendToBack and BringToFront to have the particular graphic object to draw on top or underneath of other page objects.   
•	Added a Fields side-panel for displaying and managing form fields. 
•	Added highlight Fields 
•	New form field types for create/edit: Push button, CheckBox, Radio, ComboBox, ListBox, Image, Run Form Recognition and Form Assistant. 
•	New 'Options' properties tab for form CheckBox, Radio and ListBox which can be used to set Button type and Export value.
•	".\examples\PDFViewCtrl\create-annot" was updated to include code samples for creating Ink, Note and FreeText. 
•	".\examples\UIExtension\collaboration" was added to present how to collaborate on annotations, page manipulation, document sharing, and user annotation permissions.  
	Related class and API: PDFViewCtrl::collab, PDFViewer::collaborate(action,data) 
•	New CodeSandBox Demo

## New Methods and Classes

•	Support multiple page manipulation.
	Related API: PDFDoc::rotatePages(), ***removePages(),***movePagesTo(), ***insertBlankPages()
•	Support snap measurements to PDF shape objects’ points and paths. 
	Related API: PDFViewer::setSnapMode,  ***getSnapMode(), PDFPage::getSnappedPoint()
	Related Event: PDFViewCtrl.constants.ViewerEvents.snapModeChanged
•	New functionality to read and write document/page dictionaries.
	Related new class and APIs: PDFDictionary class,  PDFDoc.getInfo() and PDFPage.getDict().
•	Support to get logical page labels.
	Related API: PDFDoc.getPageLabels()
•	New method was added to set the position of the particular page object. 
	Related API: GraphicsObject::moveToPosition() 
•	New method was added to set the width of the Eraser.
	Related API: PDFViewer::setEraserSize()
•	Support circle and square area measurements. 
	Related API: PDF.annots.circle   ***square
•	Support to create the same type of form fields continuously.
	Related API: PDFViewer::setFormCreationContinuously()
•	New method to manage the form properties dialog box visibility when a form field was created.
	Related API: PDFUI::openFormPropertyBoxAfterCreated()
•	New method to manage the form field rectangle focus visibility when the form fields have been selected.  
	Related API: pdfViewer.setFormFieldFocusRectangleVisible()
•	New option was added to PDFViewer constructor to show/hide form file tooltip. 
	Related option: options.showFormFieldTooltip()
•	New method was added to set tooltips for all form fields.
	Related API: PDFViewer::addTooltipsForAllFormFields()
•	Support Acrobat JS functions importAnFDF and exportAsFDF to import/export form data.
•	Support Acrobat JS strokeColor to set the appearance of  annotation and form field to transparent.
•	New action callback interface for custom implementation with Acrobat JavaScript.
	Related API: PDFViewCtrl.pdfjs.ActionCallback
•	New annotation mouse events mouseEnter and mouseLeave. 
	Related Events:  PDFViewCtrl.constants.ViewerEvents.mouseEnter    ***mouseLeave
•	New bookmark select event to watch the users bookmark selection. 
	Related API: UIExtension.UIEvents.bookmarkSelected
•	The tapPage, doubleTapPage and pressPage methods include an `e` parameter onevent object of hammer.js. 
	Related events: ViewerEvents.tapPage(e); ***doubleTapPage(e); ***pressPage(e)
•	The rightClickAnnotation adds an  `e` parameter for mouse event.
	Related events: ViewerEvents.rightClickAnnotation(annotRender,e)
•	The PDFDoc.sign() adds a new parameter 'image' for setting signature appearance.

## Updates
•	Optimized the loading time for files with 5000+ annotations
•	Enhanced SDK functionality so that users can build their viewer’s UI without using the UIExtension project.   
	Related module:  PDFViewCtrl.add-ons
•	New StateHandler classes for  splitting select Text & Annotation into two tools: Select Text and Select Annotation
	Related API:  PDFViewCtrl.contants.STATE_HANDLER_NAMES. STATE_HANDLER_SELECT_TEXT_IMAGE     ***STATE_HANDLER_SELECT_ANNOTATION
•	Enhanced SDK to support file:// protocol which is useful for native apps like Electron, HBuilderX packaged apps, ect.
•	Disabled the pop-ups for static XFA Forms by ignoring XFA version check.
•	Updated the annotation events for listening in to form widgets edits.
	Related events:  PDFViewCtrl:constant.DataEvents.annotationAdded,  ***annotationRemoved, ***annotationUpdated,   ***activeAnnotation, and ***unActiveAnnotation.

## Bug Fixes

•	Fixed touch screen issue on pages in PDFViewCtrl basic viewer mobile.
•	Area measurement value update fails after modifying size corrected
•	ComboBox unresponsive to mouse click  on specific files issue was fixed.
•	xref table parsing not working on specific FDF files data import operation issue fixed 
•	Signature validation working correctly on OpenPDFByHttpRangeRequest
•	Fixed an issue on new added PDF signatures displayed incorrectly on a particular use case scenario. 
•	Fixed setEnableJS issue on executing document open operation when method is set to false.
•	Fixed an issue where Annotations fail to export "custom entries" to XFDF.
•	Measurement annotation no longer truncated when being created on an re-sized page. 
•	Bookmark page numbers correctly updated when Inserting a new page.
•	Enhanced performance on toolbar items switch unusually laggy
•	Empty JavaScript Actions on a file no longer causing issues on opening PDF documents
•	Issues with "formValueChanged" method in specific documents were fully repaired.
•	Rotated stamp annotations no longer cause issues on XFDF annotation data export.
•	Hiding annotations on un-rendered pages completely supported. 
•   Fixed a cross-site scripting security issue.

# What's new in Foxit PDF SDK for Web 7.5.0

## New Features

*  New ‘Undo All’ method for undo/redo all annotations entered in a session 
   Related API: `pdfui.callAddonAPI("UndoRedoAddon","undoAll")`
*  Programmatically set image of screen annotation  
   Related API : Screen.setImage
*  Programmatically access and activate a specific annotation   
   Related API:  PDFViewer.activateAnnotation
*  New method for accessing annotation’s PDF dictionary to and storing custom data to the annotation
   Related APIs: `setDictionaryEntry(key,value)` and `getDictionaryEntry(key)`
*  Enable/disable tooltips on mouse hover on annotation
   Related option: PDFViewer.options.showAnnotTooltip
*  New event for listening when an annotation's position changes
   Related event: annotationMovedPosition 
*  New classes were added to better work with widget annotations and control form fields 
   Related classes: PDF.annots.Widget,  PDF.Form.PDFControl
*  New Form data formats supported: CSV and TXT.
   Related API: `PDFDoc.importFormFromFile()` and `PDFDoc.exportFormToFile()`
*  Enable/disable form field automatic calculation 
   Related API: PDFViewer.setAutoCalculateFieldsFlag
*  Programmatically show print dialog box
   Related API: `pdfui.callAddonAPI("PrintUIXAddon","showPrintDialog")`
*  New event triggered  when an ink signature image is selected
   Related Event: `UIExtension.UIEvents.InkImageSelected` 
*  New methods to access and set header/footer underline.
   Related APIs: HeaderFooter.setUnderline, HeaderFooter.getUnderline
*  New Features were added to the web viewer's UI 
   * New zoom mode `Fit Visible` 
   * Sort annotations by properties such as Page, Type, Author, Date, Status, Check Status  
   * Filter comments by status and author
   * New editing capabilities to the following form field properties:
     * Set tooltip 
     * Set flags: Visible, Hidden, Visible but unprintable, Hidden but printable
     * Set direction: Right-to-Left and Left-to-Right
     * Set text field properties: Text Rotation, Font Size/Color and Type (14 standard font types)
     * Set actions after placing a signature by adding a new Signed tab
   * Copy/Cut/Paste the selected form field
   * Shortcut keys for form fields
     * Arrow keys Up/Left/Down/Right for navigating Radio buttons in a group
     * Enter key to activate/deactivate the current form field
	
## Updates

*  doubleTapPage event updated to pass mouse associated information  
   Original event:  pdfViewer.eventEmitter.on(ViewerEvents.doubleTapPage, () =>{ })
   New event: pdfViewer.eventEmitter.on(ViewerEvents.doubleTapPage, (e) =>{ })
*  When a module e.g. Redaction is not licensed, its related API is notaccessible, and related UI features at UI level are hidden.  
*  Updated pencil annotation methodPDFViewer.setPencilDrawingTimeout parameters to accept '0’ as a value
*  Updated method setFormHighlightColor to highlight required fields 
   Original API: setFormHighlightColor(color)
   New API: setFormHighlightColor(color, requiredColor)
  
## Bug Fixes

*  Customized stamp icon becomes stretched in the stamp list  
*  Event nottriggered when calling methods tapAnnotation, doubleTapAnnotation, rightclickAnnotion or pressAnnotation.
*  The content of the Textbox truncated after increasing border width
*  Signature appearance displayed incorrectly on  specific files
*  Some form fields recognized incorrectly on specific files
*  Viewer UI flickered when an incorrect password entered in a password protected file 
*  Failed to add Callout annotation on a specific file
*  Watermark displayed incorrectly when rendered multiple times

# What's new in Foxit PDF SDK for Web 7.4.0

## New Features

* Import and export ink signature list.
  Related APIs: pdfViewer.getInkSignList(); pdfViewer.setInkSignList()
* Set the default state tool to a particular stamp by using the new PDFUI constructor option or method.   
  Related option: PDFUI.constructor ([options.customs.handlerParams])
  Related API: PDFViewCtrl.StateHandlerManager.switchTo(stamp,{category:"",name:""})
* Check, Enable and disable hotkey by using the new constructor option or method.   
  Related option: pdfViewer.constructor([options.enableShortcutKey=true])
  Related APIs: pdfViewer.setEnableShortcutKey(), pdfViewer.isShortcutKeyEnabled()
* Get a page's box information and check for cropped page.
  Related APIs: pdfPage.isCropped(); pdfPage.getPageBox()
* Configure default print options. 
  Related API: pdfviewer.setDefaultPrintSetting()
* Unmount the iFrame DOM running PDF JavaScript by configuring the PDFViewer constructor option. Value is set to false by default. Use true value if you don’t want the JavaScript code to be called using iframe.
  Related option: pdfViewer.constructor([options.noJSFrame=false])
* Change the PDF text background and foreground display color.  
  Related API: pdfviewer.setDocReadColor()
* Load image as document object.  
  Related API: pdfViewer.convertImageToPDFDoc()
* Support rotation and event handling.  
  Related APIs PDFViewer.rotateTo(); PDFViewer.getRotation(); ViewerEvents.afterDocumentRotation  
* New methods to set form field highlight color and enable/disable form field highlight.  
  Related APIs: pdfviewer.setFormHighlightColor(); pdfviewer.highlightForm(boolean)
* New method for pre-setting pencil drawing object time. 
  Related API: pdfviewer.setPencilDrawingTimeOut()
* New classes and methods for working with and managing PDF objects programmatically. 
  Related new Classes: PDF.GraphicsObject; PDF.ImageObject; PDF.TextObject; PDF.PathObject
  Related APIs: PDFPage.getGraphicsObjectsInRect(); PDFPage.getGraphicsObjectAtPoint(); PDFPage.getGraphicsObjectsCount(); PDFPage.addGraphicsObject(); PDFPage.removeGraphicsObject();
  Related Event: DataEvents.graphicsUpdated()
* New constructor option to display comment list or not when a markup annotation was created.
  Related option: PDFViewer.constructor.showCommentList
*  New Features at UIExtension module：
    * New <gtab> component
	* New method to make it easier to create controller class. 
	  Related API:UIXModule.prototype.controller(name, def)
	* New method to create custom appearance.
	  Related API: Appearance.extend(def, statics)
*  New features were added to the web viewer’s UI:
	* New Signature field control. 
	* New Form text field control.
	* New measurement tools `Perimeter, Polygon area and Circle area`.
	* New view Rotate options on right-click context menu.
	* New PDF text color view mode control.
	* Drag and drop annotation’s across pages feature.  
	* Support displaying annotation contents on mouse hover action.   
        * Support load image file directly.
	* Audio player now supports pause option. 
	* New language localization support: Japanese and Korean.
	
## Updates

*  Change the name of parameter `annotJson` to `annotsJson` in `PDFViewer.openPDFByHttpRangeRequest` and `PDFViewer.reopenPDFDoc`.
*  The advanced_webViewer was removed from the SDK package. It was replaced with complete_webViewer.
*  The Form import&export tool were moved to Form tab from the Home tab.
*  New `allInOne.mobile.js` file for mobile to load all addons using a single js file. 
*  The thumbnails `uix-addons` module has been made open source for specific customers, not released to general availability
*  Deprecated: Deprecate PDFUI options `template and fragments`, replace them with Appearance. 

*****Enhancements*****

*  Optimized mobile pinch zoom touch screen performance. 
*  Enhanced PDF JavaScript support: document print action and OCG object. 
*  Enhanced pdfField.setAction to support AdditionalAction. 
 	Related APIs: setAction(type,data){} was updated to setAction(trigger, action){}
 	Related constants: PDF.constant.Action_Trigger; PDF.constant.Action.Box_Type 
*  Enhanced document open workflow by separating document loading and rendering logic.
 	Related APIs:  
 	pdfViewer.renderDoc; pdfViewer.openPDFByFile(file,{isRenderOnDocLoaded:false}); pdfViewer. openPDFByHttpRangeRequest(request,{isRenderOnDocLoaded:false}); pdfViewer.openPDFById(); pdfViewer.createNewDoc(,{isRenderOnDocLoaded:false})
*  Enhanced stamp functionality to support blob url/base64 data source, and allow users to add/edit custom stamps and change time format of dynamic stamp.
	Related new APIs: 
 	pdfViewer.initAnnotationIcons(icons): Sets the custom initial stamps list. The default stamp list will be replaced. 
 	pdfViewer.addAnnotationIcon(icon): Adds a single custom stamp.
 	pdfViewer.removeAnnotationIcon(type,category,name):Removes a single custom stamp.
 	pdfui.getAnnotationIcons(annotType,onlyCustomized):Gets the custom stamps. 
 	pdfui.getAnnotationIcons('stamp',true);
 	pdfViewer.setFormatOfDynamicStamp(seperator,timeFormat):Configures the time format for the dynamic stamp.
*  Enhanced the Digital Signature solution.
	Related API: PDFUI.registerSignHandler(signerInfo); PDFUI.setVerifyHandler(verifyFunction); PDFDoc.sign(signInfo,digestSignHandler); PDFDoc.verifySignature(signatureField, verifyHandler)
	New class: PDFSignature

## Bug Fixes

*  Barcode was not updated when document print action was triggered
* `openPDFByHttpRangeRequest()` did’t trigger error  on incorrect URLs. 
*  Pencil drawing data loss after import/export to FDF format on pages containing stamp annotations. 
*  Text displayed incorrectly on rotated pages.
* `getCurrentPageIndex()` didn’tget correct page number in a visible area. 
*  Thumbnail and page index did not update after importing documents with API `PDFDoc.insertPage()`.
*  Bookmark could not be deleted after being inserted by  PDFBookmark.insertbookmark.
*  Comments were  disabled in a signed document with comments permission.
*  Tab key always jump back to the first page when using Tab key to view a form file. 
*  Font not rendered correctly in a combo box form field. 
*  MarkupAnnot.getReviewStateCount and MarkupAnnot.GetReviewStates always return 1 regardless of having more than 1 review states.
*  STATE_HANDLER_CREATE_FREETEXT_CALLOUT could not be created when using template 
*  Callout annotation displayed incorrectly after being moved in a particular file. 
*  SubmitForm action generated incorrect execution..
*  Parts of images were inaccessible or hidden when rotated.
*  Form field inaccessible  in specific form files when document is loaded17. `PDFViewCtrl.ViewerEvents.rightClickAnnotation` fails to trigger in specific scenarios.
*  Form controls get lost when new form pages were inserted in document. 
*  Combo box printed in the output file issue.   

# What's new in Foxit PDF SDK for Web 7.3.0

## New Features

•	Added progressive rendering support.
•	Added API to get font information including font type,name, embedded info etc.
•	Added multiple selection and edit function on content objects at UIExtension.
•	Added a PDF.actions class.
•	Added getActions and setActions API for PDF.annots.Link annotation.
•	Added digital signature support.
•	Added a new PDFViewer.constructor option jr.brotli
•	Added new PDFUI.constructor option customs.getLoadingMode to allow loading PDF document from memory buffer.
•	Added a new PDFViewer.constructor option renderingMode
•	Added a new parameter annotUpdatedType to DataEvents.annotationUpdated to distinguish contents from other changes on annotations. In the past, when the annotation content is added or updated straightly on a page, developers have no way to detect if content has been changed or not.
•	Added pdfviewer.killFocus() API.
•	Added pdfui.confirm(), pdfui.alert(), and pdfui.prompt() with message and log type to classify the UI pop-up component. In the past, FoxitPDFSDK for Web only has one message type, which is hard for application level developer to customize UI dialog.
•	Updated UI thumbnail component and modularized it as an add-on to allow developers to do customization and extend its functionality.
•	Added an open source scaffold example project .
•	Added show/hide all comments at UI level.
•	Added PDFUI.callAddon()API at UI level.
•	Added a paddle component in layout template to show the hidden elements on toolbar (PC only).
•	Added addon merge tools for preprocessing addon resources to reduce the network requests at the UI initialization.
•	Added UIExtension.vw.cssfile to support vmin CSS unit to adapt layout for cases that require font resizing on mobile.
•	Added PDF.HeaderFooter.isEmpty()API.

## Updates

•	Updated the PDFViewCtrl.ViewerEvents.removeActionAnnotationSuccess logic that once it was triggered, the annotation would be destroyed and no properties can be retrieved. For cases that requires to listen in removed annotations, PDF.DataEvents.annotationRemoved should be used instead.
•	Removed UIExtension.full.css that functions same as UIExtension.css.
•	Updated the output information on console.
•	Updated hot key for annotation undo ( command+z) and redo (command+shift+z) on Mac at UI level.
•	Updated Vue/Angular/React integration sample to use merged-addons.
•	Updated the return value of the PDFPage.addImage(). In the past this method returns Promise, now it returns Promise.
•	Updated PDFDoc.exportAnnotsToPDF API which now supports exporting a particular annotation to data file.
•	Updated WebPDFJRWorker.jsto allow accessing from a different origin.
•	Updated PDF.constant.Error_Codeenumerations in API references.
•	Updated the docfolder to doc-websitewith HTML format developer guide.


## Bug Fixes

•	Fixed an issue where the Edit menu in Comment List wasn't disabled after the annotations flag was set as locked.
•	Fixed an issue where creating annotation would trigger both annotationAdded and annotationUpdated events.
•	Fixed an issue where a new added custom stamp data can't be updated when being placed on the page.
•	Fixed an issue where passing annotation color=0x000000 on border and text, did not take effect.
•	Fixed an issue where the JSON data was inconsistent between exportAnnotsToJSON and addAnnot
•	Fixed an issue where the URL file cannot be opened cross origin.
•	Fixed an issue which the callout failed to create on a particular file.
•	Fixed an issue which the date format got changed on focus and on blur.
•	Fixed an issue which no comments could be imported when comments contains parenthesis.
•	Fixed an issue where uncaught promise error occurred when importing annotation.
•	Fixed an issue which the text form field can't set to be blank if a default value has been set.
•	Fixed an issue where importAnnotsFromJson could not update the old annotation when two annotations have same ID.
•	Fixed an issue that FoxitPDFSDK for Web failed to display the default appearance of a 3D annotation.
•	Fixed an issue where tooltip shows only when the cursor points to the left-top corner of the tool on Firefox.
•	Fixed an issue the FoxitPDFSDK for Web failed to open files in IE10.
•	Fixed an issue that the rendering delayed when adding highlight annotation.
•	Fixed an issue that FoxitPDFSDK for Web failed to open particular drawing files.
•	Fixed an issue where 404 Error occurred when loading a file in Angular.js.
•	Fixed an issue where FoxitPDFSDK for Web keeps loading when open a particular file.
•	Fixed an issue where the mirror field cannot be cleared when the length is less than 2 in the main field.


# What's new in Foxit PDF SDK for Web 7.3.0

## New Features
•	Added progressive rendering support.
•	Added API to get font information including font type,name, embedded info etc.
•	Added multiple selection and edit function on content objects at UIExtension.
•	Added a PDF.actions class.
•	Added getActions and setActions API for PDF.annots.Link annotation.
•	Added digital signature support.
•	Added a new PDFViewer.constructor option jr.brotli
•	Added new PDFUI.constructor option customs.getLoadingMode to allow loading PDF document from memory buffer.
•	Added a new PDFViewer.constructor option renderingMode
•	Added a new parameter annotUpdatedType to DataEvents.annotationUpdated to distinguish contents from other changes on annotations. In the past, when the annotation content is added or updated straightly on a page, developers have no way to detect if content has been changed or not.
•	Added pdfviewer.killFocus() API.
•	Added pdfui.confirm(), pdfui.alert(), and pdfui.prompt() with message and log type to classify the UI pop-up component. In the past, FoxitPDFSDK for Web only has one message type, which is hard for application level developer to customize UI dialog.
•	Updated UI thumbnail component and modularized it as an add-on to allow developers to do customization and extend its functionality.
•	Added an open source scaffold example project .
•	Added show/hide all comments at UI level.
•	Added PDFUI.callAddon()API at UI level.
•	Added a paddle component in layout template to show the hidden elements on toolbar (PC only).
•	Added addon merge tools for preprocessing addon resources to reduce the network requests at the UI initialization.
•	Added UIExtension.vw.cssfile to support vmin CSS unit to adapt layout for cases that require font resizing on mobile.
•	Added PDF.HeaderFooter.isEmpty()API.

## Updates

•	Updated the PDFViewCtrl.ViewerEvents.removeActionAnnotationSuccess logic that once it was triggered, the annotation would be destroyed and no properties can be retrieved. For cases that requires to listen in removed annotations, PDF.DataEvents.annotationRemoved should be used instead.
•	Removed UIExtension.full.css that functions same as UIExtension.css.
•	Updated the output information on console.
•	Updated hot key for annotation undo ( command+z) and redo (command+shift+z) on Mac at UI level.
•	Updated Vue/Angular/React integration sample to use merged-addons.
•	Updated the return value of the PDFPage.addImage(). In the past this method returns Promise, now it returns Promise.
•	Updated PDFDoc.exportAnnotsToPDF API which now supports exporting a particular annotation to data file.
•	Updated WebPDFJRWorker.jsto allow accessing from a different origin.
•	Updated PDF.constant.Error_Codeenumerations in API references.
•	Updated the docfolder to doc-websitewith HTML format developer guide.


## Bug Fixes

•	Fixed an issue where the Edit menu in Comment List wasn't disabled after the annotations flag was set as locked.
•	Fixed an issue where creating annotation would trigger both annotationAdded and annotationUpdated events.
•	Fixed an issue where a new added custom stamp data can't be updated when being placed on the page.
•	Fixed an issue where passing annotation color=0x000000 on border and text, did not take effect.
•	Fixed an issue where the JSON data was inconsistent between exportAnnotsToJSON and addAnnot
•	Fixed an issue where the URL file cannot be opened cross origin.
•	Fixed an issue which the callout failed to create on a particular file.
•	Fixed an issue which the date format got changed on focus and on blur.
•	Fixed an issue which no comments could be imported when comments contains parenthesis.
•	Fixed an issue where uncaught promise error occurred when importing annotation.
•	Fixed an issue which the text form field can't set to be blank if a default value has been set.
•	Fixed an issue where importAnnotsFromJson could not update the old annotation when two annotations have same ID.
•	Fixed an issue that FoxitPDFSDK for Web failed to display the default appearance of a 3D annotation.
•	Fixed an issue where tooltip shows only when the cursor points to the left-top corner of the tool on Firefox.
•	Fixed an issue the FoxitPDFSDK for Web failed to open files in IE10.
•	Fixed an issue that the rendering delayed when adding highlight annotation.
•	Fixed an issue that FoxitPDFSDK for Web failed to open particular drawing files.
•	Fixed an issue where 404 Error occurred when loading a file in Angular.js.
•	Fixed an issue where FoxitPDFSDK for Web keeps loading when open a particular file.
•	Fixed an issue where the mirror field cannot be cleared when the length is less than 2 in the main field.



