(window.webpackJsonp=window.webpackJsonp||[]).push([[23],{320:function(t,n,s){t.exports=s.p+"assets/img/noDeletePermission.aa06b9d3.png"},321:function(t,n,s){t.exports=s.p+"assets/img/hasEditPermission.aec737c8.png"},380:function(t,n,s){"use strict";s.r(n);var a=s(14),e=Object(a.a)({},(function(){var t=this,n=t._self._c;return n("ContentSlotsDistributor",{attrs:{"slot-key":t.$parent.slotKey}},[n("h1",{attrs:{id:"annotationauthoritymanager"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#annotationauthoritymanager"}},[t._v("#")]),t._v(" AnnotationAuthorityManager")]),t._v(" "),n("p",[t._v("Before formally introducing how to use the AnnotationAuthorityManager utility class, let's first understand the types of annotation permissions and how to set them.")]),t._v(" "),n("h2",{attrs:{id:"types-of-annotation-permissions"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#types-of-annotation-permissions"}},[t._v("#")]),t._v(" Types of Annotation Permissions")]),t._v(" "),n("p",[t._v("There are three types of annotation permissions:")]),t._v(" "),n("ol",[n("li",[n("p",[t._v("PDF annotation permissions: Restrictions on the operations of annotation within the PDF document itself. You can use the "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___consts_p_d_f.html#gab3d2fa3aa2db6744586420940ba7ed77",target:"_blank",rel:"noopener noreferrer"}},[t._v("User_Permissions"),n("OutboundLink")],1),t._v(" ( for global) or "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___annot_consts_p_d_f.html#ga6dffcd3133004177c3bf80847dcf3147",target:"_blank",rel:"noopener noreferrer"}},[t._v("Annot_Flags"),n("OutboundLink")],1),t._v(" (for a single annotation) to set it. The settings for PDF annotation permissions will be written into the document, thus changing the document.")])]),t._v(" "),n("li",[n("p",[t._v("View annotation permissions: Restrictions on the operations of annotation from the view layer. The settings for view annotation permissions only affect the application and are not written into the document, so that it will not change the document.")])]),t._v(" "),n("li",[n("p",[t._v("Interactive annotation permissions: The intersection of PDF annotation permissions and view annotation permissions is called interactive annotation permissions. After loading a PDF document, users will have restrictions on their actions towards annotations based on the interactive annotation permissions.")])])]),t._v(" "),n("h3",{attrs:{id:"the-method-for-setting-annotation-permissions"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#the-method-for-setting-annotation-permissions"}},[t._v("#")]),t._v(" The method for setting annotation permissions")]),t._v(" "),n("p",[t._v("Foxit PDF SDK for Web provides four ways to set annotation permissions as follows:")]),t._v(" "),n("ol",[n("li",[n("p",[t._v("Set view annotation permissions through the PDFViewer constructor. For example, "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_p_d_f_viewer.html#a1c6d3c3e038c4c165ab999fac6b038ce",target:"_blank",rel:"noopener noreferrer"}},[t._v("[options.customs.getDocPermissions=(doc:PDFDoc)=>-1]"),n("OutboundLink")],1),t._v(" and "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_p_d_f_viewer.html#a1c6d3c3e038c4c165ab999fac6b038ce",target:"_blank",rel:"noopener noreferrer"}},[t._v("[options.customs.getAnnotPermissions=(annot:Annot)=>Promise.resolve()]"),n("OutboundLink")],1),t._v(".")])]),t._v(" "),n("li",[n("p",[t._v("Set view annotation permissions dynamically in real-time using the AnnotationAuthorityManager utility class. See "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_annotation_authority_manager.html#a6dbeadea9923f8c7f579ac4aa44cb919",target:"_blank",rel:"noopener noreferrer"}},[t._v("setAnnotPermissionCallback"),n("OutboundLink")],1),t._v(".")])]),t._v(" "),n("li",[n("p",[t._v("Set PDF annotation permissions globally through the "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_p_d_f_doc.html#a006f7bf752be417d47e00dd7eccde3d8",target:"_blank",rel:"noopener noreferrer"}},[t._v("PDFDoc::setPasswordAndPermission"),n("OutboundLink")],1),t._v(" interface.")])]),t._v(" "),n("li",[n("p",[t._v("Set PDF annotation permissions for a single annotation through the "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_annot.html#a8626a625172cb9dfcad75985bbd2c990",target:"_blank",rel:"noopener noreferrer"}},[t._v("Annot:setFlags"),n("OutboundLink")],1),t._v(" interface.")])])]),t._v(" "),n("h2",{attrs:{id:"the-usage-of-annotationauthoritymanager"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#the-usage-of-annotationauthoritymanager"}},[t._v("#")]),t._v(" The Usage of AnnotationAuthorityManager")]),t._v(" "),n("p",[t._v("You can update interactive annotation permissions by setting PDF annotation permissions or view annotation permissions. In some scenarios, you may not want to modify the original document and only want to control the user's operation permissions on annotations at the application layer. In this case, you can use the AnnotationAuthorityManager utility class to set the view annotation permissions for annotations in real-time and then update the interactive annotation permissions.")]),t._v(" "),n("p",[t._v("Note: When the application layer updates the interactive annotation permissions, Foxit PDF SDK for Web internally takes the intersection of the view annotation permissions set by the application layer and the PDF annotation permissions to determine the final interactive permissions that users have on annotations.")]),t._v(" "),n("h3",{attrs:{id:"timing-for-updating-interactive-annotation-permissions"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#timing-for-updating-interactive-annotation-permissions"}},[t._v("#")]),t._v(" Timing for updating interactive annotation permissions")]),t._v(" "),n("p",[t._v("The following example code demonstrates how users can passively or actively update the interactive annotation permissions.")]),t._v(" "),n("ol",[n("li",[t._v("Update the interactive annotation permissions passively")])]),t._v(" "),n("p",[t._v("Before opening a document, users can set permissions first using "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_annotation_authority_manager.html#a6dbeadea9923f8c7f579ac4aa44cb919",target:"_blank",rel:"noopener noreferrer"}},[t._v("setAnnotPermissionCallback"),n("OutboundLink")],1),t._v(", "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_p_d_f_viewer.html#a1c6d3c3e038c4c165ab999fac6b038ce",target:"_blank",rel:"noopener noreferrer"}},[t._v("[options.customs.getDocPermissions=(doc:PDFDoc)=>-1]"),n("OutboundLink")],1),t._v(", and "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_p_d_f_viewer.html#a1c6d3c3e038c4c165ab999fac6b038ce",target:"_blank",rel:"noopener noreferrer"}},[t._v("[options.customs.getAnnotPermissions=(annot:Annot)=>Promise.resolve()]"),n("OutboundLink")],1),t._v(". After the document is opened, the SDK will update the interactive annotation permissions automatically, and users do not need to set them again.")]),t._v(" "),n("p",[t._v('Note: Here, "passive update" means that the SDK will automatically update the interactive annotation permissions after the document is opened, without the need for the user to manually call an interface to update them.')]),t._v(" "),n("div",{staticClass:"language-js extra-class"},[n("pre",{pre:!0,attrs:{class:"language-js"}},[n("code",[t._v("    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// There are two ways to set the view annotation permissions before the document is opened:")]),t._v("\n\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// The first method is to set the view annotation permissions based on the annotation information when constructing the PDFViewer object")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" pdfui "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("PDFUI")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),n("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("customs")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the view annotation permissions")]),t._v("\n                "),n("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getAnnotPermissions")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("annot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFViewCtrl"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("constants"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),t._v("\n                    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set to have all the view annotation permissions")]),t._v("\n                    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" Promise"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("resolve")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("fully"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// The second method is to set the view annotation permissions through the AnnotationAuthorityManager manager")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" pdfViewer "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getPDFViewer")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the AnnotationAuthorityManager manager.")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" annotAuthMgr "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" pdfViewer"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAnnotAuthorityManager")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the view annotation permissions")]),t._v("\n    annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAnnotPermissionCallback")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("annot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set to have no operation permissions")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" Promise"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("resolve")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v(" \n    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// When opening a PDF document, the SDK will read the view annotation permissions that you set, and then update the interactive annotation permissions automatically.")]),t._v("\n    pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("openPDFByHttpRangeRequest")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token string"}},[t._v("'http:xxx'")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),n("ol",{attrs:{start:"2"}},[n("li",[t._v("Update the interactive annotation permissions actively")])]),t._v(" "),n("p",[t._v("After the document is opened, users can dynamically set permissions and then actively update interactive annotation permissions using "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_annotation_authority_manager.html#a2753f97fa8a62b5572c28d2a68e27a77",target:"_blank",rel:"noopener noreferrer"}},[t._v("updateAll()"),n("OutboundLink")],1),t._v(" or "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_annotation_authority_manager.html#a20e5aea7d7f2a2067de0b8162a56ffdb",target:"_blank",rel:"noopener noreferrer"}},[t._v("update()"),n("OutboundLink")],1),t._v(" method.")]),t._v(" "),n("div",{staticClass:"language-js extra-class"},[n("pre",{pre:!0,attrs:{class:"language-js"}},[n("code",[t._v("    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Open a document")]),t._v("\n    pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("openPDFByHttpRangeRequest")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token string"}},[t._v("'http:xxx'")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    \n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the view annotation permissions through the AnnotationAuthorityManager manager")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" pdfViewer "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getPDFViewer")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the AnnotationAuthorityManager manager")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" annotAuthMgr "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" pdfViewer"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAnnotAuthorityManager")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the view annotation permissions ")]),t._v("\n    annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAnnotPermissionCallback")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("annot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set to have no operation permissions for all annotations")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" Promise"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("resolve")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Need to manually update the interactive permissions of all annotations, otherwise the view annotation permissions you set will not take effect immediately")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("updateAll")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),n("p",[t._v("In actual projects, users can use "),n("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_p_d_f_viewer.html#a86658653c0815911b4d3621211d55f3b",target:"_blank",rel:"noopener noreferrer"}},[t._v("PDFViewer.getCurrentPDFDoc"),n("OutboundLink")],1),t._v(" to get the current document object and verify whether the current document is open. If the value is null, it means the document is not open.")]),t._v(" "),n("h3",{attrs:{id:"usage-scenarios-of-view-annotation-permissions"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#usage-scenarios-of-view-annotation-permissions"}},[t._v("#")]),t._v(" Usage scenarios of view annotation permissions")]),t._v(" "),n("p",[t._v("In practical scenarios, different view annotation permissions may need to be set. Currently, there are mainly four types. The following example is based on a pre-created "),n("code",[t._v("AnnotationAuthorityManager")]),t._v(" instance.")]),t._v(" "),n("ol",[n("li",[n("p",[t._v("No permissions")]),t._v(" "),n("div",{staticClass:"language-js extra-class"},[n("pre",{pre:!0,attrs:{class:"language-js"}},[n("code",[t._v("    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the view annotation permissions ")]),t._v("\n    annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAnnotPermissionCallback")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("annot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set to have no operation permissions for all annotations")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" Promise"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("resolve")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n")])])])]),t._v(" "),n("li",[n("p",[t._v("Combined permissions")]),t._v(" "),n("div",{staticClass:"language-js extra-class"},[n("pre",{pre:!0,attrs:{class:"language-js"}},[n("code",[t._v("    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFViewCtrl"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("constants"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the view annotation permissions ")]),t._v("\n    annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAnnotPermissionCallback")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("annot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the permission of all annotations to be able to modify properties and behaviors, and to be able to delete/move/rotate/scale")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" Promise"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("resolve")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adjustable"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("deletable"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("modifiable"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n")])])])]),t._v(" "),n("li",[n("p",[t._v("All permissions")]),t._v(" "),n("div",{staticClass:"language-js extra-class"},[n("pre",{pre:!0,attrs:{class:"language-js"}},[n("code",[t._v("    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFViewCtrl"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("constants"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the view annotation permissions ")]),t._v("\n    annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAnnotPermissionCallback")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("annot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set to have all the view annotation permissions")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" Promise"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("resolve")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("fully"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n")])])])]),t._v(" "),n("li",[n("p",[t._v("Ignorable permissions")]),t._v(" "),n("div",{staticClass:"language-js extra-class"},[n("pre",{pre:!0,attrs:{class:"language-js"}},[n("code",[t._v("    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the view annotation permissions ")]),t._v("\n    annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAnnotPermissionCallback")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("annot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the permissions for all annotations to be ignorable")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("null")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n")])])])])]),t._v(" "),n("h3",{attrs:{id:"usage-scenarios-of-interactive-annotation-permissions"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#usage-scenarios-of-interactive-annotation-permissions"}},[t._v("#")]),t._v(" Usage scenarios of interactive annotation permissions")]),t._v(" "),n("h4",{attrs:{id:"example-1-set-the-view-annotation-permissions-which-does-not-allow-to-delete-specified-annotations"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#example-1-set-the-view-annotation-permissions-which-does-not-allow-to-delete-specified-annotations"}},[t._v("#")]),t._v(" Example 1: Set the view annotation permissions which does not allow to delete specified annotations")]),t._v(" "),n("div",{staticClass:"language-js extra-class"},[n("pre",{pre:!0,attrs:{class:"language-js"}},[n("code",[t._v("    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" pdfViewer "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getPDFViewer")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the AnnotationAuthorityManager manager")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" annotAuthMgr "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" pdfViewer"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAnnotAuthorityManager")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the annotationRender of a specified attachment type on a specified page")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" fileAnnotRender "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" pdfViewer"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAnnotRender")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token number"}},[t._v("0")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),n("span",{pre:!0,attrs:{class:"token string"}},[t._v("'name'")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the annotation of a specified attachment type on a specified page")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" fileAnnot "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" fileAnnotRender"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAnnot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" PDFViewCtrl"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("constants"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the view annotation permissions ")]),t._v("\n    annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAnnotPermissionCallback")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("annot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set a specific file annotation to have no permission to be deleted")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("if")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("annot"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getObjectNumber")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("===")]),t._v(" fileAnnot"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getObjectNumber")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" Promise"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("resolve")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("Object"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("keys")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("filter")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("per")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v("per"),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("!==")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("deletable "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("&&")]),t._v(" per"),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("!==")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("fully"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Update the interactive annotation permissions for the specified annotation")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("update")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("fileAnnot"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),n("p",[t._v("After executing the above code, users will not be able to delete the annotation with the specified name.\n"),n("img",{attrs:{src:s(320),alt:"Have no permission to delete the annotation"}})]),t._v(" "),n("h4",{attrs:{id:"example-2-set-the-view-annotation-permissions-to-allow-editing-the-callout-content"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#example-2-set-the-view-annotation-permissions-to-allow-editing-the-callout-content"}},[t._v("#")]),t._v(" Example 2: Set the view annotation permissions to allow editing the callout content")]),t._v(" "),n("div",{staticClass:"language-js extra-class"},[n("pre",{pre:!0,attrs:{class:"language-js"}},[n("code",[t._v("    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" pdfViewer "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getPDFViewer")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the AnnotationAuthorityManager manager")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" annotAuthMgr "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" pdfViewer"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAnnotAuthorityManager")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" PDFViewCtrl"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("constants"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the view annotation permissions ")]),t._v("\n    annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAnnotPermissionCallback")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("annot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the callout-type annotation to have editing permission.")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("if")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("annot"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getIntent")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("===")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token string"}},[t._v("'FreeTextCallout'")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" Promise"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("resolve")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOTATION_PERMISSION")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("editable"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n\n    "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Update the interactive annotation permissions for all the annotations")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("updateAll")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),n("p",[t._v("After executing the above code, users will be able to edit the FreeText objects with the type of callout.\n"),n("img",{attrs:{src:s(321),alt:"Have permission to eidt the annotation"}})]),t._v(" "),n("h4",{attrs:{id:"example-3-validate-pdf-annotation-permissions-and-view-annotation-permissions-on-a-custom-component"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#example-3-validate-pdf-annotation-permissions-and-view-annotation-permissions-on-a-custom-component"}},[t._v("#")]),t._v(" Example 3: Validate PDF annotation permissions and view annotation permissions on a custom component")]),t._v(" "),n("p",[t._v("The following code will demonstrate how to validate annotation permission on a newly added custom component.")]),t._v(" "),n("div",{staticClass:"language-js extra-class"},[n("pre",{pre:!0,attrs:{class:"language-js"}},[n("code",[t._v("    "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("PDFUI")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Customize a new component to delete annotations")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("fragments")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),n("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token string"}},[t._v("'hand-tool'")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),n("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<xbutton class="fv__ui-toolbar-show-text-button" name="cus-delete-button">button behind of hand-tool</xbutton>\'')]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),n("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" UIExtension"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token constant"}},[t._v("AFTER")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),n("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("config")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),n("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token string"}},[t._v("'cus-delete-button'")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),n("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("callback")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" PDFViewCtrl"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("shared"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("createClass")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),n("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("mounted")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("permissionHandler")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("permissionHandler")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" Events "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIEvents"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("let")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("permissionHandler")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("async")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                            "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" docRender "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getPDFDocRender")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n                            "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get PDF annotation permissions")]),t._v("\n                            "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" userPermission "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" docRender"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getUserPermission")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getValue")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                            "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("AnnotForm"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFViewCtrl"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("Consts"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFDocPermission"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                            "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("hasAnnotForm "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("userPermission "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("&")]),t._v(" AnnotForm"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("===")]),t._v(" AnnotForm"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                            "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Whether to disable this component")]),t._v("\n                            "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("component"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("hasAnnotForm"),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("?")]),n("span",{pre:!0,attrs:{class:"token string"}},[t._v("'enable'")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),n("span",{pre:!0,attrs:{class:"token string"}},[t._v("'disable'")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                        "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n                        "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("addDestroyHook")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("\n                            pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("addViewerEventListener")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("Events"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("openFileSuccess"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("permissionHandler"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n                            pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("addViewerEventListener")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("Events"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("permissionChanged"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("permissionHandler"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n                            pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("addViewerEventListener")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("Events"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("activeAnnotation"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("async")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("annotRender")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the active annotation")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" annot "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" annotRender"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAnnot")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" pdfViewer "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" pdfui"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getPDFViewer")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get AnnotationAuthorityManager manager")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" annotAuthMgr "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" pdfViewer"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAnnotAuthorityManager")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the view annotation permissions of a specified annotation.")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" annotPermission "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("await")]),t._v(" annotAuthMgr"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("getPermission")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("annot"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Get the value which indicates whether the annotation can be deleted")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" isDeleteAble "),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" annotPermission"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),n("span",{pre:!0,attrs:{class:"token function"}},[t._v("isDeletable")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Whether to disable this component")]),t._v("\n                                "),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("component"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),t._v("isDeleteAble"),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("&&")]),n("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("hasAnnotForm"),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v("?")]),n("span",{pre:!0,attrs:{class:"token string"}},[t._v("'enable'")]),n("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),n("span",{pre:!0,attrs:{class:"token string"}},[t._v("'disable'")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                            "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n                        "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n                "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" UIExtension"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("Controller"),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n            "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v("\n        "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v("\n    "),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),n("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),n("h3",{attrs:{id:"restrictions-on-view-annotation-permissions"}},[n("a",{staticClass:"header-anchor",attrs:{href:"#restrictions-on-view-annotation-permissions"}},[t._v("#")]),t._v(" Restrictions on view annotation permissions")]),t._v(" "),n("p",[t._v("Currently, the restrictions on view annotation permissions are:")]),t._v(" "),n("ol",[n("li",[t._v("The Redaction Apply function does not support setting interactive annotation permissions.")]),t._v(" "),n("li",[t._v("AnnotationAuthorityManager does not support Form Widgets.")])])])}),[],!1,null,null,null);n.default=e.exports}}]);